/*
 * Decompiled with CFR 0.152.
 */
package tigase.http.java;

import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncListener;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public class AsyncContextImpl
implements AsyncContext {
    private static final Logger log = Logger.getLogger(AsyncContextImpl.class.getCanonicalName());
    private final HttpExchange exchange;
    private final ServletRequest req;
    private final ServletResponse resp;
    private final ScheduledExecutorService scheduledExecutor;
    private ScheduledFuture future;
    private long timeout;

    public AsyncContextImpl(ServletRequest req, ServletResponse resp, HttpExchange exchange, ScheduledExecutorService scheduledExecutor) {
        this.req = req;
        this.resp = resp;
        this.exchange = exchange;
        this.scheduledExecutor = scheduledExecutor;
    }

    public ServletRequest getRequest() {
        return this.req;
    }

    public ServletResponse getResponse() {
        return this.resp;
    }

    public boolean hasOriginalRequestAndResponse() {
        return true;
    }

    public void dispatch() {
    }

    public void dispatch(String string) {
    }

    public void dispatch(ServletContext sc, String string) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void complete() {
        this.cancel();
        HttpExchange httpExchange = this.exchange;
        synchronized (httpExchange) {
            try {
                this.resp.flushBuffer();
            }
            catch (IOException ex) {
                log.log(Level.FINEST, "Failure during completion of async task", ex);
            }
            this.exchange.close();
        }
    }

    public void start(Runnable r) {
    }

    public void addListener(AsyncListener al) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void addListener(AsyncListener al, ServletRequest sr, ServletResponse sr1) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public <T extends AsyncListener> T createListener(Class<T> type) throws ServletException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
        this.future = this.scheduledExecutor.schedule(this::timeout, timeout, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void timeout() {
        try {
            HttpExchange httpExchange = this.exchange;
            synchronized (httpExchange) {
                try {
                    this.exchange.sendResponseHeaders(504, -1L);
                }
                catch (IOException ex) {
                    log.log(Level.FINEST, " failed to send 504 error", ex);
                }
                this.exchange.close();
            }
        }
        catch (Throwable ex) {
            log.log(Level.FINEST, " failed to send 504 error, throwable thrown:", ex);
        }
    }

    public void cancel() {
        if (this.future != null) {
            this.future.cancel(false);
        }
    }
}

