/*
 * Decompiled with CFR 0.152.
 */
package tigase.halcyon.core.xmpp.modules.presence;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tigase.halcyon.core.Context;
import tigase.halcyon.core.logger.Logger;
import tigase.halcyon.core.logger.LoggerFactory;
import tigase.halcyon.core.modules.Criteria;
import tigase.halcyon.core.modules.Criterion;
import tigase.halcyon.core.modules.XmppModule;
import tigase.halcyon.core.modules.XmppModuleProvider;
import tigase.halcyon.core.requests.RequestBuilder;
import tigase.halcyon.core.xml.Element;
import tigase.halcyon.core.xmpp.BareJID;
import tigase.halcyon.core.xmpp.FullJID;
import tigase.halcyon.core.xmpp.JID;
import tigase.halcyon.core.xmpp.StanzaKtKt;
import tigase.halcyon.core.xmpp.modules.presence.ContactChangeStatusEvent;
import tigase.halcyon.core.xmpp.modules.presence.InMemoryPresenceStore;
import tigase.halcyon.core.xmpp.modules.presence.PresenceHelperKt;
import tigase.halcyon.core.xmpp.modules.presence.PresenceModule;
import tigase.halcyon.core.xmpp.modules.presence.PresenceModuleConfig;
import tigase.halcyon.core.xmpp.modules.presence.PresenceReceivedEvent;
import tigase.halcyon.core.xmpp.modules.presence.PresenceStore;
import tigase.halcyon.core.xmpp.stanzas.Presence;
import tigase.halcyon.core.xmpp.stanzas.PresenceNode;
import tigase.halcyon.core.xmpp.stanzas.PresenceType;
import tigase.halcyon.core.xmpp.stanzas.Show;
import tigase.halcyon.core.xmpp.stanzas.Stanza_buildersKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\u0018\u0000 32\u00020\u00012\u00020\u0002:\u00013B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0016J\u0006\u0010\"\u001a\u00020\u001fJB\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020%0$2\n\b\u0002\u0010&\u001a\u0004\u0018\u00010'2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010(2\n\b\u0002\u0010)\u001a\u0004\u0018\u00010*2\n\b\u0002\u0010+\u001a\u0004\u0018\u00010\fJ\"\u0010,\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020%0$2\u0006\u0010&\u001a\u00020'2\u0006\u0010-\u001a\u00020(J\u0010\u0010.\u001a\u0004\u0018\u00010%2\u0006\u0010&\u001a\u00020/J\u0010\u00100\u001a\u0004\u0018\u00010%2\u0006\u0010&\u001a\u00020'J\u0014\u00101\u001a\b\u0012\u0004\u0012\u00020'022\u0006\u0010&\u001a\u00020/R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001e\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u0014X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u0017\u001a\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0018\u001a\u00020\u0019X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001d\u00a8\u00064"}, d2={"Ltigase/halcyon/core/xmpp/modules/presence/PresenceModule;", "Ltigase/halcyon/core/modules/XmppModule;", "Ltigase/halcyon/core/xmpp/modules/presence/PresenceModuleConfig;", "context", "Ltigase/halcyon/core/Context;", "<init>", "(Ltigase/halcyon/core/Context;)V", "getContext", "()Ltigase/halcyon/core/Context;", "log", "Ltigase/halcyon/core/logger/Logger;", "type", "", "getType", "()Ljava/lang/String;", "criteria", "Ltigase/halcyon/core/modules/Criteria;", "getCriteria", "()Ltigase/halcyon/core/modules/Criteria;", "features", "", "getFeatures", "()[Ljava/lang/String;", "[Ljava/lang/String;", "store", "Ltigase/halcyon/core/xmpp/modules/presence/PresenceStore;", "getStore", "()Ltigase/halcyon/core/xmpp/modules/presence/PresenceStore;", "setStore", "(Ltigase/halcyon/core/xmpp/modules/presence/PresenceStore;)V", "process", "", "element", "Ltigase/halcyon/core/xml/Element;", "sendInitialPresence", "sendPresence", "Ltigase/halcyon/core/requests/RequestBuilder;", "Ltigase/halcyon/core/xmpp/stanzas/Presence;", "jid", "Ltigase/halcyon/core/xmpp/JID;", "Ltigase/halcyon/core/xmpp/stanzas/PresenceType;", "show", "Ltigase/halcyon/core/xmpp/stanzas/Show;", "status", "sendSubscriptionSet", "presenceType", "getBestPresenceOf", "Ltigase/halcyon/core/xmpp/BareJID;", "getPresenceOf", "getResources", "", "Companion", "halcyon-core"})
@SourceDebugExtension(value={"SMAP\nPresenceModule.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PresenceModule.kt\ntigase/halcyon/core/xmpp/modules/presence/PresenceModule\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,208:1\n774#2:209\n865#2,2:210\n1563#2:212\n1634#2,3:213\n2423#2,14:216\n1617#2,9:230\n1869#2:239\n1870#2:241\n1626#2:242\n1#3:240\n*S KotlinDebug\n*F\n+ 1 PresenceModule.kt\ntigase/halcyon/core/xmpp/modules/presence/PresenceModule\n*L\n188#1:209\n188#1:210,2\n189#1:212\n189#1:213,3\n189#1:216,14\n205#1:230,9\n205#1:239\n205#1:241\n205#1:242\n205#1:240\n*E\n"})
public final class PresenceModule
implements XmppModule,
PresenceModuleConfig {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private final Logger log;
    @NotNull
    private final String type;
    @NotNull
    private final Criteria criteria;
    @Nullable
    private final String[] features;
    @NotNull
    private PresenceStore store;
    @NotNull
    private static final String TYPE = "PresenceModule";

    public PresenceModule(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.log = LoggerFactory.logger$default(LoggerFactory.INSTANCE, "tigase.halcyon.core.xmpp.modules.presence.PresenceModule", false, 2, null);
        this.type = TYPE;
        this.criteria = Criterion.Companion.name("presence");
        this.store = new InMemoryPresenceStore();
    }

    @Override
    @NotNull
    public Context getContext() {
        return this.context;
    }

    @Override
    @NotNull
    public String getType() {
        return this.type;
    }

    @Override
    @NotNull
    public Criteria getCriteria() {
        return this.criteria;
    }

    @Override
    @Nullable
    public String[] getFeatures() {
        return this.features;
    }

    @Override
    @NotNull
    public PresenceStore getStore() {
        return this.store;
    }

    @Override
    public void setStore(@NotNull PresenceStore presenceStore) {
        Intrinsics.checkNotNullParameter((Object)presenceStore, (String)"<set-?>");
        this.store = presenceStore;
    }

    @Override
    public void process(@NotNull Element element2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        Presence presence = (Presence)Stanza_buildersKt.wrap(element2);
        FullJID fromJID = StanzaKtKt.getFromAttr(presence);
        Logger.finer$default(this.log, null, () -> PresenceModule.process$lambda$0(presence), 1, null);
        if (fromJID == null) {
            return;
        }
        if (presence.getType() == PresenceType.Unavailable) {
            this.getStore().removePresence(fromJID);
        } else if (presence.getType() == null || presence.getType() == PresenceType.Error) {
            this.getStore().setPresence(presence);
        }
        this.getContext().getEventBus().fire(new PresenceReceivedEvent(fromJID, presence.getType(), presence));
        if (presence.getType() == null || presence.getType() == PresenceType.Unavailable || presence.getType() == PresenceType.Error) {
            Presence presence2 = this.getBestPresenceOf(fromJID.getBareJID());
            if (presence2 == null) {
                presence2 = presence;
            }
            Presence bestPresence = presence2;
            this.getContext().getEventBus().fire(new ContactChangeStatusEvent(fromJID.getBareJID(), bestPresence.getStatus(), bestPresence, presence));
        }
    }

    public final void sendInitialPresence() {
        Presence presence = Stanza_buildersKt.presence((Function1<? super PresenceNode, Unit>)((Function1)PresenceModule::sendInitialPresence$lambda$0));
        this.getContext().getWriter().writeDirectly(presence);
    }

    @NotNull
    public final RequestBuilder<Unit, Presence> sendPresence(@Nullable JID jid, @Nullable PresenceType type, @Nullable Show show, @Nullable String status) {
        return this.getContext().getRequest().presence((Function1<? super PresenceNode, Unit>)((Function1)arg_0 -> PresenceModule.sendPresence$lambda$0(jid, type, show, status, arg_0)));
    }

    public static /* synthetic */ RequestBuilder sendPresence$default(PresenceModule presenceModule, JID jID, PresenceType presenceType, Show show, String string, int n, Object object) {
        if ((n & 1) != 0) {
            jID = null;
        }
        if ((n & 2) != 0) {
            presenceType = null;
        }
        if ((n & 4) != 0) {
            show = null;
        }
        if ((n & 8) != 0) {
            string = null;
        }
        return presenceModule.sendPresence(jID, presenceType, show, string);
    }

    @NotNull
    public final RequestBuilder<Unit, Presence> sendSubscriptionSet(@NotNull JID jid, @NotNull PresenceType presenceType) {
        Intrinsics.checkNotNullParameter((Object)jid, (String)"jid");
        Intrinsics.checkNotNullParameter((Object)((Object)presenceType), (String)"presenceType");
        PresenceType[] presenceTypeArray = new PresenceType[]{PresenceType.Subscribe, PresenceType.Subscribed, PresenceType.Unsubscribe, PresenceType.Unsubscribed};
        if (!CollectionsKt.listOf((Object[])presenceTypeArray).contains((Object)presenceType)) {
            boolean bl = false;
            String string = "presenceType must one of: Subscribe, Subscribed, Unsubscribe, Unsubscribed";
            throw new IllegalArgumentException(string.toString());
        }
        return this.getContext().getRequest().presence((Function1<? super PresenceNode, Unit>)((Function1)arg_0 -> PresenceModule.sendSubscriptionSet$lambda$1(jid, presenceType, arg_0)));
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Presence getBestPresenceOf(@NotNull BareJID jid) {
        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000+\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\u0018\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0010J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\tH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001b\u0010\b\u001a\u00020\t8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0017"}, d2={"tigase/halcyon/core/xmpp/modules/presence/PresenceModule$getBestPresenceOf$Envelope", "", "presence", "Ltigase/halcyon/core/xmpp/stanzas/Presence;", "<init>", "(Ltigase/halcyon/core/xmpp/stanzas/Presence;)V", "getPresence", "()Ltigase/halcyon/core/xmpp/stanzas/Presence;", "comp", "", "getComp", "()Ljava/lang/String;", "comp$delegate", "Lkotlin/Lazy;", "component1", "copy", "(Ltigase/halcyon/core/xmpp/stanzas/Presence;)Ltigase/halcyon/core/xmpp/modules/presence/PresenceModule$getBestPresenceOf$Envelope;", "equals", "", "other", "hashCode", "", "toString", "halcyon-core"})
        public final class Envelope {
            private final Presence presence;
            private final Lazy comp$delegate;

            public Envelope(Presence presence) {
                Intrinsics.checkNotNullParameter((Object)presence, (String)"presence");
                this.presence = presence;
                this.comp$delegate = LazyKt.lazy(() -> Envelope.comp_delegate$lambda$0(this));
            }

            public final Presence getPresence() {
                return this.presence;
            }

            public final String getComp() {
                Lazy lazy = this.comp$delegate;
                return (String)lazy.getValue();
            }

            public final Presence component1() {
                return this.presence;
            }

            public final Envelope copy(Presence presence) {
                Intrinsics.checkNotNullParameter((Object)presence, (String)"presence");
                return new Envelope(presence);
            }

            public static /* synthetic */ Envelope copy$default(Envelope envelope, Presence presence, int n, Object object) {
                if ((n & 1) != 0) {
                    presence = envelope.presence;
                }
                return envelope.copy(presence);
            }

            public String toString() {
                return "Envelope(presence=" + this.presence + ")";
            }

            public int hashCode() {
                return this.presence.hashCode();
            }

            public boolean equals(Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Envelope)) {
                    return false;
                }
                Envelope envelope = (Envelope)other;
                return Intrinsics.areEqual((Object)this.presence, (Object)envelope.presence);
            }

            private static final String comp_delegate$lambda$0(Envelope this$0) {
                return 500 - this$0.presence.getPriority() + ":" + (100 + PresenceHelperKt.typeAndShow(this$0.presence).ordinal());
            }
        }
        Object v0;
        void $this$mapTo$iv$iv;
        Presence presence;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)jid, (String)"jid");
        Iterable $this$filter$iv = this.getStore().getPresences(jid);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            presence = (Presence)element$iv$iv;
            boolean bl = false;
            if (!(presence.getType() == null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            presence = (Presence)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Envelope(presence));
        }
        Iterable $this$minByOrNull$iv = (List)destination$iv$iv;
        boolean $i$f$minByOrNull = false;
        Iterator iterator$iv = $this$minByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = minElem$iv;
            } else {
                Envelope envelope = (Envelope)minElem$iv;
                boolean bl = false;
                Comparable minValue$iv = (Comparable)((Object)envelope.getComp());
                do {
                    Object e$iv = iterator$iv.next();
                    Envelope envelope2 = (Envelope)e$iv;
                    $i$a$-minByOrNull-PresenceModule$getBestPresenceOf$3 = false;
                    Comparable v$iv = (Comparable)((Object)envelope2.getComp());
                    if (minValue$iv.compareTo(v$iv) <= 0) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = minElem$iv;
            }
        }
        Envelope envelope = v0;
        return envelope != null ? envelope.getPresence() : null;
    }

    @Nullable
    public final Presence getPresenceOf(@NotNull JID jid) {
        Intrinsics.checkNotNullParameter((Object)jid, (String)"jid");
        return this.getStore().getPresence(jid);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<JID> getResources(@NotNull BareJID jid) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)jid, (String)"jid");
        Iterable $this$mapNotNull$iv = this.getStore().getPresences(jid);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            JID it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Presence p = (Presence)element$iv$iv;
            boolean bl2 = false;
            if (p.getFrom() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final Object process$lambda$0(Presence $presence) {
        return "Presence received " + $presence;
    }

    private static final Unit sendInitialPresence$lambda$0(PresenceNode $this$presence) {
        Intrinsics.checkNotNullParameter((Object)$this$presence, (String)"$this$presence");
        return Unit.INSTANCE;
    }

    private static final Unit sendPresence$lambda$0(JID $jid, PresenceType $type, Show $show, String $status, PresenceNode $this$presence) {
        Intrinsics.checkNotNullParameter((Object)$this$presence, (String)"$this$presence");
        if ($jid != null) {
            $this$presence.setTo($jid);
        }
        $this$presence.setType($type);
        if ($show != null) {
            $this$presence.setShow($show);
        }
        if ($status != null) {
            $this$presence.setStatus($status);
        }
        return Unit.INSTANCE;
    }

    private static final Unit sendSubscriptionSet$lambda$1(JID $jid, PresenceType $presenceType, PresenceNode $this$presence) {
        Intrinsics.checkNotNullParameter((Object)$this$presence, (String)"$this$presence");
        $this$presence.setTo($jid);
        $this$presence.setType($presenceType);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0016J)\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00022\u0017\u0010\u0010\u001a\u0013\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000e0\u0011\u00a2\u0006\u0002\b\u0012H\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0013"}, d2={"Ltigase/halcyon/core/xmpp/modules/presence/PresenceModule$Companion;", "Ltigase/halcyon/core/modules/XmppModuleProvider;", "Ltigase/halcyon/core/xmpp/modules/presence/PresenceModule;", "Ltigase/halcyon/core/xmpp/modules/presence/PresenceModuleConfig;", "<init>", "()V", "TYPE", "", "getTYPE", "()Ljava/lang/String;", "instance", "context", "Ltigase/halcyon/core/Context;", "configure", "", "module", "cfg", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "halcyon-core"})
    public static final class Companion
    implements XmppModuleProvider<PresenceModule, PresenceModuleConfig> {
        private Companion() {
        }

        @Override
        @NotNull
        public String getTYPE() {
            return TYPE;
        }

        @Override
        @NotNull
        public PresenceModule instance(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            return new PresenceModule(context);
        }

        @Override
        public void configure(@NotNull PresenceModule module, @NotNull Function1<? super PresenceModuleConfig, Unit> cfg) {
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            Intrinsics.checkNotNullParameter(cfg, (String)"cfg");
            cfg.invoke((Object)module);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

