/*
 * Decompiled with CFR 0.152.
 */
package tigase.halcyon.core.xmpp.modules.muc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.datetime.Instant;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tigase.halcyon.core.Context;
import tigase.halcyon.core.TimestampKt;
import tigase.halcyon.core.eventbus.EventBus;
import tigase.halcyon.core.exceptions.HalcyonException;
import tigase.halcyon.core.modules.Criteria;
import tigase.halcyon.core.modules.Criterion;
import tigase.halcyon.core.modules.XmppModule;
import tigase.halcyon.core.modules.XmppModuleProvider;
import tigase.halcyon.core.requests.Request;
import tigase.halcyon.core.requests.RequestBuilder;
import tigase.halcyon.core.requests.RequestBuilderFactory;
import tigase.halcyon.core.xml.Element;
import tigase.halcyon.core.xml.ElementNode;
import tigase.halcyon.core.xmpp.BareJID;
import tigase.halcyon.core.xmpp.ErrorCondition;
import tigase.halcyon.core.xmpp.ErrorConditionKt;
import tigase.halcyon.core.xmpp.FullJID;
import tigase.halcyon.core.xmpp.JID;
import tigase.halcyon.core.xmpp.JIDKt;
import tigase.halcyon.core.xmpp.XMPPException;
import tigase.halcyon.core.xmpp.forms.JabberDataForm;
import tigase.halcyon.core.xmpp.modules.PingModule;
import tigase.halcyon.core.xmpp.modules.mix.MIXModuleKt;
import tigase.halcyon.core.xmpp.modules.muc.Affiliation;
import tigase.halcyon.core.xmpp.modules.muc.DefaultMUCStore;
import tigase.halcyon.core.xmpp.modules.muc.Invitation;
import tigase.halcyon.core.xmpp.modules.muc.MUCModuleConfig;
import tigase.halcyon.core.xmpp.modules.muc.MUCStore;
import tigase.halcyon.core.xmpp.modules.muc.MucEvents;
import tigase.halcyon.core.xmpp.modules.muc.MucRoomEvents;
import tigase.halcyon.core.xmpp.modules.muc.MucUserExt;
import tigase.halcyon.core.xmpp.modules.muc.Occupant;
import tigase.halcyon.core.xmpp.modules.muc.Role;
import tigase.halcyon.core.xmpp.modules.muc.Room;
import tigase.halcyon.core.xmpp.modules.muc.RoomAffiliation;
import tigase.halcyon.core.xmpp.modules.muc.State;
import tigase.halcyon.core.xmpp.stanzas.IQ;
import tigase.halcyon.core.xmpp.stanzas.IQNode;
import tigase.halcyon.core.xmpp.stanzas.IQType;
import tigase.halcyon.core.xmpp.stanzas.Message;
import tigase.halcyon.core.xmpp.stanzas.MessageNode;
import tigase.halcyon.core.xmpp.stanzas.MessageType;
import tigase.halcyon.core.xmpp.stanzas.Presence;
import tigase.halcyon.core.xmpp.stanzas.PresenceNode;
import tigase.halcyon.core.xmpp.stanzas.PresenceType;
import tigase.halcyon.core.xmpp.stanzas.Stanza_buildersKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00a6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 R2\u00020\u00012\u00020\u0002:\u0002RSB\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u001a\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\b\b\u0002\u0010$\u001a\u00020\u001dH\u0002J\u0010\u0010%\u001a\u00020&2\u0006\u0010\"\u001a\u00020#H\u0016J\u0010\u0010'\u001a\u00020&2\u0006\u0010(\u001a\u00020)H\u0002J\u0010\u0010*\u001a\u00020&2\u0006\u0010(\u001a\u00020+H\u0002J\u0010\u0010,\u001a\u00020&2\u0006\u0010(\u001a\u00020)H\u0002J\u0010\u0010-\u001a\u00020&2\u0006\u0010(\u001a\u00020)H\u0002J\u0010\u0010.\u001a\u00020&2\u0006\u0010(\u001a\u00020)H\u0002J.\u0010/\u001a\u000e\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020+002\u0006\u00101\u001a\u00020\u001f2\u0006\u00102\u001a\u00020\n2\n\b\u0002\u00103\u001a\u0004\u0018\u00010\nJ\u001a\u00104\u001a\u000e\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020+002\u0006\u00105\u001a\u000206J\u001a\u00107\u001a\u000e\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u000208002\u0006\u00105\u001a\u000206J.\u00109\u001a\u000e\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020)002\u0006\u00105\u001a\u0002062\u0006\u0010:\u001a\u00020\u001f2\n\b\u0002\u0010;\u001a\u0004\u0018\u00010\nJ.\u0010<\u001a\u000e\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020)002\u0006\u00105\u001a\u0002062\u0006\u0010:\u001a\u00020\u001f2\n\b\u0002\u0010;\u001a\u0004\u0018\u00010\nJ\u001a\u0010=\u001a\u000e\u0012\u0004\u0012\u00020>\u0012\u0004\u0012\u000208002\u0006\u00105\u001a\u000206J\"\u0010?\u001a\u000e\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u000208002\u0006\u00105\u001a\u0002062\u0006\u0010@\u001a\u00020>J\"\u0010A\u001a\u000e\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020)002\u0006\u00105\u001a\u0002062\u0006\u0010B\u001a\u00020\nJ&\u0010C\u001a\u000e\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020)002\u0006\u0010D\u001a\u00020E2\n\b\u0002\u0010;\u001a\u0004\u0018\u00010\nJ\"\u0010F\u001a\u000e\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020+002\u0006\u0010D\u001a\u00020E2\u0006\u00102\u001a\u00020\nJ,\u0010G\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020I0H\u0012\u0004\u0012\u000208002\u0006\u00105\u001a\u0002062\n\b\u0002\u0010J\u001a\u0004\u0018\u00010KJ(\u0010L\u001a\u000e\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u000208002\u0006\u00105\u001a\u0002062\f\u0010M\u001a\b\u0012\u0004\u0012\u00020I0HJ$\u0010N\u001a\u000e\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020)002\u0006\u00105\u001a\u0002062\b\u0010O\u001a\u0004\u0018\u00010\nJ\u001a\u0010P\u001a\u000e\u0012\u0004\u0012\u00020Q\u0012\u0004\u0012\u000208002\u0006\u00105\u001a\u000206R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001e\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\u0012X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u0015\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0016\u001a\u00020\u0017X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001b\u00a8\u0006T"}, d2={"Ltigase/halcyon/core/xmpp/modules/muc/MUCModule;", "Ltigase/halcyon/core/modules/XmppModule;", "Ltigase/halcyon/core/xmpp/modules/muc/MUCModuleConfig;", "context", "Ltigase/halcyon/core/Context;", "<init>", "(Ltigase/halcyon/core/Context;)V", "getContext", "()Ltigase/halcyon/core/Context;", "type", "", "getType", "()Ljava/lang/String;", "criteria", "Ltigase/halcyon/core/modules/Criteria;", "getCriteria", "()Ltigase/halcyon/core/modules/Criteria;", "features", "", "getFeatures", "()[Ljava/lang/String;", "[Ljava/lang/String;", "store", "Ltigase/halcyon/core/xmpp/modules/muc/MUCStore;", "getStore", "()Ltigase/halcyon/core/xmpp/modules/muc/MUCStore;", "setStore", "(Ltigase/halcyon/core/xmpp/modules/muc/MUCStore;)V", "isFromKnownMUCRoom", "", "jid", "Ltigase/halcyon/core/xmpp/BareJID;", "calculateAction", "Ltigase/halcyon/core/xmpp/modules/muc/MUCModule$Action;", "element", "Ltigase/halcyon/core/xml/Element;", "checkRoomStore", "process", "", "processMessage", "stanza", "Ltigase/halcyon/core/xmpp/stanzas/Message;", "processPresence", "Ltigase/halcyon/core/xmpp/stanzas/Presence;", "processInvitationDeclinedMessage", "processMediatedInvitationMessage", "processDirectInvitationMessage", "join", "Ltigase/halcyon/core/requests/RequestBuilder;", "roomJID", "nickname", "password", "leave", "room", "Ltigase/halcyon/core/xmpp/modules/muc/Room;", "destroy", "Ltigase/halcyon/core/xmpp/stanzas/IQ;", "invite", "invitedJid", "reason", "inviteDirectly", "retrieveRoomConfig", "Ltigase/halcyon/core/xmpp/forms/JabberDataForm;", "updateRoomConfig", "form", "message", "messageBody", "decline", "invitation", "Ltigase/halcyon/core/xmpp/modules/muc/Invitation;", "accept", "retrieveAffiliations", "", "Ltigase/halcyon/core/xmpp/modules/muc/RoomAffiliation;", "filter", "Ltigase/halcyon/core/xmpp/modules/muc/Affiliation;", "updateAffiliations", "affiliations", "updateRoomSubject", "subject", "ping", "Ltigase/halcyon/core/xmpp/modules/PingModule$Pong;", "Companion", "Action", "halcyon-core"})
@SourceDebugExtension(value={"SMAP\nMUCModule.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MUCModule.kt\ntigase/halcyon/core/xmpp/modules/muc/MUCModule\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,640:1\n1563#2:641\n1634#2,2:642\n1636#2:648\n1869#2,2:649\n1227#3,2:644\n1227#3,2:646\n1#4:651\n*S KotlinDebug\n*F\n+ 1 MUCModule.kt\ntigase/halcyon/core/xmpp/modules/muc/MUCModule\n*L\n589#1:641\n589#1:642,2\n589#1:648\n611#1:649,2\n591#1:644,2\n596#1:646,2\n*E\n"})
public final class MUCModule
implements XmppModule,
MUCModuleConfig {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private final String type;
    @NotNull
    private final Criteria criteria;
    @Nullable
    private final String[] features;
    @NotNull
    private MUCStore store;
    @NotNull
    public static final String XMLNS = "http://jabber.org/protocol/muc";
    @NotNull
    private static final String TYPE = "http://jabber.org/protocol/muc";

    public MUCModule(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.type = TYPE;
        this.criteria = Criterion.Companion.element((Function1<? super Element, Boolean>)((Function1)arg_0 -> MUCModule.criteria$lambda$0(this, arg_0)));
        this.store = new DefaultMUCStore();
    }

    @Override
    @NotNull
    public Context getContext() {
        return this.context;
    }

    @Override
    @NotNull
    public String getType() {
        return this.type;
    }

    @Override
    @NotNull
    public Criteria getCriteria() {
        return this.criteria;
    }

    @Override
    @Nullable
    public String[] getFeatures() {
        return this.features;
    }

    @Override
    @NotNull
    public MUCStore getStore() {
        return this.store;
    }

    @Override
    public void setStore(@NotNull MUCStore mUCStore) {
        Intrinsics.checkNotNullParameter((Object)mUCStore, (String)"<set-?>");
        this.store = mUCStore;
    }

    private final boolean isFromKnownMUCRoom(BareJID jid) {
        return this.getStore().findRoom(jid) != null;
    }

    private final Action calculateAction(Element element2, boolean checkRoomStore) {
        if (MIXModuleKt.isMixMessage(element2)) {
            return Action.Skip;
        }
        Object object = element2.getAttributes().get("from");
        if (object == null || (object = JIDKt.toBareJID((String)object)) == null) {
            return Action.Skip;
        }
        Object from = object;
        if (Intrinsics.areEqual((Object)element2.getName(), (Object)"message")) {
            String type = element2.getAttributes().get("type");
            if (Intrinsics.areEqual((Object)type, (Object)MessageType.Error.getValue())) {
                return !checkRoomStore || this.isFromKnownMUCRoom((BareJID)from) ? Action.Message : Action.Skip;
            }
            if (Intrinsics.areEqual((Object)type, (Object)MessageType.Groupchat.getValue())) {
                return Action.Message;
            }
            for (Element x : element2.getChildren("x")) {
                if (Intrinsics.areEqual((Object)x.getXmlns(), (Object)"jabber:x:conference")) {
                    return Action.DirectInvitation;
                }
                if (Intrinsics.areEqual((Object)x.getXmlns(), (Object)"http://jabber.org/protocol/muc#user") && x.getFirstChild("invite") != null) {
                    return Action.MediatedInvitation;
                }
                if (!Intrinsics.areEqual((Object)x.getXmlns(), (Object)"http://jabber.org/protocol/muc#user") || x.getFirstChild("decline") == null) continue;
                return Action.MediatedInvitationDecline;
            }
        }
        if (Intrinsics.areEqual((Object)element2.getName(), (Object)"presence")) {
            if (!checkRoomStore) {
                return Action.Presence;
            }
            if (this.isFromKnownMUCRoom((BareJID)from)) {
                return Action.Presence;
            }
        }
        return Action.Skip;
    }

    static /* synthetic */ Action calculateAction$default(MUCModule mUCModule, Element element2, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return mUCModule.calculateAction(element2, bl);
    }

    @Override
    public void process(@NotNull Element element2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        switch (WhenMappings.$EnumSwitchMapping$0[this.calculateAction(element2, false).ordinal()]) {
            case 1: {
                this.processMessage((Message)Stanza_buildersKt.wrap(element2));
                break;
            }
            case 2: {
                this.processPresence((Presence)Stanza_buildersKt.wrap(element2));
                break;
            }
            case 3: {
                this.processInvitationDeclinedMessage((Message)Stanza_buildersKt.wrap(element2));
                break;
            }
            case 4: {
                this.processMediatedInvitationMessage((Message)Stanza_buildersKt.wrap(element2));
                break;
            }
            case 5: {
                this.processDirectInvitationMessage((Message)Stanza_buildersKt.wrap(element2));
                break;
            }
            case 6: {
                throw new XMPPException(ErrorCondition.FeatureNotImplemented);
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    private final void processMessage(Message stanza) {
        JID jID = stanza.getFrom();
        FullJID fullJID = this.getContext().getBoundJID();
        if (Intrinsics.areEqual((Object)(jID != null ? JIDKt.getBareJID(jID) : null), (Object)(fullJID != null ? fullJID.getBareJID() : null))) {
            return;
        }
        MUCStore mUCStore = this.getStore();
        JID jID2 = stanza.getFrom();
        Intrinsics.checkNotNull((Object)jID2);
        Room room = mUCStore.findRoom(JIDKt.getBareJID(jID2));
        if (room == null) {
            throw new XMPPException(ErrorCondition.ServiceUnavailable);
        }
        Room room2 = room;
        Object object = stanza.getFrom();
        if (object == null || (object = JIDKt.getResource((JID)object)) == null) {
            return;
        }
        Object nickname2 = object;
        if (stanza.getType() != MessageType.Error) {
            this.getContext().getEventBus().fire(new MucRoomEvents.ReceivedMessage(room2, (String)nickname2, stanza));
        }
    }

    private final void processPresence(Presence stanza) {
        boolean selfPresence;
        Pair pair;
        MUCStore mUCStore = this.getStore();
        JID jID = stanza.getFrom();
        Intrinsics.checkNotNull((Object)jID);
        Room room = mUCStore.findRoom(JIDKt.getBareJID(jID));
        if (room == null) {
            throw new XMPPException(ErrorCondition.ServiceUnavailable);
        }
        Room room2 = room;
        JID jID2 = stanza.getFrom();
        Intrinsics.checkNotNull((Object)jID2);
        String nickname2 = JIDKt.getResource(jID2);
        if (stanza.getType() == PresenceType.Error && room2.getState() != State.Joined && nickname2 == null) {
            room2.setState(State.NotJoined);
            EventBus eventBus = this.getContext().getEventBus();
            ErrorCondition errorCondition = ErrorConditionKt.getErrorConditionOrNull(stanza);
            if (errorCondition == null) {
                errorCondition = ErrorCondition.UndefinedCondition;
            }
            eventBus.fire(new MucRoomEvents.JoinError(room2, stanza, errorCondition));
        }
        if (nickname2 == null) {
            return;
        }
        MucUserExt mucExt = MucUserExt.Companion.createUserExt(stanza);
        if (room2.getOccupants$halcyon_core().containsKey(nickname2)) {
            Occupant occupant = room2.getOccupants$halcyon_core().get(nickname2);
            Intrinsics.checkNotNull((Object)occupant);
            Occupant p = occupant;
            pair = new Pair((Object)p, (Object)p.getPresence());
        } else {
            pair = new Pair((Object)new Occupant(stanza), null);
        }
        Pair pair2 = pair;
        Occupant occupant = (Occupant)pair2.component1();
        Presence presenceOld = (Presence)pair2.component2();
        boolean bl = selfPresence = mucExt != null && mucExt.getStatuses().contains(110) || Intrinsics.areEqual((Object)nickname2, (Object)room2.getNickname());
        if (room2.getState() == State.Joined && selfPresence) {
            room2.setState(State.NotJoined);
            room2.getOccupants$halcyon_core().clear();
            this.getContext().getEventBus().fire(new MucRoomEvents.YouLeaved(room2, stanza));
        } else if (room2.getState() != State.Joined && selfPresence) {
            room2.setState(State.Joined);
            room2.getOccupants$halcyon_core().put(nickname2, occupant);
            this.getContext().getEventBus().fire(new MucRoomEvents.YouJoined(room2, stanza, nickname2));
        } else if ((presenceOld == null || presenceOld.getType() == PresenceType.Unavailable) && stanza.getType() == null) {
            room2.getOccupants$halcyon_core().put(nickname2, occupant);
            this.getContext().getEventBus().fire(new MucRoomEvents.OccupantCame(room2, stanza, nickname2));
        } else if (stanza.getType() == PresenceType.Unavailable) {
            room2.getOccupants$halcyon_core().remove(nickname2);
            this.getContext().getEventBus().fire(new MucRoomEvents.OccupantLeave(room2, stanza, nickname2));
        } else {
            occupant.setPresence$halcyon_core(stanza);
            this.getContext().getEventBus().fire(new MucRoomEvents.OccupantChangedPresence(room2, stanza, nickname2));
        }
        if (mucExt != null && mucExt.getStatuses().contains(201)) {
            this.getContext().getEventBus().fire(new MucRoomEvents.Created(room2));
        }
    }

    private final void processInvitationDeclinedMessage(Message stanza) {
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    private final void processMediatedInvitationMessage(Message stanza) {
        JID jID = stanza.getFrom();
        if (jID == null || (jID = JIDKt.getBareJID(jID)) == null) {
            throw new XMPPException(ErrorCondition.BadRequest);
        }
        JID roomJid = jID;
        Element element2 = stanza.getChildrenNS("x", "http://jabber.org/protocol/muc#user");
        if (element2 == null || (element2 = element2.getFirstChild("invite")) == null) {
            throw new XMPPException(ErrorCondition.BadRequest);
        }
        Element invite = element2;
        Object object = invite.getAttributes().get("from");
        if (object == null || (object = JIDKt.toJID((String)object)) == null) {
            throw new XMPPException(ErrorCondition.BadRequest);
        }
        Object sender = object;
        Element element3 = invite.getFirstChild("reason");
        String reason = element3 != null ? element3.getValue() : null;
        Element element4 = stanza.getChildrenNS("x", "http://jabber.org/protocol/muc#user");
        String password = element4 != null && (element4 = element4.getFirstChild("password")) != null ? element4.getValue() : null;
        this.getContext().getEventBus().fire(new MucEvents.InvitationReceived(new Invitation((BareJID)roomJid, (JID)sender, password, reason, false)));
    }

    private final void processDirectInvitationMessage(Message stanza) {
        Element element2 = stanza.getChildrenNS("x", "jabber:x:conference");
        if (element2 == null) {
            throw new XMPPException(ErrorCondition.BadRequest);
        }
        Element invite = element2;
        JID jID = stanza.getFrom();
        if (jID == null) {
            throw new XMPPException(ErrorCondition.BadRequest);
        }
        JID sender = jID;
        Object object = invite.getAttributes().get("jid");
        if (object == null || (object = JIDKt.toBareJID((String)object)) == null) {
            throw new XMPPException(ErrorCondition.BadRequest);
        }
        Object roomJid = object;
        String password = invite.getAttributes().get("password");
        String reason = invite.getAttributes().get("reason");
        this.getContext().getEventBus().fire(new MucEvents.InvitationReceived(new Invitation((BareJID)roomJid, sender, password, reason, true)));
    }

    @NotNull
    public final RequestBuilder<Unit, Presence> join(@NotNull BareJID roomJID, @NotNull String nickname2, @Nullable String password) {
        Intrinsics.checkNotNullParameter((Object)roomJID, (String)"roomJID");
        Intrinsics.checkNotNullParameter((Object)nickname2, (String)"nickname");
        Room room = this.getStore().findRoom(roomJID);
        if (room == null) {
            room = this.getStore().createRoom(roomJID, nickname2);
        }
        Room room2 = room;
        room2.setPassword(password);
        return this.getContext().getRequest().presence((Function1<? super PresenceNode, Unit>)((Function1)arg_0 -> MUCModule.join$lambda$0(room2, nickname2, arg_0))).onSend(arg_0 -> MUCModule.join$lambda$1(room2, arg_0));
    }

    public static /* synthetic */ RequestBuilder join$default(MUCModule mUCModule, BareJID bareJID, String string, String string2, int n, Object object) {
        if ((n & 4) != 0) {
            string2 = null;
        }
        return mUCModule.join(bareJID, string, string2);
    }

    @NotNull
    public final RequestBuilder<Unit, Presence> leave(@NotNull Room room) {
        Intrinsics.checkNotNullParameter((Object)room, (String)"room");
        return this.getContext().getRequest().presence((Function1<? super PresenceNode, Unit>)((Function1)arg_0 -> MUCModule.leave$lambda$0(room, arg_0)));
    }

    @NotNull
    public final RequestBuilder<Unit, IQ> destroy(@NotNull Room room) {
        Intrinsics.checkNotNullParameter((Object)room, (String)"room");
        return this.getContext().getRequest().iq((Function1<? super IQNode, Unit>)((Function1)arg_0 -> MUCModule.destroy$lambda$0(room, arg_0))).map(MUCModule::destroy$lambda$1);
    }

    @NotNull
    public final RequestBuilder<Unit, Message> invite(@NotNull Room room, @NotNull BareJID invitedJid, @Nullable String reason) {
        Intrinsics.checkNotNullParameter((Object)room, (String)"room");
        Intrinsics.checkNotNullParameter((Object)invitedJid, (String)"invitedJid");
        return RequestBuilderFactory.message$default(this.getContext().getRequest(), false, arg_0 -> MUCModule.invite$lambda$0(room, invitedJid, reason, arg_0), 1, null);
    }

    public static /* synthetic */ RequestBuilder invite$default(MUCModule mUCModule, Room room, BareJID bareJID, String string, int n, Object object) {
        if ((n & 4) != 0) {
            string = null;
        }
        return mUCModule.invite(room, bareJID, string);
    }

    @NotNull
    public final RequestBuilder<Unit, Message> inviteDirectly(@NotNull Room room, @NotNull BareJID invitedJid, @Nullable String reason) {
        Intrinsics.checkNotNullParameter((Object)room, (String)"room");
        Intrinsics.checkNotNullParameter((Object)invitedJid, (String)"invitedJid");
        return RequestBuilderFactory.message$default(this.getContext().getRequest(), false, arg_0 -> MUCModule.inviteDirectly$lambda$0(invitedJid, room, reason, arg_0), 1, null);
    }

    public static /* synthetic */ RequestBuilder inviteDirectly$default(MUCModule mUCModule, Room room, BareJID bareJID, String string, int n, Object object) {
        if ((n & 4) != 0) {
            string = null;
        }
        return mUCModule.inviteDirectly(room, bareJID, string);
    }

    @NotNull
    public final RequestBuilder<JabberDataForm, IQ> retrieveRoomConfig(@NotNull Room room) {
        Intrinsics.checkNotNullParameter((Object)room, (String)"room");
        return this.getContext().getRequest().iq((Function1<? super IQNode, Unit>)((Function1)arg_0 -> MUCModule.retrieveRoomConfig$lambda$0(room, arg_0))).map(MUCModule::retrieveRoomConfig$lambda$1);
    }

    @NotNull
    public final RequestBuilder<Unit, IQ> updateRoomConfig(@NotNull Room room, @NotNull JabberDataForm form) {
        Intrinsics.checkNotNullParameter((Object)room, (String)"room");
        Intrinsics.checkNotNullParameter((Object)form, (String)"form");
        return this.getContext().getRequest().iq((Function1<? super IQNode, Unit>)((Function1)arg_0 -> MUCModule.updateRoomConfig$lambda$0(room, form, arg_0))).map(MUCModule::updateRoomConfig$lambda$1);
    }

    @NotNull
    public final RequestBuilder<Unit, Message> message(@NotNull Room room, @NotNull String messageBody) {
        Intrinsics.checkNotNullParameter((Object)room, (String)"room");
        Intrinsics.checkNotNullParameter((Object)messageBody, (String)"messageBody");
        return RequestBuilderFactory.message$default(this.getContext().getRequest(), false, arg_0 -> MUCModule.message$lambda$0(room, messageBody, arg_0), 1, null);
    }

    @NotNull
    public final RequestBuilder<Unit, Message> decline(@NotNull Invitation invitation, @Nullable String reason) {
        Intrinsics.checkNotNullParameter((Object)invitation, (String)"invitation");
        if (invitation.getDirect()) {
            throw new HalcyonException("Direct invitation should be silently ignored.");
        }
        return RequestBuilderFactory.message$default(this.getContext().getRequest(), false, arg_0 -> MUCModule.decline$lambda$0(invitation, reason, arg_0), 1, null);
    }

    public static /* synthetic */ RequestBuilder decline$default(MUCModule mUCModule, Invitation invitation, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        return mUCModule.decline(invitation, string);
    }

    @NotNull
    public final RequestBuilder<Unit, Presence> accept(@NotNull Invitation invitation, @NotNull String nickname2) {
        Intrinsics.checkNotNullParameter((Object)invitation, (String)"invitation");
        Intrinsics.checkNotNullParameter((Object)nickname2, (String)"nickname");
        return this.join(invitation.getRoomjid(), nickname2, invitation.getPassword());
    }

    @NotNull
    public final RequestBuilder<Collection<RoomAffiliation>, IQ> retrieveAffiliations(@NotNull Room room, @Nullable Affiliation filter) {
        Intrinsics.checkNotNullParameter((Object)room, (String)"room");
        return this.getContext().getRequest().iq((Function1<? super IQNode, Unit>)((Function1)arg_0 -> MUCModule.retrieveAffiliations$lambda$0(room, filter, arg_0))).map(MUCModule::retrieveAffiliations$lambda$1);
    }

    public static /* synthetic */ RequestBuilder retrieveAffiliations$default(MUCModule mUCModule, Room room, Affiliation affiliation, int n, Object object) {
        if ((n & 2) != 0) {
            affiliation = null;
        }
        return mUCModule.retrieveAffiliations(room, affiliation);
    }

    @NotNull
    public final RequestBuilder<Unit, IQ> updateAffiliations(@NotNull Room room, @NotNull Collection<RoomAffiliation> affiliations) {
        Intrinsics.checkNotNullParameter((Object)room, (String)"room");
        Intrinsics.checkNotNullParameter(affiliations, (String)"affiliations");
        return this.getContext().getRequest().iq((Function1<? super IQNode, Unit>)((Function1)arg_0 -> MUCModule.updateAffiliations$lambda$0(room, affiliations, arg_0))).map(MUCModule::updateAffiliations$lambda$1);
    }

    @NotNull
    public final RequestBuilder<Unit, Message> updateRoomSubject(@NotNull Room room, @Nullable String subject) {
        Intrinsics.checkNotNullParameter((Object)room, (String)"room");
        return RequestBuilderFactory.message$default(this.getContext().getRequest(), false, arg_0 -> MUCModule.updateRoomSubject$lambda$0(room, subject, arg_0), 1, null);
    }

    @NotNull
    public final RequestBuilder<PingModule.Pong, IQ> ping(@NotNull Room room) {
        Intrinsics.checkNotNullParameter((Object)room, (String)"room");
        return ((PingModule)this.getContext().getModules().get(PingModule.Companion.getTYPE())).ping(new FullJID(room.getRoomJID(), room.getNickname()));
    }

    private static final boolean criteria$lambda$0(MUCModule this$0, Element element2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        return MUCModule.calculateAction$default(this$0, element2, false, 2, null) != Action.Skip;
    }

    private static final Unit join$lambda$0(Room $room, String $nickname, PresenceNode $this$presence) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)$this$presence, (String)"$this$presence");
            $this$presence.setTo(JIDKt.copy($room.getRoomJID(), $nickname));
            ElementNode.invoke$default($this$presence, "x", null, arg_0 -> MUCModule.join$lambda$0$0($room, arg_0), 1, null);
            Instant instant = $room.getLastMessageTimestamp();
            if (instant == null) break block0;
            Instant lmt = instant;
            boolean bl = false;
            ElementNode.invoke$default($this$presence, "history", null, arg_0 -> MUCModule.join$lambda$0$1$0(lmt, arg_0), 1, null);
        }
        return Unit.INSTANCE;
    }

    private static final Unit join$lambda$0$0(Room $room, ElementNode $this$invoke) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)$this$invoke, (String)"$this$invoke");
            $this$invoke.setXmlns(XMLNS);
            String string = $room.getPassword();
            if (string == null) break block0;
            String pwd = string;
            boolean bl = false;
            ElementNode.invoke$default($this$invoke, "password", null, arg_0 -> MUCModule.join$lambda$0$0$0$0(pwd, arg_0), 1, null);
        }
        return Unit.INSTANCE;
    }

    private static final Unit join$lambda$0$0$0$0(String $pwd, ElementNode $this$invoke) {
        Intrinsics.checkNotNullParameter((Object)$this$invoke, (String)"$this$invoke");
        $this$invoke.unaryPlus($pwd);
        return Unit.INSTANCE;
    }

    private static final Unit join$lambda$0$1$0(Instant $lmt, ElementNode $this$invoke) {
        Intrinsics.checkNotNullParameter((Object)$this$invoke, (String)"$this$invoke");
        $this$invoke.getAttributes().set("since", TimestampKt.timestampToISO8601($lmt));
        return Unit.INSTANCE;
    }

    private static final Unit join$lambda$1(Room $room, Request it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $room.setState(State.RequestSent);
        return Unit.INSTANCE;
    }

    private static final Unit leave$lambda$0(Room $room, PresenceNode $this$presence) {
        Intrinsics.checkNotNullParameter((Object)$this$presence, (String)"$this$presence");
        $this$presence.setTo(JIDKt.copy($room.getRoomJID(), $room.getNickname()));
        $this$presence.setType(PresenceType.Unavailable);
        return Unit.INSTANCE;
    }

    private static final Unit destroy$lambda$0(Room $room, IQNode $this$iq) {
        Intrinsics.checkNotNullParameter((Object)$this$iq, (String)"$this$iq");
        $this$iq.setType(IQType.Set);
        $this$iq.setTo($room.getRoomJID());
        ElementNode.invoke$default($this$iq, "query", null, MUCModule::destroy$lambda$0$0, 1, null);
        return Unit.INSTANCE;
    }

    private static final Unit destroy$lambda$0$0(ElementNode $this$invoke) {
        Intrinsics.checkNotNullParameter((Object)$this$invoke, (String)"$this$invoke");
        $this$invoke.setXmlns("http://jabber.org/protocol/muc#owner");
        ElementNode.invoke$default($this$invoke, "destroy", null, MUCModule::destroy$lambda$0$0$0, 1, null);
        return Unit.INSTANCE;
    }

    private static final Unit destroy$lambda$0$0$0(ElementNode $this$invoke) {
        Intrinsics.checkNotNullParameter((Object)$this$invoke, (String)"$this$invoke");
        return Unit.INSTANCE;
    }

    private static final Unit destroy$lambda$1(IQ it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Unit.INSTANCE;
    }

    private static final Unit invite$lambda$0(Room $room, BareJID $invitedJid, String $reason, MessageNode $this$message) {
        Intrinsics.checkNotNullParameter((Object)$this$message, (String)"$this$message");
        $this$message.setTo($room.getRoomJID());
        ElementNode.invoke$default($this$message, "x", null, arg_0 -> MUCModule.invite$lambda$0$0($invitedJid, $reason, arg_0), 1, null);
        return Unit.INSTANCE;
    }

    private static final Unit invite$lambda$0$0(BareJID $invitedJid, String $reason, ElementNode $this$invoke) {
        Intrinsics.checkNotNullParameter((Object)$this$invoke, (String)"$this$invoke");
        $this$invoke.setXmlns("http://jabber.org/protocol/muc#user");
        ElementNode.invoke$default($this$invoke, "invite", null, arg_0 -> MUCModule.invite$lambda$0$0$0($invitedJid, $reason, arg_0), 1, null);
        return Unit.INSTANCE;
    }

    private static final Unit invite$lambda$0$0$0(BareJID $invitedJid, String $reason, ElementNode $this$invoke) {
        Intrinsics.checkNotNullParameter((Object)$this$invoke, (String)"$this$invoke");
        $this$invoke.getAttributes().set("to", $invitedJid.toString());
        if ($reason != null) {
            ElementNode.invoke$default($this$invoke, "reason", null, arg_0 -> MUCModule.invite$lambda$0$0$0$0($reason, arg_0), 1, null);
        }
        return Unit.INSTANCE;
    }

    private static final Unit invite$lambda$0$0$0$0(String $reason, ElementNode $this$invoke) {
        Intrinsics.checkNotNullParameter((Object)$this$invoke, (String)"$this$invoke");
        $this$invoke.unaryPlus($reason);
        return Unit.INSTANCE;
    }

    private static final Unit inviteDirectly$lambda$0(BareJID $invitedJid, Room $room, String $reason, MessageNode $this$message) {
        Intrinsics.checkNotNullParameter((Object)$this$message, (String)"$this$message");
        $this$message.setTo($invitedJid);
        ElementNode.invoke$default($this$message, "x", null, arg_0 -> MUCModule.inviteDirectly$lambda$0$0($room, $reason, arg_0), 1, null);
        return Unit.INSTANCE;
    }

    private static final Unit inviteDirectly$lambda$0$0(Room $room, String $reason, ElementNode $this$invoke) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)$this$invoke, (String)"$this$invoke");
            $this$invoke.setXmlns("jabber:x:conference");
            $this$invoke.getAttributes().set("jid", $room.getRoomJID().toString());
            String string = $reason;
            if (string != null) {
                String it = string;
                boolean bl = false;
                $this$invoke.getAttributes().set("reason", $reason);
            }
            String string2 = $room.getPassword();
            if (string2 == null) break block1;
            String it = string2;
            boolean bl = false;
            $this$invoke.getAttributes().set("password", it);
        }
        return Unit.INSTANCE;
    }

    private static final Unit retrieveRoomConfig$lambda$0(Room $room, IQNode $this$iq) {
        Intrinsics.checkNotNullParameter((Object)$this$iq, (String)"$this$iq");
        $this$iq.setTo($room.getRoomJID());
        $this$iq.setType(IQType.Get);
        ElementNode.invoke$default($this$iq, "query", null, MUCModule::retrieveRoomConfig$lambda$0$0, 1, null);
        return Unit.INSTANCE;
    }

    private static final Unit retrieveRoomConfig$lambda$0$0(ElementNode $this$invoke) {
        Intrinsics.checkNotNullParameter((Object)$this$invoke, (String)"$this$invoke");
        $this$invoke.setXmlns("http://jabber.org/protocol/muc#owner");
        return Unit.INSTANCE;
    }

    private static final JabberDataForm retrieveRoomConfig$lambda$1(IQ iq) {
        Intrinsics.checkNotNullParameter((Object)iq, (String)"iq");
        Element element2 = iq.getChildrenNS("query", "http://jabber.org/protocol/muc#owner");
        if (element2 == null || (element2 = element2.getFirstChild("x")) == null) {
            throw new XMPPException(ErrorCondition.BadRequest, "Missing data form.");
        }
        Element x = element2;
        return new JabberDataForm(x);
    }

    private static final Unit updateRoomConfig$lambda$0(Room $room, JabberDataForm $form, IQNode $this$iq) {
        Intrinsics.checkNotNullParameter((Object)$this$iq, (String)"$this$iq");
        $this$iq.setTo($room.getRoomJID());
        $this$iq.setType(IQType.Set);
        ElementNode.invoke$default($this$iq, "query", null, arg_0 -> MUCModule.updateRoomConfig$lambda$0$0($form, arg_0), 1, null);
        return Unit.INSTANCE;
    }

    private static final Unit updateRoomConfig$lambda$0$0(JabberDataForm $form, ElementNode $this$invoke) {
        Intrinsics.checkNotNullParameter((Object)$this$invoke, (String)"$this$invoke");
        $this$invoke.setXmlns("http://jabber.org/protocol/muc#owner");
        $this$invoke.addChild($form.createSubmitForm());
        return Unit.INSTANCE;
    }

    private static final Unit updateRoomConfig$lambda$1(IQ it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Unit.INSTANCE;
    }

    private static final Unit message$lambda$0(Room $room, String $messageBody, MessageNode $this$message) {
        Intrinsics.checkNotNullParameter((Object)$this$message, (String)"$this$message");
        $this$message.setTo($room.getRoomJID());
        $this$message.setType(MessageType.Groupchat);
        $this$message.setBody($messageBody);
        return Unit.INSTANCE;
    }

    private static final Unit decline$lambda$0(Invitation $invitation, String $reason, MessageNode $this$message) {
        Intrinsics.checkNotNullParameter((Object)$this$message, (String)"$this$message");
        $this$message.setTo($invitation.getRoomjid());
        ElementNode.invoke$default($this$message, "x", null, arg_0 -> MUCModule.decline$lambda$0$0($invitation, $reason, arg_0), 1, null);
        return Unit.INSTANCE;
    }

    private static final Unit decline$lambda$0$0(Invitation $invitation, String $reason, ElementNode $this$invoke) {
        Intrinsics.checkNotNullParameter((Object)$this$invoke, (String)"$this$invoke");
        $this$invoke.setXmlns("http://jabber.org/protocol/muc#user");
        ElementNode.invoke$default($this$invoke, "decline", null, arg_0 -> MUCModule.decline$lambda$0$0$0($invitation, $reason, arg_0), 1, null);
        return Unit.INSTANCE;
    }

    private static final Unit decline$lambda$0$0$0(Invitation $invitation, String $reason, ElementNode $this$invoke) {
        Intrinsics.checkNotNullParameter((Object)$this$invoke, (String)"$this$invoke");
        $this$invoke.getAttributes().set("to", JIDKt.getBareJID($invitation.getSender()).toString());
        if ($reason != null) {
            ElementNode.invoke$default($this$invoke, "reason", null, arg_0 -> MUCModule.decline$lambda$0$0$0$0($reason, arg_0), 1, null);
        }
        return Unit.INSTANCE;
    }

    private static final Unit decline$lambda$0$0$0$0(String $reason, ElementNode $this$invoke) {
        Intrinsics.checkNotNullParameter((Object)$this$invoke, (String)"$this$invoke");
        $this$invoke.unaryPlus($reason);
        return Unit.INSTANCE;
    }

    private static final Unit retrieveAffiliations$lambda$0(Room $room, Affiliation $filter, IQNode $this$iq) {
        Intrinsics.checkNotNullParameter((Object)$this$iq, (String)"$this$iq");
        $this$iq.setTo($room.getRoomJID());
        $this$iq.setType(IQType.Get);
        ElementNode.invoke$default($this$iq, "query", null, arg_0 -> MUCModule.retrieveAffiliations$lambda$0$0($filter, arg_0), 1, null);
        return Unit.INSTANCE;
    }

    private static final Unit retrieveAffiliations$lambda$0$0(Affiliation $filter, ElementNode $this$invoke) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)$this$invoke, (String)"$this$invoke");
            $this$invoke.setXmlns("http://jabber.org/protocol/muc#admin");
            Affiliation affiliation = $filter;
            if (affiliation == null) break block0;
            Affiliation it = affiliation;
            boolean bl = false;
            ElementNode.invoke$default($this$invoke, "item", null, arg_0 -> MUCModule.retrieveAffiliations$lambda$0$0$0$0($filter, arg_0), 1, null);
        }
        return Unit.INSTANCE;
    }

    private static final Unit retrieveAffiliations$lambda$0$0$0$0(Affiliation $filter, ElementNode $this$invoke) {
        Intrinsics.checkNotNullParameter((Object)$this$invoke, (String)"$this$invoke");
        $this$invoke.getAttributes().set("affiliation", $filter.getXmppValue());
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Collection retrieveAffiliations$lambda$1(IQ iq) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)iq, (String)"iq");
        Element element2 = iq.getChildrenNS("query", "http://jabber.org/protocol/muc#admin");
        if (element2 == null) {
            throw new XMPPException(ErrorCondition.BadRequest);
        }
        Element q = element2;
        Iterable $this$map$iv = q.getChildren("item");
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Role role2;
            String nickname2;
            JID jid;
            Object aff;
            Collection collection;
            block12: {
                Object object;
                void it;
                block14: {
                    block13: {
                        Affiliation element$iv;
                        block11: {
                            Element element3 = (Element)item$iv$iv;
                            collection = destination$iv$iv;
                            boolean bl = false;
                            object = it.getAttributes().get("affiliation");
                            if (object == null) break block13;
                            String aff2 = object;
                            boolean bl2 = false;
                            Affiliation[] $this$first$iv = Affiliation.values();
                            boolean $i$f$first = false;
                            int n = $this$first$iv.length;
                            for (int i = 0; i < n; ++i) {
                                Affiliation it2 = element$iv = $this$first$iv[i];
                                boolean bl3 = false;
                                if (!Intrinsics.areEqual((Object)it2.getXmppValue(), (Object)aff2)) {
                                    continue;
                                }
                                break block11;
                            }
                            throw new NoSuchElementException("Array contains no element matching the predicate.");
                        }
                        Affiliation affiliation = element$iv;
                        object = affiliation;
                        if (affiliation != null) break block14;
                    }
                    object = Affiliation.None;
                }
                aff = object;
                String string = it.getAttributes().get("jid");
                jid = string != null ? JIDKt.toJID(string) : null;
                nickname2 = it.getAttributes().get("nick");
                if (it.getAttributes().get("role") != null) {
                    boolean bl = false;
                    Role[] $this$first$iv = Role.values();
                    boolean $i$f$first = false;
                    int n = $this$first$iv.length;
                    for (int i = 0; i < n; ++i) {
                        String rl;
                        Role element$iv;
                        Role it3 = element$iv = $this$first$iv[i];
                        boolean bl4 = false;
                        if (!Intrinsics.areEqual((Object)it3.getXmppValue(), (Object)rl)) continue;
                        role2 = element$iv;
                        break block12;
                    }
                    throw new NoSuchElementException("Array contains no element matching the predicate.");
                }
                role2 = null;
            }
            Role role3 = role2;
            collection.add(new RoomAffiliation(jid, (Affiliation)((Object)aff), nickname2, role3));
        }
        return (List)destination$iv$iv;
    }

    private static final Unit updateAffiliations$lambda$0(Room $room, Collection $affiliations, IQNode $this$iq) {
        Intrinsics.checkNotNullParameter((Object)$this$iq, (String)"$this$iq");
        $this$iq.setTo($room.getRoomJID());
        $this$iq.setType(IQType.Set);
        ElementNode.invoke$default($this$iq, "query", null, arg_0 -> MUCModule.updateAffiliations$lambda$0$0($affiliations, arg_0), 1, null);
        return Unit.INSTANCE;
    }

    private static final Unit updateAffiliations$lambda$0$0(Collection $affiliations, ElementNode $this$invoke) {
        Intrinsics.checkNotNullParameter((Object)$this$invoke, (String)"$this$invoke");
        $this$invoke.setXmlns("http://jabber.org/protocol/muc#admin");
        Iterable $this$forEach$iv = $affiliations;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RoomAffiliation a = (RoomAffiliation)element$iv;
            boolean bl = false;
            ElementNode.invoke$default($this$invoke, "item", null, arg_0 -> MUCModule.updateAffiliations$lambda$0$0$0$0(a, arg_0), 1, null);
        }
        return Unit.INSTANCE;
    }

    private static final Unit updateAffiliations$lambda$0$0$0$0(RoomAffiliation $a, ElementNode $this$invoke) {
        block1: {
            Object it;
            Intrinsics.checkNotNullParameter((Object)$this$invoke, (String)"$this$invoke");
            $this$invoke.getAttributes().set("affiliation", $a.getAffiliation().getXmppValue());
            JID jID = $a.getJid();
            if (jID != null) {
                it = jID;
                boolean bl = false;
                $this$invoke.getAttributes().set("jid", it.toString());
            }
            Role role2 = $a.getRole();
            if (role2 == null) break block1;
            it = role2;
            boolean bl = false;
            $this$invoke.getAttributes().set("role", ((Role)((Object)it)).getXmppValue());
        }
        return Unit.INSTANCE;
    }

    private static final Unit updateAffiliations$lambda$1(IQ it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Unit.INSTANCE;
    }

    private static final Unit updateRoomSubject$lambda$0(Room $room, String $subject, MessageNode $this$message) {
        Intrinsics.checkNotNullParameter((Object)$this$message, (String)"$this$message");
        $this$message.setTo($room.getRoomJID());
        $this$message.setType(MessageType.Groupchat);
        ElementNode.invoke$default($this$message, "subject", null, arg_0 -> MUCModule.updateRoomSubject$lambda$0$0($subject, arg_0), 1, null);
        return Unit.INSTANCE;
    }

    private static final Unit updateRoomSubject$lambda$0$0(String $subject, ElementNode $this$invoke) {
        Intrinsics.checkNotNullParameter((Object)$this$invoke, (String)"$this$invoke");
        if ($subject != null) {
            $this$invoke.unaryPlus($subject);
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\t\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\n"}, d2={"Ltigase/halcyon/core/xmpp/modules/muc/MUCModule$Action;", "", "<init>", "(Ljava/lang/String;I)V", "Skip", "MediatedInvitationDecline", "MediatedInvitation", "DirectInvitation", "Message", "Presence", "halcyon-core"})
    private static final class Action
    extends Enum<Action> {
        public static final /* enum */ Action Skip = new Action();
        public static final /* enum */ Action MediatedInvitationDecline = new Action();
        public static final /* enum */ Action MediatedInvitation = new Action();
        public static final /* enum */ Action DirectInvitation = new Action();
        public static final /* enum */ Action Message = new Action();
        public static final /* enum */ Action Presence = new Action();
        private static final /* synthetic */ Action[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Action[] values() {
            return (Action[])$VALUES.clone();
        }

        public static Action valueOf(String value) {
            return Enum.valueOf(Action.class, value);
        }

        @NotNull
        public static EnumEntries<Action> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = actionArray = new Action[]{Action.Skip, Action.MediatedInvitationDecline, Action.MediatedInvitation, Action.DirectInvitation, Action.Message, Action.Presence};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\rH\u0016J)\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00022\u0017\u0010\u0011\u001a\u0013\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000f0\u0012\u00a2\u0006\u0002\b\u0013H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\u0007X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Ltigase/halcyon/core/xmpp/modules/muc/MUCModule$Companion;", "Ltigase/halcyon/core/modules/XmppModuleProvider;", "Ltigase/halcyon/core/xmpp/modules/muc/MUCModule;", "Ltigase/halcyon/core/xmpp/modules/muc/MUCModuleConfig;", "<init>", "()V", "XMLNS", "", "TYPE", "getTYPE", "()Ljava/lang/String;", "instance", "context", "Ltigase/halcyon/core/Context;", "configure", "", "module", "cfg", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "halcyon-core"})
    public static final class Companion
    implements XmppModuleProvider<MUCModule, MUCModuleConfig> {
        private Companion() {
        }

        @Override
        @NotNull
        public String getTYPE() {
            return TYPE;
        }

        @Override
        @NotNull
        public MUCModule instance(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            return new MUCModule(context);
        }

        @Override
        public void configure(@NotNull MUCModule module, @NotNull Function1<? super MUCModuleConfig, Unit> cfg) {
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            Intrinsics.checkNotNullParameter(cfg, (String)"cfg");
            cfg.invoke((Object)module);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Action.values().length];
            try {
                nArray[Action.Message.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Action.Presence.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Action.MediatedInvitationDecline.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Action.MediatedInvitation.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Action.DirectInvitation.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Action.Skip.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

