/*
 * Decompiled with CFR 0.152.
 */
package tigase.halcyon.core.logger.internal;

import java.util.logging.LogRecord;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tigase.halcyon.core.logger.Level;
import tigase.halcyon.core.logger.LoggerInternal;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\"\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00032\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\"\u0010\n\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00032\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0016\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Ltigase/halcyon/core/logger/internal/DefaultLoggerSPI;", "Ltigase/halcyon/core/logger/LoggerInternal;", "name", "", "enabled", "", "<init>", "(Ljava/lang/String;Z)V", "getEnabled", "()Z", "log", "Ljava/util/logging/Logger;", "kotlin.jvm.PlatformType", "cnv", "Ljava/util/logging/Level;", "level", "Ltigase/halcyon/core/logger/Level;", "isLoggable", "doLog", "", "msg", "caught", "", "fillCaller", "lr", "Ljava/util/logging/LogRecord;", "halcyon-core"})
public final class DefaultLoggerSPI
implements LoggerInternal {
    private final boolean enabled;
    private final Logger log;

    public DefaultLoggerSPI(@NotNull String name2, boolean enabled) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        this.enabled = enabled;
        this.log = Logger.getLogger(name2);
    }

    public final boolean getEnabled() {
        return this.enabled;
    }

    private final java.util.logging.Level cnv(Level level) {
        java.util.logging.Level level2;
        switch (WhenMappings.$EnumSwitchMapping$0[level.ordinal()]) {
            case 1: {
                java.util.logging.Level level3 = java.util.logging.Level.OFF;
                level2 = level3;
                Intrinsics.checkNotNullExpressionValue((Object)level3, (String)"OFF");
                break;
            }
            case 2: {
                java.util.logging.Level level4 = java.util.logging.Level.SEVERE;
                level2 = level4;
                Intrinsics.checkNotNullExpressionValue((Object)level4, (String)"SEVERE");
                break;
            }
            case 3: {
                java.util.logging.Level level5 = java.util.logging.Level.WARNING;
                level2 = level5;
                Intrinsics.checkNotNullExpressionValue((Object)level5, (String)"WARNING");
                break;
            }
            case 4: {
                java.util.logging.Level level6 = java.util.logging.Level.INFO;
                level2 = level6;
                Intrinsics.checkNotNullExpressionValue((Object)level6, (String)"INFO");
                break;
            }
            case 5: {
                java.util.logging.Level level7 = java.util.logging.Level.CONFIG;
                level2 = level7;
                Intrinsics.checkNotNullExpressionValue((Object)level7, (String)"CONFIG");
                break;
            }
            case 6: {
                java.util.logging.Level level8 = java.util.logging.Level.FINE;
                level2 = level8;
                Intrinsics.checkNotNullExpressionValue((Object)level8, (String)"FINE");
                break;
            }
            case 7: {
                java.util.logging.Level level9 = java.util.logging.Level.FINER;
                level2 = level9;
                Intrinsics.checkNotNullExpressionValue((Object)level9, (String)"FINER");
                break;
            }
            case 8: {
                java.util.logging.Level level10 = java.util.logging.Level.FINEST;
                level2 = level10;
                Intrinsics.checkNotNullExpressionValue((Object)level10, (String)"FINEST");
                break;
            }
            case 9: {
                java.util.logging.Level level11 = java.util.logging.Level.ALL;
                level2 = level11;
                Intrinsics.checkNotNullExpressionValue((Object)level11, (String)"ALL");
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return level2;
    }

    @Override
    public boolean isLoggable(@NotNull Level level) {
        Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
        return this.log.isLoggable(this.cnv(level));
    }

    private final void doLog(Level level, String msg, Throwable caught) {
        if (!this.enabled) {
            return;
        }
        LogRecord lr = new LogRecord(this.cnv(level), msg);
        if (caught != null) {
            lr.setThrown(caught);
        }
        this.fillCaller(lr);
        this.log.log(lr);
    }

    private final void fillCaller(LogRecord lr) {
        StackTraceElement stackTraceElement;
        block2: {
            Throwable trace = new Throwable();
            StackTraceElement[] list = trace.getStackTrace();
            Intrinsics.checkNotNull((Object)list);
            StackTraceElement[] stackTraceElementArray = list;
            int n = stackTraceElementArray.length;
            for (int i = 0; i < n; ++i) {
                StackTraceElement stackTraceElement2;
                StackTraceElement stackTraceElement3 = stackTraceElement2 = stackTraceElementArray[i];
                boolean bl = false;
                String string = stackTraceElement3.getClassName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getClassName(...)");
                boolean bl2 = !StringsKt.startsWith$default((String)string, (String)"tigase.halcyon.core.logger.", (boolean)false, (int)2, null);
                if (!bl2) continue;
                stackTraceElement = stackTraceElement2;
                break block2;
            }
            stackTraceElement = null;
        }
        StackTraceElement stackTraceElement4 = stackTraceElement;
        boolean bl = false;
        if (stackTraceElement4 != null) {
            lr.setSourceClassName(stackTraceElement4.getClassName());
            lr.setSourceMethodName(stackTraceElement4.getMethodName());
        }
    }

    @Override
    public void log(@NotNull Level level, @NotNull String msg, @Nullable Throwable caught) {
        Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        this.doLog(level, msg, caught);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Level.values().length];
            try {
                nArray[Level.OFF.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Level.SEVERE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Level.WARNING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Level.INFO.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Level.CONFIG.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Level.FINE.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Level.FINER.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Level.FINEST.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Level.ALL.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

