/*
 * Decompiled with CFR 0.152.
 */
package tigase.halcyon.core.eventbus;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import tigase.halcyon.core.TickEvent;
import tigase.halcyon.core.eventbus.Event;
import tigase.halcyon.core.eventbus.EventBusInterface;
import tigase.halcyon.core.eventbus.EventDefinition;
import tigase.halcyon.core.eventbus.EventHandler;
import tigase.halcyon.core.logger.Level;
import tigase.halcyon.core.logger.Logger;
import tigase.halcyon.core.logger.LoggerFactory;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0011\u001a\u0018\u0012\u0004\u0012\u00020\n\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f0\u000b0\tH$J\u0012\u0010\u0012\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f0\u000bH$J\u001a\u0010\u0013\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f0\u00142\u0006\u0010\u0015\u001a\u00020\nH\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H&J\u0010\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\"\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0010\u0010\u001b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f0\u0014H\u0014J(\u0010\u001c\u001a\u00020\u0017\"\b\b\u0000\u0010\u001d*\u00020\u00192\u0006\u0010\u0015\u001a\u00020\n2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u0002H\u001d0\fH\u0016J.\u0010\u001c\u001a\u00020\u0017\"\b\b\u0000\u0010\u001d*\u00020\u00192\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H\u001d0 2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u0002H\u001d0\fH\u0016J.\u0010\u001c\u001a\u00020\u0017\"\b\b\u0000\u0010\u001d*\u00020\u00192\u0006\u0010\u0015\u001a\u00020\n2\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u0002H\u001d\u0012\u0004\u0012\u00020\u00170!H\u0016J4\u0010\u001c\u001a\u00020\u0017\"\b\b\u0000\u0010\u001d*\u00020\u00192\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H\u001d0 2\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u0002H\u001d\u0012\u0004\u0012\u00020\u00170!H\u0016J\u001c\u0010\"\u001a\u00020\u00172\u0006\u0010\u0015\u001a\u00020\n2\n\u0010\u001e\u001a\u0006\u0012\u0002\b\u00030\fH\u0016J \u0010\"\u001a\u00020\u00172\n\u0010\u001f\u001a\u0006\u0012\u0002\b\u00030 2\n\u0010\u001e\u001a\u0006\u0012\u0002\b\u00030\fH\u0016J\u0014\u0010\"\u001a\u00020\u00172\n\u0010\u001e\u001a\u0006\u0012\u0002\b\u00030\fH\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R0\u0010\b\u001a\u0018\u0012\u0004\u0012\u00020\n\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f0\u000b0\tX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006#"}, d2={"Ltigase/halcyon/core/eventbus/NoContextEventBus;", "Ltigase/halcyon/core/eventbus/EventBusInterface;", "<init>", "()V", "log", "Ltigase/halcyon/core/logger/Logger;", "getLog", "()Ltigase/halcyon/core/logger/Logger;", "handlersMap", "", "", "", "Ltigase/halcyon/core/eventbus/EventHandler;", "getHandlersMap", "()Ljava/util/Map;", "setHandlersMap", "(Ljava/util/Map;)V", "createHandlersMap", "createHandlersSet", "getHandlers", "", "eventType", "updateBeforeFire", "", "event", "Ltigase/halcyon/core/eventbus/Event;", "fire", "handlers", "register", "T", "handler", "definition", "Ltigase/halcyon/core/eventbus/EventDefinition;", "Lkotlin/Function1;", "unregister", "halcyon-core"})
@SourceDebugExtension(value={"SMAP\nNoContextEventBus.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NoContextEventBus.kt\ntigase/halcyon/core/eventbus/NoContextEventBus\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,107:1\n1869#2,2:108\n*S KotlinDebug\n*F\n+ 1 NoContextEventBus.kt\ntigase/halcyon/core/eventbus/NoContextEventBus\n*L\n63#1:108,2\n*E\n"})
public abstract class NoContextEventBus
implements EventBusInterface {
    @NotNull
    private final Logger log = LoggerFactory.logger$default(LoggerFactory.INSTANCE, "tigase.halcyon.core.eventbus.EventBus", false, 2, null);
    @NotNull
    private Map<String, Set<EventHandler<?>>> handlersMap = this.createHandlersMap();

    @NotNull
    protected final Logger getLog() {
        return this.log;
    }

    @NotNull
    protected final Map<String, Set<EventHandler<?>>> getHandlersMap() {
        return this.handlersMap;
    }

    protected final void setHandlersMap(@NotNull Map<String, Set<EventHandler<?>>> map) {
        Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
        this.handlersMap = map;
    }

    @NotNull
    protected abstract Map<String, Set<EventHandler<?>>> createHandlersMap();

    @NotNull
    protected abstract Set<EventHandler<?>> createHandlersSet();

    private final Collection<EventHandler<?>> getHandlers(String eventType) {
        Set<EventHandler<?>> h2;
        HashSet result = new HashSet();
        Set<EventHandler<?>> a = this.handlersMap.get("EventBus#ALL_EVENTS");
        if (a != null && !((Collection)a).isEmpty()) {
            result.addAll(a);
        }
        if ((h2 = this.handlersMap.get(eventType)) != null && !((Collection)h2).isEmpty()) {
            result.addAll(h2);
        }
        return result;
    }

    public abstract void updateBeforeFire(@NotNull Event var1);

    @Override
    public void fire(@NotNull Event event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.updateBeforeFire(event);
        Collection<EventHandler<?>> handlers = this.getHandlers(event.getEventType());
        this.fire(event, handlers);
    }

    protected void fire(@NotNull Event event, @NotNull Collection<? extends EventHandler<?>> handlers) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter(handlers, (String)"handlers");
        if (!(event instanceof TickEvent) || this.log.isLoggable(Level.FINEST)) {
            Logger.fine$default(this.log, null, () -> NoContextEventBus.fire$lambda$0(event, handlers), 1, null);
        }
        Iterable $this$forEach$iv = handlers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EventHandler eventHandler = (EventHandler)element$iv;
            boolean bl = false;
            try {
                Intrinsics.checkNotNull((Object)eventHandler, (String)"null cannot be cast to non-null type tigase.halcyon.core.eventbus.EventHandler<tigase.halcyon.core.eventbus.Event>");
                eventHandler.onEvent(event);
            }
            catch (Exception e) {
                this.log.warning(e, (Function0<? extends Object>)((Function0)() -> NoContextEventBus.fire$lambda$1$0(event)));
            }
        }
    }

    @Override
    public <T extends Event> void register(@NotNull String eventType, @NotNull EventHandler<? super T> handler2) {
        Intrinsics.checkNotNullParameter((Object)eventType, (String)"eventType");
        Intrinsics.checkNotNullParameter(handler2, (String)"handler");
        Set<EventHandler<?>> handlers = this.handlersMap.get(eventType);
        if (handlers == null) {
            handlers = this.createHandlersSet();
            this.handlersMap.put(eventType, handlers);
        }
        handlers.add(handler2);
    }

    @Override
    public <T extends Event> void register(@NotNull EventDefinition<? extends T> definition, @NotNull EventHandler<? super T> handler2) {
        Intrinsics.checkNotNullParameter(definition, (String)"definition");
        Intrinsics.checkNotNullParameter(handler2, (String)"handler");
        this.register(definition.getTYPE(), handler2);
    }

    @Override
    public <T extends Event> void register(@NotNull String eventType, @NotNull Function1<? super T, Unit> handler2) {
        Intrinsics.checkNotNullParameter((Object)eventType, (String)"eventType");
        Intrinsics.checkNotNullParameter(handler2, (String)"handler");
        this.register(eventType, (EventHandler)new EventHandler<T>(handler2){
            final /* synthetic */ Function1<T, Unit> $handler;
            {
                this.$handler = $handler;
            }

            public void onEvent(T event) {
                Intrinsics.checkNotNullParameter(event, (String)"event");
                this.$handler.invoke(event);
            }
        });
    }

    @Override
    public <T extends Event> void register(@NotNull EventDefinition<? extends T> definition, @NotNull Function1<? super T, Unit> handler2) {
        Intrinsics.checkNotNullParameter(definition, (String)"definition");
        Intrinsics.checkNotNullParameter(handler2, (String)"handler");
        this.register(definition.getTYPE(), handler2);
    }

    @Override
    public void unregister(@NotNull String eventType, @NotNull EventHandler<?> handler2) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)eventType, (String)"eventType");
            Intrinsics.checkNotNullParameter(handler2, (String)"handler");
            Set<EventHandler<?>> set = this.handlersMap.get(eventType);
            if (set == null) break block0;
            set.remove(handler2);
        }
    }

    @Override
    public void unregister(@NotNull EventDefinition<?> definition, @NotNull EventHandler<?> handler2) {
        Intrinsics.checkNotNullParameter(definition, (String)"definition");
        Intrinsics.checkNotNullParameter(handler2, (String)"handler");
        this.unregister(definition.getTYPE(), handler2);
    }

    @Override
    public void unregister(@NotNull EventHandler<?> handler2) {
        Intrinsics.checkNotNullParameter(handler2, (String)"handler");
        Iterator<Map.Entry<String, Set<EventHandler<?>>>> iterator = this.handlersMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Set<EventHandler<?>> handlers = iterator.next().getValue();
            handlers.remove(handler2);
        }
    }

    private static final Object fire$lambda$0(Event $event, Collection $handlers) {
        return "Firing event " + $event + " with " + $handlers.size() + " handlers";
    }

    private static final Object fire$lambda$1$0(Event $event) {
        return "Problem on handling event " + $event.getEventType();
    }
}

