/*
 * Decompiled with CFR 0.152.
 */
package tigase.halcyon.core.connector.socket;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Triple;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.minidns.dnssec.DnssecValidationFailedException;
import tigase.halcyon.core.Halcyon;
import tigase.halcyon.core.configuration.ConfigurationKt;
import tigase.halcyon.core.configuration.ConnectionConfig;
import tigase.halcyon.core.connector.AbstractConnector;
import tigase.halcyon.core.connector.ChannelBindingDataProvider;
import tigase.halcyon.core.connector.ParseErrorEvent;
import tigase.halcyon.core.connector.SessionController;
import tigase.halcyon.core.connector.SrvRecord;
import tigase.halcyon.core.connector.State;
import tigase.halcyon.core.connector.StreamStartedEvent;
import tigase.halcyon.core.connector.StreamTerminatedEvent;
import tigase.halcyon.core.connector.socket.HostNotFound;
import tigase.halcyon.core.connector.socket.SocketConnectionErrorEvent;
import tigase.halcyon.core.connector.socket.SocketConnector;
import tigase.halcyon.core.connector.socket.SocketConnectorConfig;
import tigase.halcyon.core.connector.socket.SocketConnectorKt;
import tigase.halcyon.core.connector.socket.SocketSessionController;
import tigase.halcyon.core.connector.socket.SocketWorker;
import tigase.halcyon.core.connector.socket.TLSProcessor;
import tigase.halcyon.core.connector.socket.TLSProcessorFactory;
import tigase.halcyon.core.eventbus.Event;
import tigase.halcyon.core.exceptions.HalcyonException;
import tigase.halcyon.core.excutor.TickExecutor;
import tigase.halcyon.core.logger.Level;
import tigase.halcyon.core.logger.Logger;
import tigase.halcyon.core.logger.LoggerFactory;
import tigase.halcyon.core.xml.BuilderKt;
import tigase.halcyon.core.xml.Element;
import tigase.halcyon.core.xml.ElementNode;
import tigase.halcyon.core.xml.parser.StreamParser;
import tigase.halcyon.core.xmpp.BareJID;
import tigase.halcyon.core.xmpp.ErrorCondition;
import tigase.halcyon.core.xmpp.XMPPException;
import tigase.halcyon.core.xmpp.modules.sm.StreamManagementModule;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00b5\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\b\u0004\n\u0002\u0010\r\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0002\b\u0004*\u0001\u001e\u0018\u0000 I2\u00020\u00012\u00020\u0002:\u0001IB\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0002J\u0010\u0010$\u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0002J\b\u0010%\u001a\u00020!H\u0002J\b\u0010&\u001a\u00020'H\u0016J8\u0010(\u001a\u00020!2.\u0010)\u001a*\u0012 \u0012\u001e\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020-\u0012\u0004\u0012\u00020.\u0012\u0004\u0012\u00020\u000e0,j\u0002`/0+\u0012\u0004\u0012\u00020!0*H\u0002J.\u00101\u001a\u00020!2$\u0010)\u001a \u0012\u0016\u0012\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u000e0302\u0012\u0004\u0012\u00020!0*H\u0002J\b\u00104\u001a\u00020!H\u0016J\u0014\u00105\u001a\u00020!2\n\u00106\u001a\u000607j\u0002`8H\u0002J\u0010\u00109\u001a\u00020:2\u0006\u00106\u001a\u00020;H\u0002J\b\u0010<\u001a\u00020!H\u0016J\b\u0010=\u001a\u00020!H\u0002J\u0010\u0010>\u001a\u00020!2\u0006\u0010?\u001a\u00020@H\u0016J\u0006\u0010A\u001a\u00020!J\b\u0010B\u001a\u00020!H\u0002J\u0006\u0010C\u001a\u00020!J\b\u0010D\u001a\u00020\u000eH\u0016J\n\u0010E\u001a\u0004\u0018\u00010FH\u0016J\n\u0010G\u001a\u0004\u0018\u00010FH\u0016J\n\u0010H\u001a\u0004\u0018\u00010FH\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001fR(\u00100\u001a\u001c\u0012\u0004\u0012\u00020-\u0012\u0004\u0012\u00020.\u0012\u0004\u0012\u00020\u000e\u0018\u00010,j\u0004\u0018\u0001`/X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006J"}, d2={"Ltigase/halcyon/core/connector/socket/SocketConnector;", "Ltigase/halcyon/core/connector/AbstractConnector;", "Ltigase/halcyon/core/connector/ChannelBindingDataProvider;", "halcyon", "Ltigase/halcyon/core/Halcyon;", "tlsProcesorFactory", "Ltigase/halcyon/core/connector/socket/TLSProcessorFactory;", "<init>", "(Ltigase/halcyon/core/Halcyon;Ltigase/halcyon/core/connector/socket/TLSProcessorFactory;)V", "getTlsProcesorFactory", "()Ltigase/halcyon/core/connector/socket/TLSProcessorFactory;", "tlsProcesor", "Ltigase/halcyon/core/connector/socket/TLSProcessor;", "secured", "", "getSecured", "()Z", "started", "log", "Ltigase/halcyon/core/logger/Logger;", "socket", "Ljava/net/Socket;", "worker", "Ltigase/halcyon/core/connector/socket/SocketWorker;", "whitespacePingExecutor", "Ltigase/halcyon/core/excutor/TickExecutor;", "whiteSpaceEnabled", "config", "Ltigase/halcyon/core/connector/socket/SocketConnectorConfig;", "parser", "tigase/halcyon/core/connector/socket/SocketConnector$parser$1", "Ltigase/halcyon/core/connector/socket/SocketConnector$parser$1;", "processReceivedElement", "", "element", "Ltigase/halcyon/core/xml/Element;", "processTLSStanza", "proceedTLS", "createSessionController", "Ltigase/halcyon/core/connector/SessionController;", "resolveTarget", "completionHandler", "Lkotlin/Function1;", "", "Lkotlin/Triple;", "", "", "Ltigase/halcyon/core/connector/socket/HostPort;", "lastEndpoint", "createSocket", "Lkotlin/Result;", "Lkotlin/Pair;", "start", "onWorkerException", "cause", "Ljava/lang/Exception;", "Lkotlin/Exception;", "createSocketConnectionErrorEvent", "Ltigase/halcyon/core/connector/socket/SocketConnectionErrorEvent;", "", "stop", "closeStream", "send", "data", "", "restartStream", "onTick", "startTLS", "isConnectionSecure", "getTlsUnique", "", "getTlsServerEndpoint", "getTlsExporter", "Companion", "halcyon-core"})
@SourceDebugExtension(value={"SMAP\nSocketConnector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SocketConnector.kt\ntigase/halcyon/core/connector/socket/SocketConnector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,418:1\n1056#2:419\n1563#2:420\n1634#2,3:421\n1869#2,2:424\n*S KotlinDebug\n*F\n+ 1 SocketConnector.kt\ntigase/halcyon/core/connector/socket/SocketConnector\n*L\n217#1:419\n217#1:420\n217#1:421,3\n228#1:424,2\n*E\n"})
public final class SocketConnector
extends AbstractConnector
implements ChannelBindingDataProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TLSProcessorFactory tlsProcesorFactory;
    @Nullable
    private TLSProcessor tlsProcesor;
    private boolean started;
    @NotNull
    private final Logger log;
    @Nullable
    private Socket socket;
    @Nullable
    private SocketWorker worker;
    @NotNull
    private final TickExecutor whitespacePingExecutor;
    private boolean whiteSpaceEnabled;
    @NotNull
    private SocketConnectorConfig config;
    @NotNull
    private final parser.1 parser;
    @Nullable
    private Triple<String, Integer, Boolean> lastEndpoint;
    @NotNull
    public static final String SEE_OTHER_HOST_KEY = "tigase.halcyon.core.connector.socket.SocketConnector#seeOtherHost";
    @NotNull
    public static final String XMLNS_START_TLS = "urn:ietf:params:xml:ns:xmpp-tls";

    public SocketConnector(@NotNull Halcyon halcyon, @NotNull TLSProcessorFactory tlsProcesorFactory) {
        Intrinsics.checkNotNullParameter((Object)halcyon, (String)"halcyon");
        Intrinsics.checkNotNullParameter((Object)tlsProcesorFactory, (String)"tlsProcesorFactory");
        super(halcyon);
        this.tlsProcesorFactory = tlsProcesorFactory;
        this.log = LoggerFactory.logger$default(LoggerFactory.INSTANCE, "tigase.halcyon.core.connector.socket.SocketConnector", false, 2, null);
        this.whitespacePingExecutor = new TickExecutor(halcyon.getEventBus(), DurationKt.toDuration((int)30, (DurationUnit)DurationUnit.SECONDS), () -> SocketConnector.whitespacePingExecutor$lambda$0(this), null);
        this.whiteSpaceEnabled = true;
        ConnectionConfig connectionConfig = halcyon.getConfig().getConnection();
        Intrinsics.checkNotNull((Object)connectionConfig, (String)"null cannot be cast to non-null type tigase.halcyon.core.connector.socket.SocketConnectorConfig");
        this.config = (SocketConnectorConfig)connectionConfig;
        this.parser = new StreamParser(this){
            final /* synthetic */ SocketConnector this$0;
            {
                this.this$0 = $receiver;
            }

            private final void logReceivedStanza(Element element2) {
                if (SocketConnector.access$getLog$p(this.this$0).isLoggable(Level.FINEST)) {
                    SocketConnector.access$getLog$p(this.this$0).finest("Received element " + element2.getAsString());
                } else if (SocketConnector.access$getLog$p(this.this$0).isLoggable(Level.FINER)) {
                    SocketConnector.access$getLog$p(this.this$0).finer("Received element " + element2.getAsString());
                } else if (SocketConnector.access$getLog$p(this.this$0).isLoggable(Level.FINE)) {
                    SocketConnector.access$getLog$p(this.this$0).fine("Received element " + element2.getAsString());
                }
            }

            public void onNextElement(Element element2) {
                Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
                this.logReceivedStanza(element2);
                SocketConnector.access$processReceivedElement(this.this$0, element2);
            }

            public void onStreamClosed() {
                Logger.finest$default(SocketConnector.access$getLog$p(this.this$0), null, parser.1::onStreamClosed$lambda$0, 1, null);
                SocketConnector.access$fire(this.this$0, new StreamTerminatedEvent());
            }

            public void onStreamStarted(Map<String, String> attrs) {
                Intrinsics.checkNotNullParameter(attrs, (String)"attrs");
                Logger.finest$default(SocketConnector.access$getLog$p(this.this$0), null, () -> parser.1.onStreamStarted$lambda$1(attrs), 1, null);
                SocketConnector.access$fire(this.this$0, new StreamStartedEvent(attrs));
            }

            public void onParseError(String errorMessage) {
                Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
                Logger.finest$default(SocketConnector.access$getLog$p(this.this$0), null, () -> parser.1.onParseError$lambda$2(errorMessage), 1, null);
                SocketConnector.access$fire(this.this$0, new ParseErrorEvent(errorMessage));
            }

            private static final Object onStreamClosed$lambda$0() {
                return "Stream closed";
            }

            private static final Object onStreamStarted$lambda$1(Map $attrs) {
                return "Stream started: " + $attrs;
            }

            private static final Object onParseError$lambda$2(String $errorMessage) {
                return "Parse error: " + $errorMessage;
            }
        };
    }

    @NotNull
    public final TLSProcessorFactory getTlsProcesorFactory() {
        return this.tlsProcesorFactory;
    }

    public final boolean getSecured() {
        TLSProcessor tLSProcessor = this.tlsProcesor;
        return tLSProcessor != null ? tLSProcessor.isConnectionSecure() : false;
    }

    private final void processReceivedElement(Element element2) {
        if (Intrinsics.areEqual((Object)element2.getXmlns(), (Object)XMLNS_START_TLS)) {
            this.processTLSStanza(element2);
        } else {
            this.handleReceivedElement(element2);
        }
    }

    private final void processTLSStanza(Element element2) {
        String string = element2.getName();
        if (Intrinsics.areEqual((Object)string, (Object)"proceed")) {
            this.proceedTLS();
        } else if (Intrinsics.areEqual((Object)string, (Object)"failure")) {
            Logger.warning$default(this.log, null, SocketConnector::processTLSStanza$lambda$0, 1, null);
            this.fire(new SocketConnectionErrorEvent.TLSFailureEvent());
        } else {
            throw new XMPPException(ErrorCondition.BadRequest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void proceedTLS() {
        Logger.info$default(this.log, null, SocketConnector::proceedTLS$lambda$0, 1, null);
        try {
            Logger.finest$default(this.log, null, SocketConnector::proceedTLS$lambda$1, 1, null);
            this.whiteSpaceEnabled = false;
            TLSProcessor tLSProcessor = this.tlsProcesor;
            if (tLSProcessor == null) {
                throw new HalcyonException("TLS Processor not initialized");
            }
            tLSProcessor.proceedTLS((Function2<? super InputStream, ? super OutputStream, Unit>)((Function2)(arg_0, arg_1) -> SocketConnector.proceedTLS$lambda$2(this, arg_0, arg_1)));
            this.restartStream();
        }
        catch (Throwable e) {
            this.setState(State.Disconnecting);
            this.fire(this.createSocketConnectionErrorEvent(e));
        }
        finally {
            Logger.finest$default(this.log, null, SocketConnector::proceedTLS$lambda$3, 1, null);
            this.whiteSpaceEnabled = true;
        }
    }

    @Override
    @NotNull
    public SessionController createSessionController() {
        return new SocketSessionController(this.getHalcyon(), this);
    }

    private final void resolveTarget(Function1<? super List<Triple<String, Integer, Boolean>>, Unit> completionHandler) {
        String location;
        List hosts = new ArrayList();
        StreamManagementModule streamManagementModule = (StreamManagementModule)this.getHalcyon().getModuleOrNull(StreamManagementModule.Companion);
        String string = location = streamManagementModule != null ? streamManagementModule.getResumptionLocation() : null;
        if (location != null) {
            Collection collection = hosts;
            Triple<String, Integer, Boolean> triple = this.lastEndpoint;
            Triple<String, Integer, Boolean> triple2 = this.lastEndpoint;
            collection.add(new Triple((Object)location, (Object)(triple != null ? ((Number)triple.getSecond()).intValue() : this.config.getPort()), (Object)(triple2 != null ? ((Boolean)triple2.getThird()).booleanValue() : this.config.getDirectTls())));
            Logger.fine$default(this.log, null, () -> SocketConnector.resolveTarget$lambda$0(location, this), 1, null);
            completionHandler.invoke((Object)hosts);
            return;
        }
        String seeOther = (String)this.getHalcyon().getInternalDataStore().getData(SEE_OTHER_HOST_KEY);
        if (seeOther != null) {
            Collection collection = hosts;
            Triple<String, Integer, Boolean> triple = this.lastEndpoint;
            Triple<String, Integer, Boolean> triple3 = this.lastEndpoint;
            collection.add(new Triple((Object)seeOther, (Object)(triple != null ? ((Number)triple.getSecond()).intValue() : this.config.getPort()), (Object)(triple3 != null ? ((Boolean)triple3.getThird()).booleanValue() : this.config.getDirectTls())));
            Logger.fine$default(this.log, null, () -> SocketConnector.resolveTarget$lambda$1(seeOther, this), 1, null);
            completionHandler.invoke((Object)hosts);
            return;
        }
        if (this.config.getHostname() != null) {
            Collection collection = hosts;
            String string2 = this.config.getHostname();
            Intrinsics.checkNotNull((Object)string2);
            collection.add(new Triple((Object)string2, (Object)this.config.getPort(), (Object)false));
            Logger.fine$default(this.log, null, () -> SocketConnector.resolveTarget$lambda$2(this), 1, null);
            completionHandler.invoke((Object)hosts);
            return;
        }
        Logger.fine$default(this.log, null, () -> SocketConnector.resolveTarget$lambda$3(this), 1, null);
        this.config.getDnsResolver().resolve(this.config.getDomain(), (Function1<? super Result<? extends List<SrvRecord>>, Unit>)((Function1)arg_0 -> SocketConnector.resolveTarget$lambda$4(completionHandler, hosts, this, arg_0)));
    }

    private final void createSocket(Function1<? super Result<? extends Pair<? extends Socket, Boolean>>, Unit> completionHandler) {
        this.resolveTarget((Function1<? super List<Triple<String, Integer, Boolean>>, Unit>)((Function1)arg_0 -> SocketConnector.createSocket$lambda$0(completionHandler, this, arg_0)));
    }

    @Override
    public void start() {
        this.started = true;
        this.setState(State.Connecting);
        BareJID userJid = ConfigurationKt.getDeclaredUserJID(this.getHalcyon().getConfig());
        ConnectionConfig connectionConfig = this.getHalcyon().getConfig().getConnection();
        Intrinsics.checkNotNull((Object)connectionConfig, (String)"null cannot be cast to non-null type tigase.halcyon.core.connector.socket.SocketConnectorConfig");
        String domain = ((SocketConnectorConfig)connectionConfig).getDomain();
        try {
            this.createSocket((Function1<? super Result<? extends Pair<? extends Socket, Boolean>>, Unit>)((Function1)arg_0 -> SocketConnector.start$lambda$0(this, userJid, domain, arg_0)));
        }
        catch (HostNotFound e) {
            this.setState(State.Disconnected);
            this.fire(new SocketConnectionErrorEvent.HostNotFount());
        }
        catch (Exception e) {
            this.setState(State.Disconnected);
            this.fire(this.createSocketConnectionErrorEvent(e));
            this.setEventsEnabled(false);
        }
    }

    private final void onWorkerException(Exception cause) {
        cause.printStackTrace();
        this.setState(switch (WhenMappings.$EnumSwitchMapping$0[this.getState().ordinal()]) {
            case 1 -> State.Disconnected;
            case 2 -> State.Disconnecting;
            case 3 -> State.Disconnected;
            case 4 -> State.Disconnected;
            default -> throw new NoWhenBranchMatchedException();
        });
        this.fire(this.createSocketConnectionErrorEvent(cause));
        if (this.getState() == State.Disconnected) {
            this.setEventsEnabled(false);
        }
    }

    private final SocketConnectionErrorEvent createSocketConnectionErrorEvent(Throwable cause) {
        Throwable throwable = cause;
        return throwable instanceof UnknownHostException || throwable instanceof DnssecValidationFailedException ? (SocketConnectionErrorEvent)new SocketConnectionErrorEvent.HostNotFount() : (SocketConnectionErrorEvent)new SocketConnectionErrorEvent.Unknown(cause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        this.started = false;
        this.lastEndpoint = null;
        if (this.getState() != State.Disconnected) {
            Logger.fine$default(this.log, null, SocketConnector::stop$lambda$0, 1, null);
            try {
                if (this.getState() == State.Connected) {
                    this.closeStream();
                }
                this.setState(State.Disconnecting);
                this.whitespacePingExecutor.stop();
                Thread.sleep(175L);
                Socket socket = this.socket;
                boolean bl = socket != null ? !socket.isClosed() : false;
                if (bl) {
                    Object object = this.worker;
                    if (object != null && (object = ((SocketWorker)object).getWriter()) != null) {
                        ((Writer)object).close();
                    }
                    Socket socket2 = this.socket;
                    if (socket2 != null) {
                        socket2.close();
                    }
                }
                SocketWorker socketWorker = this.worker;
                if (socketWorker != null) {
                    socketWorker.interrupt();
                }
                TLSProcessor tLSProcessor = this.tlsProcesor;
                if (tLSProcessor != null) {
                    tLSProcessor.clear();
                }
                while (true) {
                    SocketWorker socketWorker2 = this.worker;
                    boolean bl2 = socketWorker2 != null ? socketWorker2.isActive() : false;
                    if (bl2) {
                        Thread.sleep(32L);
                        continue;
                    }
                    break;
                }
            }
            finally {
                Logger.fine$default(this.log, null, SocketConnector::stop$lambda$1, 1, null);
                this.setState(State.Disconnected);
                this.worker = null;
                this.socket = null;
                this.setEventsEnabled(false);
            }
        }
    }

    private final void closeStream() {
        if (this.getState() == State.Connected) {
            this.send("</stream:stream>");
        }
    }

    @Override
    public void send(@NotNull CharSequence data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        try {
            Logger.finest$default(this.log, null, () -> SocketConnector.send$lambda$0(this, data), 1, null);
            SocketWorker socketWorker = this.worker;
            if (socketWorker == null) {
                throw new HalcyonException("Socket Worker not initialized.");
            }
            SocketWorker it = socketWorker;
            boolean bl = false;
            it.getWriter().write(((Object)data).toString());
            it.getWriter().flush();
        }
        catch (Exception e) {
            this.log.warning(e, (Function0<? extends Object>)((Function0)SocketConnector::send$lambda$2));
            this.setState(State.Disconnecting);
            this.fire(this.createSocketConnectionErrorEvent(e));
            throw e;
        }
    }

    public final void restartStream() {
        StringBuilder stringBuilder;
        BareJID userJid = ConfigurationKt.getDeclaredUserJID(this.getHalcyon().getConfig());
        ConnectionConfig connectionConfig = this.getHalcyon().getConfig().getConnection();
        Intrinsics.checkNotNull((Object)connectionConfig, (String)"null cannot be cast to non-null type tigase.halcyon.core.connector.socket.SocketConnectorConfig");
        String domain = ((SocketConnectorConfig)connectionConfig).getDomain();
        StringBuilder $this$restartStream_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$restartStream_u24lambda_u240.append("<stream:stream xmlns='jabber:client' xmlns:stream='http://etherx.jabber.org/streams' ");
        $this$restartStream_u24lambda_u240.append("version='1.0' ");
        if (userJid != null) {
            $this$restartStream_u24lambda_u240.append("from='" + userJid + "' ");
        }
        $this$restartStream_u24lambda_u240.append("to='" + domain + "'");
        $this$restartStream_u24lambda_u240.append(">");
        String sb = stringBuilder.toString();
        this.send(sb);
    }

    private final void onTick() {
        block2: {
            Object object;
            if (this.getState() != State.Connected || !this.whiteSpaceEnabled) break block2;
            Logger.finer$default(this.log, null, SocketConnector::onTick$lambda$0, 1, null);
            Object object2 = this.worker;
            if (object2 != null && (object2 = ((SocketWorker)object2).getWriter()) != null) {
                ((Writer)object2).write(32);
            }
            if ((object = this.worker) != null && (object = ((SocketWorker)object).getWriter()) != null) {
                ((Writer)object).flush();
            }
        }
    }

    public final void startTLS() {
        Logger.info$default(this.log, null, SocketConnector::startTLS$lambda$0, 1, null);
        this.whiteSpaceEnabled = false;
        Element element2 = BuilderKt.element("starttls", (Function1<? super ElementNode, Unit>)((Function1)SocketConnector::startTLS$lambda$1));
        this.getHalcyon().getWriter().writeDirectly(element2);
    }

    @Override
    public boolean isConnectionSecure() {
        TLSProcessor tLSProcessor = this.tlsProcesor;
        return tLSProcessor != null ? tLSProcessor.isConnectionSecure() : false;
    }

    @Override
    @Nullable
    public byte[] getTlsUnique() {
        TLSProcessor tLSProcessor = this.tlsProcesor;
        return (byte[])(tLSProcessor != null ? tLSProcessor.getTlsUnique() : null);
    }

    @Override
    @Nullable
    public byte[] getTlsServerEndpoint() {
        TLSProcessor tLSProcessor = this.tlsProcesor;
        return (byte[])(tLSProcessor != null ? tLSProcessor.getTlsServerEndpoint() : null);
    }

    @Override
    @Nullable
    public byte[] getTlsExporter() {
        TLSProcessor tLSProcessor = this.tlsProcesor;
        return (byte[])(tLSProcessor != null ? tLSProcessor.getTlsExporter() : null);
    }

    private static final Unit whitespacePingExecutor$lambda$0(SocketConnector this$0) {
        this$0.onTick();
        return Unit.INSTANCE;
    }

    private static final Object processTLSStanza$lambda$0() {
        return "Cannot establish TLS connection!";
    }

    private static final Object proceedTLS$lambda$0() {
        return "Proceeding TLS";
    }

    private static final Object proceedTLS$lambda$1() {
        return "Disabling whitespace ping";
    }

    private static final Unit proceedTLS$lambda$2(SocketConnector this$0, InputStream inputStream, OutputStream outputStream) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
        SocketWorker socketWorker = this$0.worker;
        if (socketWorker == null) {
            throw new HalcyonException("Socket worker not initialized");
        }
        socketWorker.setReaderAndWriter$halcyon_core(new InputStreamReader(inputStream), new OutputStreamWriter(outputStream));
        return Unit.INSTANCE;
    }

    private static final Object proceedTLS$lambda$3() {
        return "Enabling whitespace ping";
    }

    private static final Object resolveTarget$lambda$0(String $location, SocketConnector this$0) {
        return "Using host " + $location + ":" + this$0.config.getPort();
    }

    private static final Object resolveTarget$lambda$1(String $seeOther, SocketConnector this$0) {
        return "Using host " + $seeOther + ":" + this$0.config.getPort();
    }

    private static final Object resolveTarget$lambda$2(SocketConnector this$0) {
        return "Using host " + this$0.config.getHostname() + ":" + this$0.config.getPort();
    }

    private static final Object resolveTarget$lambda$3(SocketConnector this$0) {
        return "Resolving DNS of " + this$0.config.getDomain();
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit resolveTarget$lambda$4(Function1 $completionHandler, List $hosts, SocketConnector this$0, Result result) {
        Object object = result.unbox-impl();
        Throwable throwable = Result.exceptionOrNull-impl((Object)object);
        if (throwable != null) {
            Throwable throwable2;
            Throwable it = throwable2 = throwable;
            boolean bl = false;
            ((Collection)$hosts).add(new Triple((Object)this$0.config.getDomain(), (Object)this$0.config.getPort(), (Object)false));
        }
        object = result.unbox-impl();
        if (Result.isSuccess-impl((Object)object)) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            List it = (List)object;
            boolean bl = false;
            Iterable $this$sortedBy$iv = it;
            boolean $i$f$sortedBy = false;
            $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    SrvRecord it = (SrvRecord)a;
                    boolean bl = false;
                    int n = it.getDirectTls() ? 0 : 1;
                    it = (SrvRecord)b;
                    Comparable comparable = Integer.valueOf(n);
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)Integer.valueOf(it.getDirectTls() ? 0 : 1));
                }
            });
            List list = $hosts;
            boolean $i$f$map = false;
            void var10_12 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                SrvRecord srvRecord = (SrvRecord)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(new Triple((Object)it2.getTarget(), (Object)it2.getPort-pVg5ArA(), (Object)it2.getDirectTls()));
            }
            list.addAll((List)destination$iv$iv);
        }
        $completionHandler.invoke((Object)$hosts);
        return Unit.INSTANCE;
    }

    private static final Unit createSocket$lambda$0(Function1 $completionHandler, SocketConnector this$0, List hosts) {
        Intrinsics.checkNotNullParameter((Object)hosts, (String)"hosts");
        Iterable $this$forEach$iv = hosts;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Triple hp = (Triple)element$iv;
            boolean bl = false;
            try {
                Logger.fine$default(this$0.log, null, () -> SocketConnector.createSocket$lambda$0$0$0(hp), 1, null);
                Socket s = new Socket();
                s.setTcpNoDelay(true);
                s.connect(new InetSocketAddress((String)hp.getFirst(), ((Number)hp.getSecond()).intValue()), 90000);
                this$0.lastEndpoint = hp;
                $completionHandler.invoke((Object)Result.box-impl((Object)Result.constructor-impl((Object)new Pair((Object)s, hp.getThird()))));
                return Unit.INSTANCE;
            }
            catch (Throwable e) {
                Logger.fine$default(this$0.log, null, () -> SocketConnector.createSocket$lambda$0$0$1(hp), 1, null);
            }
        }
        $completionHandler.invoke((Object)Result.box-impl((Object)Result.constructor-impl((Object)ResultKt.createFailure((Throwable)new HostNotFound()))));
        return Unit.INSTANCE;
    }

    private static final Object createSocket$lambda$0$0$0(Triple $hp) {
        return "Opening connection to " + $hp.getFirst() + ":" + $hp.getSecond();
    }

    private static final Object createSocket$lambda$0$0$1(Triple $hp) {
        return "Host " + $hp.getFirst() + ":" + $hp.getSecond() + " is unreachable.";
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit start$lambda$0(SocketConnector this$0, BareJID $userJid, String $domain, Result result) {
        Throwable throwable;
        Object object = result.unbox-impl();
        Throwable throwable2 = Result.exceptionOrNull-impl((Object)object);
        if (throwable2 != null) {
            Throwable e = throwable = throwable2;
            boolean bl = false;
            this$0.setState(State.Disconnected);
            if (e instanceof HostNotFound) {
                this$0.fire(new SocketConnectionErrorEvent.HostNotFount());
            } else {
                this$0.fire(this$0.createSocketConnectionErrorEvent(e));
                this$0.setEventsEnabled(false);
            }
        }
        object = result.unbox-impl();
        if (Result.isSuccess-impl((Object)object)) {
            throwable = (Pair)object;
            boolean bl = false;
            Socket sckt = (Socket)throwable.component1();
            boolean ssl = (Boolean)throwable.component2();
            try {
                void $this$start_u24lambda_u240_u241_u242;
                SocketWorker $this$start_u24lambda_u240_u241_u241;
                this$0.socket = sckt;
                sckt.setSoTimeout(20000);
                sckt.setTcpNoDelay(true);
                Function1<Socket, Unit> function1 = SocketConnectorKt.getExtendedSocketOptionsConfigurer();
                if (function1 != null) {
                    function1.invoke((Object)sckt);
                }
                Logger.fine$default(this$0.log, null, () -> SocketConnector.start$lambda$0$1$0(sckt), 1, null);
                SocketWorker socketWorker = new SocketWorker(this$0.parser);
                Object object2 = socketWorker;
                SocketConnector socketConnector = this$0;
                boolean bl2 = false;
                $this$start_u24lambda_u240_u241_u241.setReaderAndWriter$halcyon_core(new InputStreamReader(sckt.getInputStream()), new OutputStreamWriter(sckt.getOutputStream()));
                $this$start_u24lambda_u240_u241_u241 = socketWorker;
                boolean bl3 = false;
                $this$start_u24lambda_u240_u241_u242.setOnError((Function1<? super Exception, Unit>)((Function1)arg_0 -> SocketConnector.start$lambda$0$1$2$0(this$0, arg_0)));
                socketConnector.worker = socketWorker;
                this$0.tlsProcesor = this$0.tlsProcesorFactory.create(sckt, this$0.config);
                if (ssl) {
                    TLSProcessor tLSProcessor = this$0.tlsProcesor;
                    if (tLSProcessor != null) {
                        tLSProcessor.proceedTLS((Function2<? super InputStream, ? super OutputStream, Unit>)((Function2)(arg_0, arg_1) -> SocketConnector.start$lambda$0$1$3(this$0, arg_0, arg_1)));
                    } else {
                        throw new HalcyonException("TLS Processor not initialized");
                    }
                }
                SocketWorker socketWorker2 = this$0.worker;
                if (socketWorker2 == null) {
                    throw new HalcyonException("Socket Worker not created properly.");
                }
                socketWorker2.start();
                Object $this$start_u24lambda_u240_u241_u244 = object2 = new StringBuilder();
                boolean bl4 = false;
                ((StringBuilder)$this$start_u24lambda_u240_u241_u244).append("<stream:stream xmlns='jabber:client' xmlns:stream='http://etherx.jabber.org/streams' ");
                ((StringBuilder)$this$start_u24lambda_u240_u241_u244).append("version='1.0' ");
                if ($userJid != null) {
                    ((StringBuilder)$this$start_u24lambda_u240_u241_u244).append("from='" + $userJid + "' ");
                }
                ((StringBuilder)$this$start_u24lambda_u240_u241_u244).append("to='" + $domain + "'");
                ((StringBuilder)$this$start_u24lambda_u240_u241_u244).append(">");
                String sb = ((StringBuilder)object2).toString();
                this$0.send(sb);
                this$0.setState(State.Connected);
                this$0.whitespacePingExecutor.start();
            }
            catch (Exception e) {
                this$0.setState(State.Disconnected);
                this$0.fire(this$0.createSocketConnectionErrorEvent(e));
                this$0.setEventsEnabled(false);
            }
        }
        return Unit.INSTANCE;
    }

    private static final Object start$lambda$0$1$0(Socket $sckt) {
        return "Opening socket connection to " + $sckt.getInetAddress();
    }

    private static final Unit start$lambda$0$1$2$0(SocketConnector this$0, Exception exception) {
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        this$0.onWorkerException(exception);
        return Unit.INSTANCE;
    }

    private static final Unit start$lambda$0$1$3(SocketConnector this$0, InputStream inputStream, OutputStream outputStream) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
        SocketWorker socketWorker = this$0.worker;
        if (socketWorker == null) {
            throw new HalcyonException("Socket worker not initialized");
        }
        socketWorker.setReaderAndWriter$halcyon_core(new InputStreamReader(inputStream), new OutputStreamWriter(outputStream));
        return Unit.INSTANCE;
    }

    private static final Object stop$lambda$0() {
        return "Stopping...";
    }

    private static final Object stop$lambda$1() {
        return "Stopped";
    }

    private static final Object send$lambda$0(SocketConnector this$0, CharSequence $data) {
        Socket socket = this$0.socket;
        Socket socket2 = this$0.socket;
        return "Sending (" + (socket != null ? Boolean.valueOf(socket.isConnected()) : null) + ", " + !(socket2 != null ? socket2.isOutputShutdown() : true) + "): " + $data;
    }

    private static final Object send$lambda$2() {
        return "Cannot send data to server";
    }

    private static final Object onTick$lambda$0() {
        return "Whitespace ping";
    }

    private static final Object startTLS$lambda$0() {
        return "Running StartTLS";
    }

    private static final Unit startTLS$lambda$1(ElementNode $this$element) {
        Intrinsics.checkNotNullParameter((Object)$this$element, (String)"$this$element");
        $this$element.setXmlns(XMLNS_START_TLS);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Logger access$getLog$p(SocketConnector $this) {
        return $this.log;
    }

    public static final /* synthetic */ void access$processReceivedElement(SocketConnector $this, Element element2) {
        $this.processReceivedElement(element2);
    }

    public static final /* synthetic */ void access$fire(SocketConnector $this, Event e) {
        $this.fire(e);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Ltigase/halcyon/core/connector/socket/SocketConnector$Companion;", "", "<init>", "()V", "SEE_OTHER_HOST_KEY", "", "XMLNS_START_TLS", "halcyon-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[State.values().length];
            try {
                nArray[State.Connecting.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[State.Connected.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[State.Disconnecting.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[State.Disconnected.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

