/*
 * Decompiled with CFR 0.152.
 */
package tigase.halcyon.core.connector;

import java.lang.invoke.LambdaMetafactory;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import tigase.halcyon.core.AbstractHalcyon;
import tigase.halcyon.core.Scope;
import tigase.halcyon.core.configuration.Registration;
import tigase.halcyon.core.connector.ConnectionErrorEvent;
import tigase.halcyon.core.connector.ConnectorStateChangeEvent;
import tigase.halcyon.core.connector.ParseErrorEvent;
import tigase.halcyon.core.connector.SessionController;
import tigase.halcyon.core.connector.State;
import tigase.halcyon.core.eventbus.Event;
import tigase.halcyon.core.eventbus.EventBusInterface;
import tigase.halcyon.core.eventbus.EventHandler;
import tigase.halcyon.core.exceptions.HalcyonException;
import tigase.halcyon.core.logger.Logger;
import tigase.halcyon.core.logger.LoggerFactory;
import tigase.halcyon.core.requests.RequestBuilder;
import tigase.halcyon.core.requests.RequestsManager;
import tigase.halcyon.core.xmpp.JID;
import tigase.halcyon.core.xmpp.JIDKt;
import tigase.halcyon.core.xmpp.XMPPException;
import tigase.halcyon.core.xmpp.forms.JabberDataForm;
import tigase.halcyon.core.xmpp.modules.BindEvent;
import tigase.halcyon.core.xmpp.modules.BindModule;
import tigase.halcyon.core.xmpp.modules.InBandRegistrationModule;
import tigase.halcyon.core.xmpp.modules.StreamErrorEvent;
import tigase.halcyon.core.xmpp.modules.StreamFeaturesEvent;
import tigase.halcyon.core.xmpp.modules.StreamFeaturesModule;
import tigase.halcyon.core.xmpp.modules.auth.SASL2Module;
import tigase.halcyon.core.xmpp.modules.auth.SASLEvent;
import tigase.halcyon.core.xmpp.modules.auth.SASLModule;
import tigase.halcyon.core.xmpp.modules.discovery.DiscoveryModule;
import tigase.halcyon.core.xmpp.modules.presence.PresenceModule;
import tigase.halcyon.core.xmpp.modules.roster.RosterModule;
import tigase.halcyon.core.xmpp.modules.sm.StreamManagementEvent;
import tigase.halcyon.core.xmpp.modules.sm.StreamManagementModule;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0014J\b\u0010\u0015\u001a\u00020\u0012H\u0002J\b\u0010\u0016\u001a\u00020\u0012H\u0002J\u0010\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0010H\u0002J\u0010\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u001bH\u0002J\u0018\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0010\u0010!\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\"H$J\u0010\u0010#\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020$H$J\u0010\u0010%\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020&H\u0014J\b\u0010'\u001a\u00020\u0012H\u0014J\u0010\u0010(\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020)H\u0014J\u0010\u0010*\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020+H\u0014J\b\u0010,\u001a\u00020\u0012H\u0016J\b\u0010-\u001a\u00020\u0012H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Ltigase/halcyon/core/connector/AbstractSocketSessionController;", "Ltigase/halcyon/core/connector/SessionController;", "halcyon", "Ltigase/halcyon/core/AbstractHalcyon;", "loggerName", "", "<init>", "(Ltigase/halcyon/core/AbstractHalcyon;Ljava/lang/String;)V", "getHalcyon", "()Ltigase/halcyon/core/AbstractHalcyon;", "log", "Ltigase/halcyon/core/logger/Logger;", "getLog", "()Ltigase/halcyon/core/logger/Logger;", "eventsHandler", "Ltigase/halcyon/core/eventbus/EventHandler;", "Ltigase/halcyon/core/eventbus/Event;", "processStreamFeaturesEvent", "", "event", "Ltigase/halcyon/core/xmpp/modules/StreamFeaturesEvent;", "processInBandRegistration", "bindResource", "processEvent", "processConnectorStateChangeEvent", "Ltigase/halcyon/core/connector/ConnectorStateChangeEvent;", "processStreamManagementEvent", "Ltigase/halcyon/core/xmpp/modules/sm/StreamManagementEvent;", "processBindSuccess", "jid", "Ltigase/halcyon/core/xmpp/JID;", "inlineProtocol", "", "processAuthSuccessfull", "Ltigase/halcyon/core/xmpp/modules/auth/SASLEvent$SASLSuccess;", "processConnectionError", "Ltigase/halcyon/core/connector/ConnectionErrorEvent;", "processParseError", "Ltigase/halcyon/core/connector/ParseErrorEvent;", "processBindError", "processAuthError", "Ltigase/halcyon/core/xmpp/modules/auth/SASLEvent$SASLError;", "processStreamError", "Ltigase/halcyon/core/xmpp/modules/StreamErrorEvent;", "start", "stop", "halcyon-core"})
public abstract class AbstractSocketSessionController
implements SessionController {
    @NotNull
    private final AbstractHalcyon halcyon;
    @NotNull
    private final Logger log;
    @NotNull
    private final EventHandler<Event> eventsHandler;

    public AbstractSocketSessionController(@NotNull AbstractHalcyon halcyon, @NotNull String loggerName) {
        Intrinsics.checkNotNullParameter((Object)halcyon, (String)"halcyon");
        Intrinsics.checkNotNullParameter((Object)loggerName, (String)"loggerName");
        this.halcyon = halcyon;
        this.log = LoggerFactory.logger$default(LoggerFactory.INSTANCE, loggerName, false, 2, null);
        this.eventsHandler = new EventHandler<Event>(this){
            final /* synthetic */ AbstractSocketSessionController this$0;
            {
                this.this$0 = $receiver;
            }

            public void onEvent(Event event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                AbstractSocketSessionController.access$processEvent(this.this$0, event);
            }
        };
    }

    @Override
    @NotNull
    public final AbstractHalcyon getHalcyon() {
        return this.halcyon;
    }

    @NotNull
    protected final Logger getLog() {
        return this.log;
    }

    /*
     * Unable to fully structure code
     */
    protected void processStreamFeaturesEvent(@NotNull StreamFeaturesEvent event) {
        block10: {
            block11: {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                authState = this.halcyon.getAuthContext().getState();
                v0 = (StreamManagementModule)this.halcyon.getModuleOrNull(StreamManagementModule.Companion);
                isResumptionAvailable = v0 != null ? v0.isResumptionAvailable() : false;
                Logger.info$default(this.log, null, (Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, processStreamFeaturesEvent$lambda$0(tigase.halcyon.core.xmpp.modules.auth.State boolean ), ()Ljava/lang/Object;)((tigase.halcyon.core.xmpp.modules.auth.State)authState, (boolean)isResumptionAvailable), 1, null);
                if (authState != tigase.halcyon.core.xmpp.modules.auth.State.Unknown) break block10;
                if (!isResumptionAvailable) {
                    v1 = (StreamManagementModule)this.halcyon.getModuleOrNull(StreamManagementModule.Companion);
                    if (v1 != null) {
                        v1.reset();
                    }
                }
                sasl1Module = (SASLModule)this.halcyon.getModuleOrNull(SASLModule.Companion);
                sasl2Module = (SASL2Module)this.halcyon.getModuleOrNull(SASL2Module.Companion);
                registrationModule = (InBandRegistrationModule)this.halcyon.getModuleOrNull(InBandRegistrationModule.Companion);
                v2 = sasl2Module;
                v3 = v2 != null ? v2.isAllowed(event.getFeatures()) : false;
                if (!v3) break block11;
                sasl2Module.startAuth(event.getFeatures());
                break block10;
            }
            v4 = sasl2Module;
            if (v4 != null ? v4.getInProgress() : false) ** GOTO lbl-1000
            v5 = sasl1Module;
            v6 = v5 != null ? v5.isAllowed(event.getFeatures()) : false;
            if (v6) {
                sasl1Module.startAuth(event.getFeatures());
            } else lbl-1000:
            // 2 sources

            {
                v7 = registrationModule;
                v8 = v7 != null ? v7.isAllowed(event.getFeatures()) : false;
                if (v8 && this.halcyon.getConfig().getRegistration() != null) {
                    this.processInBandRegistration();
                } else {
                    throw new HalcyonException("Cannot find supported auth or registration method.");
                }
            }
        }
        if (authState == tigase.halcyon.core.xmpp.modules.auth.State.Success) {
            if (isResumptionAvailable) {
                ((StreamManagementModule)this.halcyon.getModule(StreamManagementModule.Companion)).resume();
            } else {
                var4_4 = (StreamFeaturesModule)this.halcyon.getModuleOrNull(StreamFeaturesModule.Companion);
                v9 = var4_4 != null ? var4_4.isFeatureAvailable("bind", "urn:ietf:params:xml:ns:xmpp-bind") : false;
                if (v9) {
                    this.bindResource();
                }
            }
        }
    }

    private final void processInBandRegistration() {
        InBandRegistrationModule registrationModule = (InBandRegistrationModule)this.halcyon.getModule(InBandRegistrationModule.Companion);
        Registration registration = this.halcyon.getConfig().getRegistration();
        Intrinsics.checkNotNull((Object)registration);
        Registration reg = registration;
        RequestBuilder.response$default(registrationModule.requestRegistrationForm(JIDKt.toBareJID(reg.getDomain())), null, arg_0 -> AbstractSocketSessionController.processInBandRegistration$lambda$0(reg, registrationModule, this, arg_0), 1, null).send();
    }

    private final void bindResource() {
        Object object = (BindModule)this.halcyon.getModuleOrNull(BindModule.Companion);
        if (object == null || (object = BindModule.bind$default((BindModule)object, null, 1, null)) == null || (object = ((RequestBuilder)object).send()) == null) {
            throw new HalcyonException("BindModule is required.");
        }
    }

    private final void processEvent(Event event) {
        try {
            Event event2 = event;
            if (event2 instanceof ParseErrorEvent) {
                this.processParseError((ParseErrorEvent)event);
            } else if (event2 instanceof SASLEvent.SASLError) {
                this.processAuthError((SASLEvent.SASLError)event);
            } else if (event2 instanceof StreamErrorEvent) {
                this.processStreamError((StreamErrorEvent)event);
            } else if (event2 instanceof ConnectionErrorEvent) {
                this.processConnectionError((ConnectionErrorEvent)event);
            } else if (event2 instanceof StreamFeaturesEvent) {
                this.processStreamFeaturesEvent((StreamFeaturesEvent)event);
            } else if (event2 instanceof SASLEvent.SASLSuccess) {
                this.processAuthSuccessfull((SASLEvent.SASLSuccess)event);
            } else if (event2 instanceof StreamManagementEvent) {
                this.processStreamManagementEvent((StreamManagementEvent)event);
            } else if (event2 instanceof ConnectorStateChangeEvent) {
                this.processConnectorStateChangeEvent((ConnectorStateChangeEvent)event);
            } else if (event2 instanceof BindEvent.Success) {
                this.processBindSuccess(((BindEvent.Success)event).getJid(), ((BindEvent.Success)event).getInlineProtocol());
            } else if (event2 instanceof BindEvent.Failure) {
                this.processBindError();
            }
        }
        catch (XMPPException e) {
            this.log.severe(e, (Function0<? extends Object>)((Function0)AbstractSocketSessionController::processEvent$lambda$0));
            this.halcyon.getEventBus().fire(new SessionController.SessionControllerEvents.ErrorStop("Error in session processing"));
        }
        catch (HalcyonException e) {
            this.log.severe(e, (Function0<? extends Object>)((Function0)AbstractSocketSessionController::processEvent$lambda$1));
            this.halcyon.getEventBus().fire(new SessionController.SessionControllerEvents.ErrorStop("Error in session processing"));
        }
    }

    private final void processConnectorStateChangeEvent(ConnectorStateChangeEvent event) {
        if (event.getOldState() == State.Connected && (event.getNewState() == State.Disconnected || event.getNewState() == State.Disconnecting)) {
            boolean isResumptionAvailable;
            Logger.fine$default(this.log, null, AbstractSocketSessionController::processConnectorStateChangeEvent$lambda$0, 1, null);
            StreamManagementModule streamManagementModule = (StreamManagementModule)this.halcyon.getModuleOrNull(StreamManagementModule.Companion);
            boolean bl = isResumptionAvailable = streamManagementModule != null ? streamManagementModule.isResumptionAvailable() : false;
            if (!isResumptionAvailable) {
                RequestsManager.timeoutAll$default(this.halcyon.getRequestsManager(), null, 1, null);
            }
        }
    }

    private final void processStreamManagementEvent(StreamManagementEvent event) {
        StreamManagementEvent streamManagementEvent = event;
        if (streamManagementEvent instanceof StreamManagementEvent.Resumed) {
            this.halcyon.getEventBus().fire(new SessionController.SessionControllerEvents.Successful());
        } else if (streamManagementEvent instanceof StreamManagementEvent.Failed) {
            RequestsManager.timeoutAll$default(this.halcyon.getRequestsManager(), null, 1, null);
            this.bindResource();
        } else if (!(streamManagementEvent instanceof StreamManagementEvent.Enabled)) {
            throw new NoWhenBranchMatchedException();
        }
    }

    private final void processBindSuccess(JID jid, boolean inlineProtocol) {
        block4: {
            Object object;
            this.log.info("Binded");
            DiscoveryModule discoveryModule = (DiscoveryModule)this.halcyon.getModuleOrNull(DiscoveryModule.Companion);
            if (discoveryModule != null) {
                DiscoveryModule it = discoveryModule;
                boolean bl = false;
                it.discoverServerFeatures$halcyon_core();
                it.discoverAccountFeatures$halcyon_core();
            }
            this.halcyon.getEventBus().fire(new SessionController.SessionControllerEvents.Successful());
            PresenceModule presenceModule = (PresenceModule)this.halcyon.getModuleOrNull(PresenceModule.Companion);
            if (presenceModule != null) {
                presenceModule.sendInitialPresence();
            }
            if ((object = (RosterModule)this.halcyon.getModuleOrNull(RosterModule.Companion)) != null && (object = ((RosterModule)object).rosterGet()) != null) {
                ((RequestBuilder)object).send();
            }
            if (inlineProtocol) break block4;
            StreamManagementModule streamManagementModule = (StreamManagementModule)this.halcyon.getModules().getModuleOrNull(StreamManagementModule.Companion);
            if (streamManagementModule != null) {
                streamManagementModule.enable();
            }
        }
    }

    protected abstract void processAuthSuccessfull(@NotNull SASLEvent.SASLSuccess var1);

    protected abstract void processConnectionError(@NotNull ConnectionErrorEvent var1);

    protected void processParseError(@NotNull ParseErrorEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.halcyon.getEventBus().fire(new SessionController.SessionControllerEvents.ErrorReconnect("Parse error", false, false, 6, null));
    }

    protected void processBindError() {
        this.halcyon.getEventBus().fire(new SessionController.SessionControllerEvents.ErrorReconnect("Session bind error", false, false, 6, null));
    }

    protected void processAuthError(@NotNull SASLEvent.SASLError event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.halcyon.getEventBus().fire(new SessionController.SessionControllerEvents.ErrorStop("Authentication error."));
    }

    protected void processStreamError(@NotNull StreamErrorEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.log.fine("Processing stream error: " + event);
        this.halcyon.clear$halcyon_core(Scope.Connection);
        event.getErrorElement().getName();
        this.halcyon.getEventBus().fire(new SessionController.SessionControllerEvents.ErrorReconnect("Stream error: " + event.getCondition(), false, false, 6, null));
    }

    @Override
    public void start() {
        EventBusInterface.register$default((EventBusInterface)this.halcyon.getEventBus(), null, this.eventsHandler, 1, null);
        Logger.info$default(this.log, null, AbstractSocketSessionController::start$lambda$0, 1, null);
    }

    @Override
    public void stop() {
        this.halcyon.getEventBus().unregister(this.eventsHandler);
        Logger.info$default(this.log, null, AbstractSocketSessionController::stop$lambda$0, 1, null);
    }

    private static final Object processStreamFeaturesEvent$lambda$0(tigase.halcyon.core.xmpp.modules.auth.State $authState, boolean $isResumptionAvailable) {
        return "authState=" + $authState + "; isResumptionAvailable=" + $isResumptionAvailable;
    }

    private static final Unit processInBandRegistration$lambda$0(Registration $reg, InBandRegistrationModule $registrationModule, AbstractSocketSessionController this$0, Result it) {
        Object object = it.unbox-impl();
        if (Result.isSuccess-impl((Object)object)) {
            Object object2;
            JabberDataForm requestForm = (JabberDataForm)object;
            boolean bl = false;
            Function1<JabberDataForm, Unit> function1 = $reg.getFormHandler();
            if (function1 != null) {
                function1.invoke((Object)requestForm);
            }
            if ((object2 = $reg.getFormHandlerWithResponse()) != null && (object2 = (JabberDataForm)object2.invoke((Object)requestForm)) != null) {
                Object resultForm = object2;
                boolean bl2 = false;
                RequestBuilder.response$default($registrationModule.submitRegistrationForm(JIDKt.toBareJID($reg.getDomain()), (JabberDataForm)resultForm), null, arg_0 -> AbstractSocketSessionController.processInBandRegistration$lambda$0$0$0$0(this$0, arg_0), 1, null).send();
            }
        }
        object = it.unbox-impl();
        Throwable throwable = Result.exceptionOrNull-impl((Object)object);
        if (throwable != null) {
            Throwable throwable2;
            Throwable it2 = throwable2 = throwable;
            boolean bl = false;
            this$0.log.info(it2, (Function0<? extends Object>)((Function0)AbstractSocketSessionController::processInBandRegistration$lambda$0$1$0));
            throw new HalcyonException("Cannot register account", it2);
        }
        return Unit.INSTANCE;
    }

    private static final Unit processInBandRegistration$lambda$0$0$0$0(AbstractSocketSessionController this$0, Result registrationResponse) {
        Object object = registrationResponse.unbox-impl();
        if (Result.isSuccess-impl((Object)object)) {
            Unit it = (Unit)object;
            boolean bl = false;
            this$0.log.info("Account registered");
            this$0.halcyon.disconnect();
        }
        object = registrationResponse.unbox-impl();
        Throwable throwable = Result.exceptionOrNull-impl((Object)object);
        if (throwable != null) {
            Throwable throwable2;
            Throwable it = throwable2 = throwable;
            boolean bl = false;
            this$0.log.info(it, (Function0<? extends Object>)((Function0)AbstractSocketSessionController::processInBandRegistration$lambda$0$0$0$0$1$0));
            throw new HalcyonException("Cannot register account", it);
        }
        return Unit.INSTANCE;
    }

    private static final Object processInBandRegistration$lambda$0$0$0$0$1$0() {
        return "Cannot register account.";
    }

    private static final Object processInBandRegistration$lambda$0$1$0() {
        return "Cannot register account.";
    }

    private static final Object processEvent$lambda$0() {
        return "Cannot establish connection";
    }

    private static final Object processEvent$lambda$1() {
        return "Cannot establish connection";
    }

    private static final Object processConnectorStateChangeEvent$lambda$0() {
        return "Checking conditions to force timeout";
    }

    private static final Object start$lambda$0() {
        return "Started session controller";
    }

    private static final Object stop$lambda$0() {
        return "Stopped session controller";
    }

    public static final /* synthetic */ void access$processEvent(AbstractSocketSessionController $this, Event event) {
        $this.processEvent(event);
    }
}

