/*
 * Decompiled with CFR 0.152.
 */
package tigase.halcyon.core.xmpp.modules.auth;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference0;
import kotlin.jvm.internal.PropertyReference0Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tigase.halcyon.core.Context;
import tigase.halcyon.core.exceptions.HalcyonException;
import tigase.halcyon.core.logger.Logger;
import tigase.halcyon.core.logger.LoggerFactory;
import tigase.halcyon.core.xml.Element;
import tigase.halcyon.core.xmpp.modules.auth.AuthData;
import tigase.halcyon.core.xmpp.modules.auth.ClientSaslException;
import tigase.halcyon.core.xmpp.modules.auth.MechanismsConfiguration;
import tigase.halcyon.core.xmpp.modules.auth.SASLContext;
import tigase.halcyon.core.xmpp.modules.auth.SASLEvent;
import tigase.halcyon.core.xmpp.modules.auth.SASLMechanism;
import tigase.halcyon.core.xmpp.modules.auth.SASLMechanismProvider;
import tigase.halcyon.core.xmpp.modules.auth.SASLModule;
import tigase.halcyon.core.xmpp.modules.auth.SASLPlain;
import tigase.halcyon.core.xmpp.modules.auth.SASLScramSHA1;
import tigase.halcyon.core.xmpp.modules.auth.SASLScramSHA1Plus;
import tigase.halcyon.core.xmpp.modules.auth.SASLScramSHA256;
import tigase.halcyon.core.xmpp.modules.auth.SASLScramSHA256Plus;
import tigase.halcyon.core.xmpp.modules.auth.SASLScramSHA512;
import tigase.halcyon.core.xmpp.modules.auth.SASLScramSHA512Plus;
import tigase.halcyon.core.xmpp.modules.auth.State;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001e\u0010\u0013\u001a\u00020\u00122\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0002JI\u0010\u0019\u001a\u00020\u001a\"\b\b\u0000\u0010\u001b*\u00020\u0012\"\b\b\u0001\u0010\u001c*\u00020\u001d2\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u0002H\u001b\u0012\u0004\u0012\u0002H\u001c0\u001f2\u0017\u0010 \u001a\u0013\u0012\u0004\u0012\u0002H\u001c\u0012\u0004\u0012\u00020\u001a0!\u00a2\u0006\u0002\b\"H\u0016J0\u0010#\u001a\u00020\u001a\"\b\b\u0000\u0010\u001b*\u00020\u0012\"\b\b\u0001\u0010\u001c*\u00020\u001d2\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u0002H\u001b\u0012\u0004\u0012\u0002H\u001c0\u001fH\u0016J\u001c\u0010$\u001a\u00020%2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0017\u001a\u00020\u0018J\u0012\u0010'\u001a\u0004\u0018\u00010\u00162\b\u0010(\u001a\u0004\u0018\u00010\u0016J\u0010\u0010)\u001a\u00020\u001a2\b\u0010(\u001a\u0004\u0018\u00010\u0016J\u0018\u0010*\u001a\u00020\u001a2\u0006\u0010+\u001a\u00020,2\b\u0010-\u001a\u0004\u0018\u00010\u0016J\u0006\u0010.\u001a\u00020\u001aJ\u0014\u0010/\u001a\u0002002\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\n\u001a\u00020\u000b8FX\u0086\u0084\u0002\u00a2\u0006\f\u001a\u0004\b\u000e\u0010\u000f*\u0004\b\f\u0010\rR\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Ltigase/halcyon/core/xmpp/modules/auth/SASLEngine;", "Ltigase/halcyon/core/xmpp/modules/auth/MechanismsConfiguration;", "context", "Ltigase/halcyon/core/Context;", "<init>", "(Ltigase/halcyon/core/Context;)V", "getContext", "()Ltigase/halcyon/core/Context;", "log", "Ltigase/halcyon/core/logger/Logger;", "saslContext", "Ltigase/halcyon/core/xmpp/modules/auth/SASLContext;", "getSaslContext$delegate", "(Ltigase/halcyon/core/xmpp/modules/auth/SASLEngine;)Ljava/lang/Object;", "getSaslContext", "()Ltigase/halcyon/core/xmpp/modules/auth/SASLContext;", "mechanisms", "", "Ltigase/halcyon/core/xmpp/modules/auth/SASLMechanism;", "selectMechanism", "allowedMechanisms", "", "", "streamFeatures", "Ltigase/halcyon/core/xml/Element;", "install", "", "MECH", "CFG", "", "provider", "Ltigase/halcyon/core/xmpp/modules/auth/SASLMechanismProvider;", "configuration", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "uninstall", "start", "Ltigase/halcyon/core/xmpp/modules/auth/AuthData;", "allowedMechanismsNames", "evaluateChallenge", "data", "evaluateSuccess", "evaluateFailure", "saslError", "Ltigase/halcyon/core/xmpp/modules/auth/SASLModule$SASLError;", "errorText", "removeAllMechanisms", "checkMechanisms", "", "halcyon-core"})
@SourceDebugExtension(value={"SMAP\nSASLEngine.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SASLEngine.kt\ntigase/halcyon/core/xmpp/modules/auth/SASLEngine\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,114:1\n1563#2:115\n1634#2,3:116\n1761#2,3:119\n*S KotlinDebug\n*F\n+ 1 SASLEngine.kt\ntigase/halcyon/core/xmpp/modules/auth/SASLEngine\n*L\n111#1:115\n111#1:116,3\n111#1:119,3\n*E\n"})
public final class SASLEngine
implements MechanismsConfiguration {
    @NotNull
    private final Context context;
    @NotNull
    private final Logger log;
    @NotNull
    private final List<SASLMechanism> mechanisms;

    public SASLEngine(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.log = LoggerFactory.logger$default(LoggerFactory.INSTANCE, "tigase.halcyon.core.xmpp.modules.auth.SASLEngine", false, 2, null);
        this.mechanisms = new ArrayList();
        MechanismsConfiguration.install$default(this, SASLScramSHA512Plus.Companion, null, 2, null);
        MechanismsConfiguration.install$default(this, SASLScramSHA256Plus.Companion, null, 2, null);
        MechanismsConfiguration.install$default(this, SASLScramSHA1Plus.Companion, null, 2, null);
        MechanismsConfiguration.install$default(this, SASLScramSHA512.Companion, null, 2, null);
        MechanismsConfiguration.install$default(this, SASLScramSHA256.Companion, null, 2, null);
        MechanismsConfiguration.install$default(this, SASLScramSHA1.Companion, null, 2, null);
        MechanismsConfiguration.install$default(this, SASLPlain.Companion, null, 2, null);
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    @NotNull
    public final SASLContext getSaslContext() {
        return this.context.getAuthContext();
    }

    private static Object getSaslContext$delegate(SASLEngine sASLEngine) {
        return Reflection.property0((PropertyReference0)((PropertyReference0)new PropertyReference0Impl((Object)sASLEngine.context, Context.class, "authContext", "getAuthContext()Ltigase/halcyon/core/xmpp/modules/auth/SASLContext;", 0)));
    }

    private final SASLMechanism selectMechanism(List<String> allowedMechanisms, Element streamFeatures) {
        for (SASLMechanism mechanism : this.mechanisms) {
            Logger.finer$default(this.log, null, () -> SASLEngine.selectMechanism$lambda$0(mechanism), 1, null);
            if (!allowedMechanisms.contains(mechanism.getName()) || !mechanism.isAllowedToUse(this.context, this.context.getConfig(), this.getSaslContext(), streamFeatures)) continue;
            Logger.fine$default(this.log, null, () -> SASLEngine.selectMechanism$lambda$1(mechanism), 1, null);
            return mechanism;
        }
        throw new HalcyonException("None of known SASL mechanism is supported by server");
    }

    @Override
    public <MECH extends SASLMechanism, CFG> void install(@NotNull SASLMechanismProvider<? extends MECH, CFG> provider, @NotNull Function1<? super CFG, Unit> configuration) {
        Intrinsics.checkNotNullParameter(provider, (String)"provider");
        Intrinsics.checkNotNullParameter(configuration, (String)"configuration");
        MECH m = provider.instance();
        provider.configure(m, configuration);
        this.mechanisms.add((SASLMechanism)m);
    }

    @Override
    public <MECH extends SASLMechanism, CFG> void uninstall(@NotNull SASLMechanismProvider<? extends MECH, CFG> provider) {
        Intrinsics.checkNotNullParameter(provider, (String)"provider");
        CollectionsKt.removeAll(this.mechanisms, arg_0 -> SASLEngine.uninstall$lambda$0(provider, arg_0));
    }

    @NotNull
    public final AuthData start(@NotNull List<String> allowedMechanismsNames, @NotNull Element streamFeatures) {
        Intrinsics.checkNotNullParameter(allowedMechanismsNames, (String)"allowedMechanismsNames");
        Intrinsics.checkNotNullParameter((Object)streamFeatures, (String)"streamFeatures");
        this.getSaslContext().setState$halcyon_core(State.InProgress);
        SASLMechanism mechanism = this.selectMechanism(allowedMechanismsNames, streamFeatures);
        String authData = mechanism.evaluateChallenge(null, this.context, this.context.getConfig(), this.getSaslContext());
        this.getSaslContext().setMechanism$halcyon_core(mechanism);
        this.context.getEventBus().fire(new SASLEvent.SASLStarted(mechanism.getName()));
        return new AuthData(mechanism.getName(), authData);
    }

    @Nullable
    public final String evaluateChallenge(@Nullable String data) {
        SASLMechanism sASLMechanism = this.getSaslContext().getMechanism();
        if (sASLMechanism == null) {
            throw new ClientSaslException("SASL Context is empty");
        }
        SASLMechanism mechanism = sASLMechanism;
        if (this.getSaslContext().getComplete()) {
            throw new ClientSaslException("Mechanism " + mechanism.getName() + " is finished but Server sent challenge.");
        }
        String r = mechanism.evaluateChallenge(data, this.context, this.context.getConfig(), this.getSaslContext());
        return r;
    }

    public final void evaluateSuccess(@Nullable String data) {
        SASLMechanism sASLMechanism = this.getSaslContext().getMechanism();
        if (sASLMechanism == null) {
            throw new ClientSaslException("SASL Context is empty");
        }
        SASLMechanism mechanism = sASLMechanism;
        mechanism.evaluateChallenge(data, this.context, this.context.getConfig(), this.getSaslContext());
        if (!this.getSaslContext().getComplete()) {
            this.getSaslContext().setState$halcyon_core(State.Failed);
            throw new ClientSaslException("Invalid state of SASL Engine");
        }
        this.getSaslContext().setState$halcyon_core(State.Success);
        this.context.getEventBus().fire(new SASLEvent.SASLSuccess());
    }

    public final void evaluateFailure(@NotNull SASLModule.SASLError saslError, @Nullable String errorText) {
        Intrinsics.checkNotNullParameter((Object)((Object)saslError), (String)"saslError");
        this.getSaslContext().setState$halcyon_core(State.Failed);
        this.context.getEventBus().fire(new SASLEvent.SASLError(saslError, errorText));
    }

    public final void removeAllMechanisms() {
        this.mechanisms.clear();
    }

    /*
     * WARNING - void declaration
     */
    public final boolean checkMechanisms(@NotNull List<String> allowedMechanisms) {
        boolean bl;
        block4: {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter(allowedMechanisms, (String)"allowedMechanisms");
            Iterable $this$map$iv = this.mechanisms;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                SASLMechanism sASLMechanism = (SASLMechanism)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(it.getName());
            }
            Iterable $this$any$iv = (List)destination$iv$iv;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl3 = false;
                    if (!allowedMechanisms.contains(it)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final Object selectMechanism$lambda$0(SASLMechanism $mechanism) {
        return "Checking mechanism " + $mechanism.getName();
    }

    private static final Object selectMechanism$lambda$1(SASLMechanism $mechanism) {
        return "Selected mechanism: " + $mechanism.getName();
    }

    private static final boolean uninstall$lambda$0(SASLMechanismProvider $provider, SASLMechanism mech) {
        Intrinsics.checkNotNullParameter((Object)mech, (String)"mech");
        return Intrinsics.areEqual((Object)mech.getName(), (Object)$provider.getNAME());
    }
}

