/*
 * Decompiled with CFR 0.152.
 */
package tigase.halcyon.core.requests;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.datetime.Clock;
import kotlinx.datetime.Instant;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tigase.halcyon.core.excutor.Executor;
import tigase.halcyon.core.logger.Logger;
import tigase.halcyon.core.logger.LoggerFactory;
import tigase.halcyon.core.requests.Request;
import tigase.halcyon.core.utils.Lock;
import tigase.halcyon.core.xml.Element;
import tigase.halcyon.core.xmpp.BareJID;
import tigase.halcyon.core.xmpp.FullJID;
import tigase.halcyon.core.xmpp.StanzaKtKt;
import tigase.halcyon.core.xmpp.stanzas.Stanza;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u000f\u001a\u00020\u00102\u000e\u0010\u0011\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000bJ\u0010\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0018\u0010\u001b\u001a\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\u000b2\u0006\u0010\u001c\u001a\u00020\u001aJ \u0010\u001d\u001a\u00020\u001e2\u000e\u0010\u001f\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000b2\u0006\u0010\u001c\u001a\u00020\u001aH\u0002J\u000e\u0010 \u001a\u00020\u001e2\u0006\u0010\u001c\u001a\u00020\u001aJ\u0016\u0010!\u001a\u00020\u00102\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00100#H\u0002J\u0010\u0010$\u001a\u00020\u00102\b\b\u0002\u0010%\u001a\u00020&J\u0006\u0010'\u001a\u00020\u0010J\u0006\u0010(\u001a\u00020)J\u0006\u0010*\u001a\u00020\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R:\u0010\b\u001a.\u0012\u0004\u0012\u00020\n\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000b0\tj\u0016\u0012\u0004\u0012\u00020\n\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000b`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017\u00a8\u0006+"}, d2={"Ltigase/halcyon/core/requests/RequestsManager;", "", "<init>", "()V", "log", "Ltigase/halcyon/core/logger/Logger;", "executor", "Ltigase/halcyon/core/excutor/Executor;", "requests", "Ljava/util/HashMap;", "", "Ltigase/halcyon/core/requests/Request;", "Lkotlin/collections/HashMap;", "lock", "Ltigase/halcyon/core/utils/Lock;", "register", "", "request", "boundJID", "Ltigase/halcyon/core/xmpp/FullJID;", "getBoundJID", "()Ltigase/halcyon/core/xmpp/FullJID;", "setBoundJID", "(Ltigase/halcyon/core/xmpp/FullJID;)V", "key", "element", "Ltigase/halcyon/core/xml/Element;", "getRequest", "response", "verify", "", "entry", "findAndExecute", "execute", "runnable", "Lkotlin/Function0;", "timeoutAll", "maxCreationTimestamp", "Lkotlinx/datetime/Instant;", "findOutdated", "getWaitingRequestsSize", "", "getRequestsIDs", "halcyon-core"})
@SourceDebugExtension(value={"SMAP\nRequestsManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RequestsManager.kt\ntigase/halcyon/core/requests/RequestsManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,130:1\n1869#2,2:131\n1869#2,2:133\n774#2:135\n865#2,2:136\n1563#2:138\n1634#2,3:139\n774#2:142\n865#2,2:143\n1563#2:145\n1634#2,3:146\n1563#2:149\n1634#2,3:150\n*S KotlinDebug\n*F\n+ 1 RequestsManager.kt\ntigase/halcyon/core/requests/RequestsManager\n*L\n99#1:131,2\n117#1:133,2\n95#1:135\n95#1:136,2\n97#1:138\n97#1:139,3\n113#1:142\n113#1:143,2\n115#1:145\n115#1:146,3\n128#1:149\n128#1:150,3\n*E\n"})
public final class RequestsManager {
    @NotNull
    private final Logger log = LoggerFactory.logger$default(LoggerFactory.INSTANCE, "tigase.halcyon.core.requests.RequestsManager", false, 2, null);
    @NotNull
    private final Executor executor = new Executor();
    @NotNull
    private final HashMap<String, Request<?, ?>> requests = new HashMap();
    @NotNull
    private final Lock lock = new Lock();
    @Nullable
    private FullJID boundJID;

    public final void register(@NotNull Request<?, ?> request) {
        Intrinsics.checkNotNullParameter(request, (String)"request");
        if (Intrinsics.areEqual((Object)((Stanza)request.getStanza()).getName(), (Object)"iq")) {
            this.lock.withLock(() -> RequestsManager.register$lambda$0(this, request));
        }
    }

    @Nullable
    public final FullJID getBoundJID() {
        return this.boundJID;
    }

    public final void setBoundJID(@Nullable FullJID fullJID) {
        this.boundJID = fullJID;
    }

    private final String key(Element element2) {
        return element2.getName() + ":" + element2.getAttributes().get("id");
    }

    @Nullable
    public final Request<?, ?> getRequest(@NotNull Element response) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        String id = this.key(response);
        return (Request)this.lock.withLock(() -> RequestsManager.getRequest$lambda$0(this, id, response));
    }

    private final boolean verify(Request<?, ?> entry, Element response) {
        BareJID bareBoundJID;
        FullJID jid = StanzaKtKt.getFromAttr(response);
        FullJID fullJID = this.boundJID;
        BareJID bareJID = bareBoundJID = fullJID != null ? fullJID.getBareJID() : null;
        if (Intrinsics.areEqual((Object)jid, (Object)entry.getJid())) {
            return true;
        }
        if (entry.getJid() == null && bareBoundJID != null) {
            FullJID fullJID2 = jid;
            if (Intrinsics.areEqual((Object)(fullJID2 != null ? fullJID2.getBareJID() : null), (Object)bareBoundJID)) {
                return true;
            }
        }
        return false;
    }

    public final boolean findAndExecute(@NotNull Element response) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Request<?, ?> request = this.getRequest(response);
        if (request == null) {
            return false;
        }
        Request<?, ?> r = request;
        this.execute((Function0<Unit>)((Function0)() -> RequestsManager.findAndExecute$lambda$0(r, response)));
        return true;
    }

    private final void execute(Function0<Unit> runnable) {
        this.executor.execute((Function0<Unit>)((Function0)() -> RequestsManager.execute$lambda$0(runnable, this)));
    }

    public final void timeoutAll(@NotNull Instant maxCreationTimestamp) {
        Intrinsics.checkNotNullParameter((Object)maxCreationTimestamp, (String)"maxCreationTimestamp");
        Logger.info$default(this.log, null, RequestsManager::timeoutAll$lambda$0, 1, null);
        List toTimeout = (List)this.lock.withLock(() -> RequestsManager.timeoutAll$lambda$1(this, maxCreationTimestamp));
        Iterable $this$forEach$iv = toTimeout;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair pair = (Pair)element$iv;
            boolean bl = false;
            Object object = pair.component1();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"component1(...)");
            String key = (String)object;
            Object object2 = pair.component2();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"component2(...)");
            Request value = (Request)object2;
            this.lock.withLock(() -> RequestsManager.timeoutAll$lambda$2$0(this, key));
            if (value.isCompleted()) continue;
            this.execute((Function0<Unit>)((Function0)() -> RequestsManager.timeoutAll$lambda$2$1(value)));
        }
    }

    public static /* synthetic */ void timeoutAll$default(RequestsManager requestsManager, Instant instant, int n, Object object) {
        if ((n & 1) != 0) {
            instant = Instant.Companion.getDISTANT_FUTURE();
        }
        requestsManager.timeoutAll(instant);
    }

    public final void findOutdated() {
        Instant now = Clock.System.INSTANCE.now();
        List toRemove = (List)this.lock.withLock(() -> RequestsManager.findOutdated$lambda$0(this, now));
        Iterable $this$forEach$iv = toRemove;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair pair = (Pair)element$iv;
            boolean bl = false;
            Object object = pair.component1();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"component1(...)");
            String key = (String)object;
            Object object2 = pair.component2();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"component2(...)");
            Request request = (Request)object2;
            this.lock.withLock(() -> RequestsManager.findOutdated$lambda$1$0(this, key));
            if (request.getCreationTimestamp().plus-LRDsOJo(request.getTimeoutDelay-UwyO8pc()).compareTo(now) > 0) continue;
            this.execute((Function0<Unit>)((Function0)new Function0<Unit>((Object)request){

                public final void invoke() {
                    Request.markTimeout$halcyon_core$default((Request)this.receiver, false, 1, null);
                }
            }));
        }
    }

    public final int getWaitingRequestsSize() {
        return ((Number)this.lock.withLock(() -> RequestsManager.getWaitingRequestsSize$lambda$0(this))).intValue();
    }

    @NotNull
    public final String getRequestsIDs() {
        return (String)this.lock.withLock(() -> RequestsManager.getRequestsIDs$lambda$0(this));
    }

    private static final Unit register$lambda$0(RequestsManager this$0, Request $request) {
        ((Map)this$0.requests).put(this$0.key((Element)$request.getStanza()), $request);
        return Unit.INSTANCE;
    }

    private static final Request getRequest$lambda$0(RequestsManager this$0, String $id, Element $response) {
        Request<?, ?> request = this$0.requests.get($id);
        if (request == null) {
            return null;
        }
        Request<?, ?> request2 = request;
        if (this$0.verify(request2, $response)) {
            this$0.requests.remove($id);
            return request2;
        }
        return null;
    }

    private static final Unit findAndExecute$lambda$0(Request $r, Element $response) {
        Request.setResponseStanza$default($r, $response, false, 2, null);
        return Unit.INSTANCE;
    }

    private static final Unit execute$lambda$0(Function0 $runnable, RequestsManager this$0) {
        try {
            $runnable.invoke();
        }
        catch (Throwable e) {
            this$0.log.warning(e, (Function0<? extends Object>)((Function0)RequestsManager::execute$lambda$0$0));
        }
        return Unit.INSTANCE;
    }

    private static final Object execute$lambda$0$0() {
        return "Error on processing response";
    }

    private static final Object timeoutAll$lambda$0() {
        return "Timeout all waiting requests";
    }

    /*
     * WARNING - void declaration
     */
    private static final List timeoutAll$lambda$1(RequestsManager this$0, Instant $maxCreationTimestamp) {
        void $this$mapTo$iv$iv;
        Map.Entry it;
        Iterable $this$filterTo$iv$iv;
        Set<Map.Entry<String, Request<?, ?>>> set = this$0.requests.entrySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"<get-entries>(...)");
        Iterable $this$filter$iv = set;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Map.Entry)element$iv$iv;
            boolean bl = false;
            if (!(((Request)it.getValue()).getCreationTimestamp().compareTo($maxCreationTimestamp) < 0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Map.Entry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Pair(it.getKey(), it.getValue()));
        }
        return (List)destination$iv$iv;
    }

    private static final Request timeoutAll$lambda$2$0(RequestsManager this$0, String $key) {
        return this$0.requests.remove($key);
    }

    private static final Unit timeoutAll$lambda$2$1(Request $value) {
        Request.markTimeout$halcyon_core$default($value, false, 1, null);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final List findOutdated$lambda$0(RequestsManager this$0, Instant $now) {
        void $this$mapTo$iv$iv;
        Map.Entry it;
        Iterable $this$filterTo$iv$iv;
        Set<Map.Entry<String, Request<?, ?>>> set = this$0.requests.entrySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"<get-entries>(...)");
        Iterable $this$filter$iv = set;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Map.Entry)element$iv$iv;
            boolean bl = false;
            if (!(((Request)it.getValue()).isCompleted() || ((Request)it.getValue()).getCreationTimestamp().plus-LRDsOJo(((Request)it.getValue()).getTimeoutDelay-UwyO8pc()).compareTo($now) <= 0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Map.Entry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Pair(it.getKey(), it.getValue()));
        }
        return (List)destination$iv$iv;
    }

    private static final Request findOutdated$lambda$1$0(RequestsManager this$0, String $key) {
        return this$0.requests.remove($key);
    }

    private static final int getWaitingRequestsSize$lambda$0(RequestsManager this$0) {
        return this$0.requests.size();
    }

    /*
     * WARNING - void declaration
     */
    private static final String getRequestsIDs$lambda$0(RequestsManager this$0) {
        void $this$mapTo$iv$iv;
        Collection<Request<?, ?>> collection = this$0.requests.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable $this$map$iv = collection;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Request request = (Request)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(it.getId());
        }
        return CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), null, null, null, (int)0, null, RequestsManager::getRequestsIDs$lambda$0$1, (int)31, null);
    }

    private static final CharSequence getRequestsIDs$lambda$0$1(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it;
    }
}

