/*
 * Decompiled with CFR 0.152.
 */
package tigase.halcyon.core.requests;

import kotlin.Metadata;
import kotlin.Result;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.datetime.Clock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tigase.halcyon.core.Context;
import tigase.halcyon.core.requests.Request;
import tigase.halcyon.core.requests.RequestBuilderKt;
import tigase.halcyon.core.requests.ResultHandler;
import tigase.halcyon.core.requests.SendHandler;
import tigase.halcyon.core.requests.XMPPError;
import tigase.halcyon.core.xml.Element;
import tigase.halcyon.core.xmpp.JID;
import tigase.halcyon.core.xmpp.stanzas.Stanza;
import tigase.halcyon.core.xmpp.stanzas.Stanza_buildersKt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0006\u0018\u0000*\u0004\b\u0000\u0010\u0001*\f\b\u0001\u0010\u0002*\u0006\u0012\u0002\b\u00030\u00032\u00020\u0004BF\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012#\u0010\u000b\u001a\u001f\u0012\u0015\u0012\u0013\u0018\u00010\u0004\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u000f\u0012\u0004\u0012\u00028\u00000\f\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0012\u0010%\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u001eJ;\u0010&\u001a\u000e\u0012\u0004\u0012\u0002H'\u0012\u0004\u0012\u00028\u00010\u0000\"\u0004\b\u0002\u0010'2!\u0010\u000b\u001a\u001d\u0012\u0013\u0012\u00118\u0000\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u000f\u0012\u0004\u0012\u0002H'0\fJ&\u0010(\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00002\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020$0\fJN\u0010)\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00002\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u00152.\u0010*\u001a*\u0012\u000e\u0012\f\u0012\u0002\b\u0003\u0012\u0004\u0012\u00028\u00010\u001e\u0012\u0006\u0012\u0004\u0018\u00018\u0001\u0012\u0004\u0012\u00020\u001f0\u001dj\b\u0012\u0004\u0012\u00028\u0001` JB\u0010+\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00002\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u00152\"\u0010*\u001a\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000,\u0012\u0004\u0012\u00020\u001f0\fj\b\u0012\u0004\u0012\u00028\u0000`-J\u001a\u0010.\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00002\u0006\u0010/\u001a\u000200J!\u0010.\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00002\u0006\u00101\u001a\u00020\u0018\u00a2\u0006\u0004\b2\u00103J0\u00104\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00002\u001c\u0010*\u001a\u0018\u0012\u000e\u0012\f\u0012\u0002\b\u0003\u0012\u0004\u0012\u00028\u00010\u001e\u0012\u0004\u0012\u00020\u001f0\fJ\u0012\u00105\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u001eJ\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00002\u0006\u0010\u0014\u001a\u00020\u0015R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R+\u0010\u000b\u001a\u001f\u0012\u0015\u0012\u0013\u0018\u00010\u0004\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u000f\u0012\u0004\u0012\u00028\u00000\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\u000e\u0012\u0002\b\u0003\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0019R\u0016\u0010\u001a\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R:\u0010\u001c\u001a.\u0012\u000e\u0012\f\u0012\u0002\b\u0003\u0012\u0004\u0012\u00028\u00010\u001e\u0012\u0006\u0012\u0004\u0018\u00018\u0001\u0012\u0004\u0012\u00020\u001f\u0018\u00010\u001dj\n\u0012\u0004\u0012\u00028\u0001\u0018\u0001` X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010!\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u00010\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010#\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020$0\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Ltigase/halcyon/core/requests/RequestBuilder;", "V", "STT", "Ltigase/halcyon/core/xmpp/stanzas/Stanza;", "", "halcyon", "Ltigase/halcyon/core/Context;", "element", "Ltigase/halcyon/core/xml/Element;", "writeDirectly", "", "transform", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "value", "<init>", "(Ltigase/halcyon/core/Context;Ltigase/halcyon/core/xml/Element;ZLkotlin/jvm/functions/Function1;)V", "getElement$halcyon_core", "()Ltigase/halcyon/core/xml/Element;", "requestName", "", "parentBuilder", "timeoutDelay", "Lkotlin/time/Duration;", "J", "resultHandler", "Ltigase/halcyon/core/requests/ResultHandler;", "responseStanzaHandler", "Lkotlin/Function2;", "Ltigase/halcyon/core/requests/Request;", "", "Ltigase/halcyon/core/requests/ResponseStanzaHandler;", "onSendHandler", "Ltigase/halcyon/core/requests/SendHandler;", "errorTransformer", "Ltigase/halcyon/core/requests/XMPPError;", "build", "map", "R", "errorConverter", "handleResponseStanza", "handler", "response", "Lkotlin/Result;", "Ltigase/halcyon/core/requests/RHandler;", "timeToLive", "time", "", "duration", "timeToLive-LRDsOJo", "(J)Ltigase/halcyon/core/requests/RequestBuilder;", "onSend", "send", "halcyon-core"})
@SourceDebugExtension(value={"SMAP\nRequestBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RequestBuilder.kt\ntigase/halcyon/core/requests/RequestBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,364:1\n1#2:365\n*E\n"})
public final class RequestBuilder<V, STT extends Stanza<?>> {
    @NotNull
    private final Context halcyon;
    @NotNull
    private final Element element;
    private final boolean writeDirectly;
    @NotNull
    private final Function1<Object, V> transform;
    @Nullable
    private String requestName;
    @Nullable
    private RequestBuilder<?, STT> parentBuilder;
    private long timeoutDelay;
    @Nullable
    private ResultHandler<V> resultHandler;
    @Nullable
    private Function2<? super Request<?, STT>, ? super STT, Unit> responseStanzaHandler;
    @Nullable
    private SendHandler<V, STT> onSendHandler;
    @NotNull
    private Function1<? super STT, ? extends XMPPError> errorTransformer;

    public RequestBuilder(@NotNull Context halcyon, @NotNull Element element2, boolean writeDirectly, @NotNull Function1<Object, ? extends V> transform) {
        Intrinsics.checkNotNullParameter((Object)halcyon, (String)"halcyon");
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        Intrinsics.checkNotNullParameter(transform, (String)"transform");
        this.halcyon = halcyon;
        this.element = element2;
        this.writeDirectly = writeDirectly;
        this.transform = transform;
        this.timeoutDelay = DurationKt.toDuration((int)30, (DurationUnit)DurationUnit.SECONDS);
        this.errorTransformer = RequestBuilder::errorTransformer$lambda$0;
    }

    public /* synthetic */ RequestBuilder(Context context, Element element2, boolean bl, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = false;
        }
        this(context, element2, bl, function1);
    }

    @NotNull
    public final Element getElement$halcyon_core() {
        return this.element;
    }

    @NotNull
    public final Request<V, STT> build() {
        Request request;
        Object stanza = Stanza_buildersKt.wrap(this.element);
        JID jID = ((Stanza)stanza).getTo();
        String string = ((Stanza)stanza).getId();
        Intrinsics.checkNotNull((Object)string);
        RequestBuilder<?, STT> requestBuilder = this.parentBuilder;
        Request $this$build_u24lambda_u240 = request = new Request(jID, string, Clock.System.INSTANCE.now(), (Stanza)stanza, this.timeoutDelay, this.resultHandler, (Function1)this.transform, (Function1)this.errorTransformer, requestBuilder != null ? requestBuilder.build() : null, this.onSendHandler, null);
        boolean bl = false;
        $this$build_u24lambda_u240.setStanzaHandler$halcyon_core(this.responseStanzaHandler);
        $this$build_u24lambda_u240.setRequestName$halcyon_core(this.requestName);
        return request;
    }

    @NotNull
    public final <R> RequestBuilder<R, STT> map(@NotNull Function1<? super V, ? extends R> transform) {
        Intrinsics.checkNotNullParameter(transform, (String)"transform");
        if (!(!this.writeDirectly)) {
            boolean bl = false;
            String string = "Mapping cannot be added to directly writable request.";
            throw new IllegalStateException(string.toString());
        }
        RequestBuilder<V, STT> res = new RequestBuilder<V, STT>(this.halcyon, this.element, this.writeDirectly, (Function1)TypeIntrinsics.beforeCheckcastToFunctionOfArity(transform, (int)1));
        res.errorTransformer = this.errorTransformer;
        res.timeoutDelay = this.timeoutDelay;
        res.resultHandler = null;
        res.onSendHandler = null;
        res.parentBuilder = this;
        return res;
    }

    @NotNull
    public final RequestBuilder<V, STT> errorConverter(@NotNull Function1<? super STT, ? extends XMPPError> transform) {
        Intrinsics.checkNotNullParameter(transform, (String)"transform");
        this.errorTransformer = transform;
        return this;
    }

    @NotNull
    public final RequestBuilder<V, STT> handleResponseStanza(@Nullable String name2, @NotNull Function2<? super Request<?, STT>, ? super STT, Unit> handler2) {
        Intrinsics.checkNotNullParameter(handler2, (String)"handler");
        if (!(!this.writeDirectly)) {
            boolean bl = false;
            String string = "Response handler cannot be added to directly writable request.";
            throw new IllegalStateException(string.toString());
        }
        this.responseStanzaHandler = handler2;
        if (this.requestName != null) {
            this.requestName = name2;
        }
        return this;
    }

    public static /* synthetic */ RequestBuilder handleResponseStanza$default(RequestBuilder requestBuilder, String string, Function2 function2, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        return requestBuilder.handleResponseStanza(string, function2);
    }

    @NotNull
    public final RequestBuilder<V, STT> response(@Nullable String requestName, @NotNull Function1<? super Result<? extends V>, Unit> handler2) {
        Intrinsics.checkNotNullParameter(handler2, (String)"handler");
        if (!(!this.writeDirectly)) {
            boolean bl = false;
            String string = "Response handler cannot be added to directly writable request.";
            throw new IllegalStateException(string.toString());
        }
        if (this.resultHandler == null) {
            this.resultHandler = new ResultHandler();
        }
        ResultHandler<V> resultHandler = this.resultHandler;
        if (resultHandler != null) {
            resultHandler.add(handler2);
        }
        if (requestName != null) {
            this.requestName = requestName;
        }
        return this;
    }

    public static /* synthetic */ RequestBuilder response$default(RequestBuilder requestBuilder, String string, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        return requestBuilder.response(string, function1);
    }

    @NotNull
    public final RequestBuilder<V, STT> timeToLive(long time) {
        this.timeoutDelay = DurationKt.toDuration((long)time, (DurationUnit)DurationUnit.MILLISECONDS);
        return this;
    }

    @NotNull
    public final RequestBuilder<V, STT> timeToLive-LRDsOJo(long l) {
        this.timeoutDelay = l;
        return this;
    }

    @NotNull
    public final RequestBuilder<V, STT> onSend(@NotNull Function1<? super Request<?, STT>, Unit> handler2) {
        block1: {
            Intrinsics.checkNotNullParameter(handler2, (String)"handler");
            if (this.onSendHandler == null) {
                this.onSendHandler = new SendHandler();
            }
            SendHandler<V, STT> sendHandler = this.onSendHandler;
            if (sendHandler == null) break block1;
            sendHandler.add(handler2);
        }
        return this;
    }

    @NotNull
    public final Request<V, STT> send() {
        Request<V, STT> req = this.build();
        if (this.writeDirectly) {
            this.halcyon.getWriter().writeDirectly((Element)req.getStanza());
        } else {
            this.halcyon.getWriter().write(req);
        }
        return req;
    }

    @NotNull
    public final RequestBuilder<V, STT> name(@NotNull String requestName) {
        Intrinsics.checkNotNullParameter((Object)requestName, (String)"requestName");
        this.requestName = requestName;
        return this;
    }

    private static final XMPPError errorTransformer$lambda$0(Stanza it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Request.Error e = RequestBuilderKt.findCondition(it);
        return new XMPPError(it, e.getCondition(), e.getMessage());
    }
}

