/*
 * Decompiled with CFR 0.152.
 */
package tigase.halcyon.core.eventbus;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import tigase.halcyon.core.AbstractHalcyon;
import tigase.halcyon.core.TickEvent;
import tigase.halcyon.core.eventbus.AbstractEventBus;
import tigase.halcyon.core.eventbus.Event;
import tigase.halcyon.core.eventbus.EventHandler;
import tigase.halcyon.core.logger.Logger;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0001 B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001e\u0010\u0006\u001a\u0018\u0012\u0004\u0012\u00020\b\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\t0\u0007H\u0014J\u0012\u0010\u000b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\tH\u0014J\"\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0010\u0010\u001b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\u001cH\u0002J\"\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0010\u0010\u001b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\u001cH\u0002J\"\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0010\u0010\u001b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\u001cH\u0002J\"\u0010\u001f\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0010\u0010\u001b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\u001cH\u0014R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0016\u0010\u0014\u001a\n \u0016*\u0004\u0018\u00010\u00150\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Ltigase/halcyon/core/eventbus/EventBus;", "Ltigase/halcyon/core/eventbus/AbstractEventBus;", "context", "Ltigase/halcyon/core/AbstractHalcyon;", "<init>", "(Ltigase/halcyon/core/AbstractHalcyon;)V", "createHandlersMap", "", "", "", "Ltigase/halcyon/core/eventbus/EventHandler;", "createHandlersSet", "threadCounter", "", "mode", "Ltigase/halcyon/core/eventbus/EventBus$Mode;", "getMode", "()Ltigase/halcyon/core/eventbus/EventBus$Mode;", "setMode", "(Ltigase/halcyon/core/eventbus/EventBus$Mode;)V", "executor", "Ljava/util/concurrent/ExecutorService;", "kotlin.jvm.PlatformType", "fireNoThread", "", "event", "Ltigase/halcyon/core/eventbus/Event;", "handlers", "", "fireThreadPerEvent", "fireThreadPerHandler", "fire", "Mode", "halcyon-core"})
@SourceDebugExtension(value={"SMAP\nEventBus.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EventBus.kt\ntigase/halcyon/core/eventbus/EventBus\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,97:1\n1869#2,2:98\n1869#2,2:100\n1869#2,2:102\n*S KotlinDebug\n*F\n+ 1 EventBus.kt\ntigase/halcyon/core/eventbus/EventBus\n*L\n49#1:98,2\n73#1:100,2\n61#1:102,2\n*E\n"})
public final class EventBus
extends AbstractEventBus {
    private int threadCounter;
    @NotNull
    private Mode mode;
    private final ExecutorService executor;

    public EventBus(@NotNull AbstractHalcyon context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
        this.mode = Mode.NoThread;
        this.executor = Executors.newSingleThreadExecutor(arg_0 -> EventBus.executor$lambda$0(this, arg_0));
    }

    @Override
    @NotNull
    protected Map<String, Set<EventHandler<?>>> createHandlersMap() {
        return new ConcurrentHashMap();
    }

    @Override
    @NotNull
    protected Set<EventHandler<?>> createHandlersSet() {
        ConcurrentHashMap.KeySetView keySetView = ConcurrentHashMap.newKeySet();
        Intrinsics.checkNotNullExpressionValue(keySetView, (String)"newKeySet(...)");
        return keySetView;
    }

    @NotNull
    public final Mode getMode() {
        return this.mode;
    }

    public final void setMode(@NotNull Mode mode) {
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"<set-?>");
        this.mode = mode;
    }

    private final void fireNoThread(Event event, Collection<? extends EventHandler<?>> handlers) {
        Iterable $this$forEach$iv = handlers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EventHandler eventHandler = (EventHandler)element$iv;
            boolean bl = false;
            try {
                Intrinsics.checkNotNull((Object)eventHandler, (String)"null cannot be cast to non-null type tigase.halcyon.core.eventbus.EventHandler<tigase.halcyon.core.eventbus.Event>");
                eventHandler.onEvent(event);
            }
            catch (Exception e) {
                this.getLog().warning(e, (Function0<? extends Object>)((Function0)() -> EventBus.fireNoThread$lambda$0$0(event)));
            }
        }
    }

    private final void fireThreadPerEvent(Event event, Collection<? extends EventHandler<?>> handlers) {
        this.executor.execute(() -> EventBus.fireThreadPerEvent$lambda$0(handlers, event, this));
    }

    private final void fireThreadPerHandler(Event event, Collection<? extends EventHandler<?>> handlers) {
        Iterable $this$forEach$iv = handlers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EventHandler eventHandler = (EventHandler)element$iv;
            boolean bl = false;
            this.executor.execute(() -> EventBus.fireThreadPerHandler$lambda$0$0(eventHandler, event, this));
        }
    }

    @Override
    protected void fire(@NotNull Event event, @NotNull Collection<? extends EventHandler<?>> handlers) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter(handlers, (String)"handlers");
        if (!(event instanceof TickEvent)) {
            Logger.finest$default(this.getLog(), null, () -> EventBus.fire$lambda$0(event, handlers), 1, null);
        }
        switch (WhenMappings.$EnumSwitchMapping$0[this.mode.ordinal()]) {
            case 1: {
                this.fireNoThread(event, handlers);
                break;
            }
            case 2: {
                this.fireThreadPerEvent(event, handlers);
                break;
            }
            case 3: {
                this.fireThreadPerHandler(event, handlers);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    private static final Thread executor$lambda$0(EventBus this$0, Runnable r) {
        Thread t = new Thread(r);
        ++this$0.threadCounter;
        t.setName("EventBus-Thread-" + this$0.threadCounter);
        t.setDaemon(true);
        return t;
    }

    private static final Object fireNoThread$lambda$0$0(Event $event) {
        return "Problem on handling event " + $event.getEventType();
    }

    private static final void fireThreadPerEvent$lambda$0(Collection $handlers, Event $event, EventBus this$0) {
        Iterable $this$forEach$iv = $handlers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EventHandler eventHandler = (EventHandler)element$iv;
            boolean bl = false;
            try {
                Intrinsics.checkNotNull((Object)eventHandler, (String)"null cannot be cast to non-null type tigase.halcyon.core.eventbus.EventHandler<tigase.halcyon.core.eventbus.Event>");
                eventHandler.onEvent($event);
            }
            catch (Exception e) {
                this$0.getLog().warning(e, (Function0<? extends Object>)((Function0)() -> EventBus.fireThreadPerEvent$lambda$0$0$0($event)));
            }
        }
    }

    private static final Object fireThreadPerEvent$lambda$0$0$0(Event $event) {
        return "Problem on handling event " + $event.getEventType();
    }

    private static final void fireThreadPerHandler$lambda$0$0(EventHandler $eventHandler, Event $event, EventBus this$0) {
        try {
            Intrinsics.checkNotNull((Object)$eventHandler, (String)"null cannot be cast to non-null type tigase.halcyon.core.eventbus.EventHandler<tigase.halcyon.core.eventbus.Event>");
            $eventHandler.onEvent($event);
        }
        catch (Exception e) {
            this$0.getLog().warning(e, (Function0<? extends Object>)((Function0)() -> EventBus.fireThreadPerHandler$lambda$0$0$0($event)));
        }
    }

    private static final Object fireThreadPerHandler$lambda$0$0$0(Event $event) {
        return "Problem on handling event " + $event.getEventType();
    }

    private static final Object fire$lambda$0(Event $event, Collection $handlers) {
        return "Firing event " + $event + " with " + $handlers.size() + " handlers";
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Ltigase/halcyon/core/eventbus/EventBus$Mode;", "", "<init>", "(Ljava/lang/String;I)V", "NoThread", "ThreadPerEvent", "ThreadPerHandler", "halcyon-core"})
    public static final class Mode
    extends Enum<Mode> {
        public static final /* enum */ Mode NoThread = new Mode();
        public static final /* enum */ Mode ThreadPerEvent = new Mode();
        public static final /* enum */ Mode ThreadPerHandler = new Mode();
        private static final /* synthetic */ Mode[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Mode[] values() {
            return (Mode[])$VALUES.clone();
        }

        public static Mode valueOf(String value) {
            return Enum.valueOf(Mode.class, value);
        }

        @NotNull
        public static EnumEntries<Mode> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = modeArray = new Mode[]{Mode.NoThread, Mode.ThreadPerEvent, Mode.ThreadPerHandler};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Mode.values().length];
            try {
                nArray[Mode.NoThread.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Mode.ThreadPerEvent.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Mode.ThreadPerHandler.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

