/*
 * Decompiled with CFR 0.152.
 */
package tigase.halcyon.core.connector.socket;

import java.security.MessageDigest;
import java.security.cert.X509Certificate;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tigase.halcyon.core.logger.Logger;
import tigase.halcyon.core.logger.LoggerFactory;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u000e\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u00a8\u0006\u0004"}, d2={"calculateCertificateHash", "", "certificate", "Ljava/security/cert/X509Certificate;", "halcyon-core"})
public final class DefaultTLSProcessorKt {
    @Nullable
    public static final byte[] calculateCertificateHash(@NotNull X509Certificate certificate) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)certificate, (String)"certificate");
        Logger log = LoggerFactory.logger$default(LoggerFactory.INSTANCE, "tigase.halcyon.core.connector.socket.calculateCertificateHash", false, 2, null);
        try {
            String string = certificate.getSigAlgName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSigAlgName(...)");
            String string2 = StringsKt.substringBefore$default((String)string, (String)"with", null, (int)2, null);
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
            String string3 = string2.toUpperCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toUpperCase(...)");
            String useAlgo = switch (string3) {
                case "SHA1", "MD5" -> "SHA-256";
                case "SHA224" -> "SHA-224";
                case "SHA256" -> "SHA-256";
                case "SHA384" -> "SHA-384";
                case "SHA512" -> "SHA-512";
                default -> {
                    String sigAlgName;
                    yield sigAlgName;
                }
            };
            Logger.finer$default(log, null, () -> DefaultTLSProcessorKt.calculateCertificateHash$lambda$0(useAlgo), 1, null);
            byArray = MessageDigest.getInstance(useAlgo).digest(certificate.getEncoded());
        }
        catch (Exception e) {
            log.severe(e, (Function0<? extends Object>)((Function0)DefaultTLSProcessorKt::calculateCertificateHash$lambda$1));
            e.printStackTrace();
            byArray = null;
        }
        return byArray;
    }

    private static final Object calculateCertificateHash$lambda$0(String $useAlgo) {
        return "Calculating hash of certificate with " + $useAlgo + " algorithm.";
    }

    private static final Object calculateCertificateHash$lambda$1() {
        return "Cannot calculate certificate hash.";
    }
}

