/*
 * Decompiled with CFR 0.152.
 */
package tigase.halcyon.core.connector;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import tigase.halcyon.core.AbstractHalcyon;
import tigase.halcyon.core.connector.ConnectorStateChangeEvent;
import tigase.halcyon.core.connector.ReceivedXMLElementEvent;
import tigase.halcyon.core.connector.SessionController;
import tigase.halcyon.core.connector.State;
import tigase.halcyon.core.eventbus.Event;
import tigase.halcyon.core.xml.Element;
import tigase.halcyon.core.xmpp.modules.sm.StreamManagementModule;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0015\u001a\u00020\u0016H&J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH&J\b\u0010\u001b\u001a\u00020\u0018H&J\b\u0010\u001c\u001a\u00020\u0018H&J\u0010\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u001fH\u0004J\u0010\u0010 \u001a\u00020\u00182\u0006\u0010!\u001a\u00020\"H\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u00020\tX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR$\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006#"}, d2={"Ltigase/halcyon/core/connector/AbstractConnector;", "", "halcyon", "Ltigase/halcyon/core/AbstractHalcyon;", "<init>", "(Ltigase/halcyon/core/AbstractHalcyon;)V", "getHalcyon", "()Ltigase/halcyon/core/AbstractHalcyon;", "eventsEnabled", "", "getEventsEnabled", "()Z", "setEventsEnabled", "(Z)V", "value", "Ltigase/halcyon/core/connector/State;", "state", "getState", "()Ltigase/halcyon/core/connector/State;", "setState", "(Ltigase/halcyon/core/connector/State;)V", "createSessionController", "Ltigase/halcyon/core/connector/SessionController;", "send", "", "data", "", "start", "stop", "handleReceivedElement", "element", "Ltigase/halcyon/core/xml/Element;", "fire", "e", "Ltigase/halcyon/core/eventbus/Event;", "halcyon-core"})
public abstract class AbstractConnector {
    @NotNull
    private final AbstractHalcyon halcyon;
    private boolean eventsEnabled;
    @NotNull
    private State state;

    public AbstractConnector(@NotNull AbstractHalcyon halcyon) {
        Intrinsics.checkNotNullParameter((Object)halcyon, (String)"halcyon");
        this.halcyon = halcyon;
        this.eventsEnabled = true;
        this.state = State.Disconnected;
    }

    @NotNull
    public final AbstractHalcyon getHalcyon() {
        return this.halcyon;
    }

    protected final boolean getEventsEnabled() {
        return this.eventsEnabled;
    }

    protected final void setEventsEnabled(boolean bl) {
        this.eventsEnabled = bl;
    }

    @NotNull
    public final State getState() {
        return this.state;
    }

    protected final void setState(@NotNull State value) {
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        State old = this.state;
        this.state = value;
        if (old != this.state) {
            this.fire(new ConnectorStateChangeEvent(old, this.state));
        }
    }

    @NotNull
    public abstract SessionController createSessionController();

    public abstract void send(@NotNull CharSequence var1);

    public abstract void start();

    public abstract void stop();

    protected final void handleReceivedElement(@NotNull Element element2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        StreamManagementModule streamManagementModule = (StreamManagementModule)this.halcyon.getModuleOrNull(StreamManagementModule.Companion);
        boolean bl = streamManagementModule != null ? streamManagementModule.processElementReceived(element2) : false;
        if (bl) {
            return;
        }
        this.fire(new ReceivedXMLElementEvent(element2));
    }

    protected final void fire(@NotNull Event e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (this.eventsEnabled) {
            this.halcyon.getEventBus().fire(e);
        }
    }
}

