/*
 * Decompiled with CFR 0.152.
 */
package tigase.halcyon.core;

import java.util.Timer;
import java.util.TimerTask;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tigase.halcyon.core.AbstractHalcyon;
import tigase.halcyon.core.Halcyon;
import tigase.halcyon.core.HalcyonStateChangeEvent;
import tigase.halcyon.core.builder.ConfigurationBuilder;
import tigase.halcyon.core.configuration.ConnectionConfig;
import tigase.halcyon.core.connector.AbstractConnector;
import tigase.halcyon.core.connector.socket.SocketConnector;
import tigase.halcyon.core.connector.socket.SocketConnectorConfig;
import tigase.halcyon.core.connector.socket.TLSProcessorFactory;
import tigase.halcyon.core.eventbus.Event;
import tigase.halcyon.core.eventbus.EventBus;
import tigase.halcyon.core.eventbus.EventBusInterface;
import tigase.halcyon.core.eventbus.EventDefinition;
import tigase.halcyon.core.eventbus.EventHandler;
import tigase.halcyon.core.exceptions.AuthenticationException;
import tigase.halcyon.core.exceptions.HalcyonException;
import tigase.halcyon.core.logger.Logger;
import tigase.halcyon.core.logger.LoggerFactory;
import tigase.halcyon.core.xmpp.modules.auth.SASLEvent;
import tigase.halcyon.core.xmpp.modules.auth.SASLModule;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\n\u001a\u00020\u000bH\u0014J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0006\u0010\u0012\u001a\u00020\rJ\u0006\u0010\u0013\u001a\u00020\rR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Ltigase/halcyon/core/Halcyon;", "Ltigase/halcyon/core/AbstractHalcyon;", "configuration", "Ltigase/halcyon/core/builder/ConfigurationBuilder;", "<init>", "(Ltigase/halcyon/core/builder/ConfigurationBuilder;)V", "log", "Ltigase/halcyon/core/logger/Logger;", "connectionTimer", "Ljava/util/Timer;", "createConnector", "Ltigase/halcyon/core/connector/AbstractConnector;", "reconnect", "", "immediately", "", "lock", "Ljava/lang/Object;", "waitForAllResponses", "connectAndWait", "halcyon-core"})
@SourceDebugExtension(value={"SMAP\nHalcyon.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Halcyon.kt\ntigase/halcyon/core/Halcyon\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,125:1\n1#2:126\n*E\n"})
public final class Halcyon
extends AbstractHalcyon {
    @NotNull
    private final Logger log;
    @Nullable
    private Timer connectionTimer;
    @NotNull
    private final Object lock;

    public Halcyon(@NotNull ConfigurationBuilder configuration) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        super(configuration);
        this.log = LoggerFactory.logger$default(LoggerFactory.INSTANCE, "tigase.halcyon.core.Halcyon", false, 2, null);
        this.lock = new Object();
        this.getEventBus().setMode(EventBus.Mode.ThreadPerHandler);
        this.getEventBus().register((EventDefinition)HalcyonStateChangeEvent.Companion, arg_0 -> Halcyon._init_$lambda$0(this, arg_0));
    }

    @Override
    @NotNull
    protected AbstractConnector createConnector() {
        ConnectionConfig connectionConfig = this.getConfig().getConnection();
        Intrinsics.checkNotNull((Object)connectionConfig, (String)"null cannot be cast to non-null type tigase.halcyon.core.connector.socket.SocketConnectorConfig");
        TLSProcessorFactory tlsProcessorFactory = ((SocketConnectorConfig)connectionConfig).getTlsProcessorFactory();
        this.log.fine("Selected TLS Processor: " + tlsProcessorFactory.getNAME());
        return new SocketConnector(this, tlsProcessorFactory);
    }

    @Override
    public void reconnect(boolean immediately) {
        if (!this.getRunning()) {
            Logger.fine$default(this.log, null, () -> Halcyon.reconnect$lambda$0(immediately), 1, null);
        } else {
            Logger.fine$default(this.log, null, () -> Halcyon.reconnect$lambda$1(immediately), 1, null);
            try {
                if (!immediately) {
                    Thread.sleep(3000L);
                }
                this.setState(AbstractHalcyon.State.Connecting);
                this.startConnector();
            }
            catch (HalcyonException ex) {
                this.log.fine(ex, (Function0<? extends Object>)((Function0)Halcyon::reconnect$lambda$2));
                this.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void waitForAllResponses() {
        while (this.getRequestsManager().getWaitingRequestsSize() > 0) {
            Object object = this.lock;
            synchronized (object) {
                boolean bl = false;
                this.lock.wait(100L);
                Unit unit = Unit.INSTANCE;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void connectAndWait() {
        Ref.ObjectRef exceptionToThrow = new Ref.ObjectRef();
        EventHandler<Event> handler2 = new EventHandler<Event>((Ref.ObjectRef<Throwable>)exceptionToThrow, this){
            final /* synthetic */ Ref.ObjectRef<Throwable> $exceptionToThrow;
            final /* synthetic */ Halcyon this$0;
            {
                this.$exceptionToThrow = $exceptionToThrow;
                this.this$0 = $receiver;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onEvent(Event event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (event instanceof SASLEvent.SASLError) {
                    SASLModule.SASLError sASLError = ((SASLEvent.SASLError)event).getError();
                    String string = ((SASLEvent.SASLError)event).getDescription();
                    if (string == null) {
                        string = "Authentication error";
                    }
                    this.$exceptionToThrow.element = new AuthenticationException(sASLError, string);
                } else if (event instanceof HalcyonStateChangeEvent && (((HalcyonStateChangeEvent)event).getNewState() == AbstractHalcyon.State.Connected || ((HalcyonStateChangeEvent)event).getNewState() == AbstractHalcyon.State.Stopped)) {
                    Object object = Halcyon.access$getLock$p(this.this$0);
                    Halcyon halcyon = this.this$0;
                    Object object2 = object;
                    synchronized (object2) {
                        boolean bl = false;
                        Halcyon.access$getLock$p(halcyon).notify();
                        Unit unit = Unit.INSTANCE;
                    }
                }
            }
        };
        try {
            EventBusInterface.register$default((EventBusInterface)this.getEventBus(), null, handler2, 1, null);
            super.connect();
            Object object = this.lock;
            synchronized (object) {
                boolean $i$a$-synchronized-Halcyon$connectAndWait$22 = false;
                this.lock.wait(30000L);
                Unit $i$a$-synchronized-Halcyon$connectAndWait$22 = Unit.INSTANCE;
            }
            Throwable throwable = (Throwable)exceptionToThrow.element;
            if (throwable != null) {
                Throwable it = throwable;
                boolean bl = false;
                throw it;
            }
            if (this.getState() != AbstractHalcyon.State.Connected && this.getState() != AbstractHalcyon.State.Stopped) {
                throw new HalcyonException("Cannot connect to XMPP server.");
            }
        }
        finally {
            this.getEventBus().unregister(handler2);
        }
    }

    private static final Object reconnect$lambda$0(boolean $immediately) {
        return "Called reconnect. immediately=" + $immediately + ", skipping reconnection as running is false!";
    }

    private static final Object reconnect$lambda$1(boolean $immediately) {
        return "Called reconnect. immediately=" + $immediately;
    }

    private static final Object reconnect$lambda$2() {
        return "Failed to reconnect to halcyon";
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit _init_$lambda$0(Halcyon this$0, HalcyonStateChangeEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (it.getNewState() == AbstractHalcyon.State.Connecting) {
            void it2;
            Timer timer;
            Timer timer2 = this$0.connectionTimer;
            if (timer2 != null) {
                timer2.cancel();
            }
            Timer timer3 = timer = new Timer();
            Halcyon halcyon = this$0;
            boolean bl = false;
            it2.schedule(new TimerTask(this$0){
                final /* synthetic */ Halcyon this$0;
                {
                    this.this$0 = halcyon;
                }

                public void run() {
                    TimerTask $this$lambda_u240_u240_u240 = this;
                    boolean bl = false;
                    if (this.this$0.getState() == AbstractHalcyon.State.Connecting) {
                        Logger.warning$default(Halcyon.access$getLog$p(this.this$0), null, 1.1.1.1.INSTANCE, 1, null);
                        this.this$0.disconnect();
                    }
                }
            }, Duration.toLong-impl((long)DurationKt.toDuration((int)120, (DurationUnit)DurationUnit.SECONDS), (DurationUnit)DurationUnit.MILLISECONDS));
            halcyon.connectionTimer = timer;
        } else {
            Timer timer = this$0.connectionTimer;
            if (timer != null) {
                timer.cancel();
            }
            this$0.connectionTimer = null;
        }
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Object access$getLock$p(Halcyon $this) {
        return $this.lock;
    }

    public static final /* synthetic */ Logger access$getLog$p(Halcyon $this) {
        return $this.log;
    }
}

