/*
 * Decompiled with CFR 0.152.
 */
package tigase.halcyon.core.xmpp.modules.omemo;

import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import korlibs.crypto.encoding.HexKt;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import tigase.halcyon.core.exceptions.HalcyonException;
import tigase.halcyon.core.logger.Logger;
import tigase.halcyon.core.logger.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\n\u001a\u00060\u000bj\u0002`\f2\u0006\u0010\r\u001a\u00020\u000e2\n\u0010\u000f\u001a\u00060\u000bj\u0002`\fJ\u001e\u0010\u0010\u001a\u00060\u0011j\u0002`\u00122\u0006\u0010\r\u001a\u00020\u000e2\n\u0010\u0013\u001a\u00060\u0011j\u0002`\u0012J&\u0010\u0014\u001a\u00020\u00152\n\u0010\u000f\u001a\u00060\u000bj\u0002`\f2\u0006\u0010\r\u001a\u00020\u000e2\n\u0010\u0013\u001a\u00060\u0011j\u0002`\u0012J&\u0010\u0016\u001a\u00020\u00152\n\u0010\u000f\u001a\u00060\u000bj\u0002`\f2\u0006\u0010\r\u001a\u00020\u000e2\n\u0010\u0013\u001a\u00060\u0011j\u0002`\u0012J\u0006\u0010\u0017\u001a\u00020\u0004J\u0015\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b\u001aJ\u0015\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b\u001cR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Ltigase/halcyon/core/xmpp/modules/omemo/OMEMOFileEncryptor;", "", "()V", "ALGORITHM_NAME", "", "CIPHER_NAME", "log", "Ltigase/halcyon/core/logger/Logger;", "rnd", "Ljava/security/SecureRandom;", "cipherInputStream", "Ljava/io/InputStream;", "Ltigase/halcyon/core/xmpp/modules/omemo/InputStream;", "keyAndIv", "", "input", "cipherOutputStream", "Ljava/io/OutputStream;", "Ltigase/halcyon/core/xmpp/modules/omemo/OutputStream;", "output", "decrypt", "", "encrypt", "generateIvAndKey", "getIv", "data", "getIv$halcyon_core", "getKey", "getKey$halcyon_core", "halcyon-core"})
public final class OMEMOFileEncryptor {
    @NotNull
    public static final OMEMOFileEncryptor INSTANCE = new OMEMOFileEncryptor();
    @NotNull
    private static final Logger log = LoggerFactory.logger$default(LoggerFactory.INSTANCE, "tigase.halcyon.core.xmpp.modules.omemo.OMEMOFileEncryptor", false, 2, null);
    @NotNull
    private static final String CIPHER_NAME = "AES/GCM/NoPadding";
    @NotNull
    private static final String ALGORITHM_NAME = "AES";
    @NotNull
    private static final SecureRandom rnd = new SecureRandom();

    private OMEMOFileEncryptor() {
    }

    @NotNull
    public final String generateIvAndKey() {
        byte[] byArray;
        byte[] $this$generateIvAndKey_u24lambda_u240 = byArray = new byte[44];
        boolean bl = false;
        rnd.nextBytes($this$generateIvAndKey_u24lambda_u240);
        return HexKt.getHexLower((byte[])byArray);
    }

    @NotNull
    public final byte[] getIv$halcyon_core(@NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        if (data.length > 32) {
            byte[] byArray = data;
            int n = 0;
            int n2 = data.length - 32;
            return ArraysKt.copyOfRange((byte[])byArray, (int)n, (int)n2);
        }
        throw new HalcyonException("Key is too short.");
    }

    @NotNull
    public final byte[] getKey$halcyon_core(@NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        if (data.length > 32) {
            byte[] byArray = data;
            int n = data.length - 32;
            int n2 = data.length;
            return ArraysKt.copyOfRange((byte[])byArray, (int)n, (int)n2);
        }
        throw new HalcyonException("Key is too short.");
    }

    @NotNull
    public final OutputStream cipherOutputStream(@NotNull byte[] keyAndIv, @NotNull OutputStream output) {
        Cipher cipher;
        Intrinsics.checkNotNullParameter((Object)keyAndIv, (String)"keyAndIv");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        byte[] iv = this.getIv$halcyon_core(keyAndIv);
        byte[] keyData = this.getKey$halcyon_core(keyAndIv);
        SecretKeySpec secretKey = new SecretKeySpec(keyData, ALGORITHM_NAME);
        Cipher $this$cipherOutputStream_u24lambda_u241 = cipher = Cipher.getInstance(CIPHER_NAME);
        boolean bl = false;
        $this$cipherOutputStream_u24lambda_u241.init(1, (Key)secretKey, new GCMParameterSpec(128, iv));
        Cipher cipher2 = cipher;
        return new CipherOutputStream(output, cipher2);
    }

    @NotNull
    public final InputStream cipherInputStream(@NotNull byte[] keyAndIv, @NotNull InputStream input) {
        Cipher cipher;
        Intrinsics.checkNotNullParameter((Object)keyAndIv, (String)"keyAndIv");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        byte[] iv = this.getIv$halcyon_core(keyAndIv);
        byte[] keyData = this.getKey$halcyon_core(keyAndIv);
        SecretKeySpec secretKey = new SecretKeySpec(keyData, ALGORITHM_NAME);
        Cipher $this$cipherInputStream_u24lambda_u242 = cipher = Cipher.getInstance(CIPHER_NAME);
        boolean bl = false;
        $this$cipherInputStream_u24lambda_u242.init(2, (Key)secretKey, new GCMParameterSpec(128, iv));
        Cipher cipher2 = cipher;
        return new CipherInputStream(input, cipher2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void encrypt(@NotNull InputStream input, @NotNull byte[] keyAndIv, @NotNull OutputStream output) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)keyAndIv, (String)"keyAndIv");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        Closeable closeable = this.cipherOutputStream(keyAndIv, output);
        Throwable throwable = null;
        try {
            OutputStream it = (OutputStream)closeable;
            boolean bl = false;
            long l = input.transferTo(it);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void decrypt(@NotNull InputStream input, @NotNull byte[] keyAndIv, @NotNull OutputStream output) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)keyAndIv, (String)"keyAndIv");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        Closeable closeable = this.cipherInputStream(keyAndIv, input);
        Throwable throwable = null;
        try {
            InputStream it = (InputStream)closeable;
            boolean bl = false;
            long l = it.transferTo(output);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }
}

