/*
 * Decompiled with CFR 0.152.
 */
package tigase.halcyon.core.requests;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.datetime.Clock;
import kotlinx.datetime.Instant;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tigase.halcyon.core.excutor.Executor;
import tigase.halcyon.core.logger.Logger;
import tigase.halcyon.core.logger.LoggerFactory;
import tigase.halcyon.core.requests.Request;
import tigase.halcyon.core.requests.RequestsManager;
import tigase.halcyon.core.utils.Lock;
import tigase.halcyon.core.xml.Element;
import tigase.halcyon.core.xmpp.BareJID;
import tigase.halcyon.core.xmpp.FullJID;
import tigase.halcyon.core.xmpp.StanzaKtKt;
import tigase.halcyon.core.xmpp.stanzas.Stanza;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\u0017H\u0002J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bJ\u0006\u0010\u001c\u001a\u00020\u0015J\u0018\u0010\u001d\u001a\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\u00122\u0006\u0010\u001a\u001a\u00020\u001bJ\u0006\u0010\u001e\u001a\u00020\u0011J\u0006\u0010\u001f\u001a\u00020 J\u0010\u0010!\u001a\u00020\u00112\u0006\u0010\"\u001a\u00020\u001bH\u0002J\u0016\u0010#\u001a\u00020\u00152\u000e\u0010$\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0012J\u0010\u0010%\u001a\u00020\u00152\b\b\u0002\u0010&\u001a\u00020'J \u0010(\u001a\u00020\u00192\u000e\u0010)\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00122\u0006\u0010\u001a\u001a\u00020\u001bH\u0002R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R:\u0010\u000f\u001a.\u0012\u0004\u0012\u00020\u0011\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00120\u0010j\u0016\u0012\u0004\u0012\u00020\u0011\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0012`\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Ltigase/halcyon/core/requests/RequestsManager;", "", "()V", "boundJID", "Ltigase/halcyon/core/xmpp/FullJID;", "getBoundJID", "()Ltigase/halcyon/core/xmpp/FullJID;", "setBoundJID", "(Ltigase/halcyon/core/xmpp/FullJID;)V", "executor", "Ltigase/halcyon/core/excutor/Executor;", "lock", "Ltigase/halcyon/core/utils/Lock;", "log", "Ltigase/halcyon/core/logger/Logger;", "requests", "Ljava/util/HashMap;", "", "Ltigase/halcyon/core/requests/Request;", "Lkotlin/collections/HashMap;", "execute", "", "runnable", "Lkotlin/Function0;", "findAndExecute", "", "response", "Ltigase/halcyon/core/xml/Element;", "findOutdated", "getRequest", "getRequestsIDs", "getWaitingRequestsSize", "", "key", "element", "register", "request", "timeoutAll", "maxCreationTimestamp", "Lkotlinx/datetime/Instant;", "verify", "entry", "halcyon-core"})
@SourceDebugExtension(value={"SMAP\nRequestsManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RequestsManager.kt\ntigase/halcyon/core/requests/RequestsManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,130:1\n1855#2,2:131\n1855#2,2:133\n*S KotlinDebug\n*F\n+ 1 RequestsManager.kt\ntigase/halcyon/core/requests/RequestsManager\n*L\n99#1:131,2\n117#1:133,2\n*E\n"})
public final class RequestsManager {
    @NotNull
    private final Logger log = LoggerFactory.logger$default(LoggerFactory.INSTANCE, "tigase.halcyon.core.requests.RequestsManager", false, 2, null);
    @NotNull
    private final Executor executor = new Executor();
    @NotNull
    private final HashMap<String, Request<?, ?>> requests = new HashMap();
    @NotNull
    private final Lock lock = new Lock();
    @Nullable
    private FullJID boundJID;

    public final void register(@NotNull Request<?, ?> request2) {
        Intrinsics.checkNotNullParameter(request2, (String)"request");
        if (Intrinsics.areEqual((Object)((Stanza)request2.getStanza()).getName(), (Object)"iq")) {
            this.lock.withLock((Function0)new Function0<Unit>(this, request2){
                final /* synthetic */ RequestsManager this$0;
                final /* synthetic */ Request<?, ?> $request;
                {
                    this.this$0 = $receiver;
                    this.$request = $request;
                    super(0);
                }

                public final void invoke() {
                    ((Map)RequestsManager.access$getRequests$p(this.this$0)).put(RequestsManager.access$key(this.this$0, (Element)this.$request.getStanza()), this.$request);
                }
            });
        }
    }

    @Nullable
    public final FullJID getBoundJID() {
        return this.boundJID;
    }

    public final void setBoundJID(@Nullable FullJID fullJID) {
        this.boundJID = fullJID;
    }

    private final String key(Element element2) {
        return element2.getName() + ":" + element2.getAttributes().get("id");
    }

    @Nullable
    public final Request<?, ?> getRequest(@NotNull Element response) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        String id = this.key(response);
        return (Request)this.lock.withLock((Function0)new Function0<Request<?, ?>>(this, id, response){
            final /* synthetic */ RequestsManager this$0;
            final /* synthetic */ String $id;
            final /* synthetic */ Element $response;
            {
                this.this$0 = $receiver;
                this.$id = $id;
                this.$response = $response;
                super(0);
            }

            @Nullable
            public final Request<?, ?> invoke() {
                Request request2 = (Request)RequestsManager.access$getRequests$p(this.this$0).get(this.$id);
                if (request2 == null) {
                    return null;
                }
                Request request3 = request2;
                if (RequestsManager.access$verify(this.this$0, request3, this.$response)) {
                    RequestsManager.access$getRequests$p(this.this$0).remove(this.$id);
                    return request3;
                }
                return null;
            }
        });
    }

    private final boolean verify(Request<?, ?> entry2, Element response) {
        BareJID bareBoundJID;
        FullJID jid = StanzaKtKt.getFromAttr(response);
        FullJID fullJID = this.boundJID;
        BareJID bareJID = bareBoundJID = fullJID != null ? fullJID.getBareJID() : null;
        if (Intrinsics.areEqual((Object)jid, (Object)entry2.getJid())) {
            return true;
        }
        if (entry2.getJid() == null && bareBoundJID != null) {
            FullJID fullJID2 = jid;
            if (Intrinsics.areEqual((Object)(fullJID2 != null ? fullJID2.getBareJID() : null), (Object)bareBoundJID)) {
                return true;
            }
        }
        return false;
    }

    public final boolean findAndExecute(@NotNull Element response) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Request<?, ?> request2 = this.getRequest(response);
        if (request2 == null) {
            return false;
        }
        Request<?, ?> r = request2;
        this.execute((Function0<Unit>)((Function0)new Function0<Unit>(r, response){
            final /* synthetic */ Request<?, ?> $r;
            final /* synthetic */ Element $response;
            {
                this.$r = $r;
                this.$response = $response;
                super(0);
            }

            public final void invoke() {
                Request.setResponseStanza$default(this.$r, this.$response, false, 2, null);
            }
        }));
        return true;
    }

    private final void execute(Function0<Unit> runnable) {
        this.executor.execute((Function0<Unit>)((Function0)new Function0<Unit>(runnable, this){
            final /* synthetic */ Function0<Unit> $runnable;
            final /* synthetic */ RequestsManager this$0;
            {
                this.$runnable = $runnable;
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                try {
                    this.$runnable.invoke();
                }
                catch (Throwable e) {
                    RequestsManager.access$getLog$p(this.this$0).warning(e, (Function0<? extends Object>)((Function0)execute.1.INSTANCE));
                }
            }
        }));
    }

    public final void timeoutAll(@NotNull Instant maxCreationTimestamp) {
        Intrinsics.checkNotNullParameter((Object)maxCreationTimestamp, (String)"maxCreationTimestamp");
        Logger.DefaultImpls.info$default(this.log, null, timeoutAll.1.INSTANCE, 1, null);
        List toTimeout2 = (List)this.lock.withLock((Function0)new Function0<List<? extends Pair<? extends String, ? extends Request<?, ?>>>>(this, maxCreationTimestamp){
            final /* synthetic */ RequestsManager this$0;
            final /* synthetic */ Instant $maxCreationTimestamp;
            {
                this.this$0 = $receiver;
                this.$maxCreationTimestamp = $maxCreationTimestamp;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<Pair<String, Request<?, ?>>> invoke() {
                void $this$mapTo$iv$iv;
                void $this$filterTo$iv$iv;
                void $this$filter$iv;
                Set<Map.Entry<K, V>> set = RequestsManager.access$getRequests$p(this.this$0).entrySet();
                Intrinsics.checkNotNullExpressionValue(set, (String)"<get-entries>(...)");
                Iterable iterable = set;
                Instant instant = this.$maxCreationTimestamp;
                boolean $i$f$filter22 = false;
                void var4_6 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    Map.Entry it = (Map.Entry)element$iv$iv;
                    boolean bl = false;
                    if (!(((Request)it.getValue()).getCreationTimestamp().compareTo(instant) < 0)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                Iterable $this$map$iv = (List)destination$iv$iv;
                boolean $i$f$map = false;
                Iterable $i$f$filter22 = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Object element$iv$iv;
                    element$iv$iv = (Map.Entry)item$iv$iv;
                    Collection collection = destination$iv$iv2;
                    boolean bl = false;
                    collection.add(new Pair(it.getKey(), it.getValue()));
                }
                return (List)destination$iv$iv2;
            }
        });
        Iterable $this$forEach$iv = toTimeout2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair pair = (Pair)element$iv;
            boolean bl = false;
            String key = (String)pair.component1();
            Request value = (Request)pair.component2();
            this.lock.withLock((Function0)new Function0<Request<?, ?>>(this, key){
                final /* synthetic */ RequestsManager this$0;
                final /* synthetic */ String $key;
                {
                    this.this$0 = $receiver;
                    this.$key = $key;
                    super(0);
                }

                @Nullable
                public final Request<?, ?> invoke() {
                    return (Request)RequestsManager.access$getRequests$p(this.this$0).remove(this.$key);
                }
            });
            if (value.isCompleted()) continue;
            this.execute((Function0<Unit>)((Function0)new Function0<Unit>(value){
                final /* synthetic */ Request<?, ?> $value;
                {
                    this.$value = $value;
                    super(0);
                }

                public final void invoke() {
                    Request<?, ?> request2 = this.$value;
                    Intrinsics.checkNotNullExpressionValue(request2, (String)"$value");
                    Request.markTimeout$halcyon_core$default(request2, false, 1, null);
                }
            }));
        }
    }

    public static /* synthetic */ void timeoutAll$default(RequestsManager requestsManager, Instant instant, int n, Object object) {
        if ((n & 1) != 0) {
            instant = Instant.Companion.getDISTANT_FUTURE();
        }
        requestsManager.timeoutAll(instant);
    }

    public final void findOutdated() {
        Instant now = Clock.System.INSTANCE.now();
        List toRemove2 = (List)this.lock.withLock((Function0)new Function0<List<? extends Pair<? extends String, ? extends Request<?, ?>>>>(this, now){
            final /* synthetic */ RequestsManager this$0;
            final /* synthetic */ Instant $now;
            {
                this.this$0 = $receiver;
                this.$now = $now;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<Pair<String, Request<?, ?>>> invoke() {
                void $this$mapTo$iv$iv;
                void $this$filterTo$iv$iv;
                void $this$filter$iv;
                Set<Map.Entry<K, V>> set = RequestsManager.access$getRequests$p(this.this$0).entrySet();
                Intrinsics.checkNotNullExpressionValue(set, (String)"<get-entries>(...)");
                Iterable iterable = set;
                Instant instant = this.$now;
                boolean $i$f$filter22 = false;
                void var4_6 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    Map.Entry it = (Map.Entry)element$iv$iv;
                    boolean bl = false;
                    if (!(((Request)it.getValue()).isCompleted() || ((Request)it.getValue()).getCreationTimestamp().plus-LRDsOJo(((Request)it.getValue()).getTimeoutDelay-UwyO8pc()).compareTo(instant) <= 0)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                Iterable $this$map$iv = (List)destination$iv$iv;
                boolean $i$f$map = false;
                Iterable $i$f$filter22 = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Object element$iv$iv;
                    element$iv$iv = (Map.Entry)item$iv$iv;
                    Collection collection = destination$iv$iv2;
                    boolean bl = false;
                    collection.add(new Pair(it.getKey(), it.getValue()));
                }
                return (List)destination$iv$iv2;
            }
        });
        Iterable $this$forEach$iv = toRemove2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair pair = (Pair)element$iv;
            boolean bl = false;
            String key = (String)pair.component1();
            Request request2 = (Request)pair.component2();
            this.lock.withLock((Function0)new Function0<Request<?, ?>>(this, key){
                final /* synthetic */ RequestsManager this$0;
                final /* synthetic */ String $key;
                {
                    this.this$0 = $receiver;
                    this.$key = $key;
                    super(0);
                }

                @Nullable
                public final Request<?, ?> invoke() {
                    return (Request)RequestsManager.access$getRequests$p(this.this$0).remove(this.$key);
                }
            });
            if (request2.getCreationTimestamp().plus-LRDsOJo(request2.getTimeoutDelay-UwyO8pc()).compareTo(now) > 0) continue;
            Intrinsics.checkNotNull((Object)request2);
            this.execute((Function0<Unit>)((Function0)new Function0<Unit>((Object)request2){

                public final void invoke() {
                    Request request2 = (Request)this.receiver;
                    Intrinsics.checkNotNull((Object)request2);
                    Request.markTimeout$halcyon_core$default(request2, false, 1, null);
                }
            }));
        }
    }

    public final int getWaitingRequestsSize() {
        return ((Number)this.lock.withLock((Function0)new Function0<Integer>(this){
            final /* synthetic */ RequestsManager this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Integer invoke() {
                return RequestsManager.access$getRequests$p(this.this$0).size();
            }
        })).intValue();
    }

    @NotNull
    public final String getRequestsIDs() {
        return (String)this.lock.withLock((Function0)new Function0<String>(this){
            final /* synthetic */ RequestsManager this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final String invoke() {
                void $this$mapTo$iv$iv;
                Collection<V> collection = RequestsManager.access$getRequests$p(this.this$0).values();
                Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
                Iterable $this$map$iv = collection;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Request request2 = (Request)item$iv$iv;
                    Collection collection2 = destination$iv$iv;
                    boolean bl = false;
                    collection2.add(it.getId());
                }
                return CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), null, null, null, (int)0, null, (Function1)getRequestsIDs.2.INSTANCE, (int)31, null);
            }
        });
    }

    public static final /* synthetic */ HashMap access$getRequests$p(RequestsManager $this) {
        return $this.requests;
    }

    public static final /* synthetic */ String access$key(RequestsManager $this, Element element2) {
        return $this.key(element2);
    }

    public static final /* synthetic */ boolean access$verify(RequestsManager $this, Request entry2, Element response) {
        return $this.verify(entry2, response);
    }

    public static final /* synthetic */ Logger access$getLog$p(RequestsManager $this) {
        return $this.log;
    }
}

