/*
 * Decompiled with CFR 0.152.
 */
package tigase.halcyon.core.xmpp.modules.omemo;

import java.nio.charset.Charset;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import korlibs.crypto.encoding.HexKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.whispersystems.curve25519.NoSuchProviderException;
import org.whispersystems.libsignal.DuplicateMessageException;
import org.whispersystems.libsignal.InvalidKeyIdException;
import org.whispersystems.libsignal.InvalidMessageException;
import org.whispersystems.libsignal.InvalidVersionException;
import org.whispersystems.libsignal.LegacyMessageException;
import org.whispersystems.libsignal.NoSessionException;
import org.whispersystems.libsignal.SessionCipher;
import org.whispersystems.libsignal.SignalProtocolAddress;
import org.whispersystems.libsignal.UntrustedIdentityException;
import org.whispersystems.libsignal.protocol.CiphertextMessage;
import org.whispersystems.libsignal.protocol.PreKeySignalMessage;
import org.whispersystems.libsignal.protocol.SignalMessage;
import org.whispersystems.libsignal.state.SignalProtocolStore;
import tigase.halcyon.core.Base64Kt;
import tigase.halcyon.core.exceptions.HalcyonException;
import tigase.halcyon.core.logger.Logger;
import tigase.halcyon.core.logger.LoggerFactory;
import tigase.halcyon.core.xml.BuilderKt;
import tigase.halcyon.core.xml.Element;
import tigase.halcyon.core.xml.ElementNode;
import tigase.halcyon.core.xmpp.JIDKt;
import tigase.halcyon.core.xmpp.modules.mix.MIXModuleKt;
import tigase.halcyon.core.xmpp.modules.omemo.OMEMOEncryptorKt;
import tigase.halcyon.core.xmpp.modules.omemo.OMEMOErrorCondition;
import tigase.halcyon.core.xmpp.modules.omemo.OMEMOException;
import tigase.halcyon.core.xmpp.modules.omemo.OMEMOMessage;
import tigase.halcyon.core.xmpp.modules.omemo.OMEMOSession;
import tigase.halcyon.core.xmpp.stanzas.Message;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001/B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J2\u0010\f\u001a\u0004\u0018\u00010\r2\n\u0010\u000e\u001a\u00060\u000fj\u0002`\u00102\n\u0010\u0011\u001a\u00060\u0012j\u0002`\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J \u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\rH\u0002J:\u0010\u001e\u001a\u00020\u001f2\n\u0010\u0011\u001a\u00060\u0012j\u0002`\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010 \u001a\u00020!2\u0016\u0010\"\u001a\u0012\u0012\b\u0012\u00060\u000fj\u0002`\u0010\u0012\u0004\u0012\u00020$0#J\u0018\u0010%\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010&\u001a\u0004\u0018\u00010\u0004J\u0016\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00170(2\u0006\u0010)\u001a\u00020\u0017H\u0002J\u0006\u0010*\u001a\u00020\rJ\u0006\u0010+\u001a\u00020\rJP\u0010,\u001a\u0004\u0018\u00010-2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00170(2\n\u0010\u000e\u001a\u00060\u000fj\u0002`\u00102\n\u0010\u0011\u001a\u00060\u0012j\u0002`\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0016\u0010\"\u001a\u0012\u0012\b\u0012\u00060\u000fj\u0002`\u0010\u0012\u0004\u0012\u00020$0#H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Ltigase/halcyon/core/xmpp/modules/omemo/OMEMOEncryptor;", "", "()V", "ALGORITHM_NAME", "", "CIPHER_NAME", "KEY_SIZE", "", "log", "Ltigase/halcyon/core/logger/Logger;", "rnd", "Ljava/security/SecureRandom;", "checkPotentialKey", "", "senderAddr", "Lorg/whispersystems/libsignal/SignalProtocolAddress;", "Ltigase/halcyon/core/xmpp/modules/omemo/SignalProtocolAddress;", "store", "Lorg/whispersystems/libsignal/state/SignalProtocolStore;", "Ltigase/halcyon/core/xmpp/modules/omemo/SignalProtocolStore;", "session", "Ltigase/halcyon/core/xmpp/modules/omemo/OMEMOSession;", "keyElement", "Ltigase/halcyon/core/xml/Element;", "cipherInstance", "Ljavax/crypto/Cipher;", "mode", "secretKey", "Ljavax/crypto/spec/SecretKeySpec;", "iv", "decrypt", "Ltigase/halcyon/core/xmpp/modules/omemo/OMEMOMessage;", "stanza", "Ltigase/halcyon/core/xmpp/stanzas/Message;", "healSession", "Lkotlin/Function1;", "", "encrypt", "plaintext", "findKeyElements", "", "encElement", "generateIV", "generateKey", "retrieveKey", "Ltigase/halcyon/core/xmpp/modules/omemo/OMEMOEncryptor$DecryptedKey;", "keyElements", "DecryptedKey", "halcyon-core"})
@SourceDebugExtension(value={"SMAP\nOMEMOEncryptor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OMEMOEncryptor.kt\ntigase/halcyon/core/xmpp/modules/omemo/OMEMOEncryptor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,287:1\n766#2:288\n857#2,2:289\n1855#2,2:291\n*S KotlinDebug\n*F\n+ 1 OMEMOEncryptor.kt\ntigase/halcyon/core/xmpp/modules/omemo/OMEMOEncryptor\n*L\n118#1:288\n118#1:289,2\n215#1:291,2\n*E\n"})
public final class OMEMOEncryptor {
    @NotNull
    public static final OMEMOEncryptor INSTANCE = new OMEMOEncryptor();
    @NotNull
    private static final Logger log = LoggerFactory.logger$default(LoggerFactory.INSTANCE, "tigase.halcyon.core.xmpp.modules.omemo.OMEMOEncryptor", false, 2, null);
    @NotNull
    private static final String CIPHER_NAME = "AES/GCM/NoPadding";
    @NotNull
    private static final String ALGORITHM_NAME = "AES";
    private static final int KEY_SIZE = 128;
    @NotNull
    private static final SecureRandom rnd = new SecureRandom();

    private OMEMOEncryptor() {
    }

    @NotNull
    public final byte[] generateKey() throws NoSuchAlgorithmException {
        KeyGenerator generator2 = KeyGenerator.getInstance(ALGORITHM_NAME);
        generator2.init(128);
        byte[] byArray = generator2.generateKey().getEncoded();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getEncoded(...)");
        return byArray;
    }

    @NotNull
    public final byte[] generateIV() {
        byte[] iv = new byte[12];
        rnd.nextBytes(iv);
        return iv;
    }

    private final Cipher cipherInstance(int mode, SecretKeySpec secretKey, byte[] iv) throws NoSuchPaddingException, NoSuchAlgorithmException, NoSuchProviderException, InvalidAlgorithmParameterException, InvalidKeyException {
        Cipher cipher = Cipher.getInstance(CIPHER_NAME);
        AlgorithmParameterSpec ivSpec = new GCMParameterSpec(128, iv);
        cipher.init(mode, (Key)secretKey, ivSpec);
        Intrinsics.checkNotNull((Object)cipher);
        return cipher;
    }

    private final byte[] checkPotentialKey(SignalProtocolAddress senderAddr, SignalProtocolStore store2, OMEMOSession session2, Element keyElement) {
        try {
            Object object;
            boolean preKey;
            block14: {
                block13: {
                    String string = keyElement.getAttributes().get("rid");
                    if (!(string != null ? Integer.parseInt(string) == session2.getLocalRegistrationId() : false)) {
                        return null;
                    }
                    Object[] objectArray = new String[]{"1", "true"};
                    preKey = CollectionsKt.contains((Iterable)CollectionsKt.listOf((Object[])objectArray), (Object)keyElement.getAttributes().get("prekey"));
                    object = keyElement.getValue();
                    if (object == null) break block13;
                    byte[] byArray = Base64Kt.fromBase64((CharSequence)object);
                    object = byArray;
                    if (byArray != null) break block14;
                }
                throw new HalcyonException("Cannot decode key");
            }
            Object encryptedKey = object;
            SessionCipher sessionCipher = session2.getCiphers().get(senderAddr);
            if (sessionCipher == null) {
                OMEMOEncryptor it = this;
                boolean bl = false;
                sessionCipher = new SessionCipher(store2, senderAddr);
            }
            SessionCipher sessionCipher2 = sessionCipher;
            byte[] key = preKey ? sessionCipher2.decrypt(new PreKeySignalMessage((byte[])encryptedKey)) : sessionCipher2.decrypt(new SignalMessage((byte[])encryptedKey));
            session2.getCiphers().put(senderAddr, sessionCipher2);
            return key;
        }
        catch (InvalidVersionException e) {
            return null;
        }
        catch (InvalidKeyException e) {
            return null;
        }
        catch (LegacyMessageException e) {
            return null;
        }
        catch (InvalidMessageException e) {
            return null;
        }
        catch (DuplicateMessageException e) {
            return null;
        }
        catch (InvalidKeyIdException e) {
            return null;
        }
        catch (UntrustedIdentityException e) {
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final DecryptedKey retrieveKey(List<? extends Element> keyElements, SignalProtocolAddress senderAddr, SignalProtocolStore store2, OMEMOSession session2, Function1<? super SignalProtocolAddress, Unit> healSession2) {
        Object[] it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = keyElements;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Element it2 = (Element)element$iv$iv;
            boolean bl = false;
            String string = it2.getAttributes().get("rid");
            boolean bl2 = string != null ? Integer.parseInt(string) == session2.getLocalRegistrationId() : false;
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterator iterator = ((List)destination$iv$iv).iterator();
        SessionCipher sessionCipher = session2.getCiphers().get(senderAddr);
        if (sessionCipher == null) {
            it = this;
            boolean bl = false;
            sessionCipher = new SessionCipher(store2, senderAddr);
        }
        SessionCipher sessionCipher2 = sessionCipher;
        while (iterator.hasNext()) {
            Element keyElement = (Element)iterator.next();
            it = new String[]{"1", "true"};
            boolean preKey = CollectionsKt.contains((Iterable)CollectionsKt.listOf((Object[])it), (Object)keyElement.getAttributes().get("prekey"));
            Object object = keyElement.getValue();
            if (object == null) continue;
            byte[] byArray = Base64Kt.fromBase64((CharSequence)object);
            object = byArray;
            if (byArray == null) {
                continue;
            }
            Object encryptedKey = object;
            if (preKey) {
                PreKeySignalMessage msg2 = new PreKeySignalMessage((byte[])encryptedKey);
                try {
                    byte[] byArray2 = sessionCipher2.decrypt(msg2);
                    Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"decrypt(...)");
                    return new DecryptedKey(byArray2, true);
                }
                catch (Exception e) {
                    log.fine(e, (Function0<? extends Object>)((Function0)new Function0<Object>(keyElement, senderAddr){
                        final /* synthetic */ Element $keyElement;
                        final /* synthetic */ SignalProtocolAddress $senderAddr;
                        {
                            this.$keyElement = $keyElement;
                            this.$senderAddr = $senderAddr;
                            super(0);
                        }

                        @Nullable
                        public final Object invoke() {
                            return "failed to decrypt prekey " + this.$keyElement.getAttributes().get("rid") + " from " + this.$senderAddr;
                        }
                    }));
                    if (iterator.hasNext()) continue;
                    throw e;
                }
            }
            SignalMessage msg3 = new SignalMessage((byte[])encryptedKey);
            try {
                byte[] byArray3 = sessionCipher2.decrypt(msg3);
                Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"decrypt(...)");
                return new DecryptedKey(byArray3, false);
            }
            catch (Exception e) {
                log.fine(e, (Function0<? extends Object>)((Function0)new Function0<Object>(keyElement, senderAddr){
                    final /* synthetic */ Element $keyElement;
                    final /* synthetic */ SignalProtocolAddress $senderAddr;
                    {
                        this.$keyElement = $keyElement;
                        this.$senderAddr = $senderAddr;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return "failed to decrypt key " + this.$keyElement.getAttributes().get("rid") + " from " + this.$senderAddr;
                    }
                }));
                if (e instanceof InvalidMessageException || e instanceof NoSessionException || e instanceof InvalidKeyIdException) {
                    healSession2.invoke((Object)senderAddr);
                }
                if (iterator.hasNext()) continue;
                throw e;
            }
        }
        return null;
    }

    private final List<Element> findKeyElements(Element encElement) {
        Object object = encElement.getFirstChild("header");
        if (object == null || (object = object.getChildren("key")) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public final OMEMOMessage decrypt(@NotNull SignalProtocolStore store, @NotNull OMEMOSession session, @NotNull Message stanza, @NotNull Function1<? super SignalProtocolAddress, Unit> healSession) {
        Intrinsics.checkNotNullParameter((Object)store, (String)"store");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)stanza, (String)"stanza");
        Intrinsics.checkNotNullParameter(healSession, (String)"healSession");
        hasCipherText = false;
        try {
            block19: {
                block18: {
                    myAddr = new SignalProtocolAddress(session.getLocalJid().toString(), session.getLocalRegistrationId());
                    v0 = stanza.getChildrenNS("encrypted", "eu.siacs.conversations.axolotl");
                    if (v0 == null) {
                        throw new OMEMOException.NoEncryptedElement(null, 1, null);
                    }
                    encElement = v0;
                    v1 = encElement.getFirstChild("payload");
                    if (v1 == null || (v1 = v1.getValue()) == null) ** GOTO lbl-1000
                    v2 = Base64Kt.fromBase64((CharSequence)v1);
                    v1 = v2;
                    if (v2 != null) {
                        it = var12_10 = v1;
                        $i$a$-also-OMEMOEncryptor$decrypt$ciphertext$1 = false;
                        hasCipherText = true;
                        v3 = var12_10;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v3 = ciphertext = null;
                    }
                    if ((v4 = encElement.getFirstChild("header")) == null || (v4 = v4.getAttributes()) == null || (v4 = (String)v4.get("sid")) == null) {
                        throw new OMEMOException.NoSidAttribute(null, 1, null);
                    }
                    senderId = Integer.parseInt((String)v4);
                    v5 = MIXModuleKt.getMixAnnotation(stanza);
                    if (v5 == null || (v5 = v5.getJid()) == null) {
                        v6 = stanza.getAttributes().get("from");
                        Intrinsics.checkNotNull((Object)v6);
                        v5 = JIDKt.toBareJID(v6);
                    }
                    senderAddr = new SignalProtocolAddress(v5.toString(), senderId);
                    v7 = encElement.getFirstChild("header");
                    if (v7 == null || (v7 = v7.getFirstChild("iv")) == null || (v7 = v7.getValue()) == null) break block18;
                    v8 = Base64Kt.fromBase64((CharSequence)v7);
                    v7 = v8;
                    if (v8 != null) break block19;
                }
                throw new OMEMOException.NoIV(null, 1, null);
            }
            iv = v7;
            v9 = this.retrieveKey(this.findKeyElements(encElement), senderAddr, store, session, healSession);
            if (v9 == null) {
                throw new OMEMOException.DeviceKeyNotFoundException(null, 1, null);
            }
            decryptedKey = v9;
            v10 = ciphertext;
            if (v10 != null) {
                ciphertext = v10;
                $i$a$-let-OMEMOEncryptor$decrypt$1 = false;
                key = decryptedKey.getKey();
                if (key.length < 32) {
                    throw new OMEMOException.InvalidKeyLengthException(null, 1, null);
                }
                authtaglength = key.length - 16;
                newCipherText = new byte[key.length - 16 + ((Object)ciphertext).length];
                newKey = new byte[16];
                System.arraycopy(ciphertext, 0, newCipherText, 0, ((Object)ciphertext).length);
                System.arraycopy(key, 16, newCipherText, ((Object)ciphertext).length, authtaglength);
                System.arraycopy(key, 0, newKey, 0, newKey.length);
                keySpec = new SecretKeySpec(newKey, "AES");
                cipher = OMEMOEncryptor.INSTANCE.cipherInstance(2, keySpec, (byte[])iv);
                plain = cipher.doFinal(newCipherText);
                Intrinsics.checkNotNull((Object)plain);
                var23_32 = plain;
                v11 = Charset.defaultCharset();
                Intrinsics.checkNotNullExpressionValue((Object)v11, (String)"defaultCharset(...)");
                var24_33 = v11;
                decryptedBody = new String(var23_32, var24_33);
                OMEMOEncryptorKt.access$replaceBody(stanza, decryptedBody);
            }
            v12 = stanza;
            v13 = store.getIdentity(senderAddr).getPublicKey().serialize();
            Intrinsics.checkNotNullExpressionValue((Object)v13, (String)"serialize(...)");
            return new OMEMOMessage.Decrypted(v12, senderAddr, HexKt.getHex((byte[])v13), decryptedKey.isPreKey());
        }
        catch (Throwable e) {
            OMEMOEncryptor.log.warning(e, (Function0<? extends Object>)((Function0)new Function0<Object>(stanza){
                final /* synthetic */ Message $stanza;
                {
                    this.$stanza = $stanza;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "Cannot decrypt message: " + this.$stanza.getAsString();
                }
            }));
            ciphertext = e;
            v14 = ciphertext instanceof OMEMOException != false ? ((OMEMOException)e).getCondition() : (condition = ciphertext instanceof DuplicateMessageException != false ? OMEMOErrorCondition.DuplicateMessage : OMEMOErrorCondition.CannotDecrypt);
            if (condition == OMEMOErrorCondition.DuplicateMessage) {
                $this$forEach$iv = stanza.getChildren("body");
                $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    it = (Element)element$iv;
                    $i$a$-forEach-OMEMOEncryptor$decrypt$3 = false;
                    stanza.remove(it);
                }
            } else if (hasCipherText) {
                OMEMOEncryptorKt.access$replaceBody(stanza, condition.message());
            }
            return new OMEMOMessage.Error((Element)stanza, condition);
        }
    }

    @NotNull
    public final Element encrypt(@NotNull OMEMOSession session2, @Nullable String plaintext) {
        Pair pair;
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        byte[] iv = this.generateIV();
        byte[] keyData = this.generateKey();
        SecretKeySpec secretKey = new SecretKeySpec(keyData, ALGORITHM_NAME);
        String string = plaintext;
        if (string != null) {
            String it = string;
            boolean bl = false;
            Cipher cipher = INSTANCE.cipherInstance(1, secretKey, iv);
            byte[] byArray = plaintext.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            byte[] ciphertext = cipher.doFinal(byArray);
            byte[] authtagPlusInnerKey = new byte[32];
            byte[] encData = new byte[ciphertext.length - 16];
            System.arraycopy(ciphertext, 0, encData, 0, encData.length);
            System.arraycopy(ciphertext, encData.length, authtagPlusInnerKey, 16, 16);
            System.arraycopy(keyData, 0, authtagPlusInnerKey, 0, keyData.length);
            pair = new Pair((Object)encData, (Object)authtagPlusInnerKey);
        } else {
            OMEMOEncryptor $this$encrypt_u24lambda_u247 = this;
            boolean bl = false;
            pair = new Pair(null, (Object)keyData);
        }
        Pair pair2 = pair;
        byte[] payload2 = (byte[])pair2.component1();
        byte[] combinedKey = (byte[])pair2.component2();
        return BuilderKt.element("encrypted", (Function1<? super ElementNode, Unit>)((Function1)new Function1<ElementNode, Unit>(payload2, session2, iv, combinedKey){
            final /* synthetic */ byte[] $payload;
            final /* synthetic */ OMEMOSession $session;
            final /* synthetic */ byte[] $iv;
            final /* synthetic */ byte[] $combinedKey;
            {
                this.$payload = $payload;
                this.$session = $session;
                this.$iv = $iv;
                this.$combinedKey = $combinedKey;
                super(1);
            }

            public final void invoke(@NotNull ElementNode $this$element) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)$this$element, (String)"$this$element");
                    $this$element.setXmlns("eu.siacs.conversations.axolotl");
                    ElementNode.invoke$default($this$element, "header", null, (Function1)new Function1<ElementNode, Unit>(this.$session, this.$iv, this.$combinedKey){
                        final /* synthetic */ OMEMOSession $session;
                        final /* synthetic */ byte[] $iv;
                        final /* synthetic */ byte[] $combinedKey;
                        {
                            this.$session = $session;
                            this.$iv = $iv;
                            this.$combinedKey = $combinedKey;
                            super(1);
                        }

                        /*
                         * WARNING - void declaration
                         */
                        public final void invoke(@NotNull ElementNode $this$invoke) {
                            void $this$mapTo$iv$iv;
                            void $this$map$iv;
                            Intrinsics.checkNotNullParameter((Object)$this$invoke, (String)"$this$invoke");
                            $this$invoke.getAttributes().set("sid", String.valueOf(this.$session.getLocalRegistrationId()));
                            ElementNode.invoke$default($this$invoke, "iv", null, (Function1)new Function1<ElementNode, Unit>(this.$iv){
                                final /* synthetic */ byte[] $iv;
                                {
                                    this.$iv = $iv;
                                    super(1);
                                }

                                public final void invoke(@NotNull ElementNode $this$invoke) {
                                    Intrinsics.checkNotNullParameter((Object)$this$invoke, (String)"$this$invoke");
                                    $this$invoke.unaryPlus(Base64Kt.toBase64(this.$iv));
                                }
                            }, 1, null);
                            Map<SignalProtocolAddress, SessionCipher> map = this.$session.getCiphers();
                            byte[] byArray = this.$combinedKey;
                            boolean $i$f$map = false;
                            void var5_7 = $this$map$iv;
                            Collection destination$iv$iv = new ArrayList<E>($this$map$iv.size());
                            boolean $i$f$mapTo = false;
                            Iterator<Map.Entry<K, V>> iterator = $this$mapTo$iv$iv.entrySet().iterator();
                            while (iterator.hasNext()) {
                                Pair pair;
                                Map.Entry<K, V> item$iv$iv;
                                Map.Entry<K, V> entry2 = item$iv$iv = iterator.next();
                                Collection collection = destination$iv$iv;
                                boolean bl = false;
                                SignalProtocolAddress addr = (SignalProtocolAddress)entry2.getKey();
                                SessionCipher sessionCipher = (SessionCipher)entry2.getValue();
                                try {
                                    pair = new Pair((Object)addr, (Object)sessionCipher.encrypt(byArray));
                                }
                                catch (Throwable e) {
                                    Logger.DefaultImpls.warning$default(OMEMOEncryptor.access$getLog$p(), null, (Function0)new Function0<Object>(addr, e){
                                        final /* synthetic */ SignalProtocolAddress $addr;
                                        final /* synthetic */ Throwable $e;
                                        {
                                            this.$addr = $addr;
                                            this.$e = $e;
                                            super(0);
                                        }

                                        @Nullable
                                        public final Object invoke() {
                                            return "failed to encrypt message for " + this.$addr + ", " + this.$e.getLocalizedMessage();
                                        }
                                    }, 1, null);
                                    pair = null;
                                }
                                collection.add(pair);
                            }
                            Iterable $this$forEach$iv = CollectionsKt.filterNotNull((Iterable)((List)destination$iv$iv));
                            boolean $i$f$forEach = false;
                            for (T element$iv : $this$forEach$iv) {
                                Pair pair = (Pair)element$iv;
                                boolean bl = false;
                                SignalProtocolAddress addr = (SignalProtocolAddress)pair.component1();
                                CiphertextMessage m = (CiphertextMessage)pair.component2();
                                ElementNode.invoke$default($this$invoke, "key", null, (Function1)new Function1<ElementNode, Unit>(addr, m){
                                    final /* synthetic */ SignalProtocolAddress $addr;
                                    final /* synthetic */ CiphertextMessage $m;
                                    {
                                        this.$addr = $addr;
                                        this.$m = $m;
                                        super(1);
                                    }

                                    public final void invoke(@NotNull ElementNode $this$invoke) {
                                        Intrinsics.checkNotNullParameter((Object)$this$invoke, (String)"$this$invoke");
                                        $this$invoke.getAttributes().set("rid", String.valueOf(this.$addr.getDeviceId()));
                                        if (this.$m.getType() == 3) {
                                            $this$invoke.getAttributes().set("prekey", "true");
                                        }
                                        byte[] byArray = this.$m.serialize();
                                        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"serialize(...)");
                                        $this$invoke.unaryPlus(Base64Kt.toBase64(byArray));
                                    }
                                }, 1, null);
                            }
                        }
                    }, 1, null);
                    if (this.$payload == null) break block0;
                    byte[] payload2 = this.$payload;
                    boolean bl = false;
                    ElementNode.invoke$default($this$element, "payload", null, (Function1)new Function1<ElementNode, Unit>(payload2){
                        final /* synthetic */ byte[] $payload;
                        {
                            this.$payload = $payload;
                            super(1);
                        }

                        public final void invoke(@NotNull ElementNode $this$invoke) {
                            Intrinsics.checkNotNullParameter((Object)$this$invoke, (String)"$this$invoke");
                            $this$invoke.unaryPlus(Base64Kt.toBase64(this.$payload));
                        }
                    }, 1, null);
                }
            }
        }));
    }

    public static final /* synthetic */ Logger access$getLog$p() {
        return log;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u00052\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0013"}, d2={"Ltigase/halcyon/core/xmpp/modules/omemo/OMEMOEncryptor$DecryptedKey;", "", "key", "", "isPreKey", "", "([BZ)V", "()Z", "getKey", "()[B", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "", "halcyon-core"})
    public static final class DecryptedKey {
        @NotNull
        private final byte[] key;
        private final boolean isPreKey;

        public DecryptedKey(@NotNull byte[] key, boolean isPreKey) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            this.key = key;
            this.isPreKey = isPreKey;
        }

        @NotNull
        public final byte[] getKey() {
            return this.key;
        }

        public final boolean isPreKey() {
            return this.isPreKey;
        }

        @NotNull
        public final byte[] component1() {
            return this.key;
        }

        public final boolean component2() {
            return this.isPreKey;
        }

        @NotNull
        public final DecryptedKey copy(@NotNull byte[] key, boolean isPreKey) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            return new DecryptedKey(key, isPreKey);
        }

        public static /* synthetic */ DecryptedKey copy$default(DecryptedKey decryptedKey, byte[] byArray, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                byArray = decryptedKey.key;
            }
            if ((n & 2) != 0) {
                bl = decryptedKey.isPreKey;
            }
            return decryptedKey.copy(byArray, bl);
        }

        @NotNull
        public String toString() {
            return "DecryptedKey(key=" + Arrays.toString(this.key) + ", isPreKey=" + this.isPreKey + ")";
        }

        public int hashCode() {
            int result2 = Arrays.hashCode(this.key);
            result2 = result2 * 31 + Boolean.hashCode(this.isPreKey);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DecryptedKey)) {
                return false;
            }
            DecryptedKey decryptedKey = (DecryptedKey)other;
            if (!Intrinsics.areEqual((Object)this.key, (Object)decryptedKey.key)) {
                return false;
            }
            return this.isPreKey == decryptedKey.isPreKey;
        }
    }
}

