/*
 * Decompiled with CFR 0.152.
 */
package tigase.halcyon.core;

import java.util.Timer;
import java.util.TimerTask;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tigase.halcyon.core.AbstractHalcyon;
import tigase.halcyon.core.Halcyon;
import tigase.halcyon.core.HalcyonStateChangeEvent;
import tigase.halcyon.core.builder.ConfigurationBuilder;
import tigase.halcyon.core.configuration.ConnectionConfig;
import tigase.halcyon.core.connector.AbstractConnector;
import tigase.halcyon.core.connector.socket.SocketConnector;
import tigase.halcyon.core.connector.socket.SocketConnectorConfig;
import tigase.halcyon.core.connector.socket.TLSProcessorFactory;
import tigase.halcyon.core.eventbus.Event;
import tigase.halcyon.core.eventbus.EventBus;
import tigase.halcyon.core.eventbus.EventBusInterface;
import tigase.halcyon.core.eventbus.EventDefinition;
import tigase.halcyon.core.eventbus.EventHandler;
import tigase.halcyon.core.exceptions.AuthenticationException;
import tigase.halcyon.core.exceptions.HalcyonException;
import tigase.halcyon.core.logger.Logger;
import tigase.halcyon.core.logger.LoggerFactory;
import tigase.halcyon.core.xmpp.modules.auth.SASLEvent;
import tigase.halcyon.core.xmpp.modules.auth.SASLModule;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u000b\u001a\u00020\fJ\b\u0010\r\u001a\u00020\u000eH\u0014J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0006\u0010\u0012\u001a\u00020\fR\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Ltigase/halcyon/core/Halcyon;", "Ltigase/halcyon/core/AbstractHalcyon;", "configuration", "Ltigase/halcyon/core/builder/ConfigurationBuilder;", "(Ltigase/halcyon/core/builder/ConfigurationBuilder;)V", "connectionTimer", "Ljava/util/Timer;", "lock", "Ljava/lang/Object;", "log", "Ltigase/halcyon/core/logger/Logger;", "connectAndWait", "", "createConnector", "Ltigase/halcyon/core/connector/AbstractConnector;", "reconnect", "immediately", "", "waitForAllResponses", "halcyon-core"})
@SourceDebugExtension(value={"SMAP\nHalcyon.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Halcyon.kt\ntigase/halcyon/core/Halcyon\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,125:1\n1#2:126\n*E\n"})
public final class Halcyon
extends AbstractHalcyon {
    @NotNull
    private final Logger log;
    @Nullable
    private Timer connectionTimer;
    @NotNull
    private final Object lock;

    public Halcyon(@NotNull ConfigurationBuilder configuration) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        super(configuration);
        this.log = LoggerFactory.logger$default(LoggerFactory.INSTANCE, "tigase.halcyon.core.Halcyon", false, 2, null);
        this.lock = new Object();
        this.getEventBus().setMode(EventBus.Mode.ThreadPerHandler);
        this.getEventBus().register((EventDefinition)HalcyonStateChangeEvent.Companion, (Function1)new Function1<HalcyonStateChangeEvent, Unit>(){

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull HalcyonStateChangeEvent it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (it.getNewState() == AbstractHalcyon.State.Connecting) {
                    void it2;
                    Timer timer = connectionTimer;
                    if (timer != null) {
                        timer.cancel();
                    }
                    Timer timer2 = new Timer();
                    Halcyon halcyon = this;
                    Timer timer3 = timer2;
                    Halcyon halcyon2 = this;
                    boolean bl = false;
                    it2.schedule(new TimerTask(halcyon){
                        final /* synthetic */ Halcyon this$0;
                        {
                            this.this$0 = halcyon;
                        }

                        public void run() {
                            TimerTask $this$invoke_u24lambda_u241_u24lambda_u240 = this;
                            boolean bl = false;
                            if (this.this$0.getState() == AbstractHalcyon.State.Connecting) {
                                Logger.DefaultImpls.warning$default(Halcyon.access$getLog$p(this.this$0), null, 1.1.1.INSTANCE, 1, null);
                                this.this$0.disconnect();
                            }
                        }
                    }, Duration.toLong-impl((long)DurationKt.toDuration((int)120, (DurationUnit)DurationUnit.SECONDS), (DurationUnit)DurationUnit.MILLISECONDS));
                    halcyon2.connectionTimer = timer2;
                } else {
                    Timer timer = connectionTimer;
                    if (timer != null) {
                        timer.cancel();
                    }
                    connectionTimer = null;
                }
            }
        });
    }

    @Override
    @NotNull
    protected AbstractConnector createConnector() {
        ConnectionConfig connectionConfig = this.getConfig().getConnection();
        Intrinsics.checkNotNull((Object)connectionConfig, (String)"null cannot be cast to non-null type tigase.halcyon.core.connector.socket.SocketConnectorConfig");
        TLSProcessorFactory tlsProcessorFactory = ((SocketConnectorConfig)connectionConfig).getTlsProcessorFactory();
        this.log.fine("Selected TLS Processor: " + tlsProcessorFactory.getNAME());
        return new SocketConnector(this, tlsProcessorFactory);
    }

    @Override
    public void reconnect(boolean immediately) {
        if (!this.getRunning()) {
            Logger.DefaultImpls.fine$default(this.log, null, (Function0)new Function0<Object>(immediately){
                final /* synthetic */ boolean $immediately;
                {
                    this.$immediately = $immediately;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "Called reconnect. immediately=" + this.$immediately + ", skipping reconnection as running is false!";
                }
            }, 1, null);
        } else {
            Logger.DefaultImpls.fine$default(this.log, null, (Function0)new Function0<Object>(immediately){
                final /* synthetic */ boolean $immediately;
                {
                    this.$immediately = $immediately;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "Called reconnect. immediately=" + this.$immediately;
                }
            }, 1, null);
            try {
                if (!immediately) {
                    Thread.sleep(3000L);
                }
                this.setState$halcyon_core(AbstractHalcyon.State.Connecting);
                this.startConnector();
            }
            catch (HalcyonException ex) {
                this.log.fine(ex, (Function0<? extends Object>)((Function0)reconnect.3.INSTANCE));
                this.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void waitForAllResponses() {
        while (this.getRequestsManager().getWaitingRequestsSize() > 0) {
            Object object = this.lock;
            synchronized (object) {
                boolean bl = false;
                this.lock.wait(100L);
                Unit unit = Unit.INSTANCE;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void connectAndWait() {
        Ref.ObjectRef exceptionToThrow = new Ref.ObjectRef();
        EventHandler<Event> handler2 = new EventHandler<Event>((Ref.ObjectRef<Throwable>)exceptionToThrow, this){
            final /* synthetic */ Ref.ObjectRef<Throwable> $exceptionToThrow;
            final /* synthetic */ Halcyon this$0;
            {
                this.$exceptionToThrow = $exceptionToThrow;
                this.this$0 = $receiver;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onEvent(@NotNull Event event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (event instanceof SASLEvent.SASLError) {
                    SASLModule.SASLError sASLError = ((SASLEvent.SASLError)event).getError();
                    String string = ((SASLEvent.SASLError)event).getDescription();
                    if (string == null) {
                        string = "Authentication error";
                    }
                    this.$exceptionToThrow.element = new AuthenticationException(sASLError, string);
                } else if (event instanceof HalcyonStateChangeEvent && (((HalcyonStateChangeEvent)event).getNewState() == AbstractHalcyon.State.Connected || ((HalcyonStateChangeEvent)event).getNewState() == AbstractHalcyon.State.Stopped)) {
                    Object object = Halcyon.access$getLock$p(this.this$0);
                    Halcyon halcyon = this.this$0;
                    Object object2 = object;
                    synchronized (object2) {
                        boolean bl = false;
                        Halcyon.access$getLock$p(halcyon).notify();
                        Unit unit = Unit.INSTANCE;
                    }
                }
            }
        };
        try {
            EventBusInterface.DefaultImpls.register$default((EventBusInterface)this.getEventBus(), null, handler2, 1, null);
            super.connect();
            Object object = this.lock;
            synchronized (object) {
                boolean $i$a$-synchronized-Halcyon$connectAndWait$22 = false;
                this.lock.wait(30000L);
                Unit $i$a$-synchronized-Halcyon$connectAndWait$22 = Unit.INSTANCE;
            }
            Throwable throwable = (Throwable)exceptionToThrow.element;
            if (throwable != null) {
                Throwable it = throwable;
                boolean bl = false;
                throw it;
            }
            if (this.getState() != AbstractHalcyon.State.Connected && this.getState() != AbstractHalcyon.State.Stopped) {
                throw new HalcyonException("Cannot connect to XMPP server.");
            }
        }
        finally {
            this.getEventBus().unregister(handler2);
        }
    }

    public static final /* synthetic */ Object access$getLock$p(Halcyon $this) {
        return $this.lock;
    }

    public static final /* synthetic */ Logger access$getLog$p(Halcyon $this) {
        return $this.log;
    }
}

