/*
 * Decompiled with CFR 0.152.
 */
package tigase.halcyon.core;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0019\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\u0010\r\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0004J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0004J\u000e\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u000bJ\u000e\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\fJ\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0011H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Ltigase/halcyon/core/Base64;", "", "()V", "ALPHABET", "", "ALPHABET_1", "", "decode", "", "s", "decodeToByteArray", "", "", "decodeToString", "encode", "buf", "findNexIt", "", "idx", "halcyon-core"})
public final class Base64 {
    @NotNull
    public static final Base64 INSTANCE;
    @NotNull
    private static final String ALPHABET;
    @NotNull
    private static final int[] ALPHABET_1;

    private Base64() {
    }

    @NotNull
    public final char[] decode(@NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        int separatorsCounter = 0;
        int inputLen = s.length();
        for (int i = 0; i < inputLen; ++i) {
            int c2 = ALPHABET_1[s.charAt(i)];
            if (c2 >= 0 || c2 == 61) continue;
            ++separatorsCounter;
        }
        int deltas = 0;
        for (int i = inputLen - 1; i > 1 && ALPHABET_1[s.charAt(i)] <= 0; --i) {
            if (s.charAt(i) != '=') continue;
            ++deltas;
        }
        int outputLen = (inputLen - separatorsCounter) * 3 / 4 - deltas;
        char[] buffer = new char[outputLen];
        int mask = 255;
        int index = 0;
        int o = 0;
        o = 0;
        while (o < s.length()) {
            int c3;
            int c2;
            int c1;
            int c0;
            if ((c0 = ALPHABET_1[s.charAt(o++)]) == -1) {
                --o;
                o = this.findNexIt(s, o);
                if ((c0 = ALPHABET_1[s.charAt(o++)]) == -1) break;
            }
            if ((c1 = ALPHABET_1[s.charAt(o++)]) == -1) {
                --o;
                o = this.findNexIt(s, o);
                if ((c1 = ALPHABET_1[s.charAt(o++)]) == -1) break;
            }
            buffer[index++] = (char)((c0 << 2 | c1 >> 4) & mask);
            if (index >= buffer.length) break;
            if ((c2 = ALPHABET_1[s.charAt(o++)]) == -1) {
                --o;
                o = this.findNexIt(s, o);
                if ((c2 = ALPHABET_1[s.charAt(o++)]) == -1) break;
            }
            buffer[index++] = (char)((c1 << 4 | c2 >> 2) & mask);
            if (index >= buffer.length) break;
            if ((c3 = ALPHABET_1[s.charAt(o++)]) == -1) {
                --o;
                o = this.findNexIt(s, o);
                if ((c3 = ALPHABET_1[s.charAt(o++)]) == -1) break;
            }
            buffer[index++] = (char)((c2 << 6 | c3) & mask);
        }
        return buffer;
    }

    @NotNull
    public final String decodeToString(@NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        char[] buf = this.decode(s);
        return StringsKt.concatToString((char[])buf);
    }

    @NotNull
    public final String encode(@NotNull CharSequence buf) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        int size = buf.length();
        int outputSize = (size + 2) / 3 * 4;
        char[] output = new char[outputSize];
        int a = 0;
        int i = 0;
        while (i < size) {
            char b0 = buf.charAt(i++);
            char b1 = i < size ? buf.charAt(i++) : (char)'\u0000';
            char b2 = i < size ? buf.charAt(i++) : (char)'\u0000';
            int mask = 63;
            output[a++] = ALPHABET.charAt(b0 >> 2 & mask);
            output[a++] = ALPHABET.charAt((b0 << 4 | (b1 & 0xFF) >> 4) & mask);
            output[a++] = ALPHABET.charAt((b1 << 2 | (b2 & 0xFF) >> 6) & mask);
            output[a++] = ALPHABET.charAt(b2 & mask);
        }
        switch (size % 3) {
            case 1: {
                output[--a] = 61;
                output[--a] = 61;
                break;
            }
            case 2: {
                output[--a] = 61;
            }
        }
        return StringsKt.concatToString((char[])output);
    }

    @NotNull
    public final String encode(@NotNull byte[] buf) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        int size = buf.length;
        int outputSize = (size + 2) / 3 * 4;
        char[] output = new char[outputSize];
        int a = 0;
        int i = 0;
        while (i < size) {
            byte b0 = buf[i++];
            byte b1 = i < size ? buf[i++] : (byte)0;
            byte b2 = i < size ? buf[i++] : (byte)0;
            int mask = 63;
            output[a++] = ALPHABET.charAt(b0 >> 2 & mask);
            output[a++] = ALPHABET.charAt((b0 << 4 | (b1 & 0xFF) >> 4) & mask);
            output[a++] = ALPHABET.charAt((b1 << 2 | (b2 & 0xFF) >> 6) & mask);
            output[a++] = ALPHABET.charAt(b2 & mask);
        }
        switch (size % 3) {
            case 1: {
                output[--a] = 61;
                output[--a] = 61;
                break;
            }
            case 2: {
                output[--a] = 61;
            }
        }
        return StringsKt.concatToString((char[])output);
    }

    private final int findNexIt(CharSequence s, int idx) {
        int i = idx;
        int sl = s.length() - 1;
        int c2 = 0;
        if (i >= sl) {
            return i;
        }
        while ((c2 = ALPHABET_1[s.charAt(++i)]) == -1 && i < sl) {
        }
        return i;
    }

    @NotNull
    public final byte[] decodeToByteArray(@NotNull CharSequence s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        int separatorsCounter = 0;
        int inputLen = s.length();
        for (int i = 0; i < inputLen; ++i) {
            int c2 = ALPHABET_1[s.charAt(i)];
            if (c2 >= 0 || c2 == 61) continue;
            ++separatorsCounter;
        }
        int deltas = 0;
        for (int i = inputLen - 1; i > 1 && ALPHABET_1[s.charAt(i)] <= 0; --i) {
            if (s.charAt(i) != '=') continue;
            ++deltas;
        }
        int outputLen = (inputLen - separatorsCounter) * 3 / 4 - deltas;
        byte[] buffer = new byte[outputLen];
        int mask = 255;
        int index = 0;
        int o = 0;
        o = 0;
        while (o < s.length()) {
            int c3;
            int c2;
            int c1;
            int c0;
            if ((c0 = ALPHABET_1[s.charAt(o++)]) == -1) {
                --o;
                o = this.findNexIt(s, o);
                if ((c0 = ALPHABET_1[s.charAt(o++)]) == -1) break;
            }
            if ((c1 = ALPHABET_1[s.charAt(o++)]) == -1) {
                --o;
                o = this.findNexIt(s, o);
                if ((c1 = ALPHABET_1[s.charAt(o++)]) == -1) break;
            }
            buffer[index++] = (byte)((c0 << 2 | c1 >> 4) & mask);
            if (index >= buffer.length) break;
            if ((c2 = ALPHABET_1[s.charAt(o++)]) == -1) {
                --o;
                o = this.findNexIt(s, o);
                if ((c2 = ALPHABET_1[s.charAt(o++)]) == -1) break;
            }
            buffer[index++] = (byte)((c1 << 4 | c2 >> 2) & mask);
            if (index >= buffer.length) break;
            if ((c3 = ALPHABET_1[s.charAt(o++)]) == -1) {
                --o;
                o = this.findNexIt(s, o);
                if ((c3 = ALPHABET_1[s.charAt(o++)]) == -1) break;
            }
            buffer[index++] = (byte)((c2 << 6 | c3) & mask);
        }
        return buffer;
    }

    static {
        int i;
        INSTANCE = new Base64();
        ALPHABET = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
        ALPHABET_1 = new int[256];
        int n = ALPHABET_1.length;
        for (i = 0; i < n; ++i) {
            Base64.ALPHABET_1[i] = -1;
        }
        n = ALPHABET.length();
        for (i = 0; i < n; ++i) {
            Base64.ALPHABET_1[Base64.ALPHABET.charAt((int)i)] = i;
        }
        Base64.ALPHABET_1[61] = 0;
    }
}

