/*
 * Decompiled with CFR 0.152.
 */
package tigase.halcyon.core.builder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tigase.halcyon.core.builder.ConfigurationException;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\t\nB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00060\u00050\u0004\"\u0004\b\u0000\u0010\u00062\u0012\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00060\u00050\b\u00a8\u0006\u000b"}, d2={"Ltigase/halcyon/core/builder/TopoSort;", "", "()V", "sort", "", "Ltigase/halcyon/core/builder/TopoSort$Node;", "T", "allNodes", "", "Edge", "Node", "halcyon-core"})
public final class TopoSort {
    @NotNull
    public static final TopoSort INSTANCE = new TopoSort();

    private TopoSort() {
    }

    @NotNull
    public final <T> List<Node<T>> sort(@NotNull Collection<Node<T>> allNodes) {
        Intrinsics.checkNotNullParameter(allNodes, (String)"allNodes");
        List result2 = new ArrayList();
        Set nodesEmptyIncom = new LinkedHashSet();
        for (Node<T> n : allNodes) {
            if (n.getInEdges().size() != 0) continue;
            nodesEmptyIncom.add(n);
        }
        while (!nodesEmptyIncom.isEmpty()) {
            Node n = (Node)nodesEmptyIncom.iterator().next();
            nodesEmptyIncom.remove(n);
            result2.add(n);
            Iterator it = n.getOutEdges().iterator();
            while (it.hasNext()) {
                Edge e = it.next();
                Node m = e.getTo();
                it.remove();
                Node node = m;
                Intrinsics.checkNotNull(node);
                node.getInEdges().remove(e);
                if (!m.getInEdges().isEmpty()) continue;
                nodesEmptyIncom.add(m);
            }
        }
        for (Node<T> n : allNodes) {
            if (n.getInEdges().isEmpty()) continue;
            throw new ConfigurationException("Cycle detected. Cannot initiate modules.");
        }
        return result2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B%\u0012\u000e\u0010\u0003\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0004\u0012\u000e\u0010\u0005\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0006J\u0011\u0010\n\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0004H\u00c6\u0003J\u0011\u0010\u000b\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0004H\u00c6\u0003J3\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0010\b\u0002\u0010\u0003\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00042\u0010\b\u0002\u0010\u0005\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0004H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0019\u0010\u0003\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0019\u0010\u0005\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0014"}, d2={"Ltigase/halcyon/core/builder/TopoSort$Edge;", "T", "", "from", "Ltigase/halcyon/core/builder/TopoSort$Node;", "to", "(Ltigase/halcyon/core/builder/TopoSort$Node;Ltigase/halcyon/core/builder/TopoSort$Node;)V", "getFrom", "()Ltigase/halcyon/core/builder/TopoSort$Node;", "getTo", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "halcyon-core"})
    public static final class Edge<T> {
        @Nullable
        private final Node<T> from;
        @Nullable
        private final Node<T> to;

        public Edge(@Nullable Node<T> from, @Nullable Node<T> to) {
            this.from = from;
            this.to = to;
        }

        @Nullable
        public final Node<T> getFrom() {
            return this.from;
        }

        @Nullable
        public final Node<T> getTo() {
            return this.to;
        }

        @Nullable
        public final Node<T> component1() {
            return this.from;
        }

        @Nullable
        public final Node<T> component2() {
            return this.to;
        }

        @NotNull
        public final Edge<T> copy(@Nullable Node<T> from, @Nullable Node<T> to) {
            return new Edge<T>(from, to);
        }

        public static /* synthetic */ Edge copy$default(Edge edge, Node node, Node node2, int n, Object object) {
            if ((n & 1) != 0) {
                node = edge.from;
            }
            if ((n & 2) != 0) {
                node2 = edge.to;
            }
            return edge.copy(node, node2);
        }

        @NotNull
        public String toString() {
            return "Edge(from=" + this.from + ", to=" + this.to + ")";
        }

        public int hashCode() {
            int result2 = this.from == null ? 0 : this.from.hashCode();
            result2 = result2 * 31 + (this.to == null ? 0 : this.to.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Edge)) {
                return false;
            }
            Edge edge = (Edge)other;
            if (!Intrinsics.areEqual(this.from, edge.from)) {
                return false;
            }
            return Intrinsics.areEqual(this.to, edge.to);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000J\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000J\b\u0010\u0012\u001a\u00020\u0013H\u0016R\u0013\u0010\u0003\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u0007\u001a\u0004\b\u0005\u0010\u0006R\u001d\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001d\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\f\u00a8\u0006\u0014"}, d2={"Ltigase/halcyon/core/builder/TopoSort$Node;", "T", "", "data", "(Ljava/lang/Object;)V", "getData", "()Ljava/lang/Object;", "Ljava/lang/Object;", "inEdges", "", "Ltigase/halcyon/core/builder/TopoSort$Edge;", "getInEdges", "()Ljava/util/Set;", "outEdges", "getOutEdges", "after", "node", "before", "toString", "", "halcyon-core"})
    public static final class Node<T> {
        private final T data;
        @NotNull
        private final Set<Edge<T>> inEdges;
        @NotNull
        private final Set<Edge<T>> outEdges;

        public Node(T data) {
            this.data = data;
            this.inEdges = new LinkedHashSet();
            this.outEdges = new LinkedHashSet();
        }

        public final T getData() {
            return this.data;
        }

        @NotNull
        public final Set<Edge<T>> getInEdges() {
            return this.inEdges;
        }

        @NotNull
        public final Set<Edge<T>> getOutEdges() {
            return this.outEdges;
        }

        @NotNull
        public final Node<T> after(@NotNull Node<T> node) {
            Intrinsics.checkNotNullParameter(node, (String)"node");
            Edge<T> e = new Edge<T>(node, this);
            node.outEdges.add(e);
            this.inEdges.add(e);
            return this;
        }

        @NotNull
        public final Node<T> before(@NotNull Node<T> node) {
            Intrinsics.checkNotNullParameter(node, (String)"node");
            Edge<T> e = new Edge<T>(this, node);
            this.outEdges.add(e);
            node.inEdges.add(e);
            node.inEdges.add(e);
            return this;
        }

        @NotNull
        public String toString() {
            return String.valueOf(this.data);
        }
    }
}

