/*
 * Decompiled with CFR 0.152.
 */
package tigase.halcyon.core.xmpp.modules.chatstates;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.datetime.Clock;
import kotlinx.datetime.Instant;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tigase.halcyon.core.TickEvent;
import tigase.halcyon.core.eventbus.EventBus;
import tigase.halcyon.core.eventbus.EventHandler;
import tigase.halcyon.core.xmpp.BareJID;
import tigase.halcyon.core.xmpp.modules.chatstates.ChatState;
import tigase.halcyon.core.xmpp.modules.chatstates.OwnChatStateChangeEvent;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000b\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B?\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\n\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\rJ\u0006\u0010!\u001a\u00020\"J\u0006\u0010#\u001a\u00020\"J\u0006\u0010$\u001a\u00020\"J\u0006\u0010%\u001a\u00020\"J\u0010\u0010&\u001a\u00020\"2\u0006\u0010'\u001a\u00020\u0002H\u0016J\u0006\u0010(\u001a\u00020\"J\u0018\u0010)\u001a\u00020\"2\u0006\u0010*\u001a\u00020\u000f2\u0006\u0010+\u001a\u00020\bH\u0002J\u0006\u0010,\u001a\u00020\"R\u001e\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\f\u001a\u0004\u0018\u00010\n\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0019\u0010\u000b\u001a\u00020\n\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\n\n\u0002\u0010\u0017\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0019\u0010\t\u001a\u00020\n\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\n\n\u0002\u0010\u0017\u001a\u0004\b\u001a\u0010\u0016R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u000e\u0010\u001f\u001a\u00020 X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006-"}, d2={"Ltigase/halcyon/core/xmpp/modules/chatstates/ChatStateMachine;", "Ltigase/halcyon/core/eventbus/EventHandler;", "Ltigase/halcyon/core/TickEvent;", "jid", "Ltigase/halcyon/core/xmpp/BareJID;", "eventBus", "Ltigase/halcyon/core/eventbus/EventBus;", "sendUpdatesAutomatically", "", "pausedTimeout", "Lkotlin/time/Duration;", "inactiveTimeout", "goneTimeout", "(Ltigase/halcyon/core/xmpp/BareJID;Ltigase/halcyon/core/eventbus/EventBus;ZJJLkotlin/time/Duration;Lkotlin/jvm/internal/DefaultConstructorMarker;)V", "<set-?>", "Ltigase/halcyon/core/xmpp/modules/chatstates/ChatState;", "currentState", "getCurrentState", "()Ltigase/halcyon/core/xmpp/modules/chatstates/ChatState;", "getGoneTimeout-FghU774", "()Lkotlin/time/Duration;", "getInactiveTimeout-UwyO8pc", "()J", "J", "getJid", "()Ltigase/halcyon/core/xmpp/BareJID;", "getPausedTimeout-UwyO8pc", "getSendUpdatesAutomatically", "()Z", "setSendUpdatesAutomatically", "(Z)V", "updateTime", "Lkotlinx/datetime/Instant;", "closeChat", "", "composing", "focusLost", "focused", "onEvent", "event", "sendingMessage", "setNewState", "newState", "allowedToSendUpdate", "update", "halcyon-core"})
public final class ChatStateMachine
implements EventHandler<TickEvent> {
    @NotNull
    private final BareJID jid;
    @NotNull
    private final EventBus eventBus;
    private boolean sendUpdatesAutomatically;
    private final long pausedTimeout;
    private final long inactiveTimeout;
    @Nullable
    private final Duration goneTimeout;
    @NotNull
    private ChatState currentState;
    @NotNull
    private Instant updateTime;

    private ChatStateMachine(BareJID jid, EventBus eventBus, boolean sendUpdatesAutomatically, long pausedTimeout, long inactiveTimeout, Duration goneTimeout) {
        Intrinsics.checkNotNullParameter((Object)jid, (String)"jid");
        Intrinsics.checkNotNullParameter((Object)eventBus, (String)"eventBus");
        this.jid = jid;
        this.eventBus = eventBus;
        this.sendUpdatesAutomatically = sendUpdatesAutomatically;
        this.pausedTimeout = pausedTimeout;
        this.inactiveTimeout = inactiveTimeout;
        this.goneTimeout = goneTimeout;
        this.currentState = ChatState.Inactive;
        this.updateTime = Clock.System.INSTANCE.now();
    }

    public /* synthetic */ ChatStateMachine(BareJID bareJID, EventBus eventBus, boolean bl, long l, long l2, Duration duration, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            l = DurationKt.toDuration((int)3, (DurationUnit)DurationUnit.SECONDS);
        }
        if ((n & 0x10) != 0) {
            l2 = DurationKt.toDuration((int)7, (DurationUnit)DurationUnit.SECONDS);
        }
        if ((n & 0x20) != 0) {
            duration = null;
        }
        this(bareJID, eventBus, bl, l, l2, duration, null);
    }

    @NotNull
    public final BareJID getJid() {
        return this.jid;
    }

    public final boolean getSendUpdatesAutomatically() {
        return this.sendUpdatesAutomatically;
    }

    public final void setSendUpdatesAutomatically(boolean bl) {
        this.sendUpdatesAutomatically = bl;
    }

    public final long getPausedTimeout-UwyO8pc() {
        return this.pausedTimeout;
    }

    public final long getInactiveTimeout-UwyO8pc() {
        return this.inactiveTimeout;
    }

    @Nullable
    public final Duration getGoneTimeout-FghU774() {
        return this.goneTimeout;
    }

    @NotNull
    public final ChatState getCurrentState() {
        return this.currentState;
    }

    private final void setNewState(ChatState newState, boolean allowedToSendUpdate) {
        ChatState oldState = this.currentState;
        this.updateTime = Clock.System.INSTANCE.now();
        if (this.currentState != newState) {
            this.currentState = newState;
            this.eventBus.fire(new OwnChatStateChangeEvent(this.jid, oldState, newState, this.sendUpdatesAutomatically && allowedToSendUpdate));
        }
    }

    public final void update() {
        block0: {
            ChatState chatState;
            Instant now = Clock.System.INSTANCE.now();
            ChatState chatState2 = this.currentState == ChatState.Active && this.updateTime.compareTo(now.minus-LRDsOJo(this.inactiveTimeout)) < 0 ? ChatState.Inactive : (this.currentState == ChatState.Composing && this.updateTime.compareTo(now.minus-LRDsOJo(this.pausedTimeout)) < 0 ? ChatState.Paused : (this.currentState == ChatState.Paused && this.updateTime.compareTo(now.minus-LRDsOJo(this.inactiveTimeout)) < 0 ? ChatState.Inactive : (chatState = this.currentState == ChatState.Inactive && this.goneTimeout != null && this.updateTime.compareTo(now.minus-LRDsOJo(this.goneTimeout.unbox-impl())) < 0 ? ChatState.Gone : null)));
            if (chatState == null) break block0;
            ChatState calculatedState = chatState;
            boolean bl = false;
            this.setNewState(calculatedState, true);
        }
    }

    public final void focused() {
        this.setNewState(ChatState.Active, true);
    }

    public final void focusLost() {
        this.setNewState(ChatState.Inactive, true);
    }

    public final void closeChat() {
        this.setNewState(ChatState.Gone, true);
    }

    public final void composing() {
        this.setNewState(ChatState.Composing, true);
    }

    public final void sendingMessage() {
        this.setNewState(ChatState.Active, false);
    }

    @Override
    public void onEvent(@NotNull TickEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.update();
    }

    public /* synthetic */ ChatStateMachine(BareJID jid, EventBus eventBus, boolean sendUpdatesAutomatically, long pausedTimeout, long inactiveTimeout, Duration goneTimeout, DefaultConstructorMarker $constructor_marker) {
        this(jid, eventBus, sendUpdatesAutomatically, pausedTimeout, inactiveTimeout, goneTimeout);
    }
}

