/*
 * Decompiled with CFR 0.152.
 */
package tigase.halcyon.core.xmpp.modules.auth;

import java.util.Arrays;
import korlibs.crypto.HMAC;
import korlibs.crypto.PBKDF2;
import korlibs.crypto.SHA1Kt;
import korlibs.crypto.SHA256Kt;
import korlibs.crypto.SHA512Kt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tigase.halcyon.core.Base64Kt;
import tigase.halcyon.core.Context;
import tigase.halcyon.core.configuration.Configuration;
import tigase.halcyon.core.configuration.JIDPasswordSaslConfig;
import tigase.halcyon.core.configuration.SaslConfig;
import tigase.halcyon.core.logger.Logger;
import tigase.halcyon.core.logger.LoggerFactory;
import tigase.halcyon.core.xml.Element;
import tigase.halcyon.core.xmpp.modules.auth.AbstractSASLScram;
import tigase.halcyon.core.xmpp.modules.auth.BindType;
import tigase.halcyon.core.xmpp.modules.auth.ClientSaslException;
import tigase.halcyon.core.xmpp.modules.auth.MechanismData;
import tigase.halcyon.core.xmpp.modules.auth.SASLContext;
import tigase.halcyon.core.xmpp.modules.auth.SASLMechanism;
import tigase.halcyon.core.xmpp.modules.auth.SASLScramConfig;
import tigase.halcyon.core.xmpp.modules.auth.SCRAMData;
import tigase.halcyon.core.xmpp.modules.auth.ScramHashAlgorithm;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J,\u0010 \u001a\u0004\u0018\u00010\u00042\b\u0010!\u001a\u0004\u0018\u00010\u00042\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0016J(\u0010(\u001a\u00020)2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010*\u001a\u00020+H\u0016J,\u0010,\u001a\u000e\u0012\u0004\u0012\u00020.\u0012\u0004\u0012\u00020\t0-2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0014J\u0010\u0010/\u001a\u0002002\u0006\u0010&\u001a\u00020'H\u0004R\u001a\u0010\b\u001a\u00020\tX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR \u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u000fX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001c\u001a\u00020\tX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u000b\"\u0004\b\u001e\u0010\rR\u000e\u0010\u001f\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Ltigase/halcyon/core/xmpp/modules/auth/AbstractSASLScram;", "Ltigase/halcyon/core/xmpp/modules/auth/SASLMechanism;", "Ltigase/halcyon/core/xmpp/modules/auth/SASLScramConfig;", "name", "", "hashAlgorithm", "Ltigase/halcyon/core/xmpp/modules/auth/ScramHashAlgorithm;", "(Ljava/lang/String;Ltigase/halcyon/core/xmpp/modules/auth/ScramHashAlgorithm;)V", "clientKeyData", "", "getClientKeyData", "()[B", "setClientKeyData", "([B)V", "conceGenerator", "Lkotlin/Function0;", "getConceGenerator", "()Lkotlin/jvm/functions/Function0;", "setConceGenerator", "(Lkotlin/jvm/functions/Function0;)V", "getHashAlgorithm", "()Ltigase/halcyon/core/xmpp/modules/auth/ScramHashAlgorithm;", "log", "Ltigase/halcyon/core/logger/Logger;", "getName", "()Ljava/lang/String;", "serverFirstMessageRegex", "Lkotlin/text/Regex;", "serverKeyData", "getServerKeyData", "setServerKeyData", "serverLastMessageRegex", "evaluateChallenge", "input", "context", "Ltigase/halcyon/core/Context;", "config", "Ltigase/halcyon/core/configuration/Configuration;", "saslContext", "Ltigase/halcyon/core/xmpp/modules/auth/SASLContext;", "isAllowedToUse", "", "streamFeatures", "Ltigase/halcyon/core/xml/Element;", "prepareChannelBindingData", "Lkotlin/Pair;", "Ltigase/halcyon/core/xmpp/modules/auth/BindType;", "scramData", "Ltigase/halcyon/core/xmpp/modules/auth/SCRAMData;", "halcyon-core"})
@SourceDebugExtension(value={"SMAP\nAbstractSASLScram.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractSASLScram.kt\ntigase/halcyon/core/xmpp/modules/auth/AbstractSASLScram\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,290:1\n1#2:291\n*E\n"})
public abstract class AbstractSASLScram
implements SASLMechanism,
SASLScramConfig {
    @NotNull
    private final String name;
    @NotNull
    private final ScramHashAlgorithm hashAlgorithm;
    @NotNull
    private final Logger log;
    @NotNull
    private Function0<String> conceGenerator;
    @NotNull
    private byte[] clientKeyData;
    @NotNull
    private byte[] serverKeyData;
    @NotNull
    private final Regex serverFirstMessageRegex;
    @NotNull
    private final Regex serverLastMessageRegex;

    public AbstractSASLScram(@NotNull String name2, @NotNull ScramHashAlgorithm hashAlgorithm) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)((Object)hashAlgorithm), (String)"hashAlgorithm");
        this.name = name2;
        this.hashAlgorithm = hashAlgorithm;
        this.log = LoggerFactory.logger$default(LoggerFactory.INSTANCE, "tigase.halcyon.core.xmpp.modules.auth.AbstractSASLScram", false, 2, null);
        this.conceGenerator = conceGenerator.1.INSTANCE;
        this.clientKeyData = StringsKt.encodeToByteArray((String)"Client Key");
        this.serverKeyData = StringsKt.encodeToByteArray((String)"Server Key");
        this.serverFirstMessageRegex = new Regex("^(m=[^,]+,)?r=([^,]+),s=([^,]+),i=([0-9]+)(?:,.*)?$", RegexOption.IGNORE_CASE);
        this.serverLastMessageRegex = new Regex("^(?:e=([^,]+)|v=([^,]+)(?:,.*)?)$", RegexOption.IGNORE_CASE);
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public final ScramHashAlgorithm getHashAlgorithm() {
        return this.hashAlgorithm;
    }

    @Override
    @NotNull
    public Function0<String> getConceGenerator() {
        return this.conceGenerator;
    }

    @Override
    public void setConceGenerator(@NotNull Function0<String> function0) {
        Intrinsics.checkNotNullParameter(function0, (String)"<set-?>");
        this.conceGenerator = function0;
    }

    @Override
    @NotNull
    public byte[] getClientKeyData() {
        return this.clientKeyData;
    }

    @Override
    public void setClientKeyData(@NotNull byte[] byArray) {
        Intrinsics.checkNotNullParameter((Object)byArray, (String)"<set-?>");
        this.clientKeyData = byArray;
    }

    @Override
    @NotNull
    public byte[] getServerKeyData() {
        return this.serverKeyData;
    }

    @Override
    public void setServerKeyData(@NotNull byte[] byArray) {
        Intrinsics.checkNotNullParameter((Object)byArray, (String)"<set-?>");
        this.serverKeyData = byArray;
    }

    @Override
    public boolean isAllowedToUse(@NotNull Context context, @NotNull Configuration config, @NotNull SASLContext saslContext, @NotNull Element streamFeatures) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)saslContext, (String)"saslContext");
        Intrinsics.checkNotNullParameter((Object)streamFeatures, (String)"streamFeatures");
        return config.getSasl() instanceof JIDPasswordSaslConfig;
    }

    @NotNull
    protected final SCRAMData scramData(@NotNull SASLContext saslContext) {
        Intrinsics.checkNotNullParameter((Object)saslContext, (String)"saslContext");
        if (saslContext.getMechanismData() == null) {
            saslContext.setMechanismData(new SCRAMData(null, null, null, null, null, null, null, null, null, null, null, 0, 4095, null));
        }
        MechanismData mechanismData = saslContext.getMechanismData();
        Intrinsics.checkNotNull((Object)mechanismData, (String)"null cannot be cast to non-null type tigase.halcyon.core.xmpp.modules.auth.SCRAMData");
        return (SCRAMData)mechanismData;
    }

    @NotNull
    protected Pair<BindType, byte[]> prepareChannelBindingData(@NotNull Context context, @NotNull Configuration config, @NotNull SASLContext saslContext) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)saslContext, (String)"saslContext");
        return new Pair((Object)BindType.N, (Object)new byte[0]);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public String evaluateChallenge(@Nullable String input, @NotNull Context context, @NotNull Configuration config, @NotNull SASLContext saslContext) {
        SCRAMData data;
        block57: {
            StringBuilder stringBuilder;
            byte[] byArray;
            StringBuilder stringBuilder2;
            Object object;
            Object nonce;
            MatchResult r2;
            String serverFirstMessage;
            block59: {
                block58: {
                    Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                    Intrinsics.checkNotNullParameter((Object)config, (String)"config");
                    Intrinsics.checkNotNullParameter((Object)saslContext, (String)"saslContext");
                    data = this.scramData(saslContext);
                    SaslConfig saslConfig = config.getSasl();
                    Intrinsics.checkNotNull((Object)saslConfig, (String)"null cannot be cast to non-null type tigase.halcyon.core.configuration.JIDPasswordSaslConfig");
                    JIDPasswordSaslConfig credentials = (JIDPasswordSaslConfig)saslConfig;
                    if (data.getStage() == 0) {
                        void $this$evaluateChallenge_u24lambda_u243;
                        StringBuilder $this$evaluateChallenge_u24lambda_u242;
                        data.setConce((String)this.getConceGenerator().invoke());
                        Object object2 = this.prepareChannelBindingData(context, config, saslContext);
                        boolean bl = false;
                        BindType bindType = (BindType)((Object)object2.component1());
                        byte[] bindData = (byte[])object2.component2();
                        data.setBindType(bindType);
                        data.setBindData(bindData);
                        this.log.fine("Selected channel binding: " + data.getBindType());
                        String string = credentials.getAuthcId();
                        if (string == null) {
                            String string2 = credentials.getUserJID().getLocalpart();
                            string = string2;
                            Intrinsics.checkNotNull((Object)string2);
                        }
                        data.setAuthcId(string);
                        data.setAuthzId(credentials.getAuthcId() != null ? credentials.getUserJID().toString() : null);
                        BindType bindType2 = data.getBindType();
                        Intrinsics.checkNotNull((Object)((Object)bindType2));
                        data.setGs2CBindFlag(switch (WhenMappings.$EnumSwitchMapping$0[bindType2.ordinal()]) {
                            case 1 -> "n";
                            case 2 -> "y";
                            case 3 -> "p=tls-unique";
                            case 4 -> "p=tls-server-end-point";
                            case 5 -> "p=tls-exporter";
                            default -> throw new NoWhenBranchMatchedException();
                        });
                        StringBuilder stringBuilder3 = new StringBuilder();
                        object2 = stringBuilder3;
                        SCRAMData sCRAMData = data;
                        boolean bl2 = false;
                        $this$evaluateChallenge_u24lambda_u242.append(data.getGs2CBindFlag());
                        $this$evaluateChallenge_u24lambda_u242.append(",");
                        String string3 = data.getAuthzId();
                        if (string3 != null) {
                            String it = string3;
                            boolean bl3 = false;
                            $this$evaluateChallenge_u24lambda_u242.append("a=").append(it);
                        }
                        $this$evaluateChallenge_u24lambda_u242.append(",");
                        String string4 = stringBuilder3.toString();
                        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toString(...)");
                        sCRAMData.setGs2Header(string4);
                        $this$evaluateChallenge_u24lambda_u242 = stringBuilder3 = new StringBuilder();
                        sCRAMData = data;
                        boolean bl4 = false;
                        $this$evaluateChallenge_u24lambda_u243.append("n=" + data.getAuthcId() + ",");
                        $this$evaluateChallenge_u24lambda_u243.append("r=" + data.getConce());
                        String string5 = stringBuilder3.toString();
                        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toString(...)");
                        sCRAMData.setClientFirstMessageBare(string5);
                        data.setStage(data.getStage() + 1);
                        data.getStage();
                        return Base64Kt.toBase64(data.getGs2Header() + data.getClientFirstMessageBare());
                    }
                    if (data.getStage() != 1) break block57;
                    if (input == null) {
                        throw new ClientSaslException("Unexpected empty input!");
                    }
                    serverFirstMessage = StringsKt.decodeToString((byte[])Base64Kt.fromBase64(input));
                    MatchResult matchResult = this.serverFirstMessageRegex.matchEntire((CharSequence)serverFirstMessage);
                    if (matchResult == null) {
                        throw new ClientSaslException("Bad challenge syntax");
                    }
                    r2 = matchResult;
                    Object object3 = r2.getGroups().get(2);
                    if (object3 == null || (object3 = object3.getValue()) == null) {
                        throw new ClientSaslException("Bad challenge syntax: missing nonce");
                    }
                    nonce = object3;
                    object = r2.getGroups().get(3);
                    if (object == null || (object = object.getValue()) == null) break block58;
                    byte[] byArray2 = Base64Kt.fromBase64((CharSequence)object);
                    object = byArray2;
                    if (byArray2 != null) break block59;
                }
                throw new ClientSaslException("Bad challenge syntax: missing salt");
            }
            Object salt = object;
            Object object4 = r2.getGroups().get(4);
            if (object4 == null || (object4 = object4.getValue()) == null) {
                throw new ClientSaslException("Bad challenge syntax: missing iterations");
            }
            int iterations = Integer.parseInt((String)object4);
            String string = data.getConce();
            Intrinsics.checkNotNull((Object)string);
            if (!StringsKt.startsWith$default((String)nonce, (String)string, (boolean)false, (int)2, null)) {
                throw new ClientSaslException("Wrong nonce");
            }
            byte[] cBindInput = ArraysKt.plus((byte[])StringsKt.encodeToByteArray((String)String.valueOf(data.getGs2Header())), (byte[])data.getBindData());
            StringBuilder $this$evaluateChallenge_u24lambda_u244 = stringBuilder2 = new StringBuilder();
            boolean bl = false;
            $this$evaluateChallenge_u24lambda_u244.append("c=");
            $this$evaluateChallenge_u24lambda_u244.append(Base64Kt.toBase64(cBindInput));
            $this$evaluateChallenge_u24lambda_u244.append(",");
            $this$evaluateChallenge_u24lambda_u244.append("r=");
            $this$evaluateChallenge_u24lambda_u244.append((String)nonce);
            String string6 = stringBuilder2.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"toString(...)");
            String clientFinalMessageBare = string6;
            data.setAuthMessage(data.getClientFirstMessageBare() + "," + serverFirstMessage + "," + clientFinalMessageBare);
            data.setSaltedPassword(switch (WhenMappings.$EnumSwitchMapping$1[this.hashAlgorithm.ordinal()]) {
                case 1 -> PBKDF2.Companion.pbkdf2WithHmacSHA1(StringsKt.encodeToByteArray((String)((String)((JIDPasswordSaslConfig)config.getSasl()).getPasswordCallback().invoke())), (byte[])salt, iterations, 160).getBytes();
                case 2 -> PBKDF2.Companion.pbkdf2WithHmacSHA256(StringsKt.encodeToByteArray((String)((String)((JIDPasswordSaslConfig)config.getSasl()).getPasswordCallback().invoke())), (byte[])salt, iterations, 256).getBytes();
                case 3 -> PBKDF2.Companion.pbkdf2WithHmacSHA512(StringsKt.encodeToByteArray((String)((String)((JIDPasswordSaslConfig)config.getSasl()).getPasswordCallback().invoke())), (byte[])salt, iterations, 512).getBytes();
                default -> throw new NoWhenBranchMatchedException();
            });
            byte[] clientKey = (switch (WhenMappings.$EnumSwitchMapping$1[this.hashAlgorithm.ordinal()]) {
                case 1 -> {
                    byte[] v16 = data.getSaltedPassword();
                    Intrinsics.checkNotNull((Object)v16);
                    yield HMAC.Companion.hmacSHA1(v16, this.getClientKeyData());
                }
                case 2 -> {
                    byte[] v18 = data.getSaltedPassword();
                    Intrinsics.checkNotNull((Object)v18);
                    yield HMAC.Companion.hmacSHA256(v18, this.getClientKeyData());
                }
                case 3 -> {
                    byte[] v19 = data.getSaltedPassword();
                    Intrinsics.checkNotNull((Object)v19);
                    yield HMAC.Companion.hmacSHA512(v19, this.getClientKeyData());
                }
                default -> throw new NoWhenBranchMatchedException();
            }).getBytes();
            byte[] storedKey = (switch (WhenMappings.$EnumSwitchMapping$1[this.hashAlgorithm.ordinal()]) {
                case 1 -> SHA1Kt.sha1((byte[])clientKey);
                case 2 -> SHA256Kt.sha256((byte[])clientKey);
                case 3 -> SHA512Kt.sha512((byte[])clientKey);
                default -> throw new NoWhenBranchMatchedException();
            }).getBytes();
            byte[] clientSignature = (switch (WhenMappings.$EnumSwitchMapping$1[this.hashAlgorithm.ordinal()]) {
                case 1 -> {
                    String v21 = data.getAuthMessage();
                    Intrinsics.checkNotNull((Object)v21);
                    yield HMAC.Companion.hmacSHA1(storedKey, StringsKt.encodeToByteArray((String)v21));
                }
                case 2 -> {
                    String v23 = data.getAuthMessage();
                    Intrinsics.checkNotNull((Object)v23);
                    yield HMAC.Companion.hmacSHA256(storedKey, StringsKt.encodeToByteArray((String)v23));
                }
                case 3 -> {
                    String v24 = data.getAuthMessage();
                    Intrinsics.checkNotNull((Object)v24);
                    yield HMAC.Companion.hmacSHA512(storedKey, StringsKt.encodeToByteArray((String)v24));
                }
                default -> throw new NoWhenBranchMatchedException();
            }).getBytes();
            byte[] byArray3 = Arrays.copyOf(clientKey, clientKey.length);
            Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"copyOf(...)");
            byte[] it = byArray = byArray3;
            boolean bl5 = false;
            int n = it.length;
            for (int i = 0; i < n; ++i) {
                it[i] = (byte)(it[i] ^ clientSignature[i]);
            }
            byte[] clientProof = byArray;
            StringBuilder $this$evaluateChallenge_u24lambda_u246 = stringBuilder = new StringBuilder();
            boolean bl6 = false;
            $this$evaluateChallenge_u24lambda_u246.append(clientFinalMessageBare);
            $this$evaluateChallenge_u24lambda_u246.append(",");
            $this$evaluateChallenge_u24lambda_u246.append("p=");
            $this$evaluateChallenge_u24lambda_u246.append(Base64Kt.toBase64(clientProof));
            String string7 = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"toString(...)");
            String clientFinalMessageStep2 = string7;
            data.setStage(data.getStage() + 1);
            data.getStage();
            return Base64Kt.toBase64(clientFinalMessageStep2);
        }
        if (data.getStage() == 2) {
            if (input == null) {
                throw new ClientSaslException("Unexpected empty input!");
            }
            MatchResult matchResult = this.serverLastMessageRegex.matchEntire((CharSequence)StringsKt.decodeToString((byte[])Base64Kt.fromBase64(input)));
            if (matchResult == null) {
                throw new ClientSaslException("Bad challenge syntax");
            }
            MatchResult r = matchResult;
            MatchGroup r2 = r.getGroups().get(1);
            if (r2 != null) {
                MatchGroup it = r2;
                boolean bl = false;
                throw new ClientSaslException("Error: " + it);
            }
            Object object = r.getGroups().get(2);
            if (object == null || (object = object.getValue()) == null) {
                throw new ClientSaslException("Bad challenge syntax");
            }
            Object v = object;
            byte[] serverKey = (switch (WhenMappings.$EnumSwitchMapping$1[this.hashAlgorithm.ordinal()]) {
                case 1 -> {
                    byte[] v29 = data.getSaltedPassword();
                    Intrinsics.checkNotNull((Object)v29);
                    yield HMAC.Companion.hmacSHA1(v29, this.getServerKeyData());
                }
                case 2 -> {
                    byte[] v31 = data.getSaltedPassword();
                    Intrinsics.checkNotNull((Object)v31);
                    yield HMAC.Companion.hmacSHA256(v31, this.getServerKeyData());
                }
                case 3 -> {
                    byte[] v32 = data.getSaltedPassword();
                    Intrinsics.checkNotNull((Object)v32);
                    yield HMAC.Companion.hmacSHA512(v32, this.getServerKeyData());
                }
                default -> throw new NoWhenBranchMatchedException();
            }).getBytes();
            byte[] serverSignature = (switch (WhenMappings.$EnumSwitchMapping$1[this.hashAlgorithm.ordinal()]) {
                case 1 -> {
                    String v33 = data.getAuthMessage();
                    Intrinsics.checkNotNull((Object)v33);
                    yield HMAC.Companion.hmacSHA1(serverKey, StringsKt.encodeToByteArray((String)v33));
                }
                case 2 -> {
                    String v35 = data.getAuthMessage();
                    Intrinsics.checkNotNull((Object)v35);
                    yield HMAC.Companion.hmacSHA256(serverKey, StringsKt.encodeToByteArray((String)v35));
                }
                case 3 -> {
                    String v36 = data.getAuthMessage();
                    Intrinsics.checkNotNull((Object)v36);
                    yield HMAC.Companion.hmacSHA512(serverKey, StringsKt.encodeToByteArray((String)v36));
                }
                default -> throw new NoWhenBranchMatchedException();
            }).getBytes();
            if (!Arrays.equals(serverSignature, Base64Kt.fromBase64((CharSequence)v))) {
                throw new ClientSaslException("Invalid Server Signature");
            }
            data.setStage(data.getStage() + 1);
            data.getStage();
            saslContext.completed();
            return null;
        }
        if (saslContext.getComplete() && input == null) {
            return null;
        }
        throw new IllegalStateException("SASL Client in illegal state. stage=" + data.getStage() + " complete=" + saslContext.getComplete());
    }

    @Override
    public boolean isComplete(@NotNull SASLContext saslContext) {
        return SASLMechanism.DefaultImpls.isComplete(this, saslContext);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[BindType.values().length];
            try {
                nArray[BindType.N.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BindType.Y.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BindType.TlsUnique.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BindType.TlsServerEndPoint.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BindType.TlsExporter.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[ScramHashAlgorithm.values().length];
            try {
                nArray[ScramHashAlgorithm.SHA1.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ScramHashAlgorithm.SHA256.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ScramHashAlgorithm.SHA512.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

