/*
 * Decompiled with CFR 0.152.
 */
package tigase.halcyon.core.connector.socket;

import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import javax.security.auth.x500.X500Principal;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tigase.halcyon.core.connector.socket.DefaultHostnameVerifier;
import tigase.halcyon.core.connector.socket.XMPPHostnameVerifier;
import tigase.halcyon.core.logger.Logger;
import tigase.halcyon.core.logger.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0004J\u001a\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00062\b\u0010\f\u001a\u0004\u0018\u00010\u0006H\u0004J\u0018\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0013H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Ltigase/halcyon/core/connector/socket/DefaultHostnameVerifier;", "Ltigase/halcyon/core/connector/socket/XMPPHostnameVerifier;", "()V", "log", "Ltigase/halcyon/core/logger/Logger;", "extractCN", "", "principal", "Ljavax/security/auth/x500/X500Principal;", "match", "", "hostname", "altName", "validateCertificate", "domain", "certificate", "Ljava/security/cert/X509Certificate;", "verify", "domainName", "Ljava/security/cert/Certificate;", "halcyon-core"})
@SourceDebugExtension(value={"SMAP\nDefaultHostnameVerifier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultHostnameVerifier.kt\ntigase/halcyon/core/connector/socket/DefaultHostnameVerifier\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,85:1\n1855#2,2:86\n731#2,9:88\n37#3,2:97\n*S KotlinDebug\n*F\n+ 1 DefaultHostnameVerifier.kt\ntigase/halcyon/core/connector/socket/DefaultHostnameVerifier\n*L\n53#1:86,2\n77#1:88,9\n77#1:97,2\n*E\n"})
public final class DefaultHostnameVerifier
implements XMPPHostnameVerifier {
    @NotNull
    private final Logger log = LoggerFactory.logger$default(LoggerFactory.INSTANCE, "tigase.halcyon.core.connector.socket.DefaultHostnameVerifier", false, 2, null);

    @Override
    public boolean verify(@NotNull String domainName, @NotNull Certificate certificate) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)domainName, (String)"domainName");
        Intrinsics.checkNotNullParameter((Object)certificate, (String)"certificate");
        if (certificate instanceof X509Certificate) {
            bl = this.validateCertificate(domainName, (X509Certificate)certificate);
        } else {
            Logger.DefaultImpls.warning$default(this.log, null, verify.1.INSTANCE, 1, null);
            bl = false;
        }
        return bl;
    }

    protected final boolean match(@NotNull String hostname, @Nullable String altName) {
        int dotIdx;
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)hostname, (String)"hostname");
        if (((CharSequence)hostname).length() == 0 || (charSequence = (CharSequence)altName) == null || charSequence.length() == 0) {
            return false;
        }
        String string = altName.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        String normalizedAltName = string;
        if (!StringsKt.contains$default((CharSequence)normalizedAltName, (CharSequence)"*", (boolean)false, (int)2, null)) {
            return Intrinsics.areEqual((Object)hostname, (Object)normalizedAltName);
        }
        if (StringsKt.startsWith$default((String)normalizedAltName, (String)"*.", (boolean)false, (int)2, null) && StringsKt.regionMatches$default((String)hostname, (int)0, (String)normalizedAltName, (int)2, (int)(normalizedAltName.length() - 2), (boolean)false, (int)16, null)) {
            return true;
        }
        int asteriskIdx = StringsKt.indexOf$default((CharSequence)normalizedAltName, (char)'*', (int)0, (boolean)false, (int)6, null);
        if (asteriskIdx > (dotIdx = StringsKt.indexOf$default((CharSequence)normalizedAltName, (char)'.', (int)0, (boolean)false, (int)6, null))) {
            return false;
        }
        if (!StringsKt.regionMatches$default((String)hostname, (int)0, (String)normalizedAltName, (int)0, (int)asteriskIdx, (boolean)false, (int)16, null)) {
            return false;
        }
        int suffixLength = normalizedAltName.length() - (asteriskIdx + 1);
        int suffixStart = hostname.length() - suffixLength;
        return StringsKt.indexOf$default((CharSequence)hostname, (char)'.', (int)asteriskIdx, (boolean)false, (int)4, null) < suffixStart ? false : StringsKt.regionMatches$default((String)hostname, (int)suffixStart, (String)normalizedAltName, (int)(asteriskIdx + 1), (int)suffixLength, (boolean)false, (int)16, null);
    }

    private final boolean validateCertificate(String domain, X509Certificate certificate) {
        boolean altNamePresents = false;
        List list = certificate.getSubjectAlternativeNames();
        if (list != null && (list = CollectionsKt.filterNotNull((Iterable)list)) != null) {
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                List entry2 = (List)element$iv;
                boolean bl = false;
                Object e = entry2.get(0);
                Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type kotlin.Int");
                int altNameType = (Integer)e;
                if (altNameType != 2) continue;
                altNamePresents = true;
                Object e2 = entry2.get(1);
                Intrinsics.checkNotNull(e2, (String)"null cannot be cast to non-null type kotlin.String");
                String altName = (String)e2;
                if (!this.match(domain, altName)) continue;
                return true;
            }
        }
        if (!altNamePresents) {
            X500Principal x500Principal = certificate.getSubjectX500Principal();
            Intrinsics.checkNotNullExpressionValue((Object)x500Principal, (String)"getSubjectX500Principal(...)");
            X500Principal principal = x500Principal;
            String cn = this.extractCN(principal);
            if (cn != null) {
                return this.match(domain, cn);
            }
        }
        return false;
    }

    @Nullable
    protected final String extractCN(@NotNull X500Principal principal) {
        List list;
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        String string = principal.getName("RFC2253");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        CharSequence charSequence = string;
        Regex regex = new Regex(",");
        int n = 0;
        List $this$dropLastWhile$iv = regex.split(charSequence, n);
        boolean $i$f$dropLastWhile = false;
        if (!$this$dropLastWhile$iv.isEmpty()) {
            ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
            while (iterator$iv.hasPrevious()) {
                String it = (String)iterator$iv.previous();
                boolean bl = false;
                if (((CharSequence)it).length() == 0) continue;
                list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                break;
            }
        } else {
            list = CollectionsKt.emptyList();
        }
        Collection $this$toTypedArray$iv = list;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] dd = thisCollection$iv.toArray(new String[0]);
        int n2 = dd.length;
        for (int i = 0; i < n2; ++i) {
            String string2;
            String string3 = string2 = dd[i];
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
            String string4 = string3.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
            if (!StringsKt.startsWith$default((String)string4, (String)"cn=", (boolean)false, (int)2, null)) continue;
            String string5 = string2.substring(3);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
            return string5;
        }
        return null;
    }
}

