/*
 * Decompiled with CFR 0.152.
 */
package tigase.halcyon.core.connector.socket;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.net.Socket;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bouncycastle.tls.AbstractTlsKeyExchange;
import org.bouncycastle.tls.Certificate;
import org.bouncycastle.tls.DefaultTlsClient;
import org.bouncycastle.tls.ServerOnlyTlsAuthentication;
import org.bouncycastle.tls.TlsAuthentication;
import org.bouncycastle.tls.TlsClient;
import org.bouncycastle.tls.TlsClientProtocol;
import org.bouncycastle.tls.TlsKeyExchange;
import org.bouncycastle.tls.TlsServerCertificate;
import org.bouncycastle.tls.crypto.TlsCertificate;
import org.bouncycastle.tls.crypto.TlsCrypto;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tigase.halcyon.core.connector.socket.DefaultTLSProcessorKt;
import tigase.halcyon.core.connector.socket.SocketConnectorConfig;
import tigase.halcyon.core.connector.socket.TLSProcessor;
import tigase.halcyon.core.connector.socket.TLSProcessorFactory;
import tigase.halcyon.core.connector.socket.XMPPHostnameVerifier;
import tigase.halcyon.core.logger.Logger;
import tigase.halcyon.core.logger.LoggerFactory;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 (2\u00020\u0001:\u0002()B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\n\u0010\u0014\u001a\u0004\u0018\u00010\u0011H\u0016J\n\u0010\u0015\u001a\u0004\u0018\u00010\u0011H\u0016J\n\u0010\u0016\u001a\u0004\u0018\u00010\u0011H\u0016J\b\u0010\u0017\u001a\u00020\u000fH\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J&\u0010\u001a\u001a\u00020\u00192\u001c\u0010\u001b\u001a\u0018\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u00190\u001cj\u0002`\u001fH\u0016J\u001b\u0010 \u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010!\u001a\u00020\"H\u0002\u00a2\u0006\u0002\u0010#J\u0014\u0010$\u001a\u0004\u0018\u00010%2\b\u0010&\u001a\u0004\u0018\u00010'H\u0004R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Ltigase/halcyon/core/connector/socket/BouncyCastleTLSProcessor;", "Ltigase/halcyon/core/connector/socket/TLSProcessor;", "socket", "Ljava/net/Socket;", "config", "Ltigase/halcyon/core/connector/socket/SocketConnectorConfig;", "<init>", "(Ljava/net/Socket;Ltigase/halcyon/core/connector/socket/SocketConnectorConfig;)V", "log", "Ltigase/halcyon/core/logger/Logger;", "peerCertificates", "", "Ljava/security/cert/X509Certificate;", "[Ljava/security/cert/X509Certificate;", "secured", "", "tlsUnique", "", "tlsServerEndpoint", "tlsExporter", "getTlsUnique", "getTlsServerEndpoint", "getTlsExporter", "isConnectionSecure", "clear", "", "proceedTLS", "callback", "Lkotlin/Function2;", "Ljava/io/InputStream;", "Ljava/io/OutputStream;", "Ltigase/halcyon/core/connector/socket/TLSCallback;", "convertChain", "certificates", "Lorg/bouncycastle/tls/Certificate;", "(Lorg/bouncycastle/tls/Certificate;)[Ljava/security/cert/X509Certificate;", "getAuthType", "", "tlsKeyExchange", "Lorg/bouncycastle/tls/TlsKeyExchange;", "Companion", "XMPPServerAuthentication", "halcyon-bouncycastle"})
@SourceDebugExtension(value={"SMAP\nBouncyCastleTLSProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BouncyCastleTLSProcessor.kt\ntigase/halcyon/core/connector/socket/BouncyCastleTLSProcessor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,161:1\n1#2:162\n37#3,2:163\n*S KotlinDebug\n*F\n+ 1 BouncyCastleTLSProcessor.kt\ntigase/halcyon/core/connector/socket/BouncyCastleTLSProcessor\n*L\n100#1:163,2\n*E\n"})
public final class BouncyCastleTLSProcessor
implements TLSProcessor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Socket socket;
    @NotNull
    private final SocketConnectorConfig config;
    @NotNull
    private final Logger log;
    @Nullable
    private X509Certificate[] peerCertificates;
    private boolean secured;
    @Nullable
    private byte[] tlsUnique;
    @Nullable
    private byte[] tlsServerEndpoint;
    @Nullable
    private byte[] tlsExporter;
    @NotNull
    private static final String NAME = "BouncyCastleTLSProcessor";

    public BouncyCastleTLSProcessor(@NotNull Socket socket, @NotNull SocketConnectorConfig config) {
        Intrinsics.checkNotNullParameter((Object)socket, (String)"socket");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.socket = socket;
        this.config = config;
        this.log = LoggerFactory.logger$default((LoggerFactory)LoggerFactory.INSTANCE, (String)"tigase.halcyon.core.connector.socket.BouncyCastleTLSProcessor", (boolean)false, (int)2, null);
    }

    @Nullable
    public byte[] getTlsUnique() {
        return this.tlsUnique;
    }

    @Nullable
    public byte[] getTlsServerEndpoint() {
        byte[] byArray;
        if (this.tlsServerEndpoint != null) {
            return this.tlsServerEndpoint;
        }
        BouncyCastleTLSProcessor bouncyCastleTLSProcessor = this;
        Object object = this.peerCertificates;
        if (this.peerCertificates != null && (object = (X509Certificate)ArraysKt.first((Object[])object)) != null) {
            Object it = object;
            BouncyCastleTLSProcessor bouncyCastleTLSProcessor2 = bouncyCastleTLSProcessor;
            boolean bl = false;
            byArray = DefaultTLSProcessorKt.calculateCertificateHash((X509Certificate)it);
            bouncyCastleTLSProcessor = bouncyCastleTLSProcessor2;
        } else {
            byArray = null;
        }
        bouncyCastleTLSProcessor.tlsServerEndpoint = byArray;
        return this.tlsServerEndpoint;
    }

    @Nullable
    public byte[] getTlsExporter() {
        return this.tlsExporter;
    }

    public boolean isConnectionSecure() {
        return this.secured;
    }

    public void clear() {
        this.secured = false;
    }

    public void proceedTLS(@NotNull Function2<? super InputStream, ? super OutputStream, Unit> callback) {
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        this.log.info("Proceeding TLS with Bouncycastle");
        BcTlsCrypto tlsCrypto = new BcTlsCrypto(new SecureRandom());
        TlsClientProtocol tlsClientProtocol = new TlsClientProtocol(this.socket.getInputStream(), this.socket.getOutputStream());
        DefaultTlsClient tlsClient2 = new DefaultTlsClient(tlsCrypto, this){
            final /* synthetic */ BouncyCastleTLSProcessor this$0;
            {
                this.this$0 = $receiver;
                super((TlsCrypto)$tlsCrypto);
            }

            public TlsAuthentication getAuthentication() {
                return (TlsAuthentication)this.this$0.new XMPPServerAuthentication();
            }

            public void notifyHandshakeComplete() {
                block0: {
                    super.notifyHandshakeComplete();
                    BouncyCastleTLSProcessor.access$setSecured$p(this.this$0, true);
                    BouncyCastleTLSProcessor.access$setTlsExporter$p(this.this$0, this.context.exportChannelBinding(3));
                    BouncyCastleTLSProcessor.access$setTlsUnique$p(this.this$0, this.context.exportChannelBinding(1));
                    byte[] byArray = this.context.exportChannelBinding(0);
                    if (byArray == null) break block0;
                    byte[] byArray2 = byArray;
                    BouncyCastleTLSProcessor bouncyCastleTLSProcessor = this.this$0;
                    byte[] it = byArray2;
                    boolean bl = false;
                    BouncyCastleTLSProcessor.access$setTlsServerEndpoint$p(bouncyCastleTLSProcessor, it);
                }
            }
        };
        tlsClientProtocol.connect((TlsClient)tlsClient2);
        InputStream inputStream = tlsClientProtocol.getInputStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
        OutputStream outputStream = tlsClientProtocol.getOutputStream();
        Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"getOutputStream(...)");
        callback.invoke((Object)inputStream, (Object)outputStream);
    }

    private final X509Certificate[] convertChain(Certificate certificates) throws CertificateException, IOException {
        List result = new ArrayList();
        int n = certificates.getLength();
        for (int i = 0; i < n; ++i) {
            TlsCertificate cert = certificates.getCertificateAt(i);
            java.security.cert.Certificate jsCert = CertificateFactory.getInstance("X.509").generateCertificate(new ByteArrayInputStream(cert.getEncoded()));
            Collection collection = result;
            Intrinsics.checkNotNull((Object)jsCert, (String)"null cannot be cast to non-null type java.security.cert.X509Certificate");
            collection.add((X509Certificate)jsCert);
        }
        Collection $this$toTypedArray$iv = result;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new X509Certificate[0]);
    }

    @Nullable
    protected final String getAuthType(@Nullable TlsKeyExchange tlsKeyExchange) {
        Object object;
        try {
            Field keyExchangeField = AbstractTlsKeyExchange.class.getDeclaredField("keyExchange");
            keyExchangeField.setAccessible(true);
            Object v = keyExchangeField.get(tlsKeyExchange);
            int i = Integer.parseInt(v.toString());
            object = switch (i) {
                case 0 -> "NULL";
                case 1 -> "RSA";
                case 2 -> "RSA_EXPORT";
                case 3 -> "DHE_DSS";
                case 4 -> "DHE_DSS_EXPORT";
                case 5 -> "DHE_RSA";
                case 6 -> "DHE_RSA_EXPORT";
                case 7 -> "DH_DSS";
                case 8 -> "DH_DSS_EXPORT";
                case 9 -> "DH_RSA";
                case 10 -> "DH_RSA_EXPORT";
                case 11 -> "DH_anon";
                case 12 -> "DH_anon_EXPORT";
                case 13 -> "PSK";
                case 14 -> "DHE_PSK";
                case 15 -> "RSA_PSK";
                case 16 -> "ECDH_ECDSA";
                case 17 -> "ECDHE_ECDSA";
                case 18 -> "ECDH_RSA";
                case 19 -> "ECDHE_RSA";
                case 20 -> "ECDH_anon";
                case 21 -> "SRP";
                case 22 -> "SRP_DSS";
                case 23 -> "SRP_RSA";
                case 24 -> "ECDHE_PSK";
                default -> "UNKNOWN " + i;
            };
        }
        catch (Throwable e) {
            e.printStackTrace();
            object = null;
        }
        return object;
    }

    public static final /* synthetic */ void access$setSecured$p(BouncyCastleTLSProcessor $this, boolean bl) {
        $this.secured = bl;
    }

    public static final /* synthetic */ void access$setTlsExporter$p(BouncyCastleTLSProcessor $this, byte[] byArray) {
        $this.tlsExporter = byArray;
    }

    public static final /* synthetic */ void access$setTlsUnique$p(BouncyCastleTLSProcessor $this, byte[] byArray) {
        $this.tlsUnique = byArray;
    }

    public static final /* synthetic */ void access$setTlsServerEndpoint$p(BouncyCastleTLSProcessor $this, byte[] byArray) {
        $this.tlsServerEndpoint = byArray;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000e"}, d2={"Ltigase/halcyon/core/connector/socket/BouncyCastleTLSProcessor$Companion;", "Ltigase/halcyon/core/connector/socket/TLSProcessorFactory;", "<init>", "()V", "NAME", "", "getNAME", "()Ljava/lang/String;", "create", "Ltigase/halcyon/core/connector/socket/TLSProcessor;", "socket", "Ljava/net/Socket;", "config", "Ltigase/halcyon/core/connector/socket/SocketConnectorConfig;", "halcyon-bouncycastle"})
    public static final class Companion
    implements TLSProcessorFactory {
        private Companion() {
        }

        @NotNull
        public String getNAME() {
            return NAME;
        }

        @NotNull
        public TLSProcessor create(@NotNull Socket socket, @NotNull SocketConnectorConfig config) {
            Intrinsics.checkNotNullParameter((Object)socket, (String)"socket");
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            return new BouncyCastleTLSProcessor(socket, config);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016\u00a8\u0006\b"}, d2={"Ltigase/halcyon/core/connector/socket/BouncyCastleTLSProcessor$XMPPServerAuthentication;", "Lorg/bouncycastle/tls/ServerOnlyTlsAuthentication;", "<init>", "(Ltigase/halcyon/core/connector/socket/BouncyCastleTLSProcessor;)V", "notifyServerCertificate", "", "serverCertificate", "Lorg/bouncycastle/tls/TlsServerCertificate;", "halcyon-bouncycastle"})
    @SourceDebugExtension(value={"SMAP\nBouncyCastleTLSProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BouncyCastleTLSProcessor.kt\ntigase/halcyon/core/connector/socket/BouncyCastleTLSProcessor$XMPPServerAuthentication\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,161:1\n1#2:162\n*E\n"})
    public final class XMPPServerAuthentication
    extends ServerOnlyTlsAuthentication {
        /*
         * WARNING - void declaration
         */
        public void notifyServerCertificate(@Nullable TlsServerCertificate serverCertificate) {
            X509Certificate[] x509CertificateArray;
            BouncyCastleTLSProcessor bouncyCastleTLSProcessor;
            block6: {
                block5: {
                    void it;
                    bouncyCastleTLSProcessor = BouncyCastleTLSProcessor.this;
                    x509CertificateArray = serverCertificate;
                    if (serverCertificate == null || (x509CertificateArray = x509CertificateArray.getCertificate()) == null) break block5;
                    X509Certificate[] x509CertificateArray2 = x509CertificateArray;
                    BouncyCastleTLSProcessor bouncyCastleTLSProcessor2 = BouncyCastleTLSProcessor.this;
                    X509Certificate[] x509CertificateArray3 = x509CertificateArray2;
                    BouncyCastleTLSProcessor bouncyCastleTLSProcessor3 = bouncyCastleTLSProcessor;
                    boolean bl = false;
                    X509Certificate[] x509CertificateArray4 = bouncyCastleTLSProcessor2.convertChain((Certificate)it);
                    bouncyCastleTLSProcessor = bouncyCastleTLSProcessor3;
                    x509CertificateArray = x509CertificateArray4;
                    if (x509CertificateArray4 != null) break block6;
                }
                throw new SSLHandshakeException("Unrecognized server certificates list.");
            }
            bouncyCastleTLSProcessor.peerCertificates = x509CertificateArray;
            if (BouncyCastleTLSProcessor.this.config.getTrustManager() instanceof X509TrustManager) {
                TrustManager trustManager = BouncyCastleTLSProcessor.this.config.getTrustManager();
                Intrinsics.checkNotNull((Object)trustManager, (String)"null cannot be cast to non-null type javax.net.ssl.X509TrustManager");
                X509TrustManager x509TrustManager = (X509TrustManager)trustManager;
                X509Certificate[] x509CertificateArray5 = BouncyCastleTLSProcessor.this.peerCertificates;
                Intrinsics.checkNotNull((Object)x509CertificateArray5);
                x509TrustManager.checkServerTrusted(x509CertificateArray5, "");
            }
            XMPPHostnameVerifier xMPPHostnameVerifier = BouncyCastleTLSProcessor.this.config.getHostnameVerifier();
            String string = BouncyCastleTLSProcessor.this.config.getDomain();
            Object[] objectArray = BouncyCastleTLSProcessor.this.peerCertificates;
            Intrinsics.checkNotNull((Object)objectArray);
            if (!xMPPHostnameVerifier.verify(string, (java.security.cert.Certificate)ArraysKt.first((Object[])objectArray))) {
                throw new SSLHandshakeException("Certificate hostname doesn't match domain name you want to connect.");
            }
        }
    }
}

