/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.httpclient;

import feign.Response;
import java.util.List;
import org.apache.james.webadmin.httpclient.FeignHelper;
import org.apache.james.webadmin.httpclient.feign.JamesFeignException;
import org.apache.james.webadmin.httpclient.feign.MailboxFeignClient;
import org.apache.james.webadmin.httpclient.model.MailboxName;

public class MailboxClient {
    private final MailboxFeignClient feignClient;

    public MailboxClient(MailboxFeignClient feignClient) {
        this.feignClient = feignClient;
    }

    public void createAMailbox(String username, String mailboxName) {
        try (Response response = this.feignClient.createAMailbox(username, mailboxName);){
            FeignHelper.checkResponse(response.status() == 204, "Create a mailbox failed. " + FeignHelper.extractBody(response));
        }
    }

    public boolean doesExist(String username, String mailboxName) {
        try (Response response = this.feignClient.doesExist(username, mailboxName);){
            switch (response.status()) {
                case 204: {
                    boolean bl = true;
                    return bl;
                }
                case 404: {
                    boolean bl = false;
                    return bl;
                }
            }
            throw new JamesFeignException("Check a mailbox exist failed. " + FeignHelper.extractBody(response));
        }
    }

    public List<MailboxName> getMailboxList(String username) {
        return this.feignClient.getMailboxList(username);
    }

    public void deleteAMailbox(String username, String mailboxName) {
        try (Response response = this.feignClient.deleteAMailbox(username, mailboxName);){
            FeignHelper.checkResponse(response.status() == 204, "Delete a mailbox failed. " + FeignHelper.extractBody(response));
        }
    }

    public void deleteAllMailboxes(String username) {
        try (Response response = this.feignClient.deleteAllMailboxes(username);){
            switch (response.status()) {
                case 204: {
                    return;
                }
                case 404: {
                    throw new JamesFeignException("The user name does not exist.");
                }
            }
            throw new JamesFeignException("Delete all mailboxes failed. " + FeignHelper.extractBody(response));
        }
    }
}

