/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.httpclient;

import feign.Response;
import java.util.List;
import org.apache.james.webadmin.httpclient.FeignHelper;
import org.apache.james.webadmin.httpclient.feign.DomainFeignClient;
import org.apache.james.webadmin.httpclient.feign.JamesFeignException;
import org.apache.james.webadmin.httpclient.model.DomainAlias;

public class DomainClient {
    private final DomainFeignClient feignClient;

    public DomainClient(DomainFeignClient feignClient) {
        this.feignClient = feignClient;
    }

    public List<String> getDomainList() {
        return this.feignClient.getDomainList();
    }

    public void createADomain(String domain) {
        try (Response response = this.feignClient.createADomain(domain);){
            FeignHelper.checkResponse(response.status() == 204, "Create domain failed. " + FeignHelper.extractBody(response));
        }
    }

    public void deleteADomain(String domain) {
        try (Response response = this.feignClient.deleteADomain(domain);){
            FeignHelper.checkResponse(response.status() == 204, "Delete domain failed. " + FeignHelper.extractBody(response));
        }
    }

    public boolean doesExist(String domain) {
        try (Response response = this.feignClient.doesExist(domain);){
            switch (response.status()) {
                case 204: {
                    boolean bl = true;
                    return bl;
                }
                case 404: {
                    boolean bl = false;
                    return bl;
                }
            }
            throw new JamesFeignException("Check domain exist failed. " + FeignHelper.extractBody(response));
        }
    }

    public void deleteADomainAlias(String destinationDomain, String sourceDomain) {
        try (Response response = this.feignClient.deleteADomainAlias(destinationDomain, sourceDomain);){
            FeignHelper.checkResponse(response.status() == 204, "Delete a domain alias failed. " + FeignHelper.extractBody(response));
        }
    }

    public void addADomainAlias(String destinationDomain, String sourceDomain) {
        try (Response response = this.feignClient.addADomainAlias(destinationDomain, sourceDomain);){
            FeignHelper.checkResponse(response.status() == 204, "Create a domain alias failed. " + FeignHelper.extractBody(response));
        }
    }

    public List<DomainAlias> getDomainAliasList(String domain) {
        return this.feignClient.getDomainAliasList(domain);
    }
}

