/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.cli.user;

import java.util.concurrent.Callable;
import org.apache.james.cli.user.UserCommand;
import org.apache.james.webadmin.httpclient.UserClient;
import org.apache.james.webadmin.httpclient.feign.JamesFeignException;
import picocli.CommandLine;

@CommandLine.Command(name="exist", description={"Check if a user exists"})
public class UserExistCommand
implements Callable<Integer> {
    @CommandLine.ParentCommand
    UserCommand userCommand;
    @CommandLine.Parameters
    String userName;

    @Override
    public Integer call() {
        try {
            UserClient userClient = this.userCommand.fullyQualifiedURL("/users");
            if (userClient.doesExist(this.userName)) {
                this.userCommand.out.println(this.userName + " exists");
            } else {
                this.userCommand.out.println(this.userName + " does not exist");
            }
            return 0;
        }
        catch (Exception e) {
            if (e instanceof JamesFeignException) {
                this.userCommand.out.println(e.getMessage());
            } else {
                e.printStackTrace(this.userCommand.err);
            }
            return 1;
        }
    }
}

