/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.cli.quota;

import java.util.Optional;
import java.util.concurrent.Callable;
import org.apache.james.cli.quota.GlobalQuotaCountCommand;
import org.apache.james.webadmin.httpclient.QuotaClient;
import picocli.CommandLine;

@CommandLine.Command(name="get", description={"Get quota counts limit that applies for all users"})
public class GetGlobalQuotaCountCommand
implements Callable<Integer> {
    @CommandLine.ParentCommand
    GlobalQuotaCountCommand parentCommand;

    @Override
    public Integer call() {
        try {
            QuotaClient quotaClient = this.parentCommand.parentCommand.quotaCommand.fullyQualifiedURL();
            String message = Optional.ofNullable(quotaClient.getQuotaCount()).map(Object::toString).orElse("No global quota defined");
            this.parentCommand.parentCommand.quotaCommand.out.println(message);
            return 0;
        }
        catch (Exception e) {
            e.printStackTrace(this.parentCommand.parentCommand.quotaCommand.err);
            return 1;
        }
    }
}

