/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.cli.mailbox;

import java.util.concurrent.Callable;
import org.apache.james.cli.mailbox.MailboxCommand;
import org.apache.james.webadmin.httpclient.feign.JamesFeignException;
import picocli.CommandLine;

@CommandLine.Command(name="delete", description={"Delete a mailbox and its children"})
public class MailboxDeleteCommand
implements Callable<Integer> {
    @CommandLine.ParentCommand
    MailboxCommand mailboxCommand;
    @CommandLine.Parameters(description={"Username"})
    String userName;
    @CommandLine.Parameters(description={"Mailbox's name to be deleted"})
    String mailboxName;

    @Override
    public Integer call() {
        try {
            this.mailboxCommand.fullyQualifiedURL("/users").deleteAMailbox(this.userName, this.mailboxName);
            this.mailboxCommand.out.println("The mailbox now does not exist on the server.");
            return 0;
        }
        catch (Exception e) {
            if (e instanceof JamesFeignException) {
                this.mailboxCommand.err.println(e.getMessage());
            } else {
                e.printStackTrace(this.mailboxCommand.err);
            }
            return 1;
        }
    }
}

