/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.lambdas.functions;

import com.github.fge.lambdas.Chainer;
import com.github.fge.lambdas.functions.ThrowingFunction;
import java.util.function.Function;

public class FunctionChainer<T, R>
extends Chainer<Function<T, R>, ThrowingFunction<T, R>, FunctionChainer<T, R>>
implements ThrowingFunction<T, R> {
    public FunctionChainer(ThrowingFunction<T, R> function) {
        super(function);
    }

    @Override
    public R doApply(T t2) throws Throwable {
        return ((ThrowingFunction)this.throwing).doApply(t2);
    }

    @Override
    public FunctionChainer<T, R> orTryWith(ThrowingFunction<T, R> other) {
        ThrowingFunction<Object, Object> function = t2 -> {
            try {
                return ((ThrowingFunction)this.throwing).doApply(t2);
            }
            catch (Error | RuntimeException e) {
                throw e;
            }
            catch (Throwable ignored) {
                return other.doApply(t2);
            }
        };
        return new FunctionChainer<Object, Object>(function);
    }

    @Override
    public <E extends RuntimeException> ThrowingFunction<T, R> orThrow(Class<E> exclass) {
        return t2 -> {
            try {
                return ((ThrowingFunction)this.throwing).doApply(t2);
            }
            catch (Error | RuntimeException e) {
                throw e;
            }
            catch (Throwable throwable) {
                throw FunctionChainer.rethrow(exclass, throwable);
            }
        };
    }

    @Override
    public Function<T, R> fallbackTo(Function<T, R> fallback) {
        return t2 -> {
            try {
                return this.doApply(t2);
            }
            catch (Error | RuntimeException e) {
                throw e;
            }
            catch (Throwable ignored) {
                return fallback.apply(t2);
            }
        };
    }

    @Override
    public Function<T, R> sneakyThrow() {
        return t2 -> {
            try {
                return ((ThrowingFunction)this.throwing).doApply(t2);
            }
            catch (Error | RuntimeException e) {
                throw e;
            }
            catch (Throwable throwable) {
                throw FunctionChainer.doSneakyThrow(throwable);
            }
        };
    }

    public Function<T, R> orReturn(R retval) {
        return t2 -> {
            try {
                return this.doApply(t2);
            }
            catch (Error | RuntimeException e) {
                throw e;
            }
            catch (Throwable ignored) {
                return retval;
            }
        };
    }
}

