/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailet;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.james.mailet.DefaultDescriptorsExtractor;
import org.apache.james.mailet.MailetMatcherDescriptor;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class DefaultDescriptorsExtractorTest {
    MavenProject mavenProject;
    Log log;
    DefaultDescriptorsExtractor testee;

    DefaultDescriptorsExtractorTest() {
    }

    @BeforeEach
    void setup() {
        this.mavenProject = (MavenProject)Mockito.mock(MavenProject.class);
        this.log = (Log)Mockito.mock(Log.class);
        this.testee = new DefaultDescriptorsExtractor();
    }

    @Test
    void extractShouldSetExperimentalAttributeWhenScanningMailets() {
        Mockito.when((Object)this.mavenProject.getCompileSourceRoots()).thenReturn((Object)ImmutableList.of((Object)"src/test/java/org/apache/james/mailet/experimental"));
        List descriptors = this.testee.extract(this.mavenProject, this.log).descriptors();
        MailetMatcherDescriptor experimentalMailet = MailetMatcherDescriptor.builder().name("ExperimentalMailet").fullyQualifiedClassName("org.apache.james.mailet.experimental.ExperimentalMailet").type(MailetMatcherDescriptor.Type.MAILET).noInfo().noClassDocs().isExperimental();
        MailetMatcherDescriptor nonExperimentalMailet = MailetMatcherDescriptor.builder().name("NonExperimentalMailet").fullyQualifiedClassName("org.apache.james.mailet.experimental.NonExperimentalMailet").type(MailetMatcherDescriptor.Type.MAILET).noInfo().noClassDocs().isNotExperimental();
        Assertions.assertThat((List)descriptors).containsOnly((Object[])new MailetMatcherDescriptor[]{experimentalMailet, nonExperimentalMailet});
    }

    @Test
    void extractShouldSupportArgumentsInConstructor() {
        Mockito.when((Object)this.mavenProject.getCompileSourceRoots()).thenReturn((Object)ImmutableList.of((Object)"src/test/java/org/apache/james/mailet/constructor"));
        List descriptors = this.testee.extract(this.mavenProject, this.log).descriptors();
        MailetMatcherDescriptor mailet = MailetMatcherDescriptor.builder().name("ConstructorMailet").fullyQualifiedClassName("org.apache.james.mailet.constructor.ConstructorMailet").type(MailetMatcherDescriptor.Type.MAILET).info("info").noClassDocs().isNotExperimental();
        Assertions.assertThat((List)descriptors).containsOnly((Object[])new MailetMatcherDescriptor[]{mailet});
    }

    @Test
    void extractShouldExcludeAnnotatedClassesWhenScanningMailets() {
        Mockito.when((Object)this.mavenProject.getCompileSourceRoots()).thenReturn((Object)ImmutableList.of((Object)"src/test/java/org/apache/james/mailet/excluded"));
        List descriptors = this.testee.extract(this.mavenProject, this.log).descriptors();
        MailetMatcherDescriptor notExcludedMailet = MailetMatcherDescriptor.builder().name("NotExcludedFromDocumentationMailet").fullyQualifiedClassName("org.apache.james.mailet.excluded.NotExcludedFromDocumentationMailet").type(MailetMatcherDescriptor.Type.MAILET).noInfo().noClassDocs().isNotExperimental();
        Assertions.assertThat((List)descriptors).containsOnly((Object[])new MailetMatcherDescriptor[]{notExcludedMailet});
    }
}

