/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.webadmin;

import com.github.fge.lambdas.Throwing;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import jakarta.inject.Inject;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.james.protocols.lib.netty.CertificateReloadable;
import org.apache.james.util.Port;
import org.apache.james.webadmin.Routes;
import org.apache.james.webadmin.utils.ErrorResponder;
import org.apache.james.webadmin.utils.Responses;
import spark.Request;
import spark.Response;
import spark.Service;

public class ProtocolServerRoutes
implements Routes {
    public static final String SERVERS = "servers";
    private final Set<CertificateReloadable.Factory> servers;

    @Inject
    public ProtocolServerRoutes(Set<CertificateReloadable.Factory> servers) {
        this.servers = servers;
    }

    public String getBasePath() {
        return SERVERS;
    }

    public void define(Service service) {
        service.post(SERVERS, (request, response) -> {
            Preconditions.checkArgument((boolean)request.queryParams().contains("reload-certificate"), (Object)"'reload-certificate' query parameter shall be specified");
            if (this.noServerEnabled()) {
                return ErrorResponder.builder().statusCode(400).type(ErrorResponder.ErrorType.NOT_FOUND).message("No servers configured, nothing to reload").haltError();
            }
            this.servers.stream().flatMap(CertificateReloadable.Factory::certificatesReloadable).filter(this.filters(request)).forEach((Consumer<CertificateReloadable>)Throwing.consumer(CertificateReloadable::reloadSSLCertificate));
            return Responses.returnNoContent((Response)response);
        });
    }

    private Predicate<CertificateReloadable> filters(Request request) {
        Optional<Port> port = Optional.ofNullable(request.queryParams("port")).map(Integer::parseUnsignedInt).map(Port::of);
        return server -> port.map(p -> server.getPort() == p.getValue()).orElse(true);
    }

    private boolean noServerEnabled() {
        return this.servers.stream().flatMap(CertificateReloadable.Factory::certificatesReloadable).findFirst().isEmpty();
    }
}

