/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.events;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import jakarta.inject.Inject;
import java.util.Collection;
import java.util.HashMap;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.james.events.Event;
import org.apache.james.events.EventBus;
import org.apache.james.events.EventBusName;
import org.apache.james.events.EventDeadLetters;
import org.apache.james.events.EventListener;
import org.apache.james.events.Group;
import org.apache.james.events.GroupAlreadyRegistered;
import org.apache.james.events.GroupRegistrationNotFound;
import org.apache.james.events.Registration;
import org.apache.james.events.RegistrationKey;
import org.apache.james.events.RetryBackoffConfiguration;
import org.apache.james.events.delivery.EventDelivery;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class InVMEventBus
implements EventBus {
    public static EventBusName IN_VN_EVENTBUS_NAME = new EventBusName("InVMEventBus");
    private final Multimap<RegistrationKey, EventListener.ReactiveEventListener> registrations;
    private final ConcurrentHashMap<Group, EventListener.ReactiveEventListener> groups;
    private final EventDelivery eventDelivery;
    private final RetryBackoffConfiguration retryBackoff;
    private final EventDeadLetters eventDeadLetters;

    @Inject
    public InVMEventBus(EventDelivery eventDelivery, RetryBackoffConfiguration retryBackoff, EventDeadLetters eventDeadLetters) {
        this.eventDelivery = eventDelivery;
        this.retryBackoff = retryBackoff;
        this.eventDeadLetters = eventDeadLetters;
        this.registrations = Multimaps.synchronizedSetMultimap((SetMultimap)Multimaps.newSetMultimap(new HashMap(), ConcurrentHashMap::newKeySet));
        this.groups = new ConcurrentHashMap();
    }

    public Mono<Registration> register(EventListener.ReactiveEventListener listener, RegistrationKey key) {
        this.registrations.put((Object)key, (Object)listener);
        return Mono.just(() -> Mono.fromRunnable(() -> this.registrations.remove((Object)key, (Object)listener)));
    }

    public Registration register(EventListener.ReactiveEventListener listener, Group group) {
        EventListener previous = (EventListener)this.groups.putIfAbsent(group, listener);
        if (previous == null) {
            return () -> Mono.fromRunnable(() -> this.groups.remove(group, listener));
        }
        throw new GroupAlreadyRegistered(group);
    }

    public Mono<Void> dispatch(Event event, Set<RegistrationKey> keys) {
        if (!event.isNoop()) {
            return Flux.merge((Publisher[])new Publisher[]{this.groupDeliveries(event), this.keyDeliveries(event, keys)}).then().onErrorResume(throwable -> Mono.empty());
        }
        return Mono.empty();
    }

    public Mono<Void> reDeliver(Group group, Event event) {
        if (!event.isNoop()) {
            return this.groupDelivery(event, this.retrieveListenerFromGroup(group), group);
        }
        return Mono.empty();
    }

    public EventBusName eventBusName() {
        return IN_VN_EVENTBUS_NAME;
    }

    public Collection<Group> listRegisteredGroups() {
        return this.groups.keySet();
    }

    private EventListener.ReactiveEventListener retrieveListenerFromGroup(Group group) {
        return Optional.ofNullable(this.groups.get(group)).orElseThrow(() -> new GroupRegistrationNotFound(group));
    }

    private Mono<Void> keyDeliveries(Event event, Set<RegistrationKey> keys) {
        return Flux.fromIterable(this.registeredListenersByKeys(keys)).flatMap(listener -> this.eventDelivery.deliver((EventListener.ReactiveEventListener)listener, event, EventDelivery.DeliveryOption.none()), 10).then();
    }

    private Mono<Void> groupDeliveries(Event event) {
        return Flux.fromIterable(this.groups.entrySet()).flatMap(entry -> this.groupDelivery(event, (EventListener.ReactiveEventListener)entry.getValue(), (Group)entry.getKey()), 10).then();
    }

    private Mono<Void> groupDelivery(Event event, EventListener.ReactiveEventListener listener, Group group) {
        return this.eventDelivery.deliver(listener, event, EventDelivery.DeliveryOption.of(EventDelivery.Retryer.BackoffRetryer.of(this.retryBackoff, (EventListener)listener), EventDelivery.PermanentFailureHandler.StoreToDeadLetters.of(group, this.eventDeadLetters)));
    }

    public Set<Group> registeredGroups() {
        return this.groups.keySet();
    }

    private Set<EventListener.ReactiveEventListener> registeredListenersByKeys(Set<RegistrationKey> keys) {
        return (Set)keys.stream().flatMap(registrationKey -> this.registrations.get(registrationKey).stream()).collect(ImmutableSet.toImmutableSet());
    }
}

