/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.sieve.jpa.model;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Id;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.Table;
import java.time.OffsetDateTime;
import java.util.Objects;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.james.sieverepository.api.ScriptContent;
import org.apache.james.sieverepository.api.ScriptName;
import org.apache.james.sieverepository.api.ScriptSummary;
import org.apache.openjpa.enhance.FieldConsumer;
import org.apache.openjpa.enhance.FieldSupplier;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.RedefinitionHelper;
import org.apache.openjpa.enhance.StateManager;
import org.apache.openjpa.util.InternalException;
import org.apache.openjpa.util.StringId;

@Entity(name="JamesSieveScript")
@Table(name="JAMES_SIEVE_SCRIPT")
@NamedQueries(value={@NamedQuery(name="findAllByUsername", query="SELECT sieveScript FROM JamesSieveScript sieveScript WHERE sieveScript.username=:username"), @NamedQuery(name="findActiveByUsername", query="SELECT sieveScript FROM JamesSieveScript sieveScript WHERE sieveScript.username=:username AND sieveScript.isActive=true"), @NamedQuery(name="findSieveScript", query="SELECT sieveScript FROM JamesSieveScript sieveScript WHERE sieveScript.username=:username AND sieveScript.scriptName=:scriptName")})
public class JPASieveScript
implements PersistenceCapable {
    @Id
    private String uuid = UUID.randomUUID().toString();
    @Column(name="USER_NAME", nullable=false, length=100)
    private String username;
    @Column(name="SCRIPT_NAME", nullable=false, length=255)
    private String scriptName;
    @Column(name="SCRIPT_CONTENT", nullable=false, length=1024)
    private String scriptContent;
    @Column(name="SCRIPT_SIZE", nullable=false)
    private long scriptSize;
    @Column(name="IS_ACTIVE", nullable=false)
    private boolean isActive;
    @Column(name="ACTIVATION_DATE_TIME")
    private OffsetDateTime activationDateTime;
    private static int pcInheritedFieldCount;
    private static String[] pcFieldNames;
    private static Class[] pcFieldTypes;
    private static byte[] pcFieldFlags;
    private static Class pcPCSuperclass;
    protected transient StateManager pcStateManager;
    private transient Object pcDetachedState;

    public static Builder builder() {
        return new Builder();
    }

    public static ScriptSummary toSummary(JPASieveScript script) {
        return new ScriptSummary(new ScriptName(script.getScriptName()), script.isActive(), script.getScriptSize());
    }

    @Deprecated
    protected JPASieveScript() {
    }

    private JPASieveScript(String username, String scriptName, String scriptContent, long scriptSize, boolean isActive, OffsetDateTime activationDateTime) {
        this.username = username;
        this.scriptName = scriptName;
        this.scriptContent = scriptContent;
        this.scriptSize = scriptSize;
        this.isActive = isActive;
        this.activationDateTime = activationDateTime;
    }

    public String getUsername() {
        return JPASieveScript.pcGetusername(this);
    }

    public String getScriptName() {
        return JPASieveScript.pcGetscriptName(this);
    }

    public String getScriptContent() {
        return JPASieveScript.pcGetscriptContent(this);
    }

    public long getScriptSize() {
        return JPASieveScript.pcGetscriptSize(this);
    }

    public boolean isActive() {
        return JPASieveScript.pcGetisActive(this);
    }

    public OffsetDateTime getActivationDateTime() {
        return JPASieveScript.pcGetactivationDateTime(this);
    }

    public void activate() {
        JPASieveScript.pcSetisActive(this, true);
        JPASieveScript.pcSetactivationDateTime(this, OffsetDateTime.now());
    }

    public void deactivate() {
        JPASieveScript.pcSetisActive(this, false);
        JPASieveScript.pcSetactivationDateTime(this, null);
    }

    public void renameTo(ScriptName newName) {
        JPASieveScript.pcSetscriptName(this, newName.getValue());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JPASieveScript that = (JPASieveScript)o;
        return Objects.equals(JPASieveScript.pcGetuuid(this), JPASieveScript.pcGetuuid(that));
    }

    public int hashCode() {
        return Objects.hash(JPASieveScript.pcGetuuid(this));
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("uuid", (Object)JPASieveScript.pcGetuuid(this)).add("username", (Object)JPASieveScript.pcGetusername(this)).add("scriptName", (Object)JPASieveScript.pcGetscriptName(this)).add("isActive", JPASieveScript.pcGetisActive(this)).toString();
    }

    public int pcGetEnhancementContractVersion() {
        return 106714633;
    }

    static {
        pcFieldNames = new String[]{"activationDateTime", "isActive", "scriptContent", "scriptName", "scriptSize", "username", "uuid"};
        pcFieldTypes = new Class[]{OffsetDateTime.class, Boolean.TYPE, String.class, String.class, Long.TYPE, String.class, String.class};
        pcFieldFlags = new byte[]{26, 26, 26, 26, 26, 26, 26};
        PCRegistry.register(JPASieveScript.class, (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, (String)"JamesSieveScript", (PersistenceCapable)new JPASieveScript());
    }

    protected void pcClearFields() {
        this.activationDateTime = null;
        this.isActive = false;
        this.scriptContent = null;
        this.scriptName = null;
        this.scriptSize = 0L;
        this.username = null;
        this.uuid = null;
    }

    public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
        JPASieveScript jPASieveScript = new JPASieveScript();
        if (bl) {
            jPASieveScript.pcClearFields();
        }
        jPASieveScript.pcStateManager = stateManager;
        jPASieveScript.pcCopyKeyFieldsFromObjectId(object);
        return jPASieveScript;
    }

    public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
        JPASieveScript jPASieveScript = new JPASieveScript();
        if (bl) {
            jPASieveScript.pcClearFields();
        }
        jPASieveScript.pcStateManager = stateManager;
        return jPASieveScript;
    }

    protected static int pcGetManagedFieldCount() {
        return 7;
    }

    public void pcReplaceField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.activationDateTime = (OffsetDateTime)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 1: {
                this.isActive = this.pcStateManager.replaceBooleanField((PersistenceCapable)this, n);
                return;
            }
            case 2: {
                this.scriptContent = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 3: {
                this.scriptName = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 4: {
                this.scriptSize = this.pcStateManager.replaceLongField((PersistenceCapable)this, n);
                return;
            }
            case 5: {
                this.username = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 6: {
                this.uuid = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcReplaceFields(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            this.pcReplaceField(nArray[i]);
        }
    }

    public void pcProvideField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.activationDateTime);
                return;
            }
            case 1: {
                this.pcStateManager.providedBooleanField((PersistenceCapable)this, n, this.isActive);
                return;
            }
            case 2: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.scriptContent);
                return;
            }
            case 3: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.scriptName);
                return;
            }
            case 4: {
                this.pcStateManager.providedLongField((PersistenceCapable)this, n, this.scriptSize);
                return;
            }
            case 5: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.username);
                return;
            }
            case 6: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.uuid);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcProvideFields(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            this.pcProvideField(nArray[i]);
        }
    }

    protected void pcCopyField(JPASieveScript jPASieveScript, int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.activationDateTime = jPASieveScript.activationDateTime;
                return;
            }
            case 1: {
                this.isActive = jPASieveScript.isActive;
                return;
            }
            case 2: {
                this.scriptContent = jPASieveScript.scriptContent;
                return;
            }
            case 3: {
                this.scriptName = jPASieveScript.scriptName;
                return;
            }
            case 4: {
                this.scriptSize = jPASieveScript.scriptSize;
                return;
            }
            case 5: {
                this.username = jPASieveScript.username;
                return;
            }
            case 6: {
                this.uuid = jPASieveScript.uuid;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcCopyFields(Object object, int[] nArray) {
        JPASieveScript jPASieveScript = (JPASieveScript)object;
        if (jPASieveScript.pcStateManager != this.pcStateManager) {
            throw new IllegalArgumentException();
        }
        if (this.pcStateManager == null) {
            throw new IllegalStateException();
        }
        for (int i = 0; i < nArray.length; ++i) {
            this.pcCopyField(jPASieveScript, nArray[i]);
        }
    }

    public Object pcGetGenericContext() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.getGenericContext();
    }

    public Object pcFetchObjectId() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.fetchObjectId();
    }

    public boolean pcIsDeleted() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isDeleted();
    }

    public boolean pcIsDirty() {
        if (this.pcStateManager == null) {
            return false;
        }
        StateManager stateManager = this.pcStateManager;
        RedefinitionHelper.dirtyCheck((StateManager)stateManager);
        return stateManager.isDirty();
    }

    public boolean pcIsNew() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isNew();
    }

    public boolean pcIsPersistent() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isPersistent();
    }

    public boolean pcIsTransactional() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isTransactional();
    }

    public boolean pcSerializing() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.serializing();
    }

    public void pcDirty(String string) {
        if (this.pcStateManager == null) {
            return;
        }
        this.pcStateManager.dirty(string);
    }

    public StateManager pcGetStateManager() {
        return this.pcStateManager;
    }

    public Object pcGetVersion() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.getVersion();
    }

    public void pcReplaceStateManager(StateManager stateManager) throws SecurityException {
        if (this.pcStateManager != null) {
            this.pcStateManager = this.pcStateManager.replaceStateManager(stateManager);
            return;
        }
        this.pcStateManager = stateManager;
    }

    public void pcCopyKeyFieldsToObjectId(FieldSupplier fieldSupplier, Object object) {
        throw new InternalException();
    }

    public void pcCopyKeyFieldsToObjectId(Object object) {
        throw new InternalException();
    }

    public void pcCopyKeyFieldsFromObjectId(FieldConsumer fieldConsumer, Object object) {
        StringId stringId = (StringId)object;
        fieldConsumer.storeStringField(6 + pcInheritedFieldCount, stringId.getId());
    }

    public void pcCopyKeyFieldsFromObjectId(Object object) {
        StringId stringId = (StringId)object;
        this.uuid = stringId.getId();
    }

    public Object pcNewObjectIdInstance(Object object) {
        return new StringId(JPASieveScript.class, (String)object);
    }

    public Object pcNewObjectIdInstance() {
        return new StringId(JPASieveScript.class, this.uuid);
    }

    private static final OffsetDateTime pcGetactivationDateTime(JPASieveScript jPASieveScript) {
        if (jPASieveScript.pcStateManager == null) {
            return jPASieveScript.activationDateTime;
        }
        int n = pcInheritedFieldCount + 0;
        jPASieveScript.pcStateManager.accessingField(n);
        return jPASieveScript.activationDateTime;
    }

    private static final void pcSetactivationDateTime(JPASieveScript jPASieveScript, OffsetDateTime offsetDateTime) {
        if (jPASieveScript.pcStateManager == null) {
            jPASieveScript.activationDateTime = offsetDateTime;
            return;
        }
        jPASieveScript.pcStateManager.settingObjectField((PersistenceCapable)jPASieveScript, pcInheritedFieldCount + 0, (Object)jPASieveScript.activationDateTime, (Object)offsetDateTime, 0);
    }

    private static final boolean pcGetisActive(JPASieveScript jPASieveScript) {
        if (jPASieveScript.pcStateManager == null) {
            return jPASieveScript.isActive;
        }
        int n = pcInheritedFieldCount + 1;
        jPASieveScript.pcStateManager.accessingField(n);
        return jPASieveScript.isActive;
    }

    private static final void pcSetisActive(JPASieveScript jPASieveScript, boolean bl) {
        if (jPASieveScript.pcStateManager == null) {
            jPASieveScript.isActive = bl;
            return;
        }
        jPASieveScript.pcStateManager.settingBooleanField((PersistenceCapable)jPASieveScript, pcInheritedFieldCount + 1, jPASieveScript.isActive, bl, 0);
    }

    private static final String pcGetscriptContent(JPASieveScript jPASieveScript) {
        if (jPASieveScript.pcStateManager == null) {
            return jPASieveScript.scriptContent;
        }
        int n = pcInheritedFieldCount + 2;
        jPASieveScript.pcStateManager.accessingField(n);
        return jPASieveScript.scriptContent;
    }

    private static final void pcSetscriptContent(JPASieveScript jPASieveScript, String string) {
        if (jPASieveScript.pcStateManager == null) {
            jPASieveScript.scriptContent = string;
            return;
        }
        jPASieveScript.pcStateManager.settingStringField((PersistenceCapable)jPASieveScript, pcInheritedFieldCount + 2, jPASieveScript.scriptContent, string, 0);
    }

    private static final String pcGetscriptName(JPASieveScript jPASieveScript) {
        if (jPASieveScript.pcStateManager == null) {
            return jPASieveScript.scriptName;
        }
        int n = pcInheritedFieldCount + 3;
        jPASieveScript.pcStateManager.accessingField(n);
        return jPASieveScript.scriptName;
    }

    private static final void pcSetscriptName(JPASieveScript jPASieveScript, String string) {
        if (jPASieveScript.pcStateManager == null) {
            jPASieveScript.scriptName = string;
            return;
        }
        jPASieveScript.pcStateManager.settingStringField((PersistenceCapable)jPASieveScript, pcInheritedFieldCount + 3, jPASieveScript.scriptName, string, 0);
    }

    private static final long pcGetscriptSize(JPASieveScript jPASieveScript) {
        if (jPASieveScript.pcStateManager == null) {
            return jPASieveScript.scriptSize;
        }
        int n = pcInheritedFieldCount + 4;
        jPASieveScript.pcStateManager.accessingField(n);
        return jPASieveScript.scriptSize;
    }

    private static final void pcSetscriptSize(JPASieveScript jPASieveScript, long l) {
        if (jPASieveScript.pcStateManager == null) {
            jPASieveScript.scriptSize = l;
            return;
        }
        jPASieveScript.pcStateManager.settingLongField((PersistenceCapable)jPASieveScript, pcInheritedFieldCount + 4, jPASieveScript.scriptSize, l, 0);
    }

    private static final String pcGetusername(JPASieveScript jPASieveScript) {
        if (jPASieveScript.pcStateManager == null) {
            return jPASieveScript.username;
        }
        int n = pcInheritedFieldCount + 5;
        jPASieveScript.pcStateManager.accessingField(n);
        return jPASieveScript.username;
    }

    private static final void pcSetusername(JPASieveScript jPASieveScript, String string) {
        if (jPASieveScript.pcStateManager == null) {
            jPASieveScript.username = string;
            return;
        }
        jPASieveScript.pcStateManager.settingStringField((PersistenceCapable)jPASieveScript, pcInheritedFieldCount + 5, jPASieveScript.username, string, 0);
    }

    private static final String pcGetuuid(JPASieveScript jPASieveScript) {
        if (jPASieveScript.pcStateManager == null) {
            return jPASieveScript.uuid;
        }
        int n = pcInheritedFieldCount + 6;
        jPASieveScript.pcStateManager.accessingField(n);
        return jPASieveScript.uuid;
    }

    private static final void pcSetuuid(JPASieveScript jPASieveScript, String string) {
        if (jPASieveScript.pcStateManager == null) {
            jPASieveScript.uuid = string;
            return;
        }
        jPASieveScript.pcStateManager.settingStringField((PersistenceCapable)jPASieveScript, pcInheritedFieldCount + 6, jPASieveScript.uuid, string, 0);
    }

    public Boolean pcIsDetached() {
        if (this.pcStateManager != null) {
            if (this.pcStateManager.isDetached()) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        if (this.pcGetDetachedState() != null && this.pcGetDetachedState() != PersistenceCapable.DESERIALIZED) {
            return Boolean.TRUE;
        }
        if (!this.pcisDetachedStateDefinitive()) {
            return null;
        }
        return Boolean.FALSE;
    }

    private boolean pcisDetachedStateDefinitive() {
        return false;
    }

    public Object pcGetDetachedState() {
        return this.pcDetachedState;
    }

    public void pcSetDetachedState(Object object) {
        this.pcDetachedState = object;
    }

    public static class Builder {
        private String username;
        private String scriptName;
        private String scriptContent;
        private long scriptSize;
        private boolean isActive;
        private OffsetDateTime activationDateTime;

        public Builder username(String username) {
            Preconditions.checkNotNull((Object)username);
            this.username = username;
            return this;
        }

        public Builder scriptName(String scriptName) {
            Preconditions.checkNotNull((Object)scriptName);
            this.scriptName = scriptName;
            return this;
        }

        public Builder scriptContent(ScriptContent scriptContent) {
            Preconditions.checkNotNull((Object)scriptContent);
            this.scriptContent = scriptContent.getValue();
            this.scriptSize = scriptContent.length();
            return this;
        }

        public Builder isActive(boolean isActive) {
            this.isActive = isActive;
            return this;
        }

        public JPASieveScript build() {
            Preconditions.checkState((boolean)StringUtils.isNotBlank((CharSequence)this.username), (Object)"'username' is mandatory");
            Preconditions.checkState((boolean)StringUtils.isNotBlank((CharSequence)this.scriptName), (Object)"'scriptName' is mandatory");
            this.activationDateTime = this.isActive ? OffsetDateTime.now() : null;
            return new JPASieveScript(this.username, this.scriptName, this.scriptContent, this.scriptSize, this.isActive, this.activationDateTime);
        }
    }
}

