/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jdkim.mailets;

import com.google.common.annotations.VisibleForTesting;
import jakarta.inject.Inject;
import jakarta.mail.MessagingException;
import jakarta.mail.internet.MimeMessage;
import java.util.List;
import java.util.Optional;
import org.apache.james.jdkim.api.PublicKeyRecordRetriever;
import org.apache.james.jdkim.api.SignatureRecord;
import org.apache.james.jdkim.exceptions.FailException;
import org.apache.james.jdkim.mailets.DKIMVerifier;
import org.apache.mailet.Attribute;
import org.apache.mailet.AttributeName;
import org.apache.mailet.AttributeValue;
import org.apache.mailet.Mail;
import org.apache.mailet.base.GenericMailet;

public class DKIMVerify
extends GenericMailet {
    public static final AttributeName DKIM_AUTH_RESULT = AttributeName.of((String)"jDKIM.AUTHRESULT");
    @VisibleForTesting
    DKIMVerifier verifier;
    private boolean forceCRLF;

    @Inject
    public DKIMVerify(PublicKeyRecordRetriever publicKeyRecordRetriever) {
        this.verifier = new DKIMVerifier(publicKeyRecordRetriever);
    }

    public void init() {
        this.forceCRLF = this.getInitParameter("forceCRLF", true);
    }

    public void service(Mail mail) throws MessagingException {
        try {
            MimeMessage message = mail.getMessage();
            List<SignatureRecord> res = this.verifier.verify(message, this.forceCRLF);
            if (res == null || res.isEmpty()) {
                mail.setAttribute(new Attribute(DKIM_AUTH_RESULT, AttributeValue.of((String)"neutral (no signatures)")));
            } else {
                StringBuilder msg = new StringBuilder();
                msg.append("pass");
                for (SignatureRecord rec : res) {
                    msg.append(" (");
                    msg.append("identity ");
                    msg.append(rec.getIdentity().toString());
                    msg.append(")");
                }
                mail.setAttribute(new Attribute(DKIM_AUTH_RESULT, AttributeValue.of((String)msg.toString())));
            }
        }
        catch (FailException e) {
            String relatedRecordIdentity = Optional.ofNullable(e.getRelatedRecordIdentity()).map(value -> "identity" + value + ":").orElse("");
            mail.setAttribute(new Attribute(DKIM_AUTH_RESULT, AttributeValue.of((String)("fail (" + relatedRecordIdentity + e.getMessage() + ")"))));
        }
    }
}

