/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.inmemory.mail;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import org.apache.james.core.Username;
import org.apache.james.mailbox.acl.ACLDiff;
import org.apache.james.mailbox.exception.MailboxExistsException;
import org.apache.james.mailbox.exception.MailboxNotFoundException;
import org.apache.james.mailbox.inmemory.InMemoryId;
import org.apache.james.mailbox.model.Mailbox;
import org.apache.james.mailbox.model.MailboxACL;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.UidValidity;
import org.apache.james.mailbox.model.search.MailboxQuery;
import org.apache.james.mailbox.store.mail.MailboxMapper;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class InMemoryMailboxMapper
implements MailboxMapper {
    private static final int INITIAL_SIZE = 128;
    private final ConcurrentHashMap<MailboxPath, Mailbox> mailboxesByPath;
    private final AtomicLong mailboxIdGenerator = new AtomicLong();

    public InMemoryMailboxMapper() {
        this.mailboxesByPath = new ConcurrentHashMap(128);
    }

    public Mono<Void> delete(Mailbox mailbox) {
        return Mono.fromRunnable(() -> this.mailboxesByPath.remove(mailbox.generateAssociatedPath()));
    }

    public Mono<Void> deleteAll() {
        return Mono.fromRunnable(this.mailboxesByPath::clear);
    }

    public Mono<Mailbox> findMailboxByPath(MailboxPath path) {
        return Mono.defer(() -> Mono.justOrEmpty((Object)this.mailboxesByPath.get(path))).map(Mailbox::new);
    }

    public Mono<Mailbox> findMailboxById(MailboxId id) {
        return Mono.fromCallable(this.mailboxesByPath::values).flatMapIterable(Function.identity()).filter(mailbox -> mailbox.getMailboxId().equals((Object)id)).next().map(Mailbox::new).switchIfEmpty(Mono.error(() -> new MailboxNotFoundException(id)));
    }

    public Flux<Mailbox> findMailboxWithPathLike(MailboxQuery.UserBound query) {
        return Mono.fromCallable(this.mailboxesByPath::values).flatMapIterable(Function.identity()).filter(arg_0 -> ((MailboxQuery.UserBound)query).matches(arg_0)).map(Mailbox::new);
    }

    public Mono<Mailbox> create(MailboxPath mailboxPath, UidValidity uidValidity) {
        InMemoryId id = InMemoryId.of(this.mailboxIdGenerator.incrementAndGet());
        Mailbox mailbox = new Mailbox(mailboxPath, uidValidity, (MailboxId)id);
        return this.saveMailbox(mailbox).thenReturn((Object)mailbox);
    }

    public Mono<MailboxId> rename(Mailbox mailbox) {
        Preconditions.checkNotNull((Object)mailbox.getMailboxId(), (Object)"A mailbox we want to rename should have a defined mailboxId");
        InMemoryId id = (InMemoryId)mailbox.getMailboxId();
        return this.findMailboxById(id).flatMap(mailboxWithPreviousName -> this.saveMailbox(mailbox).then(Mono.fromCallable(() -> this.mailboxesByPath.remove(mailboxWithPreviousName.generateAssociatedPath())))).thenReturn((Object)mailbox.getMailboxId());
    }

    private Mono<Void> saveMailbox(Mailbox mailbox) {
        return Mono.defer(() -> Mono.justOrEmpty((Object)this.mailboxesByPath.putIfAbsent(mailbox.generateAssociatedPath(), mailbox))).flatMap(ignored -> Mono.error((Throwable)new MailboxExistsException(mailbox.getName())));
    }

    public Mono<Boolean> hasChildren(Mailbox mailbox, char delimiter) {
        String mailboxName = mailbox.getName() + delimiter;
        return Mono.fromCallable(this.mailboxesByPath::values).flatMapIterable(Function.identity()).filter(box -> this.belongsToSameUser(mailbox, (Mailbox)box) && box.getName().startsWith(mailboxName)).hasElements();
    }

    private boolean belongsToSameUser(Mailbox mailbox, Mailbox otherMailbox) {
        return Objects.equal((Object)mailbox.getNamespace(), (Object)otherMailbox.getNamespace()) && Objects.equal((Object)mailbox.getUser(), (Object)otherMailbox.getUser());
    }

    public Flux<Mailbox> list() {
        return Mono.fromCallable(this.mailboxesByPath::values).flatMapIterable(Function.identity());
    }

    public Mono<ACLDiff> updateACL(Mailbox mailbox, MailboxACL.ACLCommand mailboxACLCommand) {
        return Mono.fromCallable(() -> {
            MailboxACL oldACL = mailbox.getACL();
            MailboxACL newACL = mailbox.getACL().apply(mailboxACLCommand);
            this.mailboxesByPath.get(mailbox.generateAssociatedPath()).setACL(newACL);
            return ACLDiff.computeDiff((MailboxACL)oldACL, (MailboxACL)newACL);
        });
    }

    public Mono<ACLDiff> setACL(Mailbox mailbox, MailboxACL mailboxACL) {
        return Mono.fromCallable(() -> {
            MailboxACL oldMailboxAcl = mailbox.getACL();
            this.mailboxesByPath.get(mailbox.generateAssociatedPath()).setACL(mailboxACL);
            return ACLDiff.computeDiff((MailboxACL)oldMailboxAcl, (MailboxACL)mailboxACL);
        });
    }

    public Flux<Mailbox> findNonPersonalMailboxes(Username userName, MailboxACL.Right right) {
        return Mono.fromCallable(this.mailboxesByPath::values).flatMapIterable(Function.identity()).filter(mailbox -> this.hasRightOn((Mailbox)mailbox, userName, right));
    }

    private Boolean hasRightOn(Mailbox mailbox, Username userName, MailboxACL.Right right) {
        return Optional.ofNullable((MailboxACL.Rfc4314Rights)mailbox.getACL().ofPositiveNameType(MailboxACL.NameType.user).get(MailboxACL.EntryKey.createUserEntryKey((Username)userName))).map(rights -> rights.contains(right)).orElse(false);
    }
}

