/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.smtpserver;

import com.google.common.net.InternetDomainName;
import jakarta.inject.Inject;
import jakarta.mail.Address;
import jakarta.mail.MessagingException;
import jakarta.mail.internet.AddressException;
import jakarta.mail.internet.InternetAddress;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.james.core.Domain;
import org.apache.james.core.MailAddress;
import org.apache.james.core.MaybeSender;
import org.apache.james.core.Username;
import org.apache.james.domainlist.api.DomainList;
import org.apache.james.domainlist.api.DomainListException;
import org.apache.james.protocols.api.ProtocolSession;
import org.apache.james.protocols.smtp.SMTPConfiguration;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.protocols.smtp.core.AbstractSenderAuthIdentifyVerificationHook;
import org.apache.james.protocols.smtp.hook.HookResult;
import org.apache.james.rrt.api.CanSendFrom;
import org.apache.james.smtpserver.ExtendedSMTPSession;
import org.apache.james.smtpserver.JamesMessageHook;
import org.apache.james.user.api.UsersRepository;
import org.apache.james.user.api.UsersRepositoryException;
import org.apache.james.util.StreamUtils;
import org.apache.mailet.Mail;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SenderAuthIdentifyVerificationHook
extends AbstractSenderAuthIdentifyVerificationHook
implements JamesMessageHook {
    private static final Logger LOGGER = LoggerFactory.getLogger(SenderAuthIdentifyVerificationHook.class);
    private final DomainList domains;
    private final UsersRepository users;
    private final CanSendFrom canSendFrom;

    @Inject
    public SenderAuthIdentifyVerificationHook(DomainList domains, UsersRepository users, CanSendFrom canSendFrom) {
        this.domains = domains;
        this.users = users;
        this.canSendFrom = canSendFrom;
    }

    public HookResult doCheck(SMTPSession session, MaybeSender sender) {
        ExtendedSMTPSession nSession = (ExtendedSMTPSession)session;
        if (nSession.verifyIdentity() == SMTPConfiguration.SenderVerificationMode.STRICT) {
            return super.doCheck(session, sender);
        }
        if (nSession.verifyIdentity() == SMTPConfiguration.SenderVerificationMode.RELAXED) {
            return this.doCheckRelaxed(session, sender);
        }
        return HookResult.DECLINED;
    }

    private HookResult doCheckRelaxed(SMTPSession session, MaybeSender sender) {
        if (this.senderDoesNotMatchAuthUser(session, sender)) {
            return INVALID_AUTH;
        }
        if (this.unauthenticatedSenderIsLocalUser(session, sender)) {
            if (this.mxHeuristic(session)) {
                return HookResult.DECLINED;
            }
            return AUTH_REQUIRED;
        }
        return HookResult.DECLINED;
    }

    private boolean mxHeuristic(SMTPSession session) {
        Optional helo = session.getAttachment(SMTPSession.CURRENT_HELO_NAME, ProtocolSession.State.Connection);
        return helo.filter(InternetDomainName::isValid).map(name -> name.contains(".")).orElse(false);
    }

    protected boolean isLocalDomain(Domain domain) {
        try {
            return this.domains.containsDomain(domain);
        }
        catch (DomainListException e) {
            return false;
        }
    }

    protected Username getUser(MailAddress mailAddress) {
        try {
            return this.users.getUsername(mailAddress);
        }
        catch (UsersRepositoryException e) {
            throw new RuntimeException(e);
        }
    }

    protected boolean isSenderAllowed(Username connectedUser, Username sender) {
        boolean allowed = this.canSendFrom.userCanSendFrom(connectedUser, sender);
        if (allowed) {
            LOGGER.debug("{} is allowed to send a mail using {} identity", (Object)connectedUser.asString(), (Object)sender.asString());
        } else {
            LOGGER.info("{} is not allowed to send a mail using {} identity", (Object)connectedUser.asString(), (Object)sender.asString());
        }
        return allowed;
    }

    @Override
    public HookResult onMessage(SMTPSession session, Mail mail) {
        boolean shouldCheck;
        ExtendedSMTPSession nSession = (ExtendedSMTPSession)session;
        boolean bl = shouldCheck = nSession.verifyIdentity() == SMTPConfiguration.SenderVerificationMode.STRICT || nSession.verifyIdentity() == SMTPConfiguration.SenderVerificationMode.RELAXED && session.getUsername() != null;
        if (shouldCheck) {
            try {
                return StreamUtils.ofNullable((Object[])mail.getMessage().getFrom()).distinct().flatMap(address -> this.doCheckMessage(session, (Address)address)).findFirst().orElse(HookResult.DECLINED);
            }
            catch (MessagingException e) {
                throw new RuntimeException(e);
            }
        }
        return HookResult.DECLINED;
    }

    private Stream<HookResult> doCheckMessage(SMTPSession session, Address from) {
        if (this.fromDoesNotMatchAuthUser(session, from)) {
            return Stream.of(INVALID_AUTH);
        }
        return Stream.empty();
    }

    private boolean fromDoesNotMatchAuthUser(SMTPSession session, Address from) {
        if (from instanceof InternetAddress) {
            InternetAddress internetAddress = (InternetAddress)from;
            try {
                MailAddress mailAddress = new MailAddress(internetAddress.getAddress());
                return session.getUsername() != null && (!this.fromMatchSessionUser(mailAddress, session) || !this.belongsToLocalDomain(mailAddress));
            }
            catch (AddressException e) {
                throw new RuntimeException(e);
            }
        }
        return false;
    }

    private boolean fromMatchSessionUser(MailAddress from, SMTPSession session) {
        Username authUser = session.getUsername();
        Username sender = this.getUser(from);
        return this.isSenderAllowed(authUser, sender);
    }

    private boolean belongsToLocalDomain(MailAddress from) {
        return this.isLocalDomain(from.getDomain());
    }
}

