/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.user.lib;

import com.github.fge.lambdas.Throwing;
import com.google.common.base.CharMatcher;
import jakarta.inject.Inject;
import java.time.temporal.ChronoUnit;
import java.util.Iterator;
import java.util.Optional;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.james.DefaultUserEntityValidator;
import org.apache.james.UserEntityValidator;
import org.apache.james.core.Domain;
import org.apache.james.core.MailAddress;
import org.apache.james.core.Username;
import org.apache.james.domainlist.api.DomainList;
import org.apache.james.domainlist.api.DomainListException;
import org.apache.james.lifecycle.api.Configurable;
import org.apache.james.user.api.AlreadyExistInUsersRepositoryException;
import org.apache.james.user.api.InvalidUsernameException;
import org.apache.james.user.api.UsersRepository;
import org.apache.james.user.api.UsersRepositoryException;
import org.apache.james.user.api.model.User;
import org.apache.james.user.lib.UsersDAO;
import org.apache.james.util.DurationParser;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class UsersRepositoryImpl<T extends UsersDAO>
implements UsersRepository,
Configurable {
    public static final Logger LOGGER = LoggerFactory.getLogger(UsersRepositoryImpl.class);
    private static String ILLEGAL_USERNAME_CHARACTERS = "\"(),:; <>@[\\]";
    private final DomainList domainList;
    protected final T usersDAO;
    private boolean virtualHosting;
    private Optional<Username> administratorId;
    private long verifyFailureDelay;
    private UserEntityValidator validator;

    @Inject
    public UsersRepositoryImpl(DomainList domainList, T usersDAO) {
        this.domainList = domainList;
        this.usersDAO = usersDAO;
        this.validator = new DefaultUserEntityValidator(this);
    }

    @Inject
    public void setValidator(UserEntityValidator validator) {
        this.validator = validator;
    }

    public void configure(HierarchicalConfiguration<ImmutableNode> configuration) throws ConfigurationException {
        this.virtualHosting = configuration.getBoolean("enableVirtualHosting", this.usersDAO.getDefaultVirtualHostingValue());
        this.administratorId = Optional.ofNullable(configuration.getString("administratorId")).map(Username::of);
        this.verifyFailureDelay = Optional.ofNullable(configuration.getString("verifyFailureDelay")).map(string -> DurationParser.parse((String)string, (ChronoUnit)ChronoUnit.SECONDS).toMillis()).orElse(0L);
    }

    public void setEnableVirtualHosting(boolean virtualHosting) {
        this.virtualHosting = virtualHosting;
    }

    public void assertValid(Username username) throws UsersRepositoryException {
        this.assertDomainPartValid(username);
        this.assertLocalPartValid(username);
    }

    public Mono<Void> assertValidReactive(Username username) {
        return this.assertDomainPartValidReactive(username).then(Mono.fromRunnable((Runnable)Throwing.runnable(() -> this.assertLocalPartValid(username)).sneakyThrow()));
    }

    protected void assertDomainPartValid(Username username) throws UsersRepositoryException {
        block6: {
            if (this.supportVirtualHosting()) {
                if (!username.hasDomainPart()) {
                    throw new InvalidUsernameException("Given Username needs to contain a @domainpart");
                }
                Domain domain = (Domain)username.getDomainPart().get();
                try {
                    if (!this.domainList.containsDomain(domain)) {
                        throw new InvalidUsernameException("Domain does not exist in DomainList");
                    }
                    break block6;
                }
                catch (DomainListException e) {
                    throw new UsersRepositoryException("Unable to query DomainList", (Throwable)e);
                }
            }
            if (username.hasDomainPart()) {
                throw new InvalidUsernameException("Given Username contains a @domainpart but virtualhosting support is disabled");
            }
        }
    }

    protected Mono<Void> assertDomainPartValidReactive(Username username) {
        if (this.supportVirtualHosting()) {
            if (!username.hasDomainPart()) {
                return Mono.error((Throwable)new InvalidUsernameException("Given Username needs to contain a @domainpart"));
            }
            Domain domain = (Domain)username.getDomainPart().get();
            return Mono.from((Publisher)this.domainList.containsDomainReactive(domain)).onErrorMap(DomainListException.class, e -> new UsersRepositoryException("Unable to query DomainList", (Throwable)e)).handle((result, sink) -> {
                if (!result.booleanValue()) {
                    sink.error((Throwable)new InvalidUsernameException("Domain does not exist in DomainList"));
                } else {
                    sink.complete();
                }
            });
        }
        if (username.hasDomainPart()) {
            return Mono.error((Throwable)new InvalidUsernameException("Given Username contains a @domainpart but virtualhosting support is disabled"));
        }
        return Mono.empty();
    }

    protected void assertLocalPartValid(Username username) throws InvalidUsernameException {
        boolean isValid = CharMatcher.anyOf((CharSequence)ILLEGAL_USERNAME_CHARACTERS).matchesNoneOf((CharSequence)username.getLocalPart());
        if (!isValid) {
            throw new InvalidUsernameException(String.format("Given Username '%s' should not contain any of those characters: %s", username.asString(), ILLEGAL_USERNAME_CHARACTERS));
        }
    }

    public void addUser(Username username, String password) throws UsersRepositoryException {
        this.ensureNoConflict(username);
        this.assertValid(username);
        this.usersDAO.addUser(username, password);
    }

    private void ensureNoConflict(Username username) throws UsersRepositoryException {
        try {
            Optional<UserEntityValidator.ValidationFailure> validationFailure = this.validator.canCreate(username);
            if (validationFailure.isPresent()) {
                throw new AlreadyExistInUsersRepositoryException(validationFailure.get().errorMessage());
            }
        }
        catch (UsersRepositoryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new UsersRepositoryException("Unexpected exception", (Throwable)e);
        }
    }

    public User getUserByName(Username name) throws UsersRepositoryException {
        return this.usersDAO.getUserByName(name).orElse(null);
    }

    public Optional<Username> test(Username name, String password) throws UsersRepositoryException {
        Optional<Username> translatedUsername = this.usersDAO.getUserByName(name).filter(user -> user.verifyPassword(password)).map(User::getUserName);
        if (translatedUsername.isEmpty()) {
            LOGGER.info("Could not retrieve user {}. Password is unverified.", (Object)name);
            if (this.verifyFailureDelay > 0L) {
                try {
                    Thread.sleep(this.verifyFailureDelay);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        return translatedUsername;
    }

    public void updateUser(User user) throws UsersRepositoryException {
        this.assertDomainPartValid(user.getUserName());
        this.usersDAO.updateUser(user);
    }

    public void removeUser(Username name) throws UsersRepositoryException {
        this.assertDomainPartValid(name);
        this.usersDAO.removeUser(name);
    }

    public boolean contains(Username name) throws UsersRepositoryException {
        return this.usersDAO.contains(name);
    }

    public Publisher<Boolean> containsReactive(Username name) {
        return this.usersDAO.containsReactive(name);
    }

    public int countUsers() throws UsersRepositoryException {
        return this.usersDAO.countUsers();
    }

    public Iterator<Username> list() throws UsersRepositoryException {
        return this.usersDAO.list();
    }

    public Publisher<Username> listReactive() {
        return this.usersDAO.listReactive();
    }

    public boolean supportVirtualHosting() {
        return this.virtualHosting;
    }

    public boolean isAdministrator(Username username) throws UsersRepositoryException {
        this.assertValid(username);
        return this.administratorId.map(id -> id.equals((Object)username)).orElse(false);
    }

    public boolean isReadOnly() {
        return false;
    }

    public MailAddress getMailAddressFor(Username username) throws UsersRepositoryException {
        try {
            if (this.supportVirtualHosting()) {
                return new MailAddress(username.asString());
            }
            return new MailAddress(username.getLocalPart(), this.domainList.getDefaultDomain());
        }
        catch (Exception e) {
            throw new UsersRepositoryException("Failed to compute mail address associated with the user", (Throwable)e);
        }
    }
}

