/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor;

import jakarta.inject.Inject;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.main.PathConverter;
import org.apache.james.imap.message.request.UnsubscribeRequest;
import org.apache.james.imap.processor.AbstractSubscriptionProcessor;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.SubscriptionManager;
import org.apache.james.mailbox.exception.SubscriptionException;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.util.MDCBuilder;
import org.apache.james.util.ReactorUtils;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class UnsubscribeProcessor
extends AbstractSubscriptionProcessor<UnsubscribeRequest> {
    private static final Logger LOGGER = LoggerFactory.getLogger(UnsubscribeProcessor.class);

    @Inject
    public UnsubscribeProcessor(MailboxManager mailboxManager, SubscriptionManager subscriptionManager, StatusResponseFactory factory, MetricFactory metricFactory) {
        super(UnsubscribeRequest.class, mailboxManager, subscriptionManager, factory, metricFactory);
    }

    @Override
    protected Mono<Void> doProcessRequest(UnsubscribeRequest request, ImapSession session, ImapProcessor.Responder responder) {
        MailboxPath mailboxPath = PathConverter.forSession(session).buildFullPath(request.getMailboxName());
        MailboxSession mailboxSession = session.getMailboxSession();
        return Mono.from((Publisher)this.getSubscriptionManager().unsubscribeReactive(mailboxPath, mailboxSession)).then(this.unsolicitedResponses(session, responder, false)).then(Mono.fromRunnable(() -> this.okComplete(request, responder))).doOnEach(ReactorUtils.logOnError(SubscriptionException.class, e -> LOGGER.info("Unsubscribe failed for mailbox {}", (Object)request.getMailboxName(), e))).onErrorResume(SubscriptionException.class, e -> this.unsolicitedResponses(session, responder, false).then(Mono.fromRunnable(() -> this.no(request, responder, HumanReadableText.GENERIC_SUBSCRIPTION_FAILURE)))).then();
    }

    @Override
    protected MDCBuilder mdc(UnsubscribeRequest message) {
        return MDCBuilder.create().addToContext("action", "UNSUBSCRIBE").addToContext("mailbox", message.getMailboxName());
    }
}

