/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor;

import jakarta.inject.Inject;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.api.process.SelectedMailbox;
import org.apache.james.imap.main.PathConverter;
import org.apache.james.imap.message.request.DeleteRequest;
import org.apache.james.imap.processor.AbstractMailboxProcessor;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.exception.MailboxNotFoundException;
import org.apache.james.mailbox.exception.TooLongMailboxNameException;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.util.MDCBuilder;
import org.apache.james.util.ReactorUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class DeleteProcessor
extends AbstractMailboxProcessor<DeleteRequest> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeleteProcessor.class);

    @Inject
    public DeleteProcessor(MailboxManager mailboxManager, StatusResponseFactory factory, MetricFactory metricFactory) {
        super(DeleteRequest.class, mailboxManager, factory, metricFactory);
    }

    @Override
    protected Mono<Void> processRequestReactive(DeleteRequest request, ImapSession session, ImapProcessor.Responder responder) {
        MailboxManager mailboxManager = this.getMailboxManager();
        MailboxPath mailboxPath = PathConverter.forSession(session).buildFullPath(request.getMailboxName());
        SelectedMailbox selected = session.getSelected();
        return this.deselect(session, selected, mailboxPath).then(mailboxManager.deleteMailboxReactive(mailboxPath, session.getMailboxSession())).then(this.unsolicitedResponses(session, responder, false)).then(Mono.fromRunnable(() -> this.okComplete(request, responder))).then().onErrorResume(MailboxNotFoundException.class, e -> {
            this.no(request, responder, HumanReadableText.FAILURE_NO_SUCH_MAILBOX);
            return ReactorUtils.logAsMono(() -> LOGGER.debug("Delete failed for mailbox {} as it doesn't exist", (Object)mailboxPath, e));
        }).onErrorResume(TooLongMailboxNameException.class, e -> {
            this.taggedBad(request, responder, HumanReadableText.FAILURE_MAILBOX_NAME);
            return ReactorUtils.logAsMono(() -> LOGGER.debug("The mailbox name length is over limit: {}", (Object)mailboxPath.getName(), e));
        }).onErrorResume(MailboxException.class, e -> {
            this.no(request, responder, HumanReadableText.GENERIC_FAILURE_DURING_PROCESSING);
            return ReactorUtils.logAsMono(() -> LOGGER.error("Delete failed for mailbox {}", (Object)mailboxPath, (Object)e));
        });
    }

    private Mono<Void> deselect(ImapSession session, SelectedMailbox selected, MailboxPath mailboxPath) {
        if (selected == null) {
            return Mono.empty();
        }
        return selected.getPathReactive().flatMap(selectedPath -> {
            if (selectedPath.equals((Object)mailboxPath)) {
                return session.deselect();
            }
            return Mono.empty();
        });
    }

    @Override
    protected MDCBuilder mdc(DeleteRequest request) {
        return MDCBuilder.create().addToContext("action", "DELETE").addToContext("mailbox", request.getMailboxName());
    }
}

