/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor;

import jakarta.inject.Inject;
import org.apache.james.imap.api.message.IdRange;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.SelectedMailbox;
import org.apache.james.imap.message.request.CopyRequest;
import org.apache.james.imap.processor.AbstractMessageRangeProcessor;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MessageRange;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.util.MDCBuilder;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

public class CopyProcessor
extends AbstractMessageRangeProcessor<CopyRequest> {
    @Inject
    public CopyProcessor(MailboxManager mailboxManager, StatusResponseFactory factory, MetricFactory metricFactory) {
        super(CopyRequest.class, mailboxManager, factory, metricFactory);
    }

    @Override
    protected String getOperationName() {
        return "Copy";
    }

    @Override
    protected Flux<MessageRange> process(MailboxId targetMailbox, SelectedMailbox currentMailbox, MailboxSession mailboxSession, MessageRange messageSet) {
        return Flux.from((Publisher)this.getMailboxManager().copyMessagesReactive(messageSet, currentMailbox.getMailboxId(), targetMailbox, mailboxSession));
    }

    @Override
    protected MDCBuilder mdc(CopyRequest request) {
        return MDCBuilder.create().addToContext("action", "COPY").addToContext("targetMailbox", request.getMailboxName()).addToContext("uidEnabled", Boolean.toString(request.isUseUids())).addToContext("idSet", IdRange.toString(request.getIdSet()));
    }
}

