/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.message.response;

import java.util.List;
import java.util.Objects;
import org.apache.james.imap.api.message.response.ImapResponseMessage;

public class NamespaceResponse
implements ImapResponseMessage {
    private final List<Namespace> personal;
    private final List<Namespace> users;
    private final List<Namespace> shared;

    public NamespaceResponse(List<Namespace> personal, List<Namespace> users, List<Namespace> shared) {
        this.personal = personal;
        this.users = users;
        this.shared = shared;
    }

    public List<Namespace> getPersonal() {
        return this.personal;
    }

    public List<Namespace> getShared() {
        return this.shared;
    }

    public List<Namespace> getUsers() {
        return this.users;
    }

    public final boolean equals(Object o) {
        if (o instanceof NamespaceResponse) {
            NamespaceResponse that = (NamespaceResponse)o;
            return Objects.equals(this.personal, that.personal) && Objects.equals(this.users, that.users) && Objects.equals(this.shared, that.shared);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.personal, this.users, this.shared);
    }

    public String toString() {
        return "NamespaceResponse [personal = " + String.valueOf(this.personal) + " users = " + String.valueOf(this.users) + " shared = " + String.valueOf(this.shared) + "  ]";
    }

    public static final class Namespace {
        private final String prefix;
        private final char delimiter;

        public Namespace(String prefix, char delimiter) {
            this.prefix = prefix;
            this.delimiter = delimiter;
        }

        public char getDelimiter() {
            return this.delimiter;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public final boolean equals(Object o) {
            if (o instanceof Namespace) {
                Namespace namespace = (Namespace)o;
                return Objects.equals(Character.valueOf(this.delimiter), Character.valueOf(namespace.delimiter)) && Objects.equals(this.prefix, namespace.prefix);
            }
            return false;
        }

        public final int hashCode() {
            return Objects.hash(this.prefix, Character.valueOf(this.delimiter));
        }

        public String toString() {
            return "Namespace [prefix=" + this.prefix + ", delim=" + this.delimiter + "]";
        }
    }
}

