/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.smtp.core.esmtp;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.james.core.Username;
import org.apache.james.protocols.api.OidcSASLConfiguration;
import org.apache.james.protocols.api.Request;
import org.apache.james.protocols.api.Response;
import org.apache.james.protocols.api.handler.CommandHandler;
import org.apache.james.protocols.api.handler.ExtensibleHandler;
import org.apache.james.protocols.api.handler.LineHandler;
import org.apache.james.protocols.api.handler.WiringException;
import org.apache.james.protocols.smtp.SMTPResponse;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.protocols.smtp.core.esmtp.EhloExtension;
import org.apache.james.protocols.smtp.dsn.DSNStatus;
import org.apache.james.protocols.smtp.hook.AuthHook;
import org.apache.james.protocols.smtp.hook.HookResult;
import org.apache.james.protocols.smtp.hook.HookResultHook;
import org.apache.james.protocols.smtp.hook.HookReturnCode;
import org.apache.james.protocols.smtp.hook.MailParametersHook;
import org.apache.james.util.AuditTrail;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthCmdHandler
implements CommandHandler<SMTPSession>,
EhloExtension,
ExtensibleHandler,
MailParametersHook {
    private static final Collection<String> COMMANDS = ImmutableSet.of((Object)"AUTH");
    private static final Logger LOGGER = LoggerFactory.getLogger(AuthCmdHandler.class);
    private static final Logger AUTHENTICATION_DEDICATED_LOGGER = LoggerFactory.getLogger((String)"org.apache.james.protocols.smtp.AUTHENTICATION");
    private static final String[] MAIL_PARAMS = new String[]{"AUTH"};
    private static final String AUTH_TYPES_DELIMITER = " ";
    private static final Response AUTH_ABORTED = new SMTPResponse("501", DSNStatus.getStatus(5, "7.1") + " Authentication aborted").immutable();
    private static final Response ALREADY_AUTH = new SMTPResponse("503", DSNStatus.getStatus(5, "5.0") + " User has previously authenticated.  Further authentication is not required!").immutable();
    private static final Response SYNTAX_ERROR = new SMTPResponse("501", DSNStatus.getStatus(5, "5.4") + " Usage: AUTH (authentication type) <challenge>").immutable();
    private static final Response AUTH_READY_PLAIN = new SMTPResponse("334", "OK. Continue authentication").immutable();
    private static final Response AUTH_READY_USERNAME_LOGIN = new SMTPResponse("334", "VXNlcm5hbWU6").immutable();
    private static final Response AUTH_READY_PASSWORD_LOGIN = new SMTPResponse("334", "UGFzc3dvcmQ6").immutable();
    private static final Response AUTH_FAILED = new SMTPResponse("535", "Authentication Failed").immutable();
    private static final Response UNKNOWN_AUTH_TYPE = new SMTPResponse("504", "Unrecognized Authentication Type").immutable();
    protected static final String AUTH_TYPE_PLAIN = "PLAIN";
    protected static final String AUTH_TYPE_LOGIN = "LOGIN";
    protected static final String AUTH_TYPE_OAUTHBEARER = "OAUTHBEARER";
    protected static final String AUTH_TYPE_XOAUTH2 = "XOAUTH2";
    private List<AuthHook> hooks;
    private List<HookResultHook> rHooks;

    public Response onCommand(SMTPSession session, Request request) {
        return this.doAUTH(session, request.getArgument());
    }

    private Response doAUTH(SMTPSession session, String argument) {
        String authType;
        if (session.getUsername() != null) {
            return ALREADY_AUTH;
        }
        if (argument == null) {
            return SYNTAX_ERROR;
        }
        String initialResponse = null;
        if (argument.indexOf(AUTH_TYPES_DELIMITER) > 0) {
            initialResponse = argument.substring(argument.indexOf(AUTH_TYPES_DELIMITER) + 1);
            argument = argument.substring(0, argument.indexOf(AUTH_TYPES_DELIMITER));
        }
        if ((authType = argument.toUpperCase(Locale.US)).equals(AUTH_TYPE_PLAIN) && session.getConfiguration().isPlainAuthEnabled()) {
            if (initialResponse == null) {
                session.pushLineHandler(new AbstractSMTPLineHandler(){

                    @Override
                    protected Response onCommand(SMTPSession session, String l) {
                        return AuthCmdHandler.this.doPlainAuth(session, l);
                    }
                });
                return AUTH_READY_PLAIN;
            }
            String userpass = initialResponse.trim();
            return this.doPlainAuth(session, userpass);
        }
        if (authType.equals(AUTH_TYPE_LOGIN) && session.getConfiguration().isPlainAuthEnabled()) {
            if (initialResponse == null) {
                session.pushLineHandler(new AbstractSMTPLineHandler(){

                    @Override
                    protected Response onCommand(SMTPSession session, String l) {
                        return AuthCmdHandler.this.doLoginAuthPass(session, l);
                    }
                });
                return AUTH_READY_USERNAME_LOGIN;
            }
            String user = initialResponse.trim();
            return this.doLoginAuthPass(session, user);
        }
        if ((authType.equals(AUTH_TYPE_OAUTHBEARER) || authType.equals(AUTH_TYPE_XOAUTH2)) && session.supportsOAuth()) {
            return this.doSASLAuthentication(session, initialResponse);
        }
        return this.doUnknownAuth(authType);
    }

    private Response doSASLAuthentication(SMTPSession session, String initialResponseString) {
        return session.getConfiguration().saslConfiguration().map(oidcSASLConfiguration -> this.hooks.stream().flatMap(hook -> Optional.ofNullable(this.executeHook(session, (AuthHook)hook, hook2 -> hook2.doSasl(session, (OidcSASLConfiguration)oidcSASLConfiguration, initialResponseString))).stream()).filter(response -> !"535".equals(response.getRetCode())).findFirst().orElseGet(() -> this.failSasl((OidcSASLConfiguration)oidcSASLConfiguration, session))).orElseGet(() -> this.doUnknownAuth(AUTH_TYPE_OAUTHBEARER));
    }

    private Response failSasl(OidcSASLConfiguration saslConfiguration, SMTPSession session) {
        String rawResponse = String.format("{\"status\":\"invalid_token\",\"scope\":\"%s\",\"schemes\":\"%s\"}", saslConfiguration.getScope(), saslConfiguration.getOidcConfigurationURL().toString());
        session.pushLineHandler(new AbstractSMTPLineHandler(this){

            @Override
            protected Response onCommand(SMTPSession session, String l) {
                session.popLineHandler();
                return AUTH_FAILED;
            }
        });
        return new SMTPResponse("334", Base64.getEncoder().encodeToString(rawResponse.getBytes()));
    }

    private Response doPlainAuth(SMTPSession session, String line) {
        try {
            List tokens = Optional.ofNullable(this.decodeBase64(line)).map(userpass1 -> Arrays.stream(userpass1.split("\u0000")).filter(token -> !token.isBlank()).collect(Collectors.toList())).orElse(List.of());
            Preconditions.checkArgument((tokens.size() == 1 || tokens.size() == 2 || tokens.size() == 3 ? 1 : 0) != 0);
            Response response = null;
            response = tokens.size() == 1 ? this.doDelegation(session, Username.of((String)((String)tokens.get(0)))) : (tokens.size() == 2 ? this.doAuthTest(session, Optional.of(Username.of((String)((String)tokens.get(0)))), Optional.of((String)tokens.get(1)), AUTH_TYPE_PLAIN) : this.doAuthTest(session, Optional.of(Username.of((String)((String)tokens.get(1)))), Optional.of((String)tokens.get(2)), AUTH_TYPE_PLAIN));
            session.popLineHandler();
            return response;
        }
        catch (Exception e) {
            LOGGER.info("Could not decode parameters for AUTH PLAIN", (Throwable)e);
            return new SMTPResponse("501", "Could not decode parameters for AUTH PLAIN");
        }
    }

    private String decodeBase64(String line) {
        if (line != null) {
            String lineWithoutTrailingCrLf = StringUtils.replace((String)line, (String)"\r\n", (String)"");
            return new String(Base64.getDecoder().decode(lineWithoutTrailingCrLf), StandardCharsets.UTF_8);
        }
        return null;
    }

    private Response doLoginAuthPass(SMTPSession session, final String user) {
        session.popLineHandler();
        session.pushLineHandler(new AbstractSMTPLineHandler(this){
            final /* synthetic */ AuthCmdHandler this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            protected Response onCommand(SMTPSession session, String l) {
                return this.this$0.doLoginAuthPassCheck(session, this.this$0.asUsername(user), l);
            }
        });
        return AUTH_READY_PASSWORD_LOGIN;
    }

    private Optional<Username> asUsername(String user) {
        try {
            return Optional.of(Username.of((String)this.decodeBase64(user)));
        }
        catch (Exception e) {
            LOGGER.info("Failed parsing base64 username {}", (Object)user, (Object)e);
            return Optional.empty();
        }
    }

    private Response doLoginAuthPassCheck(SMTPSession session, Optional<Username> username, String pass) {
        session.popLineHandler();
        return this.doAuthTest(session, username, this.sanitizePassword(username, pass), AUTH_TYPE_LOGIN);
    }

    private Optional<String> sanitizePassword(Optional<Username> username, String pass) {
        try {
            return Optional.of(this.decodeBase64(pass));
        }
        catch (Exception e) {
            LOGGER.info("Failed parsing base64 password for user {}", username, (Object)e);
            return Optional.empty();
        }
    }

    protected Response doDelegation(SMTPSession session, Username username) {
        List hooks = Optional.ofNullable(this.getHooks()).orElse(List.of());
        for (AuthHook rawHook : hooks) {
            rawHook.doDelegation(session, username);
            Response res = this.executeHook(session, rawHook, hook -> rawHook.doDelegation(session, username));
            if (res == null) continue;
            if ("535".equals(res.getRetCode())) {
                LOGGER.warn("{} was not authorized to connect as {}", (Object)session.getUsername(), (Object)username);
            } else if ("235".equals(res.getRetCode())) {
                LOGGER.info("{} was authorized to connect as {}", (Object)session.getUsername(), (Object)username);
            }
            return res;
        }
        LOGGER.info("DELEGATE failed from {}@{}", (Object)username, (Object)session.getRemoteAddress().getAddress().getHostAddress());
        return AUTH_FAILED;
    }

    protected Response doAuthTest(SMTPSession session, Optional<Username> username, Optional<String> pass, String authType) {
        if (username.isEmpty() || pass.isEmpty()) {
            return new SMTPResponse("501", "Could not decode parameters for AUTH " + authType);
        }
        List<AuthHook> hooks = this.getHooks();
        if (hooks != null) {
            for (AuthHook rawHook : hooks) {
                Response res = this.executeHook(session, rawHook, hook -> hook.doAuth(session, (Username)username.get(), (String)pass.get()));
                if (res == null) continue;
                if ("535".equals(res.getRetCode())) {
                    AUTHENTICATION_DEDICATED_LOGGER.info("AUTH method {} failed", (Object)authType);
                } else if ("235".equals(res.getRetCode())) {
                    AUTHENTICATION_DEDICATED_LOGGER.debug("AUTH method {} succeeded", (Object)authType);
                    AuditTrail.entry().username(() -> ((Username)username.get()).asString()).remoteIP(() -> Optional.ofNullable(session.getRemoteAddress())).sessionId(() -> ((SMTPSession)session).getSessionID()).protocol("SMTP").action("AUTH").parameters(() -> ImmutableMap.of((Object)"authType", (Object)authType)).log("SMTP Authentication succeeded.");
                }
                return res;
            }
        }
        AUTHENTICATION_DEDICATED_LOGGER.info("AUTH method {} failed from {}@{}", new Object[]{authType, username, session.getRemoteAddress().getAddress().getHostAddress()});
        AuditTrail.entry().username(() -> ((Username)username.get()).asString()).remoteIP(() -> Optional.ofNullable(session.getRemoteAddress())).protocol("SMTP").action("AUTH").parameters(() -> ImmutableMap.of((Object)"authType", (Object)authType)).log("SMTP Authentication failed.");
        return AUTH_FAILED;
    }

    private Response executeHook(SMTPSession session, AuthHook rawHook, Function<AuthHook, HookResult> tc) {
        LOGGER.debug("executing  hook {}", (Object)rawHook);
        long start = System.currentTimeMillis();
        HookResult hRes = tc.apply(rawHook);
        long executionTime = System.currentTimeMillis() - start;
        HookResult finalHookResult = Optional.ofNullable(this.rHooks).orElse((List<HookResultHook>)ImmutableList.of()).stream().peek(rHook -> LOGGER.debug("executing  hook {}", rHook)).reduce(hRes, (a, b) -> b.onHookResult(session, (HookResult)a, executionTime, rawHook), (a, b) -> {
            throw new UnsupportedOperationException();
        });
        return this.calcDefaultSMTPResponse(finalHookResult);
    }

    protected Response calcDefaultSMTPResponse(HookResult result) {
        if (result != null) {
            HookReturnCode returnCode = result.getResult();
            String smtpReturnCode = Optional.ofNullable(result.getSmtpRetCode()).or(() -> this.retrieveDefaultSmtpReturnCode(returnCode)).orElse(null);
            String smtpDescription = Optional.ofNullable(result.getSmtpDescription()).or(() -> this.retrieveDefaultSmtpDescription(returnCode)).orElse(null);
            if (HookReturnCode.Action.ACTIVE_ACTIONS.contains((Object)returnCode.getAction())) {
                SMTPResponse response = new SMTPResponse(smtpReturnCode, smtpDescription);
                if (returnCode.isDisconnected()) {
                    response.setEndSession(true);
                }
                return response;
            }
            if (returnCode.isDisconnected()) {
                return Response.DISCONNECT;
            }
        }
        return null;
    }

    private Optional<String> retrieveDefaultSmtpDescription(HookReturnCode returnCode) {
        switch (returnCode.getAction()) {
            case DENY: {
                return Optional.of("Authentication Failed");
            }
            case DENYSOFT: {
                return Optional.of("Temporary problem. Please try again later");
            }
            case OK: {
                return Optional.of("Authentication Succesfull");
            }
        }
        return Optional.empty();
    }

    private Optional<String> retrieveDefaultSmtpReturnCode(HookReturnCode returnCode) {
        switch (returnCode.getAction()) {
            case DENY: {
                return Optional.of("535");
            }
            case DENYSOFT: {
                return Optional.of("451");
            }
            case OK: {
                return Optional.of("235");
            }
        }
        return Optional.empty();
    }

    private Response doUnknownAuth(String authType) {
        LOGGER.info("AUTH method {} is an unrecognized authentication type", (Object)authType);
        return UNKNOWN_AUTH_TYPE;
    }

    public Collection<String> getImplCommands() {
        return COMMANDS;
    }

    @Override
    public List<String> getImplementedEsmtpFeatures(SMTPSession session) {
        if (session.isAuthAnnounced()) {
            ImmutableList authTypes;
            ImmutableList.Builder authTypesBuilder = ImmutableList.builder();
            if (session.getConfiguration().isPlainAuthEnabled()) {
                authTypesBuilder.add((Object[])new String[]{AUTH_TYPE_LOGIN, AUTH_TYPE_PLAIN});
            }
            if (session.getConfiguration().saslConfiguration().isPresent()) {
                authTypesBuilder.add((Object)AUTH_TYPE_OAUTHBEARER);
                authTypesBuilder.add((Object)AUTH_TYPE_XOAUTH2);
            }
            if ((authTypes = authTypesBuilder.build()).isEmpty()) {
                return Collections.emptyList();
            }
            String joined = Joiner.on((String)AUTH_TYPES_DELIMITER).join((Iterable)authTypes);
            return ImmutableList.of((Object)("AUTH " + joined), (Object)("AUTH=" + joined));
        }
        return Collections.emptyList();
    }

    public List<Class<?>> getMarkerInterfaces() {
        ArrayList classes = new ArrayList(2);
        classes.add(AuthHook.class);
        classes.add(HookResultHook.class);
        return classes;
    }

    public void wireExtensions(Class<?> interfaceName, List<?> extension) throws WiringException {
        if (AuthHook.class.equals(interfaceName)) {
            this.hooks = extension;
            if (this.hooks == null || this.hooks.isEmpty()) {
                throw new WiringException("AuthCmdHandler used without AuthHooks");
            }
        } else if (HookResultHook.class.equals(interfaceName)) {
            this.rHooks = extension;
        }
    }

    protected List<AuthHook> getHooks() {
        return this.hooks;
    }

    @Override
    public HookResult doMailParameter(SMTPSession session, String paramName, String paramValue) {
        return HookResult.DECLINED;
    }

    @Override
    public String[] getMailParamNames() {
        return MAIL_PARAMS;
    }

    private static abstract class AbstractSMTPLineHandler
    implements LineHandler<SMTPSession> {
        private AbstractSMTPLineHandler() {
        }

        public Response onLine(SMTPSession session, byte[] line) {
            return this.handleCommand(session, new String(line, session.getCharset()));
        }

        private Response handleCommand(SMTPSession session, String line) {
            if (line.equals("*\r\n")) {
                session.popLineHandler();
                return AUTH_ABORTED;
            }
            return this.onCommand(session, line);
        }

        protected abstract Response onCommand(SMTPSession var1, String var2);
    }
}

