/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailets.configuration;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.util.Optional;
import org.apache.james.mailets.configuration.MailetConfiguration;
import org.apache.james.mailets.configuration.SerializableAsXml;

public class ProcessorConfiguration
implements SerializableAsXml {
    public static final String TRANSPORT_PROCESSOR = "transport";
    public static final String STATE_ROOT = "root";
    public static final String STATE_BOUNCES = "bounces";
    public static final String STATE_ERROR = "error";
    public static final String STATE_SPAM = "spam";
    private final String state;
    private final boolean enableJmx;
    private final ImmutableList<MailetConfiguration> mailets;

    public static Builder builder() {
        return new Builder();
    }

    public static Builder transport() {
        return ProcessorConfiguration.builder().state(TRANSPORT_PROCESSOR);
    }

    public static Builder root() {
        return ProcessorConfiguration.builder().state(STATE_ROOT);
    }

    public static Builder bounces() {
        return ProcessorConfiguration.builder().state(STATE_BOUNCES);
    }

    public static Builder error() {
        return ProcessorConfiguration.builder().state(STATE_ERROR);
    }

    private ProcessorConfiguration(String state, boolean enableJmx, ImmutableList<MailetConfiguration> mailets) {
        this.state = state;
        this.enableJmx = enableJmx;
        this.mailets = mailets;
    }

    public String getState() {
        return this.state;
    }

    public boolean isEnableJmx() {
        return this.enableJmx;
    }

    public ImmutableList<MailetConfiguration> getMailets() {
        return this.mailets;
    }

    @Override
    public String serializeAsXml() {
        StringBuilder builder = new StringBuilder();
        builder.append("<processor state=\"").append(this.getState()).append("\" enableJmx=\"").append(this.isEnableJmx() ? "true" : "false").append("\">\n");
        for (MailetConfiguration mailet : this.getMailets()) {
            builder.append(mailet.serializeAsXml());
        }
        builder.append("</processor>\n");
        return builder.toString();
    }

    public static class Builder {
        private String state;
        private Optional<Boolean> enableJmx = Optional.empty();
        private ImmutableList.Builder<MailetConfiguration> mailets = ImmutableList.builder();

        private Builder() {
        }

        public Builder state(String state) {
            this.state = state;
            return this;
        }

        public Builder enableJmx(boolean enableJmx) {
            this.enableJmx = Optional.of(enableJmx);
            return this;
        }

        public Builder addMailet(MailetConfiguration mailetConfiguration) {
            this.mailets.add((Object)mailetConfiguration);
            return this;
        }

        public Builder addMailetsFrom(ProcessorConfiguration processorConfiguration) {
            this.mailets.addAll(processorConfiguration.mailets);
            return this;
        }

        public Builder addMailetsFrom(Builder processorConfiguration) {
            return this.addMailetsFrom(processorConfiguration.build());
        }

        public Builder addMailet(MailetConfiguration.Builder mailetConfiguration) {
            this.mailets.add((Object)mailetConfiguration.build());
            return this;
        }

        public ProcessorConfiguration build() {
            Preconditions.checkState((!Strings.isNullOrEmpty((String)this.state) ? 1 : 0) != 0, (Object)"'state' is mandatory");
            return new ProcessorConfiguration(this.state, this.enableJmx.orElse(false), (ImmutableList<MailetConfiguration>)this.mailets.build());
        }
    }
}

