/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailets.configuration;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.james.mailets.configuration.ProcessorConfiguration;
import org.apache.james.mailets.configuration.SerializableAsXml;

public class MailetContainer
implements SerializableAsXml {
    private final String postmaster;
    private final int threads;
    private final List<ProcessorConfiguration> processors;

    public static Builder builder() {
        return new Builder();
    }

    private MailetContainer(String postmaster, int threads, List<ProcessorConfiguration> processors) {
        this.postmaster = postmaster;
        this.threads = threads;
        this.processors = processors;
    }

    public String getPostmaster() {
        return this.postmaster;
    }

    public int getThreads() {
        return this.threads;
    }

    public List<ProcessorConfiguration> getProcessors() {
        return this.processors;
    }

    @Override
    public String serializeAsXml() {
        StringBuilder builder = new StringBuilder();
        builder.append("<?xml version=\"1.0\"?>\n").append("<mailetcontainer enableJmx=\"false\">\n").append("<context><postmaster>").append(this.getPostmaster()).append("</postmaster>").append("</context>\n").append("<spooler><threads>").append(this.getThreads()).append("</threads>").append("</spooler>\n").append("<processors>\n");
        for (ProcessorConfiguration processorConfiguration : this.getProcessors()) {
            builder.append(processorConfiguration.serializeAsXml());
        }
        builder.append("</processors>\n").append("</mailetcontainer>");
        return builder.toString();
    }

    public static class Builder {
        public static final int DEFAULT_THREAD_COUNT = 5;
        public static final String DEFAULT_POSTMASTER = "postmaster@localhost";
        private Optional<String> postmaster;
        private Optional<Integer> threads;
        private Map<String, ProcessorConfiguration> processors = new HashMap<String, ProcessorConfiguration>();

        private Builder() {
            this.threads = Optional.empty();
            this.postmaster = Optional.empty();
        }

        public Builder postmaster(String postmaster) {
            this.postmaster = Optional.of(postmaster);
            return this;
        }

        public Builder threads(int threads) {
            this.threads = Optional.of(threads);
            return this;
        }

        public Builder putProcessor(ProcessorConfiguration processorConfiguration) {
            this.processors.put(processorConfiguration.getState(), processorConfiguration);
            return this;
        }

        public Builder putProcessor(ProcessorConfiguration.Builder processorConfiguration) {
            return this.putProcessor(processorConfiguration.build());
        }

        public MailetContainer build() {
            String postmaster = this.postmaster.orElse(DEFAULT_POSTMASTER);
            int threads = this.threads.orElse(5);
            Preconditions.checkState((!Strings.isNullOrEmpty((String)postmaster) ? 1 : 0) != 0, (Object)"'postmaster' is mandatory");
            Preconditions.checkState((threads > 0 ? 1 : 0) != 0, (Object)"'threads' should be greater than 0");
            return new MailetContainer(postmaster, threads, (List<ProcessorConfiguration>)ImmutableList.copyOf(this.processors.values()));
        }
    }
}

