/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailets;

import com.google.common.collect.ImmutableList;
import com.google.inject.Module;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.memory.MemoryPersistenceAdapter;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.io.IOUtils;
import org.apache.james.GuiceJamesServer;
import org.apache.james.MemoryJamesServerMain;
import org.apache.james.mailets.configuration.CommonProcessors;
import org.apache.james.mailets.configuration.MailetContainer;
import org.apache.james.mailets.configuration.SmtpConfiguration;
import org.apache.james.modules.TestJMAPServerModule;
import org.apache.james.modules.data.MemoryUsersRepositoryModule;
import org.apache.james.server.core.configuration.Configuration;
import org.apache.james.utils.GuiceProbe;
import org.apache.james.webadmin.WebAdminConfiguration;

public class TemporaryJamesServer {
    private static final String MAILETCONTAINER_CONFIGURATION_FILENAME = "mailetcontainer.xml";
    private static final String SMTP_CONFIGURATION_FILENAME = "smtpserver.xml";
    private static final List<String> CONFIGURATION_FILE_NAMES = ImmutableList.of((Object)"dnsservice.xml", (Object)"domainlist.xml", (Object)"imapserver.xml", (Object)"keystore", (Object)"lmtpserver.xml", (Object)"mailrepositorystore.xml", (Object)"managesieveserver.xml", (Object)"pop3server.xml", (Object)"recipientrewritetable.xml", (Object)"usersrepository.xml", (Object)"smime.p12");
    private final GuiceJamesServer jamesServer;

    public static MailetContainer.Builder defaultMailetContainerConfiguration() {
        return MailetContainer.builder().putProcessor(CommonProcessors.root()).putProcessor(CommonProcessors.error()).putProcessor(CommonProcessors.rrtError()).putProcessor(CommonProcessors.transport()).putProcessor(CommonProcessors.bounces());
    }

    public static MailetContainer.Builder simpleMailetContainerConfiguration() {
        return MailetContainer.builder().putProcessor(CommonProcessors.simpleRoot()).putProcessor(CommonProcessors.error()).putProcessor(CommonProcessors.rrtError()).putProcessor(CommonProcessors.transport()).putProcessor(CommonProcessors.bounces());
    }

    public static Builder builder() {
        return new Builder();
    }

    private TemporaryJamesServer(File workingDir, MailetContainer mailetContainer, SmtpConfiguration smtpConfiguration, Module serverBaseModule, List<Module> additionalModules) throws Exception {
        this.appendMailetConfigurations(workingDir, mailetContainer);
        this.appendSmtpConfigurations(workingDir, smtpConfiguration);
        Configuration.Basic configuration = Configuration.builder().workingDirectory(workingDir).build();
        this.copyResources(Paths.get(workingDir.getAbsolutePath(), "conf"));
        this.jamesServer = GuiceJamesServer.forConfiguration((Configuration)configuration).combineWith(new Module[]{serverBaseModule}).combineWith(new Module[]{new MemoryUsersRepositoryModule()}).overrideWith(new Module[]{binder -> binder.bind(PersistenceAdapter.class).to(MemoryPersistenceAdapter.class)}).overrideWith(additionalModules).overrideWith(new Module[]{new TestJMAPServerModule()}).overrideWith(new Module[]{binder -> binder.bind(WebAdminConfiguration.class).toInstance((Object)WebAdminConfiguration.TEST_CONFIGURATION)});
    }

    public void start() throws Exception {
        this.jamesServer.start();
    }

    private void copyResources(Path resourcesFolder) throws FileNotFoundException, IOException {
        CONFIGURATION_FILE_NAMES.forEach(resourceName -> this.copyResource(resourcesFolder, (String)resourceName));
    }

    private void copyResource(Path resourcesFolder, String resourceName) {
        block8: {
            Path resolvedResource = resourcesFolder.resolve(resourceName);
            try (FileOutputStream outputStream = new FileOutputStream(resolvedResource.toFile());){
                URL resource = ClassLoader.getSystemClassLoader().getResource(resourceName);
                if (resource != null) {
                    resource.openStream().transferTo(outputStream);
                    break block8;
                }
                throw new RuntimeException("Failed to load configuration resource " + resourceName);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void appendMailetConfigurations(File workingDir, MailetContainer mailetContainer) throws ConfigurationException, IOException {
        try (FileOutputStream outputStream = this.createMailetConfigurationFile(workingDir);){
            IOUtils.write((String)mailetContainer.serializeAsXml(), (OutputStream)outputStream, (Charset)StandardCharsets.UTF_8);
        }
    }

    private void appendSmtpConfigurations(File workingDir, SmtpConfiguration smtpConfiguration) throws ConfigurationException, IOException {
        try (FileOutputStream outputStream = this.createSmtpConfigurationFile(workingDir);){
            IOUtils.write((String)smtpConfiguration.serializeAsXml(), (OutputStream)outputStream, (Charset)StandardCharsets.UTF_8);
        }
    }

    private FileOutputStream createMailetConfigurationFile(File workingDir) throws IOException {
        File configurationFolder = this.confDirectory(workingDir);
        return new FileOutputStream(Paths.get(configurationFolder.getAbsolutePath(), MAILETCONTAINER_CONFIGURATION_FILENAME).toFile());
    }

    private FileOutputStream createSmtpConfigurationFile(File workingDir) throws IOException {
        File configurationFolder = this.confDirectory(workingDir);
        return new FileOutputStream(Paths.get(configurationFolder.getAbsolutePath(), SMTP_CONFIGURATION_FILENAME).toFile());
    }

    private File confDirectory(File workingDir) {
        File configurationFolder = workingDir.toPath().resolve("conf").toFile();
        if (!configurationFolder.exists()) {
            configurationFolder.mkdir();
        }
        return configurationFolder;
    }

    public void shutdown() {
        this.jamesServer.stop();
    }

    public <T extends GuiceProbe> T getProbe(Class<T> probe) {
        return (T)this.jamesServer.getProbe(probe);
    }

    public static class Builder {
        private ImmutableList.Builder<Module> overrideModules = ImmutableList.builder();
        private Optional<Module> module = Optional.empty();
        private Optional<SmtpConfiguration> smtpConfiguration = Optional.empty();
        private Optional<MailetContainer> mailetConfiguration = Optional.empty();

        private Builder() {
        }

        public Builder withBase(Module module) {
            this.module = Optional.of(module);
            return this;
        }

        public Builder withSmtpConfiguration(SmtpConfiguration smtpConfiguration) {
            this.smtpConfiguration = Optional.of(smtpConfiguration);
            return this;
        }

        public Builder withSmtpConfiguration(SmtpConfiguration.Builder smtpConfiguration) {
            return this.withSmtpConfiguration(smtpConfiguration.build());
        }

        public Builder withMailetContainer(MailetContainer mailetConfiguration) {
            this.mailetConfiguration = Optional.of(mailetConfiguration);
            return this;
        }

        public Builder withMailetContainer(MailetContainer.Builder mailetConfiguration) {
            return this.withMailetContainer(mailetConfiguration.build());
        }

        public Builder withOverrides(Module ... modules) {
            this.overrideModules.addAll(Arrays.asList(modules));
            return this;
        }

        public TemporaryJamesServer build(File workingDir) throws Exception {
            return new TemporaryJamesServer(workingDir, this.mailetConfiguration.orElse(TemporaryJamesServer.defaultMailetContainerConfiguration().build()), this.smtpConfiguration.orElse(SmtpConfiguration.DEFAULT), this.module.orElse(MemoryJamesServerMain.IN_MEMORY_SERVER_AGGREGATE_MODULE), (List<Module>)this.overrideModules.build());
        }
    }
}

