/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.matchers;

import java.util.Collection;
import java.util.Optional;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.plist.PropertyListConfiguration;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.james.core.MailAddress;
import org.apache.james.core.Username;
import org.apache.james.transport.matchers.SenderIsInLDAPGroup;
import org.apache.james.user.ldap.DockerLdapSingleton;
import org.apache.james.user.ldap.LdapGenericContainer;
import org.apache.james.user.ldap.LdapRepositoryConfiguration;
import org.apache.mailet.Mail;
import org.apache.mailet.MatcherConfig;
import org.apache.mailet.base.test.FakeMail;
import org.apache.mailet.base.test.FakeMatcherConfig;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

class SenderIsInLDAPGroupTest {
    static LdapGenericContainer ldapContainer = DockerLdapSingleton.ldapContainer;

    SenderIsInLDAPGroupTest() {
    }

    @BeforeAll
    static void setUpAll() {
        ldapContainer.start();
    }

    @AfterAll
    static void afterAll() {
        ldapContainer.stop();
    }

    @Test
    void shouldMatchGroupMember() throws Exception {
        SenderIsInLDAPGroup testee = new SenderIsInLDAPGroup(LdapRepositoryConfiguration.from(SenderIsInLDAPGroupTest.ldapRepositoryConfigurationWithVirtualHosting(ldapContainer)));
        FakeMatcherConfig matcherConfig = FakeMatcherConfig.builder().matcherName("SenderIsInLDAPGroup").condition("cn=mygroup,ou=groups, dc=james,dc=org").build();
        testee.init((MatcherConfig)matcherConfig);
        MailAddress sender = new MailAddress("james-user@james.org");
        MailAddress recipient = new MailAddress("rcpt@james.org");
        Collection matched = testee.match((Mail)FakeMail.builder().name("default-id").sender(sender).recipient(recipient).build());
        Assertions.assertThat((Collection)matched).containsOnly((Object[])new MailAddress[]{recipient});
    }

    @Test
    void shouldNotMatchNotGroupMember() throws Exception {
        SenderIsInLDAPGroup testee = new SenderIsInLDAPGroup(LdapRepositoryConfiguration.from(SenderIsInLDAPGroupTest.ldapRepositoryConfigurationWithVirtualHosting(ldapContainer)));
        FakeMatcherConfig matcherConfig = FakeMatcherConfig.builder().matcherName("SenderIsInLDAPGroup").condition("cn=mygroup,ou=groups, dc=james,dc=org").build();
        testee.init((MatcherConfig)matcherConfig);
        MailAddress sender = new MailAddress("bob@james.org");
        MailAddress recipient = new MailAddress("rcpt@james.org");
        Collection matched = testee.match((Mail)FakeMail.builder().name("default-id").sender(sender).recipient(recipient).build());
        Assertions.assertThat((Collection)matched).isEmpty();
    }

    @Test
    void shouldNotMatchWhenGroupNotFound() throws Exception {
        SenderIsInLDAPGroup testee = new SenderIsInLDAPGroup(LdapRepositoryConfiguration.from(SenderIsInLDAPGroupTest.ldapRepositoryConfigurationWithVirtualHosting(ldapContainer)));
        FakeMatcherConfig matcherConfig = FakeMatcherConfig.builder().matcherName("SenderIsInLDAPGroup").condition("cn=notfound,ou=groups, dc=james,dc=org").build();
        testee.init((MatcherConfig)matcherConfig);
        MailAddress sender = new MailAddress("james-user@james.org");
        MailAddress recipient = new MailAddress("rcpt@james.org");
        Collection matched = testee.match((Mail)FakeMail.builder().name("default-id").sender(sender).recipient(recipient).build());
        Assertions.assertThat((Collection)matched).isEmpty();
    }

    static HierarchicalConfiguration<ImmutableNode> ldapRepositoryConfigurationWithVirtualHosting(LdapGenericContainer ldapContainer) {
        return SenderIsInLDAPGroupTest.ldapRepositoryConfigurationWithVirtualHosting(ldapContainer, Optional.of(DockerLdapSingleton.ADMIN));
    }

    static HierarchicalConfiguration<ImmutableNode> ldapRepositoryConfigurationWithVirtualHosting(LdapGenericContainer ldapContainer, Optional<Username> administrator) {
        PropertyListConfiguration configuration = SenderIsInLDAPGroupTest.baseConfiguration(ldapContainer);
        configuration.addProperty("[@userIdAttribute]", (Object)"mail");
        configuration.addProperty("supportsVirtualHosting", (Object)true);
        administrator.ifPresent(username -> configuration.addProperty("[@administratorId]", (Object)username.asString()));
        return configuration;
    }

    private static PropertyListConfiguration baseConfiguration(LdapGenericContainer ldapContainer) {
        PropertyListConfiguration configuration = new PropertyListConfiguration();
        configuration.addProperty("[@ldapHost]", (Object)ldapContainer.getLdapHost());
        configuration.addProperty("[@principal]", (Object)"cn=admin,dc=james,dc=org");
        configuration.addProperty("[@credentials]", (Object)"mysecretpassword");
        configuration.addProperty("[@userBase]", (Object)"ou=people,dc=james,dc=org");
        configuration.addProperty("[@userObjectClass]", (Object)"inetOrgPerson");
        configuration.addProperty("[@connectionTimeout]", (Object)"2000");
        configuration.addProperty("[@readTimeout]", (Object)"2000");
        return configuration;
    }
}

