/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.matchers;

import jakarta.mail.MessagingException;
import java.util.Collection;
import java.util.Optional;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.plist.PropertyListConfiguration;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.james.core.MailAddress;
import org.apache.james.core.Username;
import org.apache.james.transport.matchers.HasLDAPAttribute;
import org.apache.james.user.ldap.DockerLdapSingleton;
import org.apache.james.user.ldap.LdapGenericContainer;
import org.apache.james.user.ldap.LdapRepositoryConfiguration;
import org.apache.mailet.Mail;
import org.apache.mailet.MatcherConfig;
import org.apache.mailet.base.test.FakeMail;
import org.apache.mailet.base.test.FakeMatcherConfig;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

class HasLDAPAttributeTest {
    static LdapGenericContainer ldapContainer = DockerLdapSingleton.ldapContainer;

    HasLDAPAttributeTest() {
    }

    @BeforeAll
    static void setUpAll() {
        ldapContainer.start();
    }

    @AfterAll
    static void afterAll() {
        ldapContainer.stop();
    }

    @Test
    void shouldReturnRecipientWhenHasAttributeWithValue() throws Exception {
        HasLDAPAttribute testee = new HasLDAPAttribute(LdapRepositoryConfiguration.from(HasLDAPAttributeTest.ldapRepositoryConfigurationWithVirtualHosting(ldapContainer)));
        FakeMatcherConfig matcherConfig = FakeMatcherConfig.builder().matcherName("HasLDAPAttribute").condition("description:abcdef").build();
        testee.init((MatcherConfig)matcherConfig);
        MailAddress recipient = new MailAddress("james-user@james.org");
        Collection matched = testee.match((Mail)FakeMail.builder().name("default-id").recipient(recipient).build());
        Assertions.assertThat((Collection)matched).containsOnly((Object[])new MailAddress[]{recipient});
    }

    @Test
    void shouldMatchWhenCached() throws Exception {
        HasLDAPAttribute testee = new HasLDAPAttribute(LdapRepositoryConfiguration.from(HasLDAPAttributeTest.ldapRepositoryConfigurationWithVirtualHosting(ldapContainer)));
        FakeMatcherConfig matcherConfig = FakeMatcherConfig.builder().matcherName("HasLDAPAttribute").condition("description:abcdef?cacheEnabled=true").build();
        testee.init((MatcherConfig)matcherConfig);
        MailAddress recipient = new MailAddress("james-user@james.org");
        FakeMail mail = FakeMail.builder().name("default-id").recipient(recipient).build();
        testee.match((Mail)mail);
        Collection matched = testee.match((Mail)mail);
        Assertions.assertThat((Collection)matched).containsOnly((Object[])new MailAddress[]{recipient});
    }

    @Test
    void shouldAllowNoMatchWhenCached() throws Exception {
        HasLDAPAttribute testee = new HasLDAPAttribute(LdapRepositoryConfiguration.from(HasLDAPAttributeTest.ldapRepositoryConfigurationWithVirtualHosting(ldapContainer)));
        FakeMatcherConfig matcherConfig = FakeMatcherConfig.builder().matcherName("HasLDAPAttribute").condition("description:abcdef?cacheEnabled=true").build();
        testee.init((MatcherConfig)matcherConfig);
        MailAddress recipient = new MailAddress("james-user2@james.org");
        FakeMail mail = FakeMail.builder().name("default-id").recipient(recipient).build();
        testee.match((Mail)mail);
        Collection matched = testee.match((Mail)mail);
        Assertions.assertThat((Collection)matched).isEmpty();
    }

    @Test
    void shouldThrowWhenPrefixedWithDelimiter() throws Exception {
        HasLDAPAttribute testee = new HasLDAPAttribute(LdapRepositoryConfiguration.from(HasLDAPAttributeTest.ldapRepositoryConfigurationWithVirtualHosting(ldapContainer)));
        FakeMatcherConfig matcherConfig = FakeMatcherConfig.builder().matcherName("HasLDAPAttribute").condition(":abcdef").build();
        Assertions.assertThatThrownBy(() -> testee.init((MatcherConfig)matcherConfig)).isInstanceOf(MessagingException.class);
    }

    @Test
    void shouldNotThrowWhenValueContainsDelimiter() throws Exception {
        HasLDAPAttribute testee = new HasLDAPAttribute(LdapRepositoryConfiguration.from(HasLDAPAttributeTest.ldapRepositoryConfigurationWithVirtualHosting(ldapContainer)));
        FakeMatcherConfig matcherConfig = FakeMatcherConfig.builder().matcherName("HasLDAPAttribute").condition("description:abc:def").build();
        testee.init((MatcherConfig)matcherConfig);
        Assertions.assertThatCode(() -> testee.init((MatcherConfig)matcherConfig)).doesNotThrowAnyException();
    }

    @Test
    void shouldReturnRecipientWhenHasAttribute() throws Exception {
        HasLDAPAttribute testee = new HasLDAPAttribute(LdapRepositoryConfiguration.from(HasLDAPAttributeTest.ldapRepositoryConfigurationWithVirtualHosting(ldapContainer)));
        FakeMatcherConfig matcherConfig = FakeMatcherConfig.builder().matcherName("HasLDAPAttribute").condition("description").build();
        testee.init((MatcherConfig)matcherConfig);
        MailAddress recipient = new MailAddress("james-user@james.org");
        Collection matched = testee.match((Mail)FakeMail.builder().name("default-id").recipient(recipient).build());
        Assertions.assertThat((Collection)matched).containsOnly((Object[])new MailAddress[]{recipient});
    }

    @Test
    void shouldNotReturnRecipientWhenDoesNotHaveAttibure() throws Exception {
        HasLDAPAttribute testee = new HasLDAPAttribute(LdapRepositoryConfiguration.from(HasLDAPAttributeTest.ldapRepositoryConfigurationWithVirtualHosting(ldapContainer)));
        FakeMatcherConfig matcherConfig = FakeMatcherConfig.builder().matcherName("HasLDAPAttribute").condition("descriptionaa").build();
        testee.init((MatcherConfig)matcherConfig);
        MailAddress recipient = new MailAddress("james-user@james.org");
        Collection matched = testee.match((Mail)FakeMail.builder().name("default-id").recipient(recipient).build());
        Assertions.assertThat((Collection)matched).isEmpty();
    }

    @Test
    void shouldReturnEmptyWhenHasNoAttribute() throws Exception {
        HasLDAPAttribute testee = new HasLDAPAttribute(LdapRepositoryConfiguration.from(HasLDAPAttributeTest.ldapRepositoryConfigurationWithVirtualHosting(ldapContainer)));
        FakeMatcherConfig matcherConfig = FakeMatcherConfig.builder().matcherName("HasLDAPAttribute").condition("description:abcdef").build();
        testee.init((MatcherConfig)matcherConfig);
        MailAddress recipient = new MailAddress("bob@james.org");
        Collection matched = testee.match((Mail)FakeMail.builder().name("default-id").recipient(recipient).build());
        Assertions.assertThat((Collection)matched).isEmpty();
    }

    @Test
    void shouldReturnEmptyWhenHasBadAttribute() throws Exception {
        HasLDAPAttribute testee = new HasLDAPAttribute(LdapRepositoryConfiguration.from(HasLDAPAttributeTest.ldapRepositoryConfigurationWithVirtualHosting(ldapContainer)));
        FakeMatcherConfig matcherConfig = FakeMatcherConfig.builder().matcherName("HasLDAPAttribute").condition("description:abcdefg").build();
        testee.init((MatcherConfig)matcherConfig);
        MailAddress recipient = new MailAddress("james-user@james.org");
        Collection matched = testee.match((Mail)FakeMail.builder().name("default-id").recipient(recipient).build());
        Assertions.assertThat((Collection)matched).isEmpty();
    }

    @Test
    void shouldReturnEmptyWhenHasPartialAttribute() throws Exception {
        HasLDAPAttribute testee = new HasLDAPAttribute(LdapRepositoryConfiguration.from(HasLDAPAttributeTest.ldapRepositoryConfigurationWithVirtualHosting(ldapContainer)));
        FakeMatcherConfig matcherConfig = FakeMatcherConfig.builder().matcherName("HasLDAPAttribute").condition("description:abcde").build();
        testee.init((MatcherConfig)matcherConfig);
        MailAddress recipient = new MailAddress("james-user@james.org");
        Collection matched = testee.match((Mail)FakeMail.builder().name("default-id").recipient(recipient).build());
        Assertions.assertThat((Collection)matched).isEmpty();
    }

    @Test
    void shouldReturnEmptyWhenHasLongerAttributeName() throws Exception {
        HasLDAPAttribute testee = new HasLDAPAttribute(LdapRepositoryConfiguration.from(HasLDAPAttributeTest.ldapRepositoryConfigurationWithVirtualHosting(ldapContainer)));
        FakeMatcherConfig matcherConfig = FakeMatcherConfig.builder().matcherName("HasLDAPAttribute").condition("descriptionaaa:abcdef").build();
        testee.init((MatcherConfig)matcherConfig);
        MailAddress recipient = new MailAddress("james-user@james.org");
        Collection matched = testee.match((Mail)FakeMail.builder().name("default-id").recipient(recipient).build());
        Assertions.assertThat((Collection)matched).isEmpty();
    }

    static HierarchicalConfiguration<ImmutableNode> ldapRepositoryConfigurationWithVirtualHosting(LdapGenericContainer ldapContainer) {
        return HasLDAPAttributeTest.ldapRepositoryConfigurationWithVirtualHosting(ldapContainer, Optional.of(DockerLdapSingleton.ADMIN));
    }

    static HierarchicalConfiguration<ImmutableNode> ldapRepositoryConfigurationWithVirtualHosting(LdapGenericContainer ldapContainer, Optional<Username> administrator) {
        PropertyListConfiguration configuration = HasLDAPAttributeTest.baseConfiguration(ldapContainer);
        configuration.addProperty("[@userIdAttribute]", (Object)"mail");
        configuration.addProperty("supportsVirtualHosting", (Object)true);
        administrator.ifPresent(username -> configuration.addProperty("[@administratorId]", (Object)username.asString()));
        return configuration;
    }

    private static PropertyListConfiguration baseConfiguration(LdapGenericContainer ldapContainer) {
        PropertyListConfiguration configuration = new PropertyListConfiguration();
        configuration.addProperty("[@ldapHost]", (Object)ldapContainer.getLdapHost());
        configuration.addProperty("[@principal]", (Object)"cn=admin,dc=james,dc=org");
        configuration.addProperty("[@credentials]", (Object)"mysecretpassword");
        configuration.addProperty("[@userBase]", (Object)"ou=people,dc=james,dc=org");
        configuration.addProperty("[@userObjectClass]", (Object)"inetOrgPerson");
        configuration.addProperty("[@connectionTimeout]", (Object)"2000");
        configuration.addProperty("[@readTimeout]", (Object)"2000");
        return configuration;
    }
}

