/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.matchers;

import java.time.Duration;
import java.util.Optional;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.james.transport.matchers.CacheSettings;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class CacheSettingsTest {
    CacheSettingsTest() {
    }

    @Test
    void shouldMatchBeanContract() {
        EqualsVerifier.forClass(CacheSettings.class).verify();
    }

    @Test
    void shouldReturnEmptyWhenEmpty() {
        Assertions.assertThat((Optional)CacheSettings.parse((String)"")).isEmpty();
    }

    @Test
    void shouldReturnEmptyWhenNoQuestionMark() {
        Assertions.assertThat((Optional)CacheSettings.parse((String)"abcdef")).isEmpty();
    }

    @Test
    void shouldReturnEmptyWhenCacheDisabled() {
        Assertions.assertThat((Optional)CacheSettings.parse((String)"abcdef?cacheEnabled=false")).isEmpty();
    }

    @Test
    void shouldBeTolerantRegardingCaseInKeys() {
        Assertions.assertThat((Optional)CacheSettings.parse((String)"abcdef?cacheEnaBLed=false")).isEmpty();
    }

    @Test
    void shouldReturnDefaultWhenNoSettings() {
        Assertions.assertThat((Optional)CacheSettings.parse((String)"abcdef?")).contains((Object)new CacheSettings(Duration.ofDays(1L), 10000));
    }

    @Test
    void shouldReturnDefaultWhenEnabled() {
        Assertions.assertThat((Optional)CacheSettings.parse((String)"abcdef?cacheEnabled=true")).contains((Object)new CacheSettings(Duration.ofDays(1L), 10000));
    }

    @Test
    void shouldTrimKeys() {
        Assertions.assertThat((Optional)CacheSettings.parse((String)"abcdef?cacheEnabled=true   ")).contains((Object)new CacheSettings(Duration.ofDays(1L), 10000));
    }

    @Test
    void shouldIgnoreEmptyKeys() {
        Assertions.assertThat((Optional)CacheSettings.parse((String)"abcdef?cacheEnabled=true&")).contains((Object)new CacheSettings(Duration.ofDays(1L), 10000));
    }

    @Test
    void shouldIgnoreUnknownSettings() {
        Assertions.assertThat((Optional)CacheSettings.parse((String)"abcdef?cacheEnabled=true&unrelated=ignored")).contains((Object)new CacheSettings(Duration.ofDays(1L), 10000));
    }

    @Test
    void shouldAcceptCustomSize() {
        Assertions.assertThat((Optional)CacheSettings.parse((String)"abcdef?cacheEnabled=true&cacheSize=1234")).contains((Object)new CacheSettings(Duration.ofDays(1L), 1234));
    }

    @Test
    void shouldAcceptCustomDuration() {
        Assertions.assertThat((Optional)CacheSettings.parse((String)"abcdef?cacheEnabled=true&cacheDuration=1234minutes")).contains((Object)new CacheSettings(Duration.ofMinutes(1234L), 10000));
    }

    @Test
    void shouldRejectBadlyFormattedKey() {
        Assertions.assertThatThrownBy(() -> CacheSettings.parse((String)"abcdef?noQuestionMark")).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void shouldRejectNegativeSize() {
        Assertions.assertThatThrownBy(() -> CacheSettings.parse((String)"abcdef?cacheSize=-1")).isInstanceOf(IllegalArgumentException.class);
    }
}

