/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Multimap;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import jakarta.annotation.PreDestroy;
import jakarta.inject.Inject;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.james.jmap.JMAPConfiguration;
import org.apache.james.jmap.JMAPRoute;
import org.apache.james.jmap.JMAPRoutesHandler;
import org.apache.james.jmap.Version;
import org.apache.james.jmap.VersionParser;
import org.apache.james.lifecycle.api.Startable;
import org.apache.james.util.Port;
import org.slf4j.LoggerFactory;
import reactor.netty.DisposableChannel;
import reactor.netty.DisposableServer;
import reactor.netty.http.server.HttpServer;
import reactor.netty.http.server.HttpServerRequest;
import reactor.netty.http.server.HttpServerResponse;

public class JMAPServer
implements Startable {
    private static final int RANDOM_PORT = 0;
    private final JMAPConfiguration configuration;
    private final VersionParser versionParser;
    private final Multimap<Version, JMAPRoute> routes;
    private final List<JMAPRoute> corsRoutes;
    private Optional<DisposableServer> server;

    @Inject
    public JMAPServer(JMAPConfiguration configuration, Set<JMAPRoutesHandler> jmapRoutesHandlers, VersionParser versionParser) {
        this.configuration = configuration;
        this.versionParser = versionParser;
        this.server = Optional.empty();
        this.routes = (Multimap)versionParser.getSupportedVersions().stream().flatMap(version -> jmapRoutesHandlers.stream().flatMap(handler -> handler.routes((Version)version).map(route -> Pair.of((Object)version, (Object)route)))).filter(route -> !((JMAPRoute)route.getRight()).getEndpoint().getMethod().equals((Object)HttpMethod.OPTIONS)).collect(ImmutableListMultimap.toImmutableListMultimap(Pair::getKey, Pair::getValue));
        this.corsRoutes = (List)versionParser.getSupportedVersions().stream().flatMap(version -> jmapRoutesHandlers.stream().flatMap(handler -> handler.routes((Version)version))).filter(route -> route.getEndpoint().getMethod().equals((Object)HttpMethod.OPTIONS)).collect(ImmutableList.toImmutableList());
    }

    public Port getPort() {
        return this.server.map(DisposableServer::port).map(Port::of).orElseThrow(() -> new IllegalStateException("port is not available because server is not started or disabled"));
    }

    public void start() {
        if (this.configuration.isEnabled()) {
            this.server = Optional.of(HttpServer.create().port(this.configuration.getPort().map(Port::getValue).orElse(0).intValue()).handle((request, response) -> this.handleVersionRoute((HttpServerRequest)request).handleRequest((HttpServerRequest)request, (HttpServerResponse)response)).wiretap(this.wireTapEnabled()).bindNow());
        }
    }

    private boolean wireTapEnabled() {
        return LoggerFactory.getLogger((String)"org.apache.james.jmap.wire").isTraceEnabled();
    }

    private JMAPRoute.Action handleVersionRoute(HttpServerRequest request) {
        if (request.method().equals((Object)HttpMethod.OPTIONS)) {
            return this.retrieveMatchingAction(request, this.corsRoutes.stream());
        }
        try {
            Version version = this.versionParser.parseRequestVersionHeader(request);
            return this.retrieveMatchingAction(request, this.routes.get((Object)version).stream());
        }
        catch (IllegalArgumentException e) {
            return (req, res) -> res.status(HttpResponseStatus.BAD_REQUEST).send();
        }
    }

    private JMAPRoute.Action retrieveMatchingAction(HttpServerRequest request, Stream<JMAPRoute> routeStream) {
        return routeStream.filter(jmapRoute -> jmapRoute.matches(request)).map(JMAPRoute::getAction).findFirst().orElse((req, res) -> res.status(HttpResponseStatus.NOT_FOUND).send());
    }

    @PreDestroy
    public void stop() {
        this.server.ifPresent(DisposableChannel::disposeNow);
    }
}

